/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Encoding", storages={@Storage(value="encodings.xml")})
public final class EncodingProjectManagerImpl
extends EncodingProjectManager
implements PersistentStateComponent<Element>,
Disposable {
    @NonNls
    private static final String PROJECT_URL = "PROJECT";
    private final Project myProject;
    private final EncodingManagerImpl myIdeEncodingManager;
    private boolean myNative2AsciiForPropertiesFiles;
    private Charset myDefaultCharsetForPropertiesFiles;
    private final SimpleModificationTracker myModificationTracker;
    private BOMForNewUTF8Files myBomForNewUtf8Files;
    private final Map<VirtualFilePointer, Charset> myMapping;
    private volatile Charset myProjectCharset;
    private static final ThreadLocal<Boolean> SUPPRESS_RELOAD = new ThreadLocal();

    public EncodingProjectManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(0);
        }
        this.myModificationTracker = new SimpleModificationTracker();
        this.myBomForNewUtf8Files = BOMForNewUTF8Files.NEVER;
        this.myMapping = ConcurrentCollectionFactory.createMap(new TObjectHashingStrategy<VirtualFilePointer>(){

            @Override
            public int computeHashCode(VirtualFilePointer pointer) {
                return FileUtil.PATH_HASHING_STRATEGY.computeHashCode(pointer.getUrl());
            }

            @Override
            public boolean equals(VirtualFilePointer o1, VirtualFilePointer o2) {
                return FileUtil.PATH_HASHING_STRATEGY.equals(o1.getUrl(), o2.getUrl());
            }
        });
        this.myProject = project2;
        this.myIdeEncodingManager = (EncodingManagerImpl)EncodingManager.getInstance();
    }

    @Override
    public void dispose() {
    }

    @Override
    public Element getState() {
        Element element2 = new Element("x");
        if (!this.myMapping.isEmpty()) {
            ArrayList<Map.Entry<VirtualFilePointer, Charset>> mappings = new ArrayList<Map.Entry<VirtualFilePointer, Charset>>(this.myMapping.entrySet());
            ContainerUtil.quickSort(mappings, Comparator.comparing(e -> ((VirtualFilePointer)e.getKey()).getUrl()));
            for (Map.Entry entry : mappings) {
                VirtualFilePointer file2 = (VirtualFilePointer)entry.getKey();
                Charset charset = (Charset)entry.getValue();
                Element child2 = new Element("file");
                element2.addContent(child2);
                child2.setAttribute("url", file2.getUrl());
                child2.setAttribute("charset", charset.name());
            }
        }
        if (this.myProjectCharset != null) {
            Element child3 = new Element("file");
            element2.addContent(child3);
            child3.setAttribute("url", PROJECT_URL);
            child3.setAttribute("charset", this.myProjectCharset.name());
        }
        if (this.myNative2AsciiForPropertiesFiles) {
            element2.setAttribute("native2AsciiForPropertiesFiles", Boolean.toString(true));
        }
        if (this.myDefaultCharsetForPropertiesFiles != null) {
            element2.setAttribute("defaultCharsetForPropertiesFiles", this.myDefaultCharsetForPropertiesFiles.name());
        }
        if (this.myBomForNewUtf8Files != BOMForNewUTF8Files.NEVER) {
            element2.setAttribute("addBOMForNewFiles", this.myBomForNewUtf8Files.name);
        }
        return element2;
    }

    @Override
    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(1);
        }
        this.myMapping.clear();
        List<Element> files2 = element2.getChildren("file");
        if (!files2.isEmpty()) {
            THashMap<VirtualFilePointer, Charset> mapping2 = new THashMap<VirtualFilePointer, Charset>();
            for (Element fileElement : files2) {
                String url = fileElement.getAttributeValue("url");
                String charsetName = fileElement.getAttributeValue("charset");
                Charset charset = CharsetToolkit.forName(charsetName);
                if (charset == null) continue;
                if (PROJECT_URL.equals(url)) {
                    this.myProjectCharset = charset;
                    continue;
                }
                if (url == null) continue;
                VirtualFilePointer file2 = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, null);
                mapping2.put(file2, charset);
            }
            this.myMapping.putAll(mapping2);
        }
        this.myNative2AsciiForPropertiesFiles = Boolean.parseBoolean(element2.getAttributeValue("native2AsciiForPropertiesFiles"));
        this.myDefaultCharsetForPropertiesFiles = CharsetToolkit.forName(element2.getAttributeValue("defaultCharsetForPropertiesFiles"));
        this.myBomForNewUtf8Files = BOMForNewUTF8Files.getByNameOrDefault(element2.getAttributeValue("addBOMForNewFiles"));
        this.myModificationTracker.incModificationCount();
    }

    private void reloadAlreadyLoadedDocuments() {
        if (this.myMapping.isEmpty()) {
            return;
        }
        FileDocumentManagerImpl fileDocumentManager = (FileDocumentManagerImpl)FileDocumentManager.getInstance();
        for (VirtualFilePointer pointer : this.myMapping.keySet()) {
            VirtualFile file2 = pointer.getFile();
            Document cachedDocument = file2 == null ? null : fileDocumentManager.getCachedDocument(file2);
            if (cachedDocument == null) continue;
            EncodingProjectManagerImpl.reload(file2, this.myProject, fileDocumentManager);
        }
    }

    @Override
    @Nullable
    public Charset getEncoding(@Nullable VirtualFile virtualFile2, boolean useParentDefaults) {
        for (VirtualFile parent = virtualFile2; parent != null; parent = parent.getParent()) {
            Charset charset = this.myMapping.get(new LightFilePointer(parent.getUrl()));
            if (charset == null && useParentDefaults) continue;
            return charset;
        }
        return this.getDefaultCharset();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        if (simpleModificationTracker == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(2);
        }
        return simpleModificationTracker;
    }

    @Override
    public void setEncoding(@Nullable VirtualFile virtualFileOrDir, @Nullable Charset charset) {
        Charset oldCharset;
        if (virtualFileOrDir == null) {
            oldCharset = this.myProjectCharset;
            this.myProjectCharset = charset;
        } else {
            VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(virtualFileOrDir, (Disposable)this, null);
            oldCharset = charset == null ? this.myMapping.remove(pointer) : this.myMapping.put(pointer, charset);
        }
        if (!Comparing.equal(oldCharset, charset) || virtualFileOrDir != null && !Comparing.equal(virtualFileOrDir.getCharset(), charset)) {
            this.myModificationTracker.incModificationCount();
            if (virtualFileOrDir != null) {
                virtualFileOrDir.setCharset(virtualFileOrDir.getBOM() == null ? charset : null);
            }
            this.reloadAllFilesUnder(virtualFileOrDir);
        }
    }

    private static void clearAndReload(@NotNull VirtualFile virtualFileOrDir, @NotNull Project project2) {
        if (virtualFileOrDir == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(4);
        }
        virtualFileOrDir.setCharset(null);
        EncodingProjectManagerImpl.reload(virtualFileOrDir, project2, (FileDocumentManagerImpl)FileDocumentManager.getInstance());
    }

    private static void reload(@NotNull VirtualFile virtualFile2, @NotNull Project project2, @NotNull FileDocumentManagerImpl documentManager) {
        if (virtualFile2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(6);
        }
        if (documentManager == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try (AccessToken ignored = ProjectLocator.runWithPreferredProject(virtualFile2, project2);){
                documentManager.contentsChanged(new VFileContentChangeEvent(null, virtualFile2, 0L, 0L, false));
            }
        });
    }

    @Override
    @NotNull
    public Collection<Charset> getFavorites() {
        Set<Charset> result2 = EncodingProjectManagerImpl.widelyKnownCharsets();
        result2.addAll(this.myMapping.values());
        result2.add(this.getDefaultCharset());
        Set<Charset> set = result2;
        if (set == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    static Set<Charset> widelyKnownCharsets() {
        HashSet<Charset> result2 = new HashSet<Charset>();
        result2.add(StandardCharsets.UTF_8);
        result2.add(CharsetToolkit.getDefaultSystemCharset());
        result2.add(CharsetToolkit.UTF_16_CHARSET);
        result2.add(CharsetToolkit.forName("ISO-8859-1"));
        result2.add(CharsetToolkit.forName("US-ASCII"));
        result2.add(EncodingManager.getInstance().getDefaultCharset());
        result2.add(EncodingManager.getInstance().getDefaultCharsetForPropertiesFiles(null));
        result2.remove(null);
        HashSet<Charset> hashSet = result2;
        if (hashSet == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @NotNull
    public Map<? extends VirtualFile, ? extends Charset> getAllMappings() {
        Map<VirtualFile, Charset> map2 = this.myMapping.entrySet().stream().map(e -> Pair.create(((VirtualFilePointer)e.getKey()).getFile(), e.getValue())).filter(e -> e.getFirst() != null).collect(Collectors.toMap(p -> (VirtualFile)p.getFirst(), p -> (Charset)p.getSecond(), (c1, c2) -> c1));
        if (map2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(10);
        }
        return map2;
    }

    public void setMapping(@NotNull Map<? extends VirtualFile, ? extends Charset> mapping2) {
        if (mapping2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsWriteThread();
        FileDocumentManager.getInstance().saveAllDocuments();
        THashMap newMap = new THashMap(mapping2.size());
        THashMap<VirtualFilePointer, Charset> oldMap = new THashMap<VirtualFilePointer, Charset>(this.myMapping);
        EncodingProjectManagerImpl.suppressReloadDuring(() -> {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            for (Map.Entry entry : mapping2.entrySet()) {
                VirtualFile virtualFile2 = (VirtualFile)entry.getKey();
                Charset charset = (Charset)entry.getValue();
                if (charset == null) {
                    throw new IllegalArgumentException("Null charset for " + virtualFile2 + "; mapping: " + mapping2);
                }
                if (virtualFile2 == null) {
                    this.myProjectCharset = charset;
                    continue;
                }
                if (!fileIndex.isInContent(virtualFile2)) continue;
                VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(virtualFile2, (Disposable)this, null);
                if (!virtualFile2.isDirectory() && !Comparing.equal(charset, oldMap.get(pointer))) {
                    byte[] bytes;
                    Document document;
                    try {
                        document = FileDocumentManager.getInstance().getDocument(virtualFile2);
                        if (document == null) {
                            throw new IOException();
                        }
                        bytes = virtualFile2.contentsToByteArray();
                    }
                    catch (IOException e) {
                        continue;
                    }
                    boolean changed2 = new ChangeFileEncodingAction().chosen(document, null, virtualFile2, bytes, charset);
                    if (!changed2) continue;
                }
                newMap.put(pointer, charset);
            }
        });
        this.myMapping.clear();
        this.myMapping.putAll(newMap);
        HashSet changed2 = new HashSet(oldMap.keySet());
        for (Map.Entry entry : newMap.entrySet()) {
            VirtualFilePointer file2 = (VirtualFilePointer)entry.getKey();
            Charset charset = (Charset)entry.getValue();
            Charset oldCharset = (Charset)oldMap.get(file2);
            if (!Comparing.equal(oldCharset, charset)) continue;
            changed2.remove(file2);
        }
        HashSet added = new HashSet(newMap.keySet());
        added.removeAll(oldMap.keySet());
        HashSet removed = new HashSet(oldMap.keySet());
        removed.removeAll(newMap.keySet());
        changed2.addAll(added);
        changed2.addAll(removed);
        changed2.remove(null);
        if (!changed2.isEmpty()) {
            Processor<VirtualFile> reloadProcessor = EncodingProjectManagerImpl.createChangeCharsetProcessor(this.myProject);
            this.tryStartReloadWithProgress(() -> {
                THashSet<VirtualFile> processed2 = new THashSet<VirtualFile>();
                block0: for (VirtualFilePointer changedFilePointer : changed2) {
                    VirtualFile changedFile = changedFilePointer.getFile();
                    if (changedFile == null) continue;
                    for (VirtualFile processedFile : processed2) {
                        if (!VfsUtilCore.isAncestor(processedFile, changedFile, false)) continue;
                        continue block0;
                    }
                    this.processSubFiles(changedFile, reloadProcessor);
                    processed2.add(changedFile);
                }
            });
        }
        this.myModificationTracker.incModificationCount();
    }

    @NotNull
    private static Processor<VirtualFile> createChangeCharsetProcessor(@NotNull Project project2) {
        if (project2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(12);
        }
        Processor<VirtualFile> processor2 = file2 -> {
            if (file2.isDirectory()) {
                return true;
            }
            if (!(file2 instanceof VirtualFileSystemEntry)) {
                return false;
            }
            Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument((VirtualFile)file2);
            if (cachedDocument == null) {
                if (file2.isCharsetSet()) {
                    file2.setCharset(null, null, false);
                }
                return true;
            }
            ProgressManager.progress(IdeBundle.message("progress.text.reloading.files", new Object[0]), file2.getPresentableUrl());
            TransactionGuard.submitTransaction(ApplicationManager.getApplication(), () -> EncodingProjectManagerImpl.clearAndReload(file2, project2));
            return true;
        };
        if (processor2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(13);
        }
        return processor2;
    }

    private boolean processSubFiles(@Nullable(value="null means all in the project") @Nullable(value="null means all in the project") VirtualFile file2, final @NotNull Processor<? super VirtualFile> processor2) {
        if (processor2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            for (VirtualFile virtualFile2 : ProjectRootManager.getInstance(this.myProject).getContentRoots()) {
                if (this.processSubFiles(virtualFile2, processor2)) continue;
                return false;
            }
            return true;
        }
        return VirtualFileVisitor.CONTINUE == VfsUtilCore.visitChildrenRecursively(file2, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return processor2.process(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl$2", "visitFile"));
            }
        });
    }

    @Override
    @NotNull
    public Charset getDefaultCharset() {
        Charset charset = this.myProjectCharset;
        Charset charset2 = charset == null ? this.myIdeEncodingManager.getDefaultCharset() : charset;
        if (charset2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(15);
        }
        return charset2;
    }

    @Nullable
    public Charset getConfiguredDefaultCharset() {
        return this.myProjectCharset;
    }

    static void suppressReloadDuring(@NotNull Runnable action2) {
        if (action2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(16);
        }
        Boolean old = SUPPRESS_RELOAD.get();
        try {
            SUPPRESS_RELOAD.set(Boolean.TRUE);
            action2.run();
        }
        finally {
            SUPPRESS_RELOAD.set(old);
        }
    }

    private void tryStartReloadWithProgress(@NotNull Runnable reloadAction) {
        Boolean suppress;
        if (reloadAction == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(17);
        }
        if ((suppress = SUPPRESS_RELOAD.get()) == Boolean.TRUE) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> EncodingProjectManagerImpl.suppressReloadDuring(reloadAction), IdeBundle.message("progress.title.reload.files", new Object[0]), false, this.myProject);
    }

    private void reloadAllFilesUnder(@Nullable VirtualFile root) {
        this.tryStartReloadWithProgress(() -> this.processSubFiles(root, file2 -> {
            if (!(file2 instanceof VirtualFileSystemEntry)) {
                return true;
            }
            Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument((VirtualFile)file2);
            if (cachedDocument != null) {
                ProgressManager.progress(IdeBundle.message("progress.text.reloading.file", new Object[0]), file2.getPresentableUrl());
                TransactionGuard.submitTransaction(this.myProject, () -> EncodingProjectManagerImpl.reload(file2, this.myProject, (FileDocumentManagerImpl)FileDocumentManager.getInstance()));
            } else if (file2.isCharsetSet() && !file2.equals(root)) {
                file2.setCharset(null);
            }
            return true;
        }));
    }

    @Override
    public boolean isNative2Ascii(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(18);
        }
        return FileTypeRegistry.getInstance().isFileOfType(virtualFile2, StdFileTypes.PROPERTIES) && this.myNative2AsciiForPropertiesFiles;
    }

    @Override
    public boolean isNative2AsciiForPropertiesFiles() {
        return this.myNative2AsciiForPropertiesFiles;
    }

    @Override
    public void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile2, boolean native2Ascii) {
        if (this.myNative2AsciiForPropertiesFiles != native2Ascii) {
            this.myNative2AsciiForPropertiesFiles = native2Ascii;
            this.myIdeEncodingManager.firePropertyChange(null, "native2ascii", !native2Ascii, native2Ascii, this.myProject);
        }
    }

    @Override
    @NotNull
    public String getDefaultCharsetName() {
        Charset charset = this.getEncoding(null, false);
        String string = charset == null ? "" : charset.name();
        if (string == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Override
    public void setDefaultCharsetName(@NotNull String name) {
        if (name == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(20);
        }
        this.setEncoding(null, name.isEmpty() ? null : CharsetToolkit.forName(name));
    }

    @Override
    @Nullable
    public Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile2) {
        return this.myDefaultCharsetForPropertiesFiles;
    }

    @Override
    public void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile2, @Nullable Charset charset) {
        Charset old = this.myDefaultCharsetForPropertiesFiles;
        if (!Comparing.equal(old, charset)) {
            this.myDefaultCharsetForPropertiesFiles = charset;
            this.myIdeEncodingManager.firePropertyChange(null, "propertiesFilesEncoding", old, charset, this.myProject);
        }
    }

    @Override
    @Nullable
    public Charset getCachedCharsetFromContent(@NotNull Document document) {
        if (document == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(21);
        }
        return this.myIdeEncodingManager.getCachedCharsetFromContent(document);
    }

    public void setBOMForNewUtf8Files(@NotNull BOMForNewUTF8Files option2) {
        if (option2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(22);
        }
        this.myBomForNewUtf8Files = option2;
    }

    @NotNull
    BOMForNewUTF8Files getBOMForNewUTF8Files() {
        BOMForNewUTF8Files bOMForNewUTF8Files = this.myBomForNewUtf8Files;
        if (bOMForNewUTF8Files == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(23);
        }
        return bOMForNewUTF8Files;
    }

    @Override
    public boolean shouldAddBOMForNewUtf8File() {
        switch (this.myBomForNewUtf8Files) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case WINDOWS_ONLY: {
                return SystemInfo.isWindows;
            }
        }
        throw new IllegalStateException(this.myBomForNewUtf8Files.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileOrDir";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloadAction";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavorites";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "widelyKnownCharsets";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMappings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangeCharsetProcessor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharset";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharsetName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBOMForNewUTF8Files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 23: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearAndReload";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reload";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChangeCharsetProcessor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processSubFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "suppressReloadDuring";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryStartReloadWithProgress";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isNative2Ascii";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultCharsetName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCachedCharsetFromContent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setBOMForNewUtf8Files";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum BOMForNewUTF8Files {
        ALWAYS("with BOM"),
        NEVER("with NO BOM"),
        WINDOWS_ONLY("with BOM under Windows, with no BOM otherwise");

        private final String name;

        private BOMForNewUTF8Files(String name) {
            if (name == null) {
                BOMForNewUTF8Files.$$$reportNull$$$0(0);
            }
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        private static BOMForNewUTF8Files getByNameOrDefault(@Nullable String name) {
            if (!StringUtil.isEmpty(name)) {
                for (BOMForNewUTF8Files value2 : BOMForNewUTF8Files.values()) {
                    if (!value2.name.equalsIgnoreCase(name)) continue;
                    BOMForNewUTF8Files bOMForNewUTF8Files = value2;
                    if (bOMForNewUTF8Files == null) {
                        BOMForNewUTF8Files.$$$reportNull$$$0(1);
                    }
                    return bOMForNewUTF8Files;
                }
            }
            BOMForNewUTF8Files bOMForNewUTF8Files = NEVER;
            if (bOMForNewUTF8Files == null) {
                BOMForNewUTF8Files.$$$reportNull$$$0(2);
            }
            return bOMForNewUTF8Files;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl$BOMForNewUTF8Files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl$BOMForNewUTF8Files";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getByNameOrDefault";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class EncodingProjectManagerStartUpActivity
    implements StartupActivity.DumbAware {
        EncodingProjectManagerStartUpActivity() {
        }

        @Override
        public void runActivity(@NotNull Project project2) {
            if (project2 == null) {
                EncodingProjectManagerStartUpActivity.$$$reportNull$$$0(0);
            }
            GuiUtils.invokeLaterIfNeeded(() -> ((EncodingProjectManagerImpl)EncodingProjectManager.getInstance(project2)).reloadAlreadyLoadedDocuments(), ModalityState.NON_MODAL, project2.getDisposed());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl$EncodingProjectManagerStartUpActivity", "runActivity"));
        }
    }
}

