/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.ActionEvent;
import java.nio.charset.Charset;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncompatibleEncodingDialog
extends DialogWrapper {
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final Charset charset;
    @NotNull
    private final EncodingUtil.Magic8 safeToReload;
    @NotNull
    private final EncodingUtil.Magic8 safeToConvert;
    static final int RELOAD_EXIT_CODE = 10;
    static final int CONVERT_EXIT_CODE = 20;

    IncompatibleEncodingDialog(@NotNull VirtualFile virtualFile2, @NotNull Charset charset, @NotNull EncodingUtil.Magic8 safeToReload, @NotNull EncodingUtil.Magic8 safeToConvert) {
        if (virtualFile2 == null) {
            IncompatibleEncodingDialog.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            IncompatibleEncodingDialog.$$$reportNull$$$0(1);
        }
        if (safeToReload == null) {
            IncompatibleEncodingDialog.$$$reportNull$$$0(2);
        }
        if (safeToConvert == null) {
            IncompatibleEncodingDialog.$$$reportNull$$$0(3);
        }
        super(false);
        this.virtualFile = virtualFile2;
        this.charset = charset;
        this.safeToReload = safeToReload;
        this.safeToConvert = safeToConvert;
        this.setTitle(IdeBundle.message("dialog.title.0.reload.or.convert.to.1", virtualFile2.getName(), charset.displayName()));
        this.init();
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        JLabel label2 = new JLabel(XmlStringUtil.wrapInHtml("The encoding you've chosen ('" + this.charset.displayName() + "') may change the contents of '" + this.virtualFile.getName() + "'.<br>Do you want to<br>1. <b>Reload</b> the file from disk in the new encoding '" + this.charset.displayName() + "' and overwrite editor contents or<br>2. <b>Convert</b> the text and overwrite file in the new encoding?"));
        label2.setIcon(Messages.getQuestionIcon());
        label2.setIconTextGap(10);
        return label2;
    }

    @Override
    protected Action @NotNull [] createActions() {
        DialogWrapper.DialogWrapperAction reloadAction = new DialogWrapper.DialogWrapperAction(IdeBundle.message("button.reload", new Object[0])){

            @Override
            protected void doAction(ActionEvent e) {
                if (IncompatibleEncodingDialog.this.safeToReload == EncodingUtil.Magic8.NO_WAY) {
                    int res2;
                    Ref current2 = Ref.create();
                    EncodingUtil.FailReason failReason = EncodingUtil.checkCanReload(IncompatibleEncodingDialog.this.virtualFile, current2);
                    byte[] bom = IncompatibleEncodingDialog.this.virtualFile.getBOM();
                    String explanation = "<br><br>" + (failReason == null ? "" : "Why: " + (Object)((Object)failReason) + "<br>") + (current2.isNull() ? "" : "Current encoding: '" + ((Charset)current2.get()).displayName() + "'");
                    if (bom != null) {
                        Messages.showErrorDialog(XmlStringUtil.wrapInHtml("File '" + IncompatibleEncodingDialog.this.virtualFile.getName() + "' can't be reloaded in the '" + IncompatibleEncodingDialog.this.charset.displayName() + "' encoding." + explanation), "Incompatible Encoding: " + IncompatibleEncodingDialog.this.charset.displayName());
                        res2 = -1;
                    } else {
                        res2 = Messages.showDialog(XmlStringUtil.wrapInHtml("File '" + IncompatibleEncodingDialog.this.virtualFile.getName() + "' most likely isn't stored in the '" + IncompatibleEncodingDialog.this.charset.displayName() + "' encoding." + explanation), "Incompatible Encoding: " + IncompatibleEncodingDialog.this.charset.displayName(), new String[]{"Reload anyway", "Cancel"}, 1, AllIcons.General.WarningDialog);
                    }
                    if (res2 != 0) {
                        IncompatibleEncodingDialog.this.doCancelAction();
                        return;
                    }
                }
                IncompatibleEncodingDialog.this.close(10);
            }
        };
        if (!SystemInfo.isMac && this.safeToReload == EncodingUtil.Magic8.NO_WAY) {
            reloadAction.putValue("SmallIcon", AllIcons.General.Warning);
        }
        reloadAction.putValue("MnemonicKey", 82);
        DialogWrapper.DialogWrapperAction convertAction = new DialogWrapper.DialogWrapperAction(IdeBundle.message("button.convert", new Object[0])){

            @Override
            protected void doAction(ActionEvent e) {
                if (IncompatibleEncodingDialog.this.safeToConvert == EncodingUtil.Magic8.NO_WAY) {
                    EncodingUtil.FailReason error = EncodingUtil.checkCanConvert(IncompatibleEncodingDialog.this.virtualFile);
                    int res2 = Messages.showDialog(XmlStringUtil.wrapInHtml("Please do not convert to '" + IncompatibleEncodingDialog.this.charset.displayName() + "'.<br><br>" + (error == null ? "Encoding '" + IncompatibleEncodingDialog.this.charset.displayName() + "' does not support some characters from the text." : EncodingUtil.reasonToString(error, IncompatibleEncodingDialog.this.virtualFile))), IdeBundle.message("dialog.title.incompatible.encoding.0", IncompatibleEncodingDialog.this.charset.displayName()), new String[]{"Convert anyway", "Cancel"}, 1, AllIcons.General.WarningDialog);
                    if (res2 != 0) {
                        IncompatibleEncodingDialog.this.doCancelAction();
                        return;
                    }
                }
                IncompatibleEncodingDialog.this.close(20);
            }

            @Override
            public boolean isEnabled() {
                return !FileUtilRt.isTooLarge(IncompatibleEncodingDialog.this.virtualFile.getLength());
            }
        };
        if (!SystemInfo.isMac && this.safeToConvert == EncodingUtil.Magic8.NO_WAY) {
            convertAction.putValue("SmallIcon", AllIcons.General.Warning);
        }
        convertAction.putValue("MnemonicKey", 67);
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("DefaultAction", Boolean.TRUE);
        Action[] actionArray = new Action[]{reloadAction, convertAction, cancelAction};
        if (actionArray == null) {
            IncompatibleEncodingDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "safeToReload";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "safeToConvert";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/IncompatibleEncodingDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/IncompatibleEncodingDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

