/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class VirtualFileDirectoryImpl
extends VirtualFileImpl {
    private final ArrayList<VirtualFileImpl> myChildren = new ArrayList();

    VirtualFileDirectoryImpl(DummyFileSystem fileSystem, VirtualFileDirectoryImpl parent, String name) {
        super(fileSystem, parent, name);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public VirtualFile[] getChildren() {
        return this.myChildren.size() == 0 ? EMPTY_ARRAY : this.myChildren.toArray(VirtualFile.EMPTY_ARRAY);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new IOException(IdeBundle.message("file.read.error", this.getUrl()));
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new IOException(IdeBundle.message("file.write.error", this.getUrl()));
    }

    @Override
    public byte @NotNull [] contentsToByteArray() throws IOException {
        throw new IOException(IdeBundle.message("file.read.error", this.getUrl()));
    }

    @Override
    public long getModificationStamp() {
        return -1L;
    }

    void addChild(VirtualFileImpl child2) {
        this.myChildren.add(child2);
    }

    void removeChild(VirtualFileImpl child2) {
        this.myChildren.remove(child2);
        child2.myIsValid = false;
    }
}

