/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.UrlPartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilePointerPartNode {
    private static final FilePointerPartNode[] EMPTY_ARRAY = new FilePointerPartNode[0];
    private final int nameId;
    FilePointerPartNode @NotNull [] children;
    final FilePointerPartNode parent;
    private Object leaves;
    volatile Pair<VirtualFile, String> myFileAndUrl;
    volatile long myLastUpdated;
    volatile int useCount;
    int pointersUnder;
    private static final VirtualFileManager ourFileManager = VirtualFileManager.getInstance();

    private FilePointerPartNode(int nameId, @NotNull FilePointerPartNode parent) {
        if (parent == null) {
            FilePointerPartNode.$$$reportNull$$$0(0);
        }
        this.children = EMPTY_ARRAY;
        this.myLastUpdated = -1L;
        assert (nameId > 0) : nameId + "; " + this.getClass();
        this.nameId = nameId;
        this.parent = parent;
    }

    boolean urlEndsWithName(@NotNull String urlAfter, VirtualFile fileAfter) {
        if (urlAfter == null) {
            FilePointerPartNode.$$$reportNull$$$0(1);
        }
        if (fileAfter != null) {
            return this.nameId == FilePointerPartNode.getNameId(fileAfter);
        }
        return StringUtil.endsWith(urlAfter, this.getName());
    }

    @NotNull
    static FilePointerPartNode createFakeRoot() {
        return new FilePointerPartNode(null){

            @Override
            public String toString() {
                return "root -> " + this.children.length;
            }

            @Override
            @NotNull
            CharSequence getName() {
                return "";
            }
        };
    }

    FilePointerPartNode(FilePointerPartNode parent) {
        this.children = EMPTY_ARRAY;
        this.myLastUpdated = -1L;
        this.nameId = -1;
        this.parent = parent;
    }

    @NotNull
    static CharSequence fromNameId(int nameId) {
        CharSequence charSequence = FileNameCache.getVFileName(nameId);
        if (charSequence == null) {
            FilePointerPartNode.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    @NotNull
    CharSequence getName() {
        CharSequence charSequence = FileNameCache.getVFileName(this.nameId);
        if (charSequence == null) {
            FilePointerPartNode.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    public String toString() {
        return this.getName() + (this.children.length == 0 ? "" : " -> " + this.children.length);
    }

    private FilePointerPartNode matchById(@Nullable VirtualFile parent, int parentNameId, int childNameId, @Nullable List<? super FilePointerPartNode> outDirs, boolean createIfNotFound, @NotNull VirtualFileSystem fs) {
        FilePointerPartNode leaf;
        if (fs == null) {
            FilePointerPartNode.$$$reportNull$$$0(4);
        }
        assert (childNameId != -1 && parent == null == (parentNameId == -1));
        if (parent == null) {
            leaf = this;
        } else {
            int gParentNameId;
            VirtualFile gParent = FilePointerPartNode.getParentThroughJars(parent, fs);
            leaf = this.matchById(gParent, gParentNameId = FilePointerPartNode.getNameId(gParent), parentNameId, outDirs, createIfNotFound, fs);
            if (leaf == null) {
                return null;
            }
        }
        leaf.addRecursiveDirectoryPtrTo(outDirs);
        return leaf.findChildByNameId(childNameId, createIfNotFound);
    }

    private static int getNameId(VirtualFile file2) {
        return file2 == null ? -1 : ((VirtualFileSystemEntry)file2).getNameId();
    }

    private FilePointerPartNode findByExistingNameId(@Nullable VirtualFile parent, int childNameId, @Nullable List<? super FilePointerPartNode> outDirs, @NotNull VirtualFileSystem fs) {
        FilePointerPartNode leaf;
        if (fs == null) {
            FilePointerPartNode.$$$reportNull$$$0(5);
        }
        if (childNameId <= 0) {
            throw new IllegalArgumentException("invalid argument childNameId: " + childNameId);
        }
        if (parent == null) {
            leaf = this;
        } else {
            int gParentNameId;
            int nameId = FilePointerPartNode.getNameId(parent);
            VirtualFile gParent = FilePointerPartNode.getParentThroughJars(parent, fs);
            leaf = this.matchById(gParent, gParentNameId = FilePointerPartNode.getNameId(gParent), nameId, outDirs, false, fs);
            if (leaf == null) {
                return null;
            }
        }
        leaf.addRecursiveDirectoryPtrTo(outDirs);
        return leaf.findChildByNameId(childNameId, false);
    }

    private static int extractName(@NotNull CharSequence path2, int length) {
        if (path2 == null) {
            FilePointerPartNode.$$$reportNull$$$0(6);
        }
        if (length == 1 && path2.charAt(0) == '/') {
            return 0;
        }
        int i = StringUtil.lastIndexOf(path2, '/', 0, length);
        return i + 1;
    }

    private FilePointerPartNode findChildByNameId(int nameId, boolean createIfNotFound) {
        if (nameId <= 0) {
            throw new IllegalArgumentException("invalid argument nameId: " + nameId);
        }
        for (FilePointerPartNode child2 : this.children) {
            if (!child2.nameEqualTo(nameId)) continue;
            return child2;
        }
        if (createIfNotFound) {
            CharSequence name = FilePointerPartNode.fromNameId(nameId);
            int index = this.binarySearchChildByName(name);
            if (!$assertionsDisabled && index >= 0) {
                FilePointerPartNode child3 = this.children[index];
                throw new AssertionError((Object)(index + " : child= '" + child3 + "'; child.nameEqualTo(nameId)=" + child3.nameEqualTo(nameId) + "; child.getClass()=" + child3.getClass() + "; child.nameId=" + child3.nameId + "; child.getName()='" + child3.getName() + "'; nameId=" + nameId + "; name='" + name + "'; compare(child) = " + StringUtil.compare(child3.getName(), name, !SystemInfo.isFileSystemCaseSensitive) + "; UrlPart.nameEquals: " + FileUtil.PATH_CHAR_SEQUENCE_HASHING_STRATEGY.equals(child3.getName(), FilePointerPartNode.fromNameId(nameId)) + "; name.equals(child.getName())=" + name.equals(child3.getName())));
            }
            FilePointerPartNode child4 = new FilePointerPartNode(nameId, this);
            this.children = ArrayUtil.insert(this.children, -index - 1, child4);
            return child4;
        }
        return null;
    }

    boolean nameEqualTo(int nameId) {
        return this.nameId == nameId;
    }

    private int binarySearchChildByName(@NotNull CharSequence name) {
        if (name == null) {
            FilePointerPartNode.$$$reportNull$$$0(7);
        }
        return ObjectUtils.binarySearch(0, this.children.length, i -> {
            FilePointerPartNode child2 = this.children[i];
            CharSequence childName = child2.getName();
            return StringUtil.compare(childName, name, !SystemInfo.isFileSystemCaseSensitive);
        });
    }

    private void addRecursiveDirectoryPtrTo(@Nullable List<? super FilePointerPartNode> dirs) {
        if (dirs != null && this.hasRecursiveDirectoryPointer() && ContainerUtil.getLastItem(dirs) != this) {
            dirs.add(this);
        }
    }

    void addRelevantPointersFrom(@Nullable VirtualFile parent, int childNameId, @NotNull List<? super FilePointerPartNode> out, boolean addSubdirectoryPointers, @NotNull VirtualFileSystem fs) {
        if (out == null) {
            FilePointerPartNode.$$$reportNull$$$0(8);
        }
        if (fs == null) {
            FilePointerPartNode.$$$reportNull$$$0(9);
        }
        if (childNameId <= 0) {
            throw new IllegalArgumentException("invalid argument childNameId: " + childNameId);
        }
        FilePointerPartNode node = this.findByExistingNameId(parent, childNameId, out, fs);
        if (node != null) {
            if (node.leaves != null) {
                out.add(node);
            }
            if (addSubdirectoryPointers) {
                FilePointerPartNode.addAllPointersStrictlyUnder(node, out);
            }
        }
    }

    private boolean hasRecursiveDirectoryPointer() {
        VirtualFilePointerImpl[] leaves;
        if (this.leaves == null) {
            return false;
        }
        if (this.leaves instanceof VirtualFilePointer) {
            return ((VirtualFilePointer)this.leaves).isRecursive();
        }
        for (VirtualFilePointerImpl leaf : leaves = (VirtualFilePointerImpl[])this.leaves) {
            if (!leaf.isRecursive()) continue;
            return true;
        }
        return false;
    }

    private static void addAllPointersStrictlyUnder(@NotNull FilePointerPartNode node, @NotNull List<? super FilePointerPartNode> out) {
        if (node == null) {
            FilePointerPartNode.$$$reportNull$$$0(10);
        }
        if (out == null) {
            FilePointerPartNode.$$$reportNull$$$0(11);
        }
        for (FilePointerPartNode child2 : node.children) {
            if (child2.leaves != null) {
                out.add(child2);
            }
            FilePointerPartNode.addAllPointersStrictlyUnder(child2, out);
        }
    }

    void checkConsistency() {
        if (VirtualFilePointerManagerImpl.IS_UNDER_UNIT_TEST && !ApplicationInfoImpl.isInStressTest()) {
            this.doCheckConsistency();
        }
    }

    private void doCheckConsistency() {
        boolean hasFile;
        String name = this.getName().toString();
        assert (!"..".equals(name) && !".".equals(name)) : "url must not contain '.' or '..' but got: " + this;
        int childSum = 0;
        for (int i = 0; i < this.children.length; ++i) {
            FilePointerPartNode child2 = this.children[i];
            childSum += child2.pointersUnder;
            child2.doCheckConsistency();
            assert (child2.parent == this);
            if (i != 0) assert (!FileUtil.namesEqual(child2.getName().toString(), this.children[i - 1].getName().toString())) : "child[" + i + "] = " + child2 + "; [-1] = " + this.children[i - 1];
        }
        childSum += this.leavesNumber();
        assert (this.useCount == 0 == (this.leaves == null)) : this.useCount + " - " + (this.leaves instanceof VirtualFilePointerImpl ? this.leaves : Arrays.toString((VirtualFilePointerImpl[])this.leaves));
        assert (this.pointersUnder == childSum) : "expected: " + this.pointersUnder + "; actual: " + childSum;
        Pair<VirtualFile, String> fileAndUrl = this.myFileAndUrl;
        if (fileAndUrl != null && fileAndUrl.second != null) {
            String url = (String)fileAndUrl.second;
            String path2 = VfsUtilCore.urlToPath(url);
            path2 = StringUtil.trimEnd(path2, "!/");
            String nameFromPath = PathUtil.getFileName(path2);
            if (!path2.isEmpty() && nameFromPath.isEmpty() && SystemInfo.isUnix) {
                nameFromPath = "/";
            }
            assert (StringUtilRt.equal(nameFromPath, name, SystemInfo.isFileSystemCaseSensitive)) : "fileAndUrl: " + fileAndUrl + "; but this: " + this + "; nameFromPath: " + nameFromPath + "; name: " + name + "; parent: " + this.parent + "; path: " + path2 + "; url: " + url;
        }
        boolean bl = hasFile = fileAndUrl != null && fileAndUrl.first != null;
        if (hasFile) assert (((VirtualFile)fileAndUrl.first).getName().equals(name)) : "fileAndUrl: " + fileAndUrl + "; but this: " + this;
    }

    @NotNull
    FilePointerPartNode remove() {
        int pointersNumber = this.leavesNumber();
        assert (this.leaves != null) : this.toString();
        this.associate(null, null);
        this.useCount = 0;
        FilePointerPartNode node = this;
        while (node.parent != null) {
            int pointersAfter = node.pointersUnder -= pointersNumber;
            if (pointersAfter == 0) {
                node.parent.children = ArrayUtil.remove(node.parent.children, node);
                node.myFileAndUrl = null;
            }
            node = node.parent;
        }
        if ((node.pointersUnder -= pointersNumber) == 0) {
            node.children = EMPTY_ARRAY;
        }
        FilePointerPartNode filePointerPartNode = node;
        if (filePointerPartNode == null) {
            FilePointerPartNode.$$$reportNull$$$0(12);
        }
        return filePointerPartNode;
    }

    @Nullable(value="null means this node's myFileAndUrl became invalid")
    @Nullable(value="null means this node's myFileAndUrl became invalid") Pair<VirtualFile, String> update() {
        Pair<VirtualFile, String> result2;
        boolean fileIsValid;
        long lastUpdated = this.myLastUpdated;
        Pair<VirtualFile, String> fileAndUrl = this.myFileAndUrl;
        if (fileAndUrl == null) {
            return null;
        }
        long fsModCount = ManagingFS.getInstance().getStructureModificationCount();
        if (lastUpdated == fsModCount) {
            return fileAndUrl;
        }
        VirtualFile file2 = (VirtualFile)fileAndUrl.first;
        String url = (String)fileAndUrl.second;
        boolean changed2 = false;
        if (url == null) {
            url = file2.getUrl();
            if (!file2.isValid()) {
                file2 = null;
            }
            changed2 = true;
        }
        boolean bl = fileIsValid = file2 != null && file2.isValid();
        if (file2 != null && !fileIsValid) {
            file2 = null;
            changed2 = true;
        }
        if (file2 == null) {
            file2 = ourFileManager.findFileByUrl(url);
            boolean bl2 = fileIsValid = file2 != null && file2.isValid();
            if (file2 != null) {
                changed2 = true;
            }
        }
        if (file2 != null) {
            if (fileIsValid) {
                url = file2.getUrl();
                changed2 |= !url.equals(fileAndUrl.second);
            } else {
                file2 = null;
                changed2 = true;
            }
        }
        if (changed2) {
            this.myFileAndUrl = result2 = Pair.create(file2, url);
        } else {
            result2 = fileAndUrl;
        }
        this.myLastUpdated = fsModCount;
        return result2;
    }

    void associate(Object leaves, Pair<VirtualFile, String> fileAndUrl) {
        this.leaves = leaves;
        this.myFileAndUrl = fileAndUrl;
        if (leaves != null) {
            if (leaves instanceof VirtualFilePointerImpl) {
                ((VirtualFilePointerImpl)leaves).myNode = this;
            } else {
                for (VirtualFilePointerImpl pointer : (VirtualFilePointerImpl[])leaves) {
                    pointer.myNode = this;
                }
            }
        }
        this.myLastUpdated = -1L;
    }

    int incrementUsageCount(int delta) {
        return this.useCount += delta;
    }

    int numberOfPointersUnder() {
        return this.pointersUnder;
    }

    VirtualFilePointerImpl getAnyPointer() {
        Object leaves = this.leaves;
        return leaves == null ? null : (leaves instanceof VirtualFilePointerImpl ? (VirtualFilePointerImpl)leaves : ((VirtualFilePointerImpl[])leaves)[0]);
    }

    @NotNull
    private String getUrl() {
        String string = this.parent == null ? this.getName().toString() : this.parent.getUrl() + "/" + this.getName();
        if (string == null) {
            FilePointerPartNode.$$$reportNull$$$0(13);
        }
        return string;
    }

    private int leavesNumber() {
        Object leaves = this.leaves;
        return leaves == null ? 0 : (leaves instanceof VirtualFilePointerImpl ? 1 : ((VirtualFilePointerImpl[])leaves).length);
    }

    void addAllPointersTo(@NotNull Collection<? super VirtualFilePointerImpl> outList) {
        Object leaves;
        if (outList == null) {
            FilePointerPartNode.$$$reportNull$$$0(14);
        }
        if ((leaves = this.leaves) == null) {
            return;
        }
        if (leaves instanceof VirtualFilePointerImpl) {
            outList.add((VirtualFilePointerImpl)leaves);
        } else {
            ContainerUtil.addAll(outList, (VirtualFilePointerImpl[])leaves);
        }
    }

    @NotNull
    FilePointerPartNode findOrCreateNodeByFile(@NotNull VirtualFile file2, @NotNull NewVirtualFileSystem fs) {
        if (file2 == null) {
            FilePointerPartNode.$$$reportNull$$$0(15);
        }
        if (fs == null) {
            FilePointerPartNode.$$$reportNull$$$0(16);
        }
        int nameId = FilePointerPartNode.getNameId(file2);
        VirtualFile parent = FilePointerPartNode.getParentThroughJars(file2, fs);
        int parentNameId = FilePointerPartNode.getNameId(parent);
        FilePointerPartNode filePointerPartNode = this.matchById(parent, parentNameId, nameId, null, true, fs);
        if (filePointerPartNode == null) {
            FilePointerPartNode.$$$reportNull$$$0(17);
        }
        return filePointerPartNode;
    }

    private static VirtualFile getParentThroughJars(@NotNull VirtualFile file2, @NotNull VirtualFileSystem fs) {
        VirtualFile local;
        VirtualFile parent;
        if (file2 == null) {
            FilePointerPartNode.$$$reportNull$$$0(18);
        }
        if (fs == null) {
            FilePointerPartNode.$$$reportNull$$$0(19);
        }
        if ((parent = file2.getParent()) == null && fs instanceof ArchiveFileSystem && (local = ((ArchiveFileSystem)fs).getLocalByEntry(file2)) != null) {
            parent = local.getParent();
        }
        return parent;
    }

    @NotNull
    static FilePointerPartNode findOrCreateNodeByPath(@NotNull FilePointerPartNode rootNode, @NotNull String path2, @NotNull NewVirtualFileSystem fs) {
        NullVirtualFile NEVER_TRIED_TO_FIND;
        if (rootNode == null) {
            FilePointerPartNode.$$$reportNull$$$0(20);
        }
        if (path2 == null) {
            FilePointerPartNode.$$$reportNull$$$0(21);
        }
        if (fs == null) {
            FilePointerPartNode.$$$reportNull$$$0(22);
        }
        List<String> names2 = FilePointerPartNode.splitNames(path2);
        NewVirtualFile fsRoot = null;
        VirtualFile currentFile = NEVER_TRIED_TO_FIND = NullVirtualFile.INSTANCE;
        FilePointerPartNode currentNode = rootNode;
        for (int i = names2.size() - 1; i >= 0; --i) {
            String name = names2.get(i);
            int index = currentNode.binarySearchChildByName(name);
            if (index >= 0) {
                currentNode = currentNode.children[index];
                currentFile = currentFile == NEVER_TRIED_TO_FIND || currentFile == null ? currentFile : currentFile.findChild(name);
                continue;
            }
            if (currentFile == NEVER_TRIED_TO_FIND) {
                if (fsRoot == null) {
                    String rootPath = ContainerUtil.getLastItem(names2);
                    fsRoot = ManagingFS.getInstance().findRoot(rootPath, fs instanceof ArchiveFileSystem ? LocalFileSystem.getInstance() : fs);
                    if (fsRoot != null && !fsRoot.getName().equals(rootPath)) {
                        fsRoot = null;
                    }
                }
                currentFile = fsRoot == null ? null : FilePointerPartNode.findFileFromRoot(fsRoot, fs, names2, i);
            } else {
                currentFile = currentFile == null ? null : currentFile.findChild(name);
            }
            FilePointerPartNode child2 = currentFile == null ? new UrlPartNode(name, currentNode) : new FilePointerPartNode(FilePointerPartNode.getNameId(currentFile), currentNode);
            currentNode.children = ArrayUtil.insert(currentNode.children, -index - 1, child2);
            currentNode = child2;
            if (i == 0 || !(fs instanceof ArchiveFileSystem) || currentFile == null || ((VirtualFile)currentFile).isDirectory()) continue;
            currentFile = ((ArchiveFileSystem)fs).getRootByLocal(currentFile);
        }
        FilePointerPartNode filePointerPartNode = currentNode;
        if (filePointerPartNode == null) {
            FilePointerPartNode.$$$reportNull$$$0(23);
        }
        return filePointerPartNode;
    }

    @NotNull
    private static List<String> splitNames(@NotNull String path2) {
        if (path2 == null) {
            FilePointerPartNode.$$$reportNull$$$0(24);
        }
        ArrayList<String> names2 = new ArrayList<String>(20);
        int end = path2.length();
        if (end == 0) {
            ArrayList<String> arrayList = names2;
            if (arrayList == null) {
                FilePointerPartNode.$$$reportNull$$$0(25);
            }
            return arrayList;
        }
        while (true) {
            int startIndex = FilePointerPartNode.extractName(path2, end);
            assert (startIndex != end) : "startIndex: " + startIndex + "; end: " + end + "; path:'" + path2 + "'; toExtract: '" + path2.substring(0, end) + "'";
            names2.add(path2.substring(startIndex, end));
            if (startIndex == 0) break;
            int skipSeparator = StringUtil.endsWith(path2, 0, startIndex, "!/") && startIndex > 2 && path2.charAt(startIndex - 3) != '/' ? 2 : 1;
            end = startIndex - skipSeparator;
            if (end != 0 || path2.charAt(0) != '/') continue;
            end = 1;
        }
        ArrayList<String> arrayList = names2;
        if (arrayList == null) {
            FilePointerPartNode.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    private static VirtualFile findFileFromRoot(@NotNull NewVirtualFile root, @NotNull NewVirtualFileSystem fs, @NotNull List<String> names2, int startIndex) {
        if (root == null) {
            FilePointerPartNode.$$$reportNull$$$0(27);
        }
        if (fs == null) {
            FilePointerPartNode.$$$reportNull$$$0(28);
        }
        if (names2 == null) {
            FilePointerPartNode.$$$reportNull$$$0(29);
        }
        VirtualFile file2 = root;
        for (int i = names2.size() - 2; i >= startIndex; --i) {
            String name = names2.get(i);
            file2 = file2.findChild(name);
            if (fs instanceof ArchiveFileSystem && file2 != null && !file2.isDirectory() && file2.getFileSystem() != fs) {
                file2 = ((ArchiveFileSystem)fs).getRootByLocal(file2);
            }
            if (file2 == null) break;
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlAfter";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/FilePointerPartNode";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 16: 
            case 19: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 6: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outList";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/FilePointerPartNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNameId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateNodeByFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateNodeByPath";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "urlEndsWithName";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "matchById";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findByExistingNameId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "binarySearchChildByName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRelevantPointersFrom";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addAllPointersStrictlyUnder";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addAllPointersTo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateNodeByFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParentThroughJars";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateNodeByPath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "splitNames";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findFileFromRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

