/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.FilePointerPartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;

class VirtualFilePointerImpl
extends TraceableDisposable
implements VirtualFilePointer {
    private static final Logger LOG = Logger.getInstance(VirtualFilePointerImpl.class);
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode();
    volatile FilePointerPartNode myNode;
    boolean recursive;

    VirtualFilePointerImpl() {
        super(TRACE_CREATION);
    }

    @Override
    @NotNull
    public String getFileName() {
        FilePointerPartNode node = this.checkDisposed(this.myNode);
        if (node == null) {
            return "";
        }
        Pair<VirtualFile, String> result2 = node.update();
        if (result2 == null) {
            return "";
        }
        VirtualFile file2 = (VirtualFile)result2.first;
        if (file2 != null) {
            String string = file2.getName();
            if (string == null) {
                VirtualFilePointerImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        String url = (String)result2.second;
        int index = url.lastIndexOf(47);
        String string = index >= 0 ? url.substring(index + 1) : url;
        if (string == null) {
            VirtualFilePointerImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public VirtualFile getFile() {
        FilePointerPartNode node = this.checkDisposed(this.myNode);
        if (node == null) {
            return null;
        }
        Pair<VirtualFile, String> result2 = node.update();
        return result2 == null ? null : (VirtualFile)result2.first;
    }

    @Override
    @NotNull
    public String getUrl() {
        FilePointerPartNode node = this.myNode;
        if (node == null) {
            return "";
        }
        Pair<VirtualFile, String> fileAndUrl = node.myFileAndUrl;
        if (fileAndUrl != null && fileAndUrl.getFirst() == null) {
            String string = fileAndUrl.getSecond();
            if (string == null) {
                VirtualFilePointerImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        Pair<VirtualFile, String> result2 = node.update();
        String string = result2 == null ? "" : (String)result2.second;
        if (string == null) {
            VirtualFilePointerImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        FilePointerPartNode node = this.checkDisposed(this.myNode);
        if (node == null) {
            return "";
        }
        Pair<VirtualFile, String> result2 = node.update();
        String string = result2 == null ? "" : PathUtil.toPresentableUrl((String)result2.second);
        if (string == null) {
            VirtualFilePointerImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    private FilePointerPartNode checkDisposed(FilePointerPartNode node) {
        if (node == null) {
            ProgressManager.checkCanceled();
            LOG.error("Already disposed: URL='" + this + "'");
        }
        return node;
    }

    @Override
    public boolean isValid() {
        FilePointerPartNode node = this.myNode;
        Pair<VirtualFile, String> result2 = node == null ? null : node.update();
        return result2 != null && result2.first != null;
    }

    public String toString() {
        Pair<VirtualFile, String> fileAndUrl;
        FilePointerPartNode node = this.myNode;
        return node == null ? "(disposed)" : ((fileAndUrl = node.myFileAndUrl) == null ? "?" : (String)fileAndUrl.second);
    }

    public void dispose() {
        boolean shouldKill;
        VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
        if (pointerManager instanceof VirtualFilePointerManagerImpl) {
            shouldKill = ((VirtualFilePointerManagerImpl)pointerManager).decrementUsageCount(this);
        } else {
            boolean bl = shouldKill = this.incrementUsageCount(-1) == 0;
        }
        if (shouldKill) {
            this.kill("URL when die: " + this);
        }
    }

    int incrementUsageCount(int delta) {
        FilePointerPartNode node = this.checkDisposed(this.myNode);
        if (node == null) {
            return 1;
        }
        return node.incrementUsageCount(delta);
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/vfs/impl/VirtualFilePointerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

