/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VirtualFilePointerTracker {
    private static final Set<VirtualFilePointer> storedPointers = ContainerUtil.newIdentityTroveSet();
    private static Throwable trace;
    private static boolean isTracking;

    public VirtualFilePointerTracker() {
        this.storePointers();
    }

    private synchronized void storePointers() {
        if (isTracking) {
            isTracking = false;
            throw new IllegalStateException("Previous test did not call assertPointersAreDisposed() - see 'Caused by:' for its stacktrace", trace);
        }
        trace = new Throwable();
        storedPointers.clear();
        storedPointers.addAll(VirtualFilePointerTracker.dumpAllPointers());
        isTracking = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void assertPointersAreDisposed() {
        if (!isTracking) {
            throw new IllegalStateException("Double call of assertPointersAreDisposed() - see 'Caused by:' for the previous call", trace);
        }
        ArrayList<VirtualFilePointer> pointers2 = new ArrayList<VirtualFilePointer>(VirtualFilePointerTracker.dumpAllPointers());
        for (int i = pointers2.size() - 1; i >= 0; --i) {
            VirtualFilePointer pointer = (VirtualFilePointer)pointers2.get(i);
            if (!storedPointers.remove(pointer)) continue;
            pointers2.remove(i);
        }
        try {
            THashSet<VirtualFilePointer> leaked = ContainerUtil.newTroveSet(new TObjectHashingStrategy<VirtualFilePointer>(){

                @Override
                public int computeHashCode(VirtualFilePointer pointer) {
                    return FileUtil.PATH_HASHING_STRATEGY.computeHashCode(pointer.getUrl());
                }

                @Override
                public boolean equals(VirtualFilePointer o1, VirtualFilePointer o2) {
                    return FileUtil.PATH_HASHING_STRATEGY.equals(o1.getUrl(), o2.getUrl());
                }
            }, pointers2);
            leaked.removeAll(storedPointers);
            for (VirtualFilePointer pointer : leaked) {
                ((VirtualFilePointerImpl)pointer).throwDisposalError("Virtual pointer '" + pointer + "' hasn't been disposed: " + ((VirtualFilePointerImpl)pointer).getStackTrace());
            }
        }
        finally {
            storedPointers.clear();
            trace = new Throwable();
            isTracking = false;
        }
    }

    @NotNull
    private static Collection<VirtualFilePointer> dumpAllPointers() {
        Collection<VirtualFilePointer> collection = ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).dumpAllPointers();
        if (collection == null) {
            VirtualFilePointerTracker.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFilePointerTracker", "dumpAllPointers"));
    }
}

