/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.openapi.vfs.impl.jar.BasicJarHandler;
import com.intellij.openapi.vfs.impl.jar.JarHandler;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarFileSystemImpl
extends JarFileSystem {
    private final Set<String> myNoCopyJarPaths;
    private final File myNoCopyJarDir;
    private final DiskQueryRelay<VirtualFile, FileAttributes> myAttrGetter = new DiskQueryRelay<VirtualFile, FileAttributes>(x$0 -> super.getAttributes((VirtualFile)x$0));
    private final DiskQueryRelay<VirtualFile, String[]> myChildrenGetter = new DiskQueryRelay<VirtualFile, String[]>(x$0 -> super.list((VirtualFile)x$0));

    public JarFileSystemImpl() {
        boolean noCopy = SystemProperties.getBooleanProperty("idea.jars.nocopy", !SystemInfo.isWindows);
        this.myNoCopyJarPaths = noCopy ? null : ConcurrentCollectionFactory.createConcurrentSet(FileUtil.PATH_HASHING_STRATEGY);
        boolean runningFromDist = new File(PathManager.getLibPath(), "openapi.jar").exists();
        this.myNoCopyJarDir = !runningFromDist ? null : new File(PathManager.getHomePath());
    }

    @Override
    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JarFileSystemImpl.$$$reportNull$$$0(0);
        }
        return this.myAttrGetter.accessDiskWithCheckCanceled(file2);
    }

    @Override
    public String @NotNull [] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JarFileSystemImpl.$$$reportNull$$$0(1);
        }
        String[] stringArray = this.myChildrenGetter.accessDiskWithCheckCanceled(file2);
        if (stringArray == null) {
            JarFileSystemImpl.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Override
    public void setNoCopyJarForPath(@NotNull String pathInJar) {
        if (pathInJar == null) {
            JarFileSystemImpl.$$$reportNull$$$0(3);
        }
        if (this.myNoCopyJarPaths == null) {
            return;
        }
        int index = pathInJar.indexOf("!/");
        if (index < 0) {
            return;
        }
        String path2 = FileUtil.toSystemIndependentName(pathInJar.substring(0, index));
        this.myNoCopyJarPaths.add(path2);
    }

    @Nullable
    public File getMirroredFile(@NotNull VirtualFile vFile) {
        VirtualFile root;
        if (vFile == null) {
            JarFileSystemImpl.$$$reportNull$$$0(4);
        }
        if ((root = this.getRootByLocal(vFile)) != null) {
            ArchiveHandler handler2 = this.getHandler(root);
            if (handler2 instanceof JarHandler) {
                return ((JarHandler)handler2).getFileToUse();
            }
            return handler2.getFile();
        }
        return null;
    }

    public boolean isMakeCopyOfJar(@NotNull File originalJar) {
        if (originalJar == null) {
            JarFileSystemImpl.$$$reportNull$$$0(5);
        }
        if (this.myNoCopyJarPaths == null || this.myNoCopyJarPaths.contains(FileUtil.toSystemIndependentName(originalJar.getPath()))) {
            return false;
        }
        return this.myNoCopyJarDir == null || !FileUtil.isAncestor(this.myNoCopyJarDir, originalJar, false);
    }

    @Override
    @NotNull
    public String getProtocol() {
        return "jar";
    }

    @Override
    @NotNull
    public String extractPresentableUrl(@NotNull String path2) {
        if (path2 == null) {
            JarFileSystemImpl.$$$reportNull$$$0(6);
        }
        String string = super.extractPresentableUrl(StringUtil.trimEnd(path2, "!/"));
        if (string == null) {
            JarFileSystemImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nullable
    protected String normalize(@NotNull String path2) {
        int separatorIndex;
        if (path2 == null) {
            JarFileSystemImpl.$$$reportNull$$$0(8);
        }
        return (separatorIndex = path2.indexOf("!/")) > 0 ? FileUtil.normalize(path2.substring(0, separatorIndex)) + path2.substring(separatorIndex) : null;
    }

    @Override
    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        int separatorIndex;
        if (normalizedPath == null) {
            JarFileSystemImpl.$$$reportNull$$$0(9);
        }
        return (separatorIndex = normalizedPath.indexOf("!/")) > 0 ? normalizedPath.substring(0, separatorIndex + "!/".length()) : "";
    }

    @Override
    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        if (rootPath == null) {
            JarFileSystemImpl.$$$reportNull$$$0(10);
        }
        String string = StringUtil.trimEnd(rootPath, "!/");
        if (string == null) {
            JarFileSystemImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        if (localPath == null) {
            JarFileSystemImpl.$$$reportNull$$$0(12);
        }
        String string = localPath + "!/";
        if (string == null) {
            JarFileSystemImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        if (entryFile == null) {
            JarFileSystemImpl.$$$reportNull$$$0(14);
        }
        boolean useNewJarHandler = SystemInfo.isWindows && Registry.is("vfs.use.new.jar.handler");
        ZipHandlerBase zipHandlerBase = VfsImplUtil.getHandler(this, entryFile, useNewJarHandler ? BasicJarHandler::new : JarHandler::new);
        if (zipHandlerBase == null) {
            JarFileSystemImpl.$$$reportNull$$$0(15);
        }
        return zipHandlerBase;
    }

    @Override
    public VirtualFile findFileByPath(@NotNull String path2) {
        if (path2 == null) {
            JarFileSystemImpl.$$$reportNull$$$0(16);
        }
        return JarFileSystemImpl.isValid(path2) ? VfsImplUtil.findFileByPath(this, path2) : null;
    }

    @Override
    public VirtualFile findFileByPathIfCached(@NotNull String path2) {
        if (path2 == null) {
            JarFileSystemImpl.$$$reportNull$$$0(17);
        }
        return JarFileSystemImpl.isValid(path2) ? VfsImplUtil.findFileByPathIfCached(this, path2) : null;
    }

    @Override
    public VirtualFile refreshAndFindFileByPath(@NotNull String path2) {
        if (path2 == null) {
            JarFileSystemImpl.$$$reportNull$$$0(18);
        }
        return JarFileSystemImpl.isValid(path2) ? VfsImplUtil.refreshAndFindFileByPath(this, path2) : null;
    }

    private static boolean isValid(String path2) {
        return path2.contains("!/");
    }

    @Override
    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh(this, asynchronous);
    }

    public static void cleanupForNextTest() {
        BasicJarHandler.closeOpenedZipReferences();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalJar";
                break;
            }
            case 6: 
            case 8: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLocalPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "composeRootPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setNoCopyJarForPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMirroredFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMakeCopyOfJar";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractLocalPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "composeRootPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

