/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.core.CoreBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.local.DirectoryAccessChecker;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PreemptiveSafeFileOutputStream;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileSystemBase
extends LocalFileSystem {
    protected static final Logger LOG = Logger.getInstance(LocalFileSystemBase.class);
    private static final FileAttributes FAKE_ROOT_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, 0L, false);
    private final List<LocalFileOperationsHandler> myHandlers = new ArrayList<LocalFileOperationsHandler>();
    private static final String[] ourRootPaths;
    private final DiskQueryRelay<String, FileAttributes> myAttrGetter = new DiskQueryRelay<String, FileAttributes>(FileSystemUtil::getAttributes);
    private final DiskQueryRelay<File, String[]> myChildrenGetter = new DiskQueryRelay<File, String[]>(dir -> dir.list(DirectoryAccessChecker.getFileFilter(dir)));

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull String path2) {
        if (path2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(0);
        }
        return VfsImplUtil.findFileByPath(this, path2);
    }

    @Override
    public VirtualFile findFileByPathIfCached(@NotNull String path2) {
        if (path2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(1);
        }
        return VfsImplUtil.findFileByPathIfCached(this, path2);
    }

    @Override
    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path2) {
        if (path2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(2);
        }
        return VfsImplUtil.refreshAndFindFileByPath(this, path2);
    }

    @Override
    public VirtualFile findFileByIoFile(@NotNull File file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(3);
        }
        return this.findFileByPath(FileUtil.toSystemIndependentName(file2.getAbsolutePath()));
    }

    @NotNull
    private static File convertToIOFile(@NotNull VirtualFile file2) {
        String path2;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(4);
        }
        if (StringUtil.endsWithChar(path2 = file2.getPath(), ':') && path2.length() == 2 && SystemInfo.isWindows) {
            path2 = path2 + '/';
        }
        return new File(path2);
    }

    @NotNull
    private static File convertToIOFileAndCheck(@NotNull VirtualFile file2) throws FileNotFoundException {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(5);
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (SystemInfo.isUnix && (attributes = FileSystemUtil.getAttributes(ioFile)) != null && !attributes.isFile()) {
            throw new FileNotFoundException("Not a file: " + ioFile + " (type=" + (Object)((Object)attributes.type) + ')');
        }
        File file3 = ioFile;
        if (file3 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(6);
        }
        return file3;
    }

    @Override
    public boolean exists(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(7);
        }
        return this.getAttributes(file2) != null;
    }

    @Override
    public long getLength(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(8);
        }
        return (attributes = this.getAttributes(file2)) != null ? attributes.length : 0L;
    }

    @Override
    public long getTimeStamp(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(9);
        }
        return (attributes = this.getAttributes(file2)) != null ? attributes.lastModified : 0L;
    }

    @Override
    public boolean isDirectory(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(10);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isDirectory();
    }

    @Override
    public boolean isWritable(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(11);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isWritable();
    }

    @Override
    public boolean isSymLink(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(12);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isSymLink();
    }

    @Override
    public String resolveSymLink(@NotNull VirtualFile file2) {
        String result2;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(13);
        }
        return (result2 = FileSystemUtil.resolveSymLink(file2.getPath())) != null ? FileUtil.toSystemIndependentName(result2) : null;
    }

    @Override
    public String @NotNull [] list(@NotNull VirtualFile file2) {
        String[] names2;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(14);
        }
        String[] stringArray = (names2 = this.myChildrenGetter.accessDiskWithCheckCanceled(LocalFileSystemBase.convertToIOFile(file2))) == null ? ArrayUtil.EMPTY_STRING_ARRAY : names2;
        if (stringArray == null) {
            LocalFileSystemBase.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String getProtocol() {
        return "file";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    @Nullable
    protected String normalize(@NotNull String path2) {
        if (path2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(16);
        }
        if (SystemInfo.isWindows) {
            if (path2.length() > 1 && path2.charAt(0) == '/' && path2.charAt(1) != '/') {
                path2 = path2.substring(1);
            }
            try {
                path2 = FileUtil.resolveShortWindowsName(path2);
            }
            catch (IOException e) {
                return null;
            }
        }
        try {
            Path file2 = Paths.get(path2, new String[0]);
            if (!(file2.isAbsolute() || SystemInfo.isWindows && path2.length() == 2 && path2.charAt(1) == ':')) {
                path2 = file2.toAbsolutePath().toString();
            }
        }
        catch (IOError | InvalidPathException e) {
            Logger.getInstance(this.getClass()).trace(e);
            return null;
        }
        return FileUtil.normalize(path2);
    }

    @Override
    public VirtualFile refreshAndFindFileByIoFile(@NotNull File file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(17);
        }
        String path2 = FileUtil.toSystemIndependentName(file2.getAbsolutePath());
        return this.refreshAndFindFileByPath(path2);
    }

    @Override
    public void refreshIoFiles(@NotNull Iterable<? extends File> files2) {
        if (files2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(18);
        }
        this.refreshIoFiles(files2, false, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshIoFiles(@NotNull Iterable<? extends File> files2, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        boolean fireCommonRefreshSession;
        if (files2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(19);
        }
        VirtualFileManagerEx manager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        Application app = ApplicationManager.getApplication();
        boolean bl = fireCommonRefreshSession = app.isDispatchThread() || app.isWriteAccessAllowed();
        if (fireCommonRefreshSession) {
            manager.fireBeforeRefreshStart(false);
        }
        try {
            ArrayList<VirtualFile> filesToRefresh = new ArrayList<VirtualFile>();
            for (File file2 : files2) {
                VirtualFile virtualFile2 = this.refreshAndFindFileByIoFile(file2);
                if (virtualFile2 == null) continue;
                filesToRefresh.add(virtualFile2);
            }
            RefreshQueue.getInstance().refresh(async, recursive, onFinish, filesToRefresh);
        }
        finally {
            if (fireCommonRefreshSession) {
                manager.fireAfterRefreshFinish(false);
            }
        }
    }

    @Override
    public void refreshFiles(@NotNull Iterable<? extends VirtualFile> files2) {
        if (files2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(20);
        }
        this.refreshFiles(files2, false, false, null);
    }

    @Override
    public void refreshFiles(@NotNull Iterable<? extends VirtualFile> files2, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        if (files2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(21);
        }
        RefreshQueue.getInstance().refresh(async, recursive, onFinish, ContainerUtil.toCollection(files2));
    }

    @Override
    public void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler2) {
        if (handler2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(22);
        }
        if (this.myHandlers.contains(handler2)) {
            LOG.error("Handler " + handler2 + " already registered.");
        }
        this.myHandlers.add(handler2);
    }

    @Override
    public void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler2) {
        if (handler2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(23);
        }
        if (!this.myHandlers.remove(handler2)) {
            LOG.error("Handler " + handler2 + " haven't been registered or already unregistered.");
        }
    }

    private boolean auxDelete(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(24);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.delete(file2)) continue;
            return true;
        }
        return false;
    }

    private boolean auxMove(@NotNull VirtualFile file2, @NotNull VirtualFile toDir) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(25);
        }
        if (toDir == null) {
            LocalFileSystemBase.$$$reportNull$$$0(26);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.move(file2, toDir)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCopy(@NotNull VirtualFile file2, @NotNull VirtualFile toDir, @NotNull String copyName) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(27);
        }
        if (toDir == null) {
            LocalFileSystemBase.$$$reportNull$$$0(28);
        }
        if (copyName == null) {
            LocalFileSystemBase.$$$reportNull$$$0(29);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            File copy2 = handler2.copy(file2, toDir, copyName);
            if (copy2 == null) continue;
            return true;
        }
        return false;
    }

    private boolean auxRename(@NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(30);
        }
        if (newName == null) {
            LocalFileSystemBase.$$$reportNull$$$0(31);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.rename(file2, newName)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateFile(@NotNull VirtualFile dir, @NotNull String name) throws IOException {
        if (dir == null) {
            LocalFileSystemBase.$$$reportNull$$$0(32);
        }
        if (name == null) {
            LocalFileSystemBase.$$$reportNull$$$0(33);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.createFile(dir, name)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateDirectory(@NotNull VirtualFile dir, @NotNull String name) throws IOException {
        if (dir == null) {
            LocalFileSystemBase.$$$reportNull$$$0(34);
        }
        if (name == null) {
            LocalFileSystemBase.$$$reportNull$$$0(35);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.createDirectory(dir, name)) continue;
            return true;
        }
        return false;
    }

    private void auxNotifyCompleted(@NotNull ThrowableConsumer<LocalFileOperationsHandler, IOException> consumer) {
        if (consumer == null) {
            LocalFileSystemBase.$$$reportNull$$$0(36);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            handler2.afterDone(consumer);
        }
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        File ioDir;
        if (parent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(37);
        }
        if (dir == null) {
            LocalFileSystemBase.$$$reportNull$$$0(38);
        }
        if (!this.isValidName(dir)) {
            throw new IOException(CoreBundle.message("directory.invalid.name.error", dir));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(IdeBundle.message("vfs.target.not.directory.error", parent.getPath()));
        }
        if (parent.findChild(dir) != null) {
            throw new IOException(IdeBundle.message("vfs.target.already.exists.error", parent.getPath() + "/" + dir));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(parent);
        if (!ioParent.isDirectory()) {
            throw new IOException(IdeBundle.message("target.not.directory.error", ioParent.getPath()));
        }
        if (!(this.auxCreateDirectory(parent, dir) || (ioDir = new File(ioParent, dir)).mkdirs() || ioDir.isDirectory())) {
            throw new IOException(IdeBundle.message("new.directory.failed.error", ioDir.getPath()));
        }
        this.auxNotifyCompleted(handler2 -> handler2.createDirectory(parent, dir));
        return new FakeVirtualFile(parent, dir);
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        File ioFile;
        if (parent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(39);
        }
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(40);
        }
        if (!this.isValidName(file2)) {
            throw new IOException(CoreBundle.message("file.invalid.name.error", file2));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(IdeBundle.message("vfs.target.not.directory.error", parent.getPath()));
        }
        if (parent.findChild(file2) != null) {
            throw new IOException(IdeBundle.message("vfs.target.already.exists.error", parent.getPath() + "/" + file2));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(parent);
        if (!ioParent.isDirectory()) {
            throw new IOException(IdeBundle.message("target.not.directory.error", ioParent.getPath()));
        }
        if (!this.auxCreateFile(parent, file2) && !FileUtil.createIfDoesntExist(ioFile = new File(ioParent, file2))) {
            throw new IOException(IdeBundle.message("new.file.failed.error", ioFile.getPath()));
        }
        this.auxNotifyCompleted(handler2 -> handler2.createFile(parent, file2));
        return new FakeVirtualFile(parent, file2);
    }

    @Override
    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        File ioFile;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(41);
        }
        if (file2.getParent() == null) {
            throw new IOException(IdeBundle.message("cannot.delete.root.directory", file2.getPath()));
        }
        if (!this.auxDelete(file2) && !FileUtil.delete(ioFile = LocalFileSystemBase.convertToIOFile(file2))) {
            throw new IOException(IdeBundle.message("delete.failed.error", ioFile.getPath()));
        }
        this.auxNotifyCompleted(handler2 -> handler2.delete(file2));
    }

    @Override
    public boolean isCaseSensitive() {
        return SystemInfo.isFileSystemCaseSensitive;
    }

    @Override
    public boolean isValidName(@NotNull String name) {
        if (name == null) {
            LocalFileSystemBase.$$$reportNull$$$0(42);
        }
        return PathUtilRt.isValidFileName(name, false);
    }

    @Override
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(43);
        }
        return new BufferedInputStream(new FileInputStream(LocalFileSystemBase.convertToIOFileAndCheck(file2)));
    }

    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        byte[] byArray;
        block15: {
            if (file2 == null) {
                LocalFileSystemBase.$$$reportNull$$$0(44);
            }
            try (FileInputStream stream = new FileInputStream(LocalFileSystemBase.convertToIOFileAndCheck(file2));){
                long l = file2.getLength();
                if (l >= (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                    throw new FileTooBigException(file2.getPath());
                }
                int length = (int)l;
                if (length < 0) {
                    throw new IOException("Invalid file length: " + length + ", " + file2);
                }
                byArray = LocalFileSystemBase.loadBytes(length <= 8192 ? stream : new BufferedInputStream(stream), length);
                if (byArray != null) break block15;
            }
            LocalFileSystemBase.$$$reportNull$$$0(45);
        }
        return byArray;
    }

    private static byte @NotNull [] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int count;
        int n;
        if (stream == null) {
            LocalFileSystemBase.$$$reportNull$$$0(46);
        }
        byte[] bytes = new byte[length];
        for (count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (count < length) {
            byte[] byArray = Arrays.copyOf(bytes, count);
            if (byArray == null) {
                LocalFileSystemBase.$$$reportNull$$$0(47);
            }
            return byArray;
        }
        if (bytes == null) {
            LocalFileSystemBase.$$$reportNull$$$0(48);
        }
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file2, Object requestor, long modStamp, long l) throws IOException {
        void timeStamp;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(49);
        }
        File ioFile = LocalFileSystemBase.convertToIOFileAndCheck(file2);
        OutputStream stream = !SafeWriteRequestor.shouldUseSafeWrite(requestor) ? new FileOutputStream(ioFile) : (Registry.is("ide.io.preemptive.safe.write") ? new PreemptiveSafeFileOutputStream(ioFile.toPath()) : new SafeFileOutputStream(ioFile));
        return new BufferedOutputStream(stream, (long)timeStamp, ioFile){
            final /* synthetic */ long val$timeStamp;
            final /* synthetic */ File val$ioFile;
            {
                this.val$timeStamp = l;
                this.val$ioFile = file2;
                super(x0);
            }

            @Override
            public void close() throws IOException {
                super.close();
                if (this.val$timeStamp > 0L && this.val$ioFile.exists() && !this.val$ioFile.setLastModified(this.val$timeStamp)) {
                    LOG.warn("Failed: " + this.val$ioFile.getPath() + ", new:" + this.val$timeStamp + ", old:" + this.val$ioFile.lastModified());
                }
            }
        };
    }

    @Override
    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(50);
        }
        if (newParent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(51);
        }
        String name = file2.getName();
        if (!file2.exists()) {
            throw new IOException(IdeBundle.message("vfs.file.not.exist.error", file2.getPath()));
        }
        if (file2.getParent() == null) {
            throw new IOException(CoreBundle.message("cannot.rename.root.directory", file2.getPath()));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(IdeBundle.message("vfs.target.not.directory.error", newParent.getPath()));
        }
        if (newParent.findChild(name) != null) {
            throw new IOException(IdeBundle.message("vfs.target.already.exists.error", newParent.getPath() + "/" + name));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (FileSystemUtil.getAttributes(ioFile) == null) {
            throw new FileNotFoundException(IdeBundle.message("file.not.exist.error", ioFile.getPath()));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
        if (!ioParent.isDirectory()) {
            throw new IOException(IdeBundle.message("target.not.directory.error", ioParent.getPath()));
        }
        File ioTarget = new File(ioParent, name);
        if (ioTarget.exists()) {
            throw new IOException(IdeBundle.message("target.already.exists.error", ioTarget.getPath()));
        }
        if (!this.auxMove(file2, newParent) && !ioFile.renameTo(ioTarget)) {
            throw new IOException(IdeBundle.message("move.failed.error", ioFile.getPath(), ioParent.getPath()));
        }
        this.auxNotifyCompleted(handler2 -> handler2.move(file2, newParent));
    }

    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        boolean sameName;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(52);
        }
        if (newName == null) {
            LocalFileSystemBase.$$$reportNull$$$0(53);
        }
        if (!this.isValidName(newName)) {
            throw new IOException(CoreBundle.message("file.invalid.name.error", newName));
        }
        boolean bl = sameName = !this.isCaseSensitive() && newName.equalsIgnoreCase(file2.getName());
        if (!file2.exists()) {
            throw new IOException(IdeBundle.message("vfs.file.not.exist.error", file2.getPath()));
        }
        VirtualFile parent = file2.getParent();
        if (parent == null) {
            throw new IOException(CoreBundle.message("cannot.rename.root.directory", file2.getPath()));
        }
        if (!sameName && parent.findChild(newName) != null) {
            throw new IOException(IdeBundle.message("vfs.target.already.exists.error", parent.getPath() + "/" + newName));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (!ioFile.exists()) {
            throw new FileNotFoundException(IdeBundle.message("file.not.exist.error", ioFile.getPath()));
        }
        File ioTarget = new File(LocalFileSystemBase.convertToIOFile(parent), newName);
        if (!sameName && ioTarget.exists()) {
            throw new IOException(IdeBundle.message("target.already.exists.error", ioTarget.getPath()));
        }
        if (!this.auxRename(file2, newName) && !FileUtil.rename(ioFile, newName)) {
            throw new IOException(IdeBundle.message("rename.failed.error", ioFile.getPath(), newName));
        }
        this.auxNotifyCompleted(handler2 -> handler2.rename(file2, newName));
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(54);
        }
        if (newParent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(55);
        }
        if (copyName == null) {
            LocalFileSystemBase.$$$reportNull$$$0(56);
        }
        if (!this.isValidName(copyName)) {
            throw new IOException(CoreBundle.message("file.invalid.name.error", copyName));
        }
        if (!file2.exists()) {
            throw new IOException(IdeBundle.message("vfs.file.not.exist.error", file2.getPath()));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(IdeBundle.message("vfs.target.not.directory.error", newParent.getPath()));
        }
        if (newParent.findChild(copyName) != null) {
            throw new IOException(IdeBundle.message("vfs.target.already.exists.error", newParent.getPath() + "/" + copyName));
        }
        FileAttributes attributes = this.getAttributes(file2);
        if (attributes == null) {
            throw new FileNotFoundException(IdeBundle.message("file.not.exist.error", file2.getPath()));
        }
        if (attributes.isSpecial()) {
            throw new FileNotFoundException("Not a file: " + file2);
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
        if (!ioParent.isDirectory()) {
            throw new IOException(IdeBundle.message("target.not.directory.error", ioParent.getPath()));
        }
        File ioTarget = new File(ioParent, copyName);
        if (ioTarget.exists()) {
            throw new IOException(IdeBundle.message("target.already.exists.error", ioTarget.getPath()));
        }
        if (!this.auxCopy(file2, newParent, copyName)) {
            try {
                File ioFile = LocalFileSystemBase.convertToIOFile(file2);
                FileUtil.copyFileOrDir(ioFile, ioTarget, attributes.isDirectory());
            }
            catch (IOException e) {
                FileUtil.delete(ioTarget);
                throw e;
            }
        }
        this.auxNotifyCompleted(handler2 -> handler2.copy(file2, newParent, copyName));
        return new FakeVirtualFile(newParent, copyName);
    }

    @Override
    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) {
        File ioFile;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(57);
        }
        if ((ioFile = LocalFileSystemBase.convertToIOFile(file2)).exists() && !ioFile.setLastModified(timeStamp)) {
            LOG.warn("Failed: " + file2.getPath() + ", new:" + timeStamp + ", old:" + ioFile.lastModified());
        }
    }

    @Override
    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(58);
        }
        String path2 = FileUtil.toSystemDependentName(file2.getPath());
        FileUtil.setReadOnlyAttribute(path2, !writableFlag);
        if (FileUtil.canWrite(path2) != writableFlag) {
            throw new IOException("Failed to change read-only flag for " + path2);
        }
    }

    @Override
    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        if (normalizedPath == null) {
            LocalFileSystemBase.$$$reportNull$$$0(59);
        }
        for (String customRootPath : ourRootPaths) {
            if (!normalizedPath.startsWith(customRootPath)) continue;
            String string = customRootPath;
            if (string == null) {
                LocalFileSystemBase.$$$reportNull$$$0(60);
            }
            return string;
        }
        if (SystemInfo.isWindows) {
            int p1;
            if (normalizedPath.length() >= 2 && normalizedPath.charAt(1) == ':') {
                String string = StringUtil.toUpperCase(normalizedPath.substring(0, 2));
                if (string == null) {
                    LocalFileSystemBase.$$$reportNull$$$0(61);
                }
                return string;
            }
            if (normalizedPath.startsWith("//") && (p1 = normalizedPath.indexOf(47, 2)) > 2) {
                int p2 = normalizedPath.indexOf(47, p1 + 1);
                if (p2 > p1 + 1) {
                    String string = normalizedPath.substring(0, p2);
                    if (string == null) {
                        LocalFileSystemBase.$$$reportNull$$$0(62);
                    }
                    return string;
                }
                if (p2 < 0) {
                    String string = normalizedPath;
                    if (string == null) {
                        LocalFileSystemBase.$$$reportNull$$$0(63);
                    }
                    return string;
                }
            }
        } else if (StringUtil.startsWithChar(normalizedPath, '/')) {
            return "/";
        }
        return "";
    }

    @Override
    public int getRank() {
        return 1;
    }

    @Override
    public boolean markNewFilesAsDirty() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file2) {
        String string;
        long t;
        block24: {
            String string2;
            block23: {
                String string3;
                block22: {
                    String string4;
                    block21: {
                        if (file2 == null) {
                            LocalFileSystemBase.$$$reportNull$$$0(64);
                        }
                        if (this.isCaseSensitive()) {
                            String string5 = super.getCanonicallyCasedName(file2);
                            if (string5 == null) {
                                LocalFileSystemBase.$$$reportNull$$$0(65);
                            }
                            return string5;
                        }
                        String originalFileName = file2.getName();
                        t = LOG.isTraceEnabled() ? System.nanoTime() : 0L;
                        try {
                            String[] canonicalFileNames;
                            File ioFile = LocalFileSystemBase.convertToIOFile(file2);
                            File canonicalFile = ioFile.getCanonicalFile();
                            String canonicalFileName = canonicalFile.getName();
                            if (!SystemInfo.isUnix) {
                                String string6 = canonicalFileName;
                                string4 = string6;
                                break block21;
                            }
                            if (canonicalFileName.compareToIgnoreCase(originalFileName) == 0) {
                                String string7 = canonicalFileName;
                                string3 = string7;
                                break block22;
                            }
                            File parentFile = ioFile.getParentFile();
                            if (parentFile != null && (canonicalFileNames = parentFile.list()) != null) {
                                for (String name : canonicalFileNames) {
                                    if (name.compareToIgnoreCase(originalFileName) != 0) continue;
                                    String string8 = name;
                                    string2 = string8;
                                    break block23;
                                }
                            }
                            String string9 = canonicalFileName;
                            string = string9;
                            break block24;
                        }
                        catch (IOException | InvalidPathException e) {
                            String string10 = originalFileName;
                            String string11 = string10;
                            if (string11 == null) {
                                LocalFileSystemBase.$$$reportNull$$$0(70);
                            }
                            return string11;
                        }
                    }
                    if (string4 == null) {
                        LocalFileSystemBase.$$$reportNull$$$0(66);
                    }
                    return string4;
                }
                if (string3 == null) {
                    LocalFileSystemBase.$$$reportNull$$$0(67);
                }
                return string3;
            }
            if (string2 == null) {
                LocalFileSystemBase.$$$reportNull$$$0(68);
            }
            return string2;
        }
        if (string == null) {
            LocalFileSystemBase.$$$reportNull$$$0(69);
        }
        return string;
        finally {
            if (t != 0L) {
                t = (System.nanoTime() - t) / 1000L;
                LOG.trace("getCanonicallyCasedName(" + file2 + "): " + t + " mks");
            }
        }
    }

    @Override
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(71);
        }
        String path2 = file2.getPath();
        if (SystemInfo.isWindows && file2.getParent() == null && path2.startsWith("//")) {
            return FAKE_ROOT_ATTRIBUTES;
        }
        return this.myAttrGetter.accessDiskWithCheckCanceled(FileUtil.toSystemDependentName(path2));
    }

    @Override
    public void refresh(boolean asynchronous) {
        RefreshQueue.getInstance().refresh(asynchronous, true, null, ManagingFS.getInstance().getRoots(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasChildren(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(72);
        }
        if (file2.getParent() == null) {
            return true;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(file2.getPath(), new String[0]));){
            boolean bl = stream.iterator().hasNext();
            return bl;
        }
        catch (IOException | SecurityException | InvalidPathException e) {
            return true;
        }
    }

    static {
        List<String> roots = StringUtil.split(System.getProperty("idea.persistentfs.roots", ""), File.pathSeparator);
        Collections.sort(roots, (o1, o2) -> o2.length() - o1.length());
        ourRootPaths = ArrayUtil.toStringArray(roots);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 15: 
            case 45: 
            case 47: 
            case 48: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 15: 
            case 45: 
            case 47: 
            case 48: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 58: 
            case 64: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 15: 
            case 45: 
            case 47: 
            case 48: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 29: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 31: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 32: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 33: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToIOFileAndCheck";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPath";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicallyCasedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIoFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToIOFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertToIOFileAndCheck";
                break;
            }
            case 6: 
            case 15: 
            case 45: 
            case 47: 
            case 48: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByIoFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "refreshIoFiles";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "refreshFiles";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "registerAuxiliaryFileOperationsHandler";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAuxiliaryFileOperationsHandler";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "auxDelete";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "auxMove";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "auxCopy";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "auxRename";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "auxCreateFile";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "auxCreateDirectory";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "auxNotifyCompleted";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicallyCasedName";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 15: 
            case 45: 
            case 47: 
            case 48: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

