/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

class SymbolicLinkRefresher {
    private final ScheduledExecutorService myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService("File SymbolicLinkRefresher", 1);
    private static final int REFRESH_DELAY = 10;
    private final Object myLock = new Object();
    private Set<String> myRefreshQueue = new HashSet<String>();
    private ScheduledFuture<?> myScheduledFuture;
    private final LocalFileSystemImpl mySystem;

    SymbolicLinkRefresher(LocalFileSystemImpl system) {
        this.mySystem = system;
        ApplicationManager.getApplication().getMessageBus().connect(system).subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                SymbolicLinkRefresher.this.analyzeEvents(events);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/local/SymbolicLinkRefresher$1", "after"));
            }
        });
    }

    private void analyzeEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            SymbolicLinkRefresher.$$$reportNull$$$0(0);
        }
        if (events.isEmpty()) {
            return;
        }
        HashSet<String> toRefresh = new HashSet<String>();
        FileWatcher fileWatcher = this.mySystem.getFileWatcher();
        Consumer<String> queuePath = path2 -> toRefresh.addAll(fileWatcher.mapToAllSymlinks(FileUtil.toSystemDependentName(path2)));
        Consumer<VirtualFile> queueFile = file2 -> {
            if (file2 instanceof VirtualFileSystemEntry) {
                if (((VirtualFileSystemEntry)file2).hasSymlink() && !SymbolicLinkRefresher.isUnderRecursiveOrCircularSymlink(file2)) {
                    if ((file2 = ObjectUtils.doIfNotNull(file2.getCanonicalPath(), this.mySystem::findFileByPathIfCached)) != null && fileWatcher.belongsToWatchRoots(FileUtil.toSystemDependentName(file2.getPath()), !file2.isDirectory())) {
                        toRefresh.add(file2.getPath());
                    }
                } else {
                    queuePath.accept(file2.getPath());
                }
            }
        };
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent.isFromRefresh() || vFileEvent.getFileSystem() != this.mySystem) continue;
            if (vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFileDeleteEvent) {
                queueFile.accept(vFileEvent.getFile());
                continue;
            }
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                VirtualFile file3 = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                if (((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) {
                    queuePath.accept(((VFilePropertyChangeEvent)vFileEvent).getOldPath());
                    queueFile.accept(file3.getParent());
                    continue;
                }
                queueFile.accept(file3);
                continue;
            }
            if (vFileEvent instanceof VFileCreateEvent) {
                queueFile.accept(((VFileCreateEvent)vFileEvent).getParent());
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                queueFile.accept(((VFileCopyEvent)vFileEvent).getNewParent());
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) continue;
            queueFile.accept(vFileEvent.getFile());
            queueFile.accept(((VFileMoveEvent)vFileEvent).getNewParent());
        }
        if (!toRefresh.isEmpty()) {
            this.scheduleRefresh(toRefresh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRefresh(Set<String> toRefresh) {
        Object object = this.myLock;
        synchronized (object) {
            this.myRefreshQueue.addAll(toRefresh);
            if (this.myScheduledFuture == null) {
                this.myScheduledFuture = this.myExecutor.schedule(this::performRefresh, 10L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRefresh() {
        Set<String> toRefresh;
        Object object = this.myLock;
        synchronized (object) {
            toRefresh = this.myRefreshQueue;
            this.myRefreshQueue = new HashSet<String>();
            this.myScheduledFuture = null;
        }
        List<VirtualFile> files2 = ContainerUtil.mapNotNull(toRefresh, this.mySystem::findFileByPath);
        RefreshQueue.getInstance().refresh(false, false, null, files2);
    }

    private static boolean isUnderRecursiveOrCircularSymlink(VirtualFile file2) {
        if (((VirtualFileSystemEntry)file2).hasSymlink()) {
            while (file2 != null && !file2.is(VFileProperty.SYMLINK)) {
                file2 = file2.getParent();
            }
            return file2 != null && file2.isRecursiveOrCircularSymLink();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/local/SymbolicLinkRefresher", "analyzeEvents"));
    }
}

