/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class VirtualFileInfoAction
extends AnAction
implements DumbAware {
    public static final DateFormat DATE_FORMAT = SimpleDateFormat.getDateTimeInstance(1, 1);

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        String pathToFile;
        if (e == null) {
            VirtualFileInfoAction.$$$reportNull$$$0(0);
        }
        if ((pathToFile = Messages.showInputDialog("Path to file: ", "Virtual File Info", Messages.getQuestionIcon())) == null) {
            return;
        }
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByIoFile(new File(pathToFile));
        if (virtualFile2 == null) {
            Messages.showErrorDialog("Cannot find virtual file", "Virtual File Info");
            return;
        }
        StringBuilder info = new StringBuilder();
        info.append("Path: ");
        info.append(virtualFile2.getPath());
        info.append("\n");
        info.append("Time stamp: ");
        info.append(DATE_FORMAT.format(new Date(virtualFile2.getTimeStamp())));
        info.append("\n");
        info.append("isValid: ");
        info.append(virtualFile2.isValid());
        info.append("\n");
        info.append("isWritable: ");
        info.append(virtualFile2.isWritable());
        info.append("\n");
        info.append("Content: ");
        try {
            info.append(VfsUtil.loadText(virtualFile2));
        }
        catch (IOException e1) {
            info.append("<unable to load content>");
            info.append(e1.getMessage());
        }
        info.append("\n");
        Messages.showMessageDialog(info.toString(), "Virtual File Info", Messages.getInformationIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vfs/impl/local/VirtualFileInfoAction", "actionPerformed"));
    }
}

