/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

class WatchRootsUtil {
    static final Comparator<String> FILE_NAME_COMPARATOR = FileUtil::comparePaths;

    WatchRootsUtil() {
    }

    static boolean isCoveredRecursively(@NotNull NavigableSet<String> recursiveRoots, @NotNull String path2) {
        String recursiveRoot;
        if (recursiveRoots == null) {
            WatchRootsUtil.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            WatchRootsUtil.$$$reportNull$$$0(1);
        }
        return (recursiveRoot = recursiveRoots.floor(path2)) != null && FileUtil.startsWith(path2, recursiveRoot);
    }

    static <T> void collectByPrefix(@NotNull NavigableMap<String, T> paths, @NotNull String prefix, @NotNull Consumer<Map.Entry<String, T>> collector) {
        if (paths == null) {
            WatchRootsUtil.$$$reportNull$$$0(2);
        }
        if (prefix == null) {
            WatchRootsUtil.$$$reportNull$$$0(3);
        }
        if (collector == null) {
            WatchRootsUtil.$$$reportNull$$$0(4);
        }
        for (Map.Entry entry : paths.tailMap(prefix, false).entrySet()) {
            if (!FileUtil.startsWith((String)entry.getKey(), prefix)) break;
            collector.accept(entry);
        }
    }

    static void insertRecursivePath(@NotNull NavigableSet<String> recursiveRoots, @NotNull String path2) {
        if (recursiveRoots == null) {
            WatchRootsUtil.$$$reportNull$$$0(5);
        }
        if (path2 == null) {
            WatchRootsUtil.$$$reportNull$$$0(6);
        }
        if (!WatchRootsUtil.isCoveredRecursively(recursiveRoots, path2)) {
            String higher;
            recursiveRoots.add(path2);
            while ((higher = recursiveRoots.higher(path2)) != null && FileUtil.startsWith(higher, path2)) {
                recursiveRoots.remove(higher);
            }
        }
    }

    static void forEachPathSegment(@NotNull String path2, char separator, @NotNull Predicate<String> consumer) {
        if (path2 == null) {
            WatchRootsUtil.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            WatchRootsUtil.$$$reportNull$$$0(8);
        }
        int position = path2.indexOf(separator);
        int length = path2.length();
        while (position >= 0 && position < length) {
            String subPath = path2.substring(0, position);
            if (!consumer.test(subPath)) {
                return;
            }
            position = path2.indexOf(separator, position + 1);
        }
        consumer.test(path2);
    }

    @NotNull
    static NavigableSet<String> optimizeFlatRoots(@NotNull Iterable<String> flatRoots, @NotNull NavigableSet<String> recursiveRoots) {
        if (flatRoots == null) {
            WatchRootsUtil.$$$reportNull$$$0(9);
        }
        if (recursiveRoots == null) {
            WatchRootsUtil.$$$reportNull$$$0(10);
        }
        NavigableSet<String> result2 = WatchRootsUtil.createFileNavigableSet();
        for (String flatRoot : flatRoots) {
            if (WatchRootsUtil.isCoveredRecursively(recursiveRoots, flatRoot)) continue;
            result2.add(flatRoot);
        }
        NavigableSet<String> navigableSet = result2;
        if (navigableSet == null) {
            WatchRootsUtil.$$$reportNull$$$0(11);
        }
        return navigableSet;
    }

    @NotNull
    static NavigableSet<String> createFileNavigableSet() {
        return new TreeSet<String>(FILE_NAME_COMPARATOR);
    }

    @NotNull
    static <T> NavigableMap<String, T> createFileNavigableMap() {
        return new TreeMap(FILE_NAME_COMPARATOR);
    }

    static boolean removeRecursivePath(@NotNull NavigableSet<String> optimizedRecursiveRoots, @NotNull NavigableMap<String, ?> sourceRecursiveRoots, @NotNull String path2) {
        if (optimizedRecursiveRoots == null) {
            WatchRootsUtil.$$$reportNull$$$0(12);
        }
        if (sourceRecursiveRoots == null) {
            WatchRootsUtil.$$$reportNull$$$0(13);
        }
        if (path2 == null) {
            WatchRootsUtil.$$$reportNull$$$0(14);
        }
        if (!optimizedRecursiveRoots.remove(path2)) {
            return false;
        }
        Ref lastPathRef = new Ref();
        WatchRootsUtil.collectByPrefix(sourceRecursiveRoots, path2, entry -> {
            String lastPath = (String)lastPathRef.get();
            String childPath = (String)entry.getKey();
            if (lastPath == null || !FileUtil.startsWith(childPath, lastPath)) {
                optimizedRecursiveRoots.add(childPath);
                lastPathRef.set(childPath);
            }
        });
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursiveRoots";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatRoots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/WatchRootsUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimizedRecursiveRoots";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRecursiveRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/WatchRootsUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeFlatRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCoveredRecursively";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectByPrefix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertRecursivePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forEachPathSegment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "optimizeFlatRoots";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeRecursivePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

