/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.local;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class CoreLocalVirtualFile
extends VirtualFile {
    private final CoreLocalFileSystem myFileSystem;
    private final File myIoFile;
    private VirtualFile[] myChildren;
    private final NotNullLazyValue<Boolean> myIsDirectory;

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull File ioFile) {
        if (fileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(0);
        }
        if (ioFile == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(1);
        }
        this.myFileSystem = fileSystem;
        this.myIoFile = ioFile;
        this.myIsDirectory = NotNullLazyValue.createValue(this.myIoFile::isDirectory);
    }

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull File ioFile, boolean isDirectory) {
        if (fileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(2);
        }
        if (ioFile == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(3);
        }
        this.myFileSystem = fileSystem;
        this.myIoFile = ioFile;
        this.myIsDirectory = NotNullLazyValue.createConstantValue(isDirectory);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myIoFile.getName();
        if (string == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        CoreLocalFileSystem coreLocalFileSystem = this.myFileSystem;
        if (coreLocalFileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(5);
        }
        return coreLocalFileSystem;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = FileUtil.toSystemIndependentName(this.myIoFile.getAbsolutePath());
        if (string == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.myIsDirectory.getValue();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public VirtualFile getParent() {
        File parentFile = this.myIoFile.getParentFile();
        return parentFile != null ? new CoreLocalVirtualFile(this.myFileSystem, parentFile, true) : null;
    }

    @Override
    public VirtualFile[] getChildren() {
        VirtualFile[] answer = this.myChildren;
        if (answer == null) {
            File[] files2 = this.myIoFile.listFiles();
            if (files2 == null || files2.length == 0) {
                answer = EMPTY_ARRAY;
            } else {
                answer = new VirtualFile[files2.length];
                for (int i = 0; i < files2.length; ++i) {
                    answer[i] = new CoreLocalVirtualFile(this.myFileSystem, files2[i]);
                }
            }
            this.myChildren = answer;
        }
        return answer;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte @NotNull [] contentsToByteArray() throws IOException {
        byte[] byArray = FileUtil.loadFileBytes(this.myIoFile);
        if (byArray == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(7);
        }
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.myIoFile.lastModified();
    }

    @Override
    public long getLength() {
        return this.myIoFile.length();
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.inputStreamSkippingBOM(new BufferedInputStream(new FileInputStream(this.myIoFile)), this);
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreLocalVirtualFile that = (CoreLocalVirtualFile)o;
        return this.myIoFile.equals(that.myIoFile);
    }

    public int hashCode() {
        return this.myIoFile.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/local/CoreLocalVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/local/CoreLocalVirtualFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

