/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AsyncEventSupport {
    private static final Logger LOG = Logger.getInstance(AsyncEventSupport.class);
    @ApiStatus.Internal
    public static final ExtensionPointName<AsyncFileListener> EP_NAME = ExtensionPointName.create("com.intellij.vfs.asyncListener");
    private static boolean ourSuppressAppliers;

    public static void startListening() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){
            Pair<List<? extends VFileEvent>, List<AsyncFileListener.ChangeApplier>> appliersFromBefore;

            @Override
            public void before(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ourSuppressAppliers) {
                    return;
                }
                List<AsyncFileListener.ChangeApplier> appliers = AsyncEventSupport.runAsyncListeners(events);
                this.appliersFromBefore = Pair.create(events, appliers);
                AsyncEventSupport.beforeVfsChange(appliers);
            }

            @Override
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ourSuppressAppliers) {
                    return;
                }
                List appliers = this.appliersFromBefore != null && ((List)this.appliersFromBefore.first).equals(events) ? (List)this.appliersFromBefore.second : AsyncEventSupport.runAsyncListeners(events);
                this.appliersFromBefore = null;
                AsyncEventSupport.afterVfsChange(appliers);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/AsyncEventSupport$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "before";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static List<AsyncFileListener.ChangeApplier> runAsyncListeners(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            AsyncEventSupport.$$$reportNull$$$0(0);
        }
        if (events.isEmpty()) {
            List<AsyncFileListener.ChangeApplier> list2 = Collections.emptyList();
            if (list2 == null) {
                AsyncEventSupport.$$$reportNull$$$0(1);
            }
            return list2;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing " + events);
        }
        ArrayList<AsyncFileListener.ChangeApplier> appliers = new ArrayList<AsyncFileListener.ChangeApplier>();
        List<AsyncFileListener> allListeners = ContainerUtil.concat(EP_NAME.getExtensionList(), ((VirtualFileManagerImpl)VirtualFileManager.getInstance()).getAsyncFileListeners());
        for (AsyncFileListener listener2 : allListeners) {
            long elapsedMs;
            ProgressManager.checkCanceled();
            long startNs = System.nanoTime();
            boolean canceled = false;
            try {
                ReadAction.run(() -> ContainerUtil.addIfNotNull(appliers, listener2.prepareChange(events)));
            }
            catch (ProcessCanceledException e) {
                try {
                    canceled = true;
                    throw e;
                    catch (Throwable e2) {
                        LOG.error(e2);
                        elapsedMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
                        if (elapsedMs <= 10000L) continue;
                        LOG.warn(listener2 + " took too long (" + elapsedMs + "ms) on " + events.size() + " events" + (canceled ? ", canceled" : ""));
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    long elapsedMs2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
                    if (elapsedMs2 > 10000L) {
                        LOG.warn(listener2 + " took too long (" + elapsedMs2 + "ms) on " + events.size() + " events" + (canceled ? ", canceled" : ""));
                    }
                    throw throwable;
                }
            }
            elapsedMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            if (elapsedMs <= 10000L) continue;
            LOG.warn(listener2 + " took too long (" + elapsedMs + "ms) on " + events.size() + " events" + (canceled ? ", canceled" : ""));
        }
        ArrayList<AsyncFileListener.ChangeApplier> arrayList = appliers;
        if (arrayList == null) {
            AsyncEventSupport.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void beforeVfsChange(List<? extends AsyncFileListener.ChangeApplier> appliers) {
        for (AsyncFileListener.ChangeApplier changeApplier : appliers) {
            try {
                changeApplier.beforeVfsChange();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private static void afterVfsChange(List<? extends AsyncFileListener.ChangeApplier> appliers) {
        for (AsyncFileListener.ChangeApplier changeApplier : appliers) {
            try {
                changeApplier.afterVfsChange();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    static void processEvents(List<? extends VFileEvent> events, @Nullable List<? extends AsyncFileListener.ChangeApplier> appliers) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (appliers != null) {
            AsyncEventSupport.beforeVfsChange(appliers);
            ourSuppressAppliers = true;
        }
        try {
            PersistentFS.getInstance().processEvents(events);
        }
        finally {
            ourSuppressAppliers = false;
        }
        if (appliers != null) {
            AsyncEventSupport.afterVfsChange(appliers);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/AsyncEventSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/AsyncEventSupport";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "runAsyncListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runAsyncListeners";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

