/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAttribute {
    private static final Set<String> ourRegisteredIds = ContainerUtil.newConcurrentSet();
    private static final int UNDEFINED_VERSION = -1;
    private final String myId;
    private final int myVersion;
    private final boolean myFixedSize;

    public FileAttribute(@NonNls @NotNull String id2) {
        if (id2 == null) {
            FileAttribute.$$$reportNull$$$0(0);
        }
        this(id2, -1, false);
    }

    public FileAttribute(@NonNls @NotNull String id2, int version2, boolean fixedSize) {
        if (id2 == null) {
            FileAttribute.$$$reportNull$$$0(1);
        }
        this(version2, fixedSize, id2);
        boolean added = ourRegisteredIds.add(id2);
        assert (added) : "Attribute id='" + id2 + "' is not unique";
    }

    private FileAttribute(int version2, boolean fixedSize, @NotNull String id2) {
        if (id2 == null) {
            FileAttribute.$$$reportNull$$$0(2);
        }
        this.myId = id2;
        this.myVersion = version2;
        this.myFixedSize = fixedSize;
    }

    @Nullable
    public DataInputStream readAttribute(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileAttribute.$$$reportNull$$$0(3);
        }
        return ManagingFS.getInstance().readAttribute(file2, this);
    }

    @NotNull
    public DataOutputStream writeAttribute(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileAttribute.$$$reportNull$$$0(4);
        }
        DataOutputStream dataOutputStream = ManagingFS.getInstance().writeAttribute(file2, this);
        if (dataOutputStream == null) {
            FileAttribute.$$$reportNull$$$0(5);
        }
        return dataOutputStream;
    }

    public byte @Nullable [] readAttributeBytes(VirtualFile file2) throws IOException {
        try (DataInputStream stream = this.readAttribute(file2);){
            if (stream == null) {
                byte[] byArray = null;
                return byArray;
            }
            int len = stream.readInt();
            byte[] byArray = FileUtil.loadBytes(stream, len);
            return byArray;
        }
    }

    public void writeAttributeBytes(VirtualFile file2, byte @NotNull [] bytes) throws IOException {
        if (bytes == null) {
            FileAttribute.$$$reportNull$$$0(6);
        }
        this.writeAttributeBytes(file2, bytes, 0, bytes.length);
    }

    public void writeAttributeBytes(VirtualFile file2, byte[] bytes, int offset, int len) throws IOException {
        try (DataOutputStream stream = this.writeAttribute(file2);){
            stream.writeInt(len);
            stream.write(bytes, offset, len);
        }
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            FileAttribute.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isFixedSize() {
        return this.myFixedSize;
    }

    @NotNull
    public FileAttribute newVersion(int newVersion) {
        return new FileAttribute(newVersion, this.myFixedSize, this.myId);
    }

    public int getVersion() {
        return this.myVersion;
    }

    public boolean isVersioned() {
        return this.myVersion != -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/FileAttribute";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/FileAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributeBytes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

