/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.FrequentEventDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.RefreshProgress;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.RefreshSessionImpl;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.EDT;
import gnu.trove.TLongObjectHashMap;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class RefreshQueueImpl
extends RefreshQueue
implements Disposable {
    private static final Logger LOG = Logger.getInstance(RefreshQueueImpl.class);
    private final Executor myQueue = AppExecutorUtil.createBoundedApplicationPoolExecutor("RefreshQueue Pool", PooledThreadExecutor.INSTANCE, 1, this);
    private final Executor myEventProcessingQueue = AppExecutorUtil.createBoundedApplicationPoolExecutor("Async Refresh Event Processing", PooledThreadExecutor.INSTANCE, 1, this);
    private final ProgressIndicator myRefreshIndicator = RefreshProgress.create(IdeBundle.message("file.synchronize.progress", new Object[0]));
    private int myBusyThreads;
    private final TLongObjectHashMap<RefreshSession> mySessions = new TLongObjectHashMap();
    private final FrequentEventDetector myEventCounter = new FrequentEventDetector(100, 100, FrequentEventDetector.Level.WARN);

    public void execute(@NotNull RefreshSessionImpl session2) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(0);
        }
        if (session2.isAsynchronous()) {
            this.queueSession(session2, session2.getModality());
        } else {
            Application app = ApplicationManager.getApplication();
            if (app.isWriteThread()) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
                this.doScan(session2);
                session2.fireEvents(session2.getEvents(), null);
            } else {
                if (((ApplicationEx)app).holdsReadLock() || EDT.isCurrentThreadEdt()) {
                    LOG.error("Do not perform a synchronous refresh under read lock (except from EDT) - causes deadlocks if there are events to fire.");
                    return;
                }
                this.queueSession(session2, ModalityState.defaultModalityState());
                session2.waitFor();
            }
        }
    }

    private void queueSession(@NotNull RefreshSessionImpl session2, @NotNull ModalityState modality) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(1);
        }
        if (modality == null) {
            RefreshQueueImpl.$$$reportNull$$$0(2);
        }
        this.myQueue.execute(() -> {
            this.startRefreshActivity();
            try (AccessToken ignored = HeavyProcessLatch.INSTANCE.processStarted("Doing file refresh. " + session2);){
                this.doScan(session2);
            }
            finally {
                this.finishRefreshActivity();
                if (Registry.is("vfs.async.event.processing")) {
                    this.scheduleAsynchronousPreprocessing(session2, modality);
                } else {
                    AppUIExecutor.onWriteThread(modality).later().submit(() -> session2.fireEvents(session2.getEvents(), null));
                }
            }
        });
        this.myEventCounter.eventHappened(session2);
    }

    private void scheduleAsynchronousPreprocessing(@NotNull RefreshSessionImpl session2, @NotNull ModalityState modality) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(3);
        }
        if (modality == null) {
            RefreshQueueImpl.$$$reportNull$$$0(4);
        }
        try {
            this.startRefreshActivity();
            ReadAction.nonBlocking(() -> RefreshQueueImpl.runAsyncListeners(session2)).wrapProgress(this.myRefreshIndicator).finishOnUiThread(modality, Runnable::run).submit(this.myEventProcessingQueue).onProcessed(__ -> this.finishRefreshActivity()).onError(t -> {
                if (!this.myRefreshIndicator.isCanceled()) {
                    LOG.error((Throwable)t);
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOG.debug(e);
        }
    }

    private synchronized void startRefreshActivity() {
        if (this.myBusyThreads++ == 0) {
            this.myRefreshIndicator.start();
        }
    }

    private synchronized void finishRefreshActivity() {
        if (--this.myBusyThreads == 0) {
            this.myRefreshIndicator.stop();
        }
    }

    private static Runnable runAsyncListeners(@NotNull RefreshSessionImpl session2) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(5);
        }
        List<VFileEvent> events = ContainerUtil.filter(session2.getEvents(), e -> {
            VirtualFile file2 = e instanceof VFileCreateEvent ? ((VFileCreateEvent)e).getParent() : e.getFile();
            return file2 == null || file2.isValid();
        });
        List<AsyncFileListener.ChangeApplier> appliers = AsyncEventSupport.runAsyncListeners(events);
        return () -> session2.fireEvents(events, appliers);
    }

    private void doScan(@NotNull RefreshSessionImpl session2) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(6);
        }
        try {
            this.updateSessionMap(session2, true);
            session2.scan();
        }
        finally {
            this.updateSessionMap(session2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSessionMap(@NotNull RefreshSession session2, boolean add) {
        long id2;
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(7);
        }
        if ((id2 = session2.getId()) != 0L) {
            TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
            synchronized (tLongObjectHashMap) {
                if (add) {
                    this.mySessions.put(id2, session2);
                } else {
                    this.mySessions.remove(id2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelSession(long id2) {
        RefreshSession session2;
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
        synchronized (tLongObjectHashMap) {
            session2 = this.mySessions.get(id2);
        }
        if (session2 instanceof RefreshSessionImpl) {
            ((RefreshSessionImpl)session2).cancel();
        }
    }

    @Override
    @NotNull
    public RefreshSession createSession(boolean async, boolean recursively, @Nullable Runnable finishRunnable, @NotNull ModalityState state) {
        if (state == null) {
            RefreshQueueImpl.$$$reportNull$$$0(8);
        }
        return new RefreshSessionImpl(async, recursively, finishRunnable, state);
    }

    @Override
    public void processSingleEvent(@NotNull VFileEvent event) {
        if (event == null) {
            RefreshQueueImpl.$$$reportNull$$$0(9);
        }
        new RefreshSessionImpl(Collections.singletonList(event)).launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRefreshInProgress() {
        RefreshQueueImpl refreshQueue = (RefreshQueueImpl)RefreshQueue.getInstance();
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = refreshQueue.mySessions;
        synchronized (tLongObjectHashMap) {
            return !refreshQueue.mySessions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        TLongObjectHashMap<RefreshSession> tLongObjectHashMap = this.mySessions;
        synchronized (tLongObjectHashMap) {
            this.mySessions.forEachValue(session2 -> {
                ((RefreshSessionImpl)session2).cancel();
                return true;
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "queueSession";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleAsynchronousPreprocessing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runAsyncListeners";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doScan";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSessionMap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createSession";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processSingleEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

