/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CachedFileType {
    private static final ConcurrentMap<FileType, CachedFileType> ourInterner = ContainerUtil.newConcurrentMap();
    @Nullable
    private FileType fileType;

    private CachedFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            CachedFileType.$$$reportNull$$$0(0);
        }
        this.fileType = fileType;
    }

    @Nullable
    FileType getUpToDateOrNull() {
        return this.fileType;
    }

    static CachedFileType forType(@NotNull FileType fileType) {
        CachedFileType cached;
        if (fileType == null) {
            CachedFileType.$$$reportNull$$$0(1);
        }
        return (cached = (CachedFileType)ourInterner.get(fileType)) != null ? cached : CachedFileType.computeSynchronized(fileType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CachedFileType computeSynchronized(FileType fileType) {
        ConcurrentMap<FileType, CachedFileType> concurrentMap = ourInterner;
        synchronized (concurrentMap) {
            return ourInterner.computeIfAbsent(fileType, CachedFileType::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        ConcurrentMap<FileType, CachedFileType> concurrentMap = ourInterner;
        synchronized (concurrentMap) {
            for (CachedFileType value2 : ourInterner.values()) {
                value2.fileType = null;
            }
            ourInterner.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(FileType type) {
        ConcurrentMap<FileType, CachedFileType> concurrentMap = ourInterner;
        synchronized (concurrentMap) {
            CachedFileType cached = (CachedFileType)ourInterner.get(type);
            if (cached != null) {
                cached.fileType = null;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "fileType";
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/CachedFileType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "forType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PsiListener
    implements PsiModificationTracker.Listener {
        @Override
        public void modificationCountChanged() {
            CachedFileType.clearCache();
        }
    }
}

