/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class FileLoadingTracker {
    private static final Logger LOG = Logger.getInstance(FileLoadingTracker.class);
    private static final Set<String> ourPaths = new THashSet<String>(FileLoadingTracker.getPathsToTrack(), FilePathHashingStrategy.create());
    private static final TIntHashSet ourLeafNameIds = new TIntHashSet(ourPaths.stream().mapToInt(path2 -> FileNameCache.storeName(StringUtil.getShortName(path2, '/'))).toArray());

    FileLoadingTracker() {
    }

    @NotNull
    private static List<String> getPathsToTrack() {
        List<String> list2;
        try {
            list2 = StringUtil.split(Registry.stringValue("file.system.trace.loading"), ";");
        }
        catch (MissingResourceException e) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                FileLoadingTracker.$$$reportNull$$$0(1);
            }
            return list3;
        }
        if (list2 == null) {
            FileLoadingTracker.$$$reportNull$$$0(0);
        }
        return list2;
    }

    static void fileLoaded(@NotNull VirtualDirectoryImpl parent, int nameId) {
        String path2;
        if (parent == null) {
            FileLoadingTracker.$$$reportNull$$$0(2);
        }
        if (ourLeafNameIds.contains(nameId) && ourPaths.contains(path2 = parent.getPath() + "/" + FileNameCache.getVFileName(nameId).toString())) {
            LOG.info("Loading " + path2, new Throwable());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/FileLoadingTracker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToTrack";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/FileLoadingTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fileLoaded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

