/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.impl.CachedFileType;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.CompactRecordsTable;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.CompressionUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.io.storage.RefCountingStorage;
import com.intellij.util.io.storage.Storage;
import gnu.trove.TIntArrayList;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FSRecords {
    private static final Logger LOG = Logger.getInstance(FSRecords.class);
    public static final boolean WE_HAVE_CONTENT_HASHES = SystemProperties.getBooleanProperty("idea.share.contents", true);
    static final String VFS_FILES_EXTENSION = System.getProperty("idea.vfs.files.extension", ".dat");
    private static final boolean lazyVfsDataCleaning = SystemProperties.getBooleanProperty("idea.lazy.vfs.data.cleaning", true);
    private static final boolean backgroundVfsFlush = SystemProperties.getBooleanProperty("idea.background.vfs.flush", true);
    private static final boolean inlineAttributes = SystemProperties.getBooleanProperty("idea.inline.vfs.attributes", true);
    private static final boolean bulkAttrReadSupport = SystemProperties.getBooleanProperty("idea.bulk.attr.read", false);
    private static final boolean useCompressionUtil = SystemProperties.getBooleanProperty("idea.use.lightweight.compression.for.vfs", false);
    private static final boolean useSmallAttrTable = SystemProperties.getBooleanProperty("idea.use.small.attr.table.for.vfs", true);
    private static final boolean ourStoreRootsSeparately = SystemProperties.getBooleanProperty("idea.store.roots.separately", false);
    private static final int VERSION = 53 + (WE_HAVE_CONTENT_HASHES ? 16 : 0) + (IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER ? 55 : 0) + (bulkAttrReadSupport ? 39 : 0) + (inlineAttributes ? 49 : 0) + (ourStoreRootsSeparately ? 99 : 0) + (useCompressionUtil ? 127 : 0) + (useSmallAttrTable ? 49 : 0) + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 21 : 0);
    private static final int PARENT_OFFSET = 0;
    private static final int PARENT_SIZE = 4;
    private static final int NAME_OFFSET = 4;
    private static final int NAME_SIZE = 4;
    private static final int FLAGS_OFFSET = 8;
    private static final int FLAGS_SIZE = 4;
    private static final int ATTR_REF_OFFSET = 12;
    private static final int ATTR_REF_SIZE = 4;
    private static final int CONTENT_OFFSET = 16;
    private static final int CONTENT_SIZE = 4;
    private static final int TIMESTAMP_OFFSET = 20;
    private static final int TIMESTAMP_SIZE = 8;
    private static final int MOD_COUNT_OFFSET = 28;
    private static final int MOD_COUNT_SIZE = 4;
    private static final int LENGTH_OFFSET = 32;
    private static final int LENGTH_SIZE = 8;
    private static final int RECORD_SIZE = 40;
    private static final byte[] ZEROES = new byte[40];
    private static final int HEADER_VERSION_OFFSET = 0;
    private static final int HEADER_GLOBAL_MOD_COUNT_OFFSET = 8;
    private static final int HEADER_CONNECTION_STATUS_OFFSET = 12;
    private static final int HEADER_TIMESTAMP_OFFSET = 16;
    private static final int HEADER_SIZE = 24;
    private static final int CONNECTED_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190095;
    private static final int CORRUPTED_MAGIC = -1412464769;
    private static final FileAttribute ourChildrenAttr = new FileAttribute("FsRecords.DIRECTORY_CHILDREN");
    private static final FileAttribute ourSymlinkTargetAttr = new FileAttribute("FsRecords.SYMLINK_TARGET_2");
    private static final FileAttribute ourSymlinkTargetAttr_old = new FileAttribute("FsRecords.SYMLINK_TARGET");
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock r = lock.readLock();
    private static final ReentrantReadWriteLock.WriteLock w = lock.writeLock();
    private static volatile int ourLocalModificationCount;
    private static volatile boolean ourIsDisposed;
    private static final int FREE_RECORD_FLAG = 256;
    private static final int ALL_VALID_FLAGS = 383;
    private static final int MAX_INITIALIZATION_ATTEMPTS = 10;
    private static final int ROOT_RECORD_ID = 1;
    private static final int MAX_SMALL_ATTR_SIZE = 64;
    private static final boolean DUMP_STATISTICS;
    private static long totalContents;
    private static long totalReuses;
    private static long time;
    private static int contents;
    private static int reuses;
    private static final MessageDigest CONTENT_HASH_DIGEST;

    static void writeAttributesToRecord(int id2, int parentId, @NotNull FileAttributes attributes, @NotNull String name) {
        if (attributes == null) {
            FSRecords.$$$reportNull$$$0(0);
        }
        if (name == null) {
            FSRecords.$$$reportNull$$$0(1);
        }
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.setName(id2, name);
            FSRecords.setTimestamp(id2, attributes.lastModified);
            FSRecords.setLength(id2, attributes.isDirectory() ? -1L : attributes.length);
            FSRecords.setFlags(id2, (attributes.isDirectory() ? 2 : 0) | (attributes.isWritable() ? 0 : 4) | (attributes.isSymLink() ? 16 : 0) | (attributes.isSpecial() ? 32 : 0) | (attributes.isHidden() ? 64 : 0), true);
            FSRecords.setParent(id2, parentId);
        });
    }

    @Contract(value="_->fail")
    static void requestVfsRebuild(@NotNull Throwable e) {
        if (e == null) {
            FSRecords.$$$reportNull$$$0(2);
        }
        DbConnection.handleError(e);
    }

    @NotNull
    static File basePath() {
        return new File(DbConnection.getCachesDir());
    }

    private FSRecords() {
    }

    @ApiStatus.Internal
    public static int getVersion() {
        return VERSION;
    }

    static void connect() {
        DbConnection.connect();
    }

    public static long getCreationTimestamp() {
        return FSRecords.readAndHandleErrors(() -> DbConnection.getTimestamp());
    }

    private static ResizeableMappedFile getRecords() {
        ResizeableMappedFile records = DbConnection.myRecords;
        assert (records != null) : "Vfs must be initialized";
        return records;
    }

    private static ContentHashEnumerator getContentHashesEnumerator() {
        return DbConnection.myContentHashesEnumerator;
    }

    private static RefCountingStorage getContentStorage() {
        return DbConnection.myContents;
    }

    private static Storage getAttributesStorage() {
        return DbConnection.myAttributes;
    }

    private static PersistentStringEnumerator getNames() {
        return DbConnection.getNames();
    }

    public static int createRecord() {
        return FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            int free = DbConnection.getFreeRecord();
            if (free == 0) {
                int fileLength = FSRecords.length();
                LOG.assertTrue(fileLength % 40 == 0);
                int newRecord = fileLength / 40;
                DbConnection.cleanRecord(newRecord);
                assert (fileLength + 40 == FSRecords.length());
                return newRecord;
            }
            if (lazyVfsDataCleaning) {
                FSRecords.deleteContentAndAttributes(free);
            }
            DbConnection.cleanRecord(free);
            return free;
        });
    }

    private static int length() {
        return (int)FSRecords.getRecords().length();
    }

    public static int getMaxId() {
        return FSRecords.readAndHandleErrors(() -> FSRecords.length() / 40);
    }

    static void deleteRecordRecursively(int id2) {
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(id2);
            if (lazyVfsDataCleaning) {
                FSRecords.markAsDeletedRecursively(id2);
            } else {
                FSRecords.doDeleteRecursively(id2);
            }
        });
    }

    private static void markAsDeletedRecursively(int id2) {
        for (int subRecord : FSRecords.list(id2)) {
            FSRecords.markAsDeletedRecursively(subRecord);
        }
        FSRecords.markAsDeleted(id2);
    }

    private static void markAsDeleted(int id2) {
        FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            FSRecords.addToFreeRecordsList(id2);
        });
    }

    private static void doDeleteRecursively(int id2) {
        for (int subRecord : FSRecords.list(id2)) {
            FSRecords.doDeleteRecursively(subRecord);
        }
        FSRecords.deleteRecord(id2);
    }

    private static void deleteRecord(int id2) {
        FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            FSRecords.deleteContentAndAttributes(id2);
            DbConnection.cleanRecord(id2);
            FSRecords.addToFreeRecordsList(id2);
        });
    }

    private static void deleteContentAndAttributes(int id2) throws IOException {
        int att_page;
        int content_page = FSRecords.getContentRecordId(id2);
        if (content_page != 0) {
            if (WE_HAVE_CONTENT_HASHES) {
                FSRecords.getContentStorage().releaseRecord(content_page, false);
            } else {
                FSRecords.getContentStorage().releaseRecord(content_page);
            }
        }
        if ((att_page = FSRecords.getAttributeRecordId(id2)) != 0) {
            try (DataInputStream attStream = FSRecords.getAttributesStorage().readStream(att_page);){
                if (bulkAttrReadSupport) {
                    FSRecords.skipRecordHeader(attStream, DbConnection.RESERVED_ATTR_ID, id2);
                }
                while (attStream.available() > 0) {
                    DataInputOutputUtil.readINT(attStream);
                    int attAddressOrSize = DataInputOutputUtil.readINT(attStream);
                    if (inlineAttributes) {
                        if (attAddressOrSize < 64) {
                            attStream.skipBytes(attAddressOrSize);
                            continue;
                        }
                        attAddressOrSize -= 64;
                    }
                    FSRecords.getAttributesStorage().deleteRecord(attAddressOrSize);
                }
            }
            FSRecords.getAttributesStorage().deleteRecord(att_page);
        }
    }

    private static void addToFreeRecordsList(int id2) {
        FSRecords.setFlags(id2, 256, false);
    }

    static int @NotNull [] listRoots() {
        int[] nArray = FSRecords.readAndHandleErrors(() -> {
            if (ourStoreRootsSeparately) {
                TIntArrayList result2 = new TIntArrayList();
                try (LineNumberReader stream = new LineNumberReader(new BufferedReader(new InputStreamReader(new FileInputStream(DbConnection.myRootsFile))));){
                    String str;
                    while ((str = stream.readLine()) != null) {
                        int index = str.indexOf(32);
                        int id2 = Integer.parseInt(str.substring(0, index));
                        result2.add(id2);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                return result2.toNativeArray();
            }
            try (DataInputStream input = FSRecords.readAttribute(1, ourChildrenAttr);){
                if (input == null) {
                    int[] nArray = ArrayUtilRt.EMPTY_INT_ARRAY;
                    return nArray;
                }
                int count = DataInputOutputUtil.readINT(input);
                int[] result3 = ArrayUtil.newIntArray(count);
                int prevId = 0;
                for (int i = 0; i < count; ++i) {
                    DataInputOutputUtil.readINT(input);
                    prevId = result3[i] = DataInputOutputUtil.readINT(input) + prevId;
                }
                int[] nArray = result3;
                return nArray;
            }
        });
        if (nArray == null) {
            FSRecords.$$$reportNull$$$0(3);
        }
        return nArray;
    }

    static void force() {
        FSRecords.writeAndHandleErrors(() -> DbConnection.doForce());
    }

    static boolean isDirty() {
        return FSRecords.readAndHandleErrors(DbConnection::isDirty);
    }

    private static void saveNameIdSequenceWithDeltas(int[] names2, int[] ids, DataOutputStream output) throws IOException {
        DataInputOutputUtil.writeINT(output, names2.length);
        int prevId = 0;
        int prevNameId = 0;
        for (int i = 0; i < names2.length; ++i) {
            DataInputOutputUtil.writeINT(output, names2[i] - prevNameId);
            DataInputOutputUtil.writeINT(output, ids[i] - prevId);
            prevId = ids[i];
            prevNameId = names2[i];
        }
    }

    static int findRootRecord(@NotNull String rootUrl) {
        if (rootUrl == null) {
            FSRecords.$$$reportNull$$$0(4);
        }
        return FSRecords.writeAndHandleErrors(() -> {
            int id2;
            if (ourStoreRootsSeparately) {
                Throwable throwable;
                Closeable stream2;
                try {
                    stream2 = new LineNumberReader(new BufferedReader(new InputStreamReader(new FileInputStream(DbConnection.myRootsFile))));
                    throwable = null;
                    try {
                        String str;
                        while ((str = ((LineNumberReader)stream2).readLine()) != null) {
                            int index = str.indexOf(32);
                            if (!str.substring(index + 1).equals(rootUrl)) continue;
                            Integer n = Integer.parseInt(str.substring(0, index));
                            return n;
                        }
                    }
                    catch (Throwable str) {
                        throwable = str;
                        throw str;
                    }
                    finally {
                        if (stream2 != null) {
                            if (throwable != null) {
                                try {
                                    ((BufferedReader)stream2).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                ((BufferedReader)stream2).close();
                            }
                        }
                    }
                }
                catch (FileNotFoundException stream2) {
                    // empty catch block
                }
                DbConnection.markDirty();
                stream2 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(DbConnection.myRootsFile, true)));
                throwable = null;
                try {
                    int id3 = FSRecords.createRecord();
                    ((Writer)stream2).write(id3 + " " + rootUrl + "\n");
                    Integer index = id3;
                    return index;
                }
                catch (Throwable id3) {
                    throwable = id3;
                    throw id3;
                }
                finally {
                    if (stream2 != null) {
                        if (throwable != null) {
                            try {
                                ((Writer)stream2).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((Writer)stream2).close();
                        }
                    }
                }
            }
            int root = FSRecords.getNames().tryEnumerate(rootUrl);
            int[] names2 = ArrayUtilRt.EMPTY_INT_ARRAY;
            int[] ids = ArrayUtilRt.EMPTY_INT_ARRAY;
            try (DataInputStream input = FSRecords.readAttribute(1, ourChildrenAttr);){
                if (input != null) {
                    int count = DataInputOutputUtil.readINT(input);
                    names2 = ArrayUtil.newIntArray(count);
                    ids = ArrayUtil.newIntArray(count);
                    int prevId = 0;
                    int prevNameId = 0;
                    for (int i = 0; i < count; ++i) {
                        int name = DataInputOutputUtil.readINT(input) + prevNameId;
                        int id4 = DataInputOutputUtil.readINT(input) + prevId;
                        if (name == root) {
                            Integer n = id4;
                            return n;
                        }
                        prevNameId = names2[i] = name;
                        prevId = ids[i] = id4;
                    }
                }
            }
            DbConnection.markDirty();
            root = FSRecords.getNames().enumerate(rootUrl);
            try (DataOutputStream output = FSRecords.writeAttribute(1, ourChildrenAttr);){
                id2 = FSRecords.createRecord();
                int index = Arrays.binarySearch(ids, id2);
                ids = ArrayUtil.insert(ids, -index - 1, id2);
                names2 = ArrayUtil.insert(names2, -index - 1, root);
                FSRecords.saveNameIdSequenceWithDeltas(names2, ids, output);
            }
            return id2;
        });
    }

    static void deleteRootRecord(int id2) {
        FSRecords.writeAndHandleErrors(() -> {
            int[] names2;
            int[] ids;
            DbConnection.markDirty();
            if (ourStoreRootsSeparately) {
                Throwable throwable;
                ArrayList<Object> rootsThatLeft = new ArrayList<Object>();
                try {
                    throwable = null;
                    try (LineNumberReader stream2 = new LineNumberReader(new BufferedReader(new InputStreamReader(new FileInputStream(DbConnection.myRootsFile))));){
                        Object str;
                        while ((str = stream2.readLine()) != null) {
                            int n = ((String)str).indexOf(32);
                            int rootId = Integer.parseInt(((String)str).substring(0, n));
                            if (rootId == id2) continue;
                            rootsThatLeft.add(str);
                        }
                    }
                    catch (Throwable str) {
                        throwable = str;
                        throw str;
                    }
                }
                catch (FileNotFoundException stream2) {
                    // empty catch block
                }
                throwable = null;
                try (BufferedWriter stream = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(DbConnection.myRootsFile)));){
                    for (String string : rootsThatLeft) {
                        stream.write(string);
                        stream.write("\n");
                    }
                }
                catch (Throwable str) {
                    throwable = str;
                    throw str;
                }
                return;
            }
            try (DataInputStream input = FSRecords.readAttribute(1, ourChildrenAttr);){
                assert (input != null);
                int n = DataInputOutputUtil.readINT(input);
                int[] names22 = ArrayUtil.newIntArray(n);
                ids = ArrayUtil.newIntArray(n);
                int prevId = 0;
                int prevNameId = 0;
                for (int i = 0; i < n; ++i) {
                    names22[i] = DataInputOutputUtil.readINT(input) + prevNameId;
                    ids[i] = DataInputOutputUtil.readINT(input) + prevId;
                    prevId = ids[i];
                    prevNameId = names22[i];
                }
            }
            int index = ArrayUtil.find(ids, id2);
            assert (index >= 0);
            names2 = ArrayUtil.remove(names2, index);
            ids = ArrayUtil.remove(ids, index);
            Throwable throwable = null;
            try (DataOutputStream output = FSRecords.writeAttribute(1, ourChildrenAttr);){
                FSRecords.saveNameIdSequenceWithDeltas(names2, ids, output);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        });
    }

    static int @NotNull [] list(int id2) {
        int[] nArray = FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream input = FSRecords.readAttribute(id2, ourChildrenAttr);){
                if (input == null) {
                    int[] nArray = ArrayUtilRt.EMPTY_INT_ARRAY;
                    return nArray;
                }
                int count = DataInputOutputUtil.readINT(input);
                int[] result2 = ArrayUtil.newIntArray(count);
                int prevId = id2;
                for (int i = 0; i < count; ++i) {
                    prevId = result2[i] = DataInputOutputUtil.readINT(input) + prevId;
                }
                int[] nArray = result2;
                return nArray;
            }
        });
        if (nArray == null) {
            FSRecords.$$$reportNull$$$0(5);
        }
        return nArray;
    }

    static boolean mayHaveChildren(int id2) {
        return FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream input = FSRecords.readAttribute(id2, ourChildrenAttr);){
                if (input == null) {
                    Boolean bl = true;
                    return bl;
                }
                int count = DataInputOutputUtil.readINT(input);
                Boolean bl = count != 0;
                return bl;
            }
        });
    }

    public static NameId @NotNull [] listAll(int parentId) {
        assert (parentId > 0) : parentId;
        NameId[] nameIdArray = FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream input = FSRecords.readAttribute(parentId, ourChildrenAttr);){
                if (input == null) {
                    NameId[] nameIdArray = NameId.EMPTY_ARRAY;
                    return nameIdArray;
                }
                int count = DataInputOutputUtil.readINT(input);
                NameId[] result2 = count == 0 ? NameId.EMPTY_ARRAY : new NameId[count];
                int prevId = parentId;
                for (int i = 0; i < count; ++i) {
                    int id2;
                    prevId = id2 = DataInputOutputUtil.readINT(input) + prevId;
                    int nameId = FSRecords.doGetNameId(id2);
                    result2[i] = new NameId(id2, nameId, FileNameCache.getVFileName(nameId, FSRecords::doGetNameByNameId));
                }
                NameId[] nameIdArray = result2;
                return nameIdArray;
            }
        });
        if (nameIdArray == null) {
            FSRecords.$$$reportNull$$$0(6);
        }
        return nameIdArray;
    }

    static boolean wereChildrenAccessed(int id2) {
        return FSRecords.readAndHandleErrors(() -> FSRecords.findAttributePage(id2, ourChildrenAttr, false) != 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T readAndHandleErrors(@NotNull ThrowableComputable<T, ?> action2) {
        if (action2 == null) {
            FSRecords.$$$reportNull$$$0(7);
        }
        assert (lock.getReadHoldCount() == 0);
        try {
            r.lock();
            try {
                T t = action2.compute();
                return t;
            }
            finally {
                r.unlock();
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            throw new RuntimeException(e);
        }
    }

    private static <T> T writeAndHandleErrors(@NotNull ThrowableComputable<T, ?> action2) {
        if (action2 == null) {
            FSRecords.$$$reportNull$$$0(8);
        }
        try {
            w.lock();
            T t = action2.compute();
            return t;
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            throw new RuntimeException(e);
        }
        finally {
            w.unlock();
        }
    }

    private static void writeAndHandleErrors(@NotNull ThrowableRunnable<?> action2) {
        if (action2 == null) {
            FSRecords.$$$reportNull$$$0(9);
        }
        try {
            w.lock();
            action2.run();
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            throw new RuntimeException(e);
        }
        finally {
            w.unlock();
        }
    }

    static void updateList(int id2, int @NotNull [] childIds) {
        if (childIds == null) {
            FSRecords.$$$reportNull$$$0(10);
        }
        assert (id2 > 0) : id2;
        Arrays.sort(childIds);
        FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            try (DataOutputStream record = FSRecords.writeAttribute(id2, ourChildrenAttr);){
                DataInputOutputUtil.writeINT(record, childIds.length);
                int prevId = id2;
                for (int childId : childIds) {
                    assert (childId > 0) : childId;
                    if (childId == id2) {
                        LOG.error("Cyclic parent child relations");
                        continue;
                    }
                    int delta = childId - prevId;
                    assert (prevId == id2 || delta > 0) : delta;
                    DataInputOutputUtil.writeINT(record, delta);
                    prevId = childId;
                }
            }
        });
    }

    @Nullable
    static String readSymlinkTarget(int id2) {
        String result2 = FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream stream = FSRecords.readAttribute(id2, ourSymlinkTargetAttr);){
                if (stream != null) {
                    String string = StringUtil.nullize(IOUtil.readUTF(stream));
                    return string;
                }
            }
            stream = FSRecords.readAttribute(id2, ourSymlinkTargetAttr_old);
            var2_2 = null;
            try {
                if (stream != null) {
                    String string = StringUtil.nullize(stream.readUTF());
                    return string;
                }
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (var2_2 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            return null;
        });
        return result2 != null ? FileUtil.toSystemIndependentName(result2) : null;
    }

    static void storeSymlinkTarget(int id2, @Nullable String symlinkTarget) {
        FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            try (DataOutputStream stream = FSRecords.writeAttribute(id2, ourSymlinkTargetAttr);){
                IOUtil.writeUTF(stream, StringUtil.notNullize(symlinkTarget));
            }
        });
    }

    private static void incModCount(int id2) {
        FSRecords.incLocalModCount();
        int count = FSRecords.doGetModCount() + 1;
        FSRecords.getRecords().putInt(8L, count);
        FSRecords.setModCount(id2, count);
    }

    private static void incLocalModCount() {
        DbConnection.markDirty();
        ++ourLocalModificationCount;
        CachedFileType.clearCache();
    }

    static int getLocalModCount() {
        return ourLocalModificationCount;
    }

    static int getModCount() {
        return FSRecords.readAndHandleErrors(FSRecords::doGetModCount);
    }

    private static int doGetModCount() {
        return FSRecords.getRecords().getInt(8L);
    }

    public static int getParent(int id2) {
        return FSRecords.readAndHandleErrors(() -> {
            int parentId = FSRecords.getRecordInt(id2, 0);
            if (parentId == id2) {
                LOG.error("Cyclic parent child relations in the database. id = " + id2);
                return 0;
            }
            return parentId;
        });
    }

    @Nullable
    static VirtualFileSystemEntry findFileById(final int id2, final @NotNull ConcurrentIntObjectMap<VirtualFileSystemEntry> idToDirCache) {
        if (idToDirCache == null) {
            FSRecords.$$$reportNull$$$0(11);
        }
        class ParentFinder
        implements ThrowableComputable<Void, Throwable> {
            @Nullable
            private TIntArrayList path;
            private VirtualFileSystemEntry foundParent;

            ParentFinder() {
            }

            @Override
            public Void compute() {
                int parentId;
                int currentId = id2;
                while ((parentId = FSRecords.getRecordInt(currentId, 0)) != 0) {
                    if (parentId == currentId || this.path != null && this.path.size() % 128 == 0 && this.path.contains(parentId)) {
                        LOG.error("Cyclic parent child relations in the database. id = " + parentId);
                        break;
                    }
                    this.foundParent = (VirtualFileSystemEntry)idToDirCache.get(parentId);
                    if (this.foundParent != null) break;
                    currentId = parentId;
                    if (this.path == null) {
                        this.path = new TIntArrayList();
                    }
                    this.path.add(currentId);
                }
                return null;
            }

            private VirtualFileSystemEntry findDescendantByIdPath() {
                VirtualFileSystemEntry parent = this.foundParent;
                if (this.path != null) {
                    for (int i = this.path.size() - 1; i >= 0; --i) {
                        parent = this.findChild(parent, this.path.get(i));
                    }
                }
                return this.findChild(parent, id2);
            }

            private VirtualFileSystemEntry findChild(VirtualFileSystemEntry parent, int childId) {
                VirtualFileSystemEntry old;
                if (!(parent instanceof VirtualDirectoryImpl)) {
                    return null;
                }
                VirtualFileSystemEntry child2 = ((VirtualDirectoryImpl)parent).doFindChildById(childId);
                if (child2 instanceof VirtualDirectoryImpl && (old = idToDirCache.putIfAbsent(childId, child2)) != null) {
                    child2 = old;
                }
                return child2;
            }
        }
        ParentFinder finder = new ParentFinder();
        FSRecords.readAndHandleErrors(finder);
        return finder.findDescendantByIdPath();
    }

    static void setParent(int id2, int parentId) {
        if (id2 == parentId) {
            LOG.error("Cyclic parent/child relations");
            return;
        }
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(id2);
            FSRecords.putRecordInt(id2, 0, parentId);
        });
    }

    public static int getNameId(int id2) {
        return FSRecords.readAndHandleErrors(() -> FSRecords.doGetNameId(id2));
    }

    private static int doGetNameId(int id2) {
        return FSRecords.getRecordInt(id2, 4);
    }

    public static int getNameId(@NotNull String name) {
        if (name == null) {
            FSRecords.$$$reportNull$$$0(12);
        }
        return FSRecords.readAndHandleErrors(() -> FSRecords.getNames().enumerate(name));
    }

    public static String getName(int id2) {
        return FSRecords.getNameSequence(id2).toString();
    }

    @NotNull
    static CharSequence getNameSequence(int id2) {
        CharSequence charSequence = FSRecords.readAndHandleErrors(() -> FSRecords.doGetNameSequence(id2));
        if (charSequence == null) {
            FSRecords.$$$reportNull$$$0(13);
        }
        return charSequence;
    }

    @NotNull
    private static CharSequence doGetNameSequence(int id2) throws IOException {
        int nameId = FSRecords.getRecordInt(id2, 4);
        CharSequence charSequence = nameId == 0 ? "" : FileNameCache.getVFileName(nameId, FSRecords::doGetNameByNameId);
        if (charSequence == null) {
            FSRecords.$$$reportNull$$$0(14);
        }
        return charSequence;
    }

    public static String getNameByNameId(int nameId) {
        return FSRecords.readAndHandleErrors(() -> FSRecords.doGetNameByNameId(nameId));
    }

    private static String doGetNameByNameId(int nameId) throws IOException {
        return nameId == 0 ? "" : FSRecords.getNames().valueOf(nameId);
    }

    static void setName(int id2, @NotNull String name) {
        if (name == null) {
            FSRecords.$$$reportNull$$$0(15);
        }
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(id2);
            int nameId = FSRecords.getNames().enumerate(name);
            FSRecords.putRecordInt(id2, 4, nameId);
        });
    }

    static int getFlags(int id2) {
        return FSRecords.readAndHandleErrors(() -> FSRecords.doGetFlags(id2));
    }

    private static int doGetFlags(int id2) {
        return FSRecords.getRecordInt(id2, 8);
    }

    static void setFlags(int id2, int flags, boolean markAsChange) {
        FSRecords.writeAndHandleErrors(() -> {
            if (markAsChange) {
                FSRecords.incModCount(id2);
            }
            FSRecords.putRecordInt(id2, 8, flags);
        });
    }

    static long getLength(int id2) {
        return FSRecords.readAndHandleErrors(() -> FSRecords.getRecords().getLong(FSRecords.getOffset(id2, 32)));
    }

    static void setLength(int id2, long len) {
        FSRecords.writeAndHandleErrors(() -> {
            int lengthOffset;
            ResizeableMappedFile records = FSRecords.getRecords();
            if (records.getLong(lengthOffset = FSRecords.getOffset(id2, 32)) != len) {
                FSRecords.incModCount(id2);
                records.putLong(lengthOffset, len);
            }
        });
    }

    static long getTimestamp(int id2) {
        return FSRecords.readAndHandleErrors(() -> FSRecords.getRecords().getLong(FSRecords.getOffset(id2, 20)));
    }

    static void setTimestamp(int id2, long value2) {
        FSRecords.writeAndHandleErrors(() -> {
            int timeStampOffset = FSRecords.getOffset(id2, 20);
            ResizeableMappedFile records = FSRecords.getRecords();
            if (records.getLong(timeStampOffset) != value2) {
                FSRecords.incModCount(id2);
                records.putLong(timeStampOffset, value2);
            }
        });
    }

    static int getModCount(int id2) {
        return FSRecords.readAndHandleErrors(() -> FSRecords.getRecordInt(id2, 28));
    }

    private static void setModCount(int id2, int value2) {
        FSRecords.putRecordInt(id2, 28, value2);
    }

    private static int getContentRecordId(int fileId) {
        return FSRecords.getRecordInt(fileId, 16);
    }

    private static void setContentRecordId(int id2, int value2) {
        FSRecords.putRecordInt(id2, 16, value2);
    }

    private static int getAttributeRecordId(int id2) {
        return FSRecords.getRecordInt(id2, 12);
    }

    private static void setAttributeRecordId(int id2, int value2) {
        FSRecords.putRecordInt(id2, 12, value2);
    }

    private static int getRecordInt(int id2, int offset) {
        return FSRecords.getRecords().getInt(FSRecords.getOffset(id2, offset));
    }

    private static void putRecordInt(int id2, int offset, int value2) {
        FSRecords.getRecords().putInt(FSRecords.getOffset(id2, offset), value2);
    }

    private static int getOffset(int id2, int offset) {
        return id2 * 40 + offset;
    }

    @Nullable
    static DataInputStream readContent(int fileId) {
        int page = FSRecords.readAndHandleErrors(() -> {
            FSRecords.checkFileIsValid(fileId);
            return FSRecords.getContentRecordId(fileId);
        });
        if (page == 0) {
            return null;
        }
        try {
            return FSRecords.doReadContentById(page);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            return null;
        }
    }

    @NotNull
    static DataInputStream readContentById(int contentId) {
        try {
            return FSRecords.doReadContentById(contentId);
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            if (null == null) {
                FSRecords.$$$reportNull$$$0(16);
            }
            return null;
        }
    }

    @NotNull
    private static DataInputStream doReadContentById(int contentId) throws IOException {
        DataInputStream stream = FSRecords.getContentStorage().readStream(contentId);
        if (useCompressionUtil) {
            byte[] bytes = CompressionUtil.readCompressed(stream);
            stream = new DataInputStream(new UnsyncByteArrayInputStream(bytes));
        }
        DataInputStream dataInputStream = stream;
        if (dataInputStream == null) {
            FSRecords.$$$reportNull$$$0(17);
        }
        return dataInputStream;
    }

    @Nullable
    public static DataInputStream readAttributeWithLock(int fileId, @NotNull FileAttribute att) {
        if (att == null) {
            FSRecords.$$$reportNull$$$0(18);
        }
        return FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream stream = FSRecords.readAttribute(fileId, att);){
                if (stream != null && att.isVersioned()) {
                    try {
                        int actualVersion = DataInputOutputUtil.readINT(stream);
                        if (actualVersion != att.getVersion()) {
                            DataInputStream dataInputStream = null;
                            return dataInputStream;
                        }
                    }
                    catch (IOException e) {
                        DataInputStream dataInputStream = null;
                        return dataInputStream;
                    }
                }
                DataInputStream dataInputStream = stream;
                return dataInputStream;
            }
        });
    }

    @Nullable
    private static DataInputStream readAttribute(int fileId, @NotNull FileAttribute attribute) throws IOException {
        if (attribute == null) {
            FSRecords.$$$reportNull$$$0(19);
        }
        FSRecords.checkFileIsValid(fileId);
        int recordId = FSRecords.getAttributeRecordId(fileId);
        if (recordId == 0) {
            return null;
        }
        int encodedAttrId = DbConnection.getAttributeId(attribute.getId());
        Storage storage = FSRecords.getAttributesStorage();
        int page = 0;
        try (DataInputStream attrRefs = storage.readStream(recordId);){
            if (bulkAttrReadSupport) {
                FSRecords.skipRecordHeader(attrRefs, DbConnection.RESERVED_ATTR_ID, fileId);
            }
            while (attrRefs.available() > 0) {
                int attIdOnPage = DataInputOutputUtil.readINT(attrRefs);
                int attrAddressOrSize = DataInputOutputUtil.readINT(attrRefs);
                if (attIdOnPage != encodedAttrId) {
                    if (!inlineAttributes || attrAddressOrSize >= 64) continue;
                    attrRefs.skipBytes(attrAddressOrSize);
                    continue;
                }
                if (inlineAttributes && attrAddressOrSize < 64) {
                    byte[] b = new byte[attrAddressOrSize];
                    attrRefs.readFully(b);
                    DataInputStream dataInputStream = new DataInputStream(new UnsyncByteArrayInputStream(b));
                    return dataInputStream;
                }
                page = inlineAttributes ? attrAddressOrSize - 64 : attrAddressOrSize;
                break;
            }
        }
        if (page == 0) {
            return null;
        }
        DataInputStream stream = FSRecords.getAttributesStorage().readStream(page);
        if (bulkAttrReadSupport) {
            FSRecords.skipRecordHeader(stream, encodedAttrId, fileId);
        }
        return stream;
    }

    /*
     * Loose catch block
     */
    private static int findAttributePage(int fileId, @NotNull FileAttribute attr, boolean toWrite) throws IOException {
        Throwable throwable;
        if (attr == null) {
            FSRecords.$$$reportNull$$$0(20);
        }
        FSRecords.checkFileIsValid(fileId);
        int recordId = FSRecords.getAttributeRecordId(fileId);
        int encodedAttrId = DbConnection.getAttributeId(attr.getId());
        boolean directoryRecord = false;
        Storage storage = FSRecords.getAttributesStorage();
        if (recordId == 0) {
            if (!toWrite) {
                return 0;
            }
            recordId = storage.createNewRecord();
            FSRecords.setAttributeRecordId(fileId, recordId);
            directoryRecord = true;
        } else {
            throwable = null;
            try (DataInputStream attrRefs = storage.readStream(recordId);){
                if (bulkAttrReadSupport) {
                    FSRecords.skipRecordHeader(attrRefs, DbConnection.RESERVED_ATTR_ID, fileId);
                }
                while (attrRefs.available() > 0) {
                    int attIdOnPage = DataInputOutputUtil.readINT(attrRefs);
                    int attrAddressOrSize = DataInputOutputUtil.readINT(attrRefs);
                    if (attIdOnPage == encodedAttrId) {
                        if (inlineAttributes) {
                            int n = attrAddressOrSize < 64 ? -recordId : attrAddressOrSize - 64;
                            return n;
                        }
                        int n = attrAddressOrSize;
                        return n;
                    }
                    if (!inlineAttributes || attrAddressOrSize >= 64) continue;
                    attrRefs.skipBytes(attrAddressOrSize);
                }
            }
            catch (Throwable attIdOnPage) {
                throwable = attIdOnPage;
                throw attIdOnPage;
            }
        }
        if (toWrite) {
            try {
                throwable = null;
                try (AbstractStorage.AppenderStream appender = storage.appendStream(recordId);){
                    if (bulkAttrReadSupport && directoryRecord) {
                        DataInputOutputUtil.writeINT(appender, DbConnection.RESERVED_ATTR_ID);
                        DataInputOutputUtil.writeINT(appender, fileId);
                    }
                    DataInputOutputUtil.writeINT(appender, encodedAttrId);
                    int attrAddress = storage.createNewRecord();
                    DataInputOutputUtil.writeINT(appender, inlineAttributes ? attrAddress + 64 : attrAddress);
                    DbConnection.REASONABLY_SMALL.myAttrPageRequested = true;
                    int n = attrAddress;
                    return n;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                {
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
            finally {
                DbConnection.REASONABLY_SMALL.myAttrPageRequested = false;
            }
        }
        return 0;
    }

    private static void skipRecordHeader(DataInputStream refs, int expectedRecordTag, int expectedFileId) throws IOException {
        int attId = DataInputOutputUtil.readINT(refs);
        assert (attId == expectedRecordTag || expectedRecordTag == 0);
        int fileId = DataInputOutputUtil.readINT(refs);
        assert (expectedFileId == fileId || expectedFileId == 0);
    }

    private static void writeRecordHeader(int recordTag, int fileId, @NotNull DataOutputStream appender) throws IOException {
        if (appender == null) {
            FSRecords.$$$reportNull$$$0(21);
        }
        DataInputOutputUtil.writeINT(appender, recordTag);
        DataInputOutputUtil.writeINT(appender, fileId);
    }

    private static void checkFileIsValid(int fileId) throws IOException {
        assert (fileId > 0) : fileId;
        if (!lazyVfsDataCleaning) assert (!BitUtil.isSet(FSRecords.doGetFlags(fileId), 256)) : "Accessing attribute of a deleted page: " + fileId + ":" + FSRecords.doGetNameSequence(fileId);
    }

    static int acquireFileContent(int fileId) {
        return FSRecords.writeAndHandleErrors(() -> {
            int record = FSRecords.getContentRecordId(fileId);
            if (record > 0) {
                FSRecords.getContentStorage().acquireRecord(record);
            }
            return record;
        });
    }

    static void releaseContent(int contentId) {
        FSRecords.writeAndHandleErrors(() -> FSRecords.getContentStorage().releaseRecord(contentId, !WE_HAVE_CONTENT_HASHES));
    }

    static int getContentId(int fileId) {
        return FSRecords.readAndHandleErrors(() -> FSRecords.getContentRecordId(fileId));
    }

    static byte[] getContentHash(int fileId) {
        if (!WE_HAVE_CONTENT_HASHES) {
            return null;
        }
        return FSRecords.readAndHandleErrors(() -> {
            int contentId = FSRecords.getContentRecordId(fileId);
            return contentId <= 0 ? null : FSRecords.getContentHashesEnumerator().valueOf(contentId);
        });
    }

    @NotNull
    static DataOutputStream writeContent(int fileId, boolean readOnly) {
        return new ContentOutputStream(fileId, readOnly);
    }

    static void writeContent(int fileId, ByteArraySequence bytes, boolean readOnly) {
        new ContentOutputStream(fileId, readOnly).writeBytes(bytes);
    }

    static int storeUnlinkedContent(byte[] bytes) {
        return FSRecords.writeAndHandleErrors(() -> {
            int recordId;
            if (WE_HAVE_CONTENT_HASHES) {
                recordId = FSRecords.findOrCreateContentRecord(bytes, 0, bytes.length);
                if (recordId > 0) {
                    return recordId;
                }
                recordId = -recordId;
            } else {
                recordId = FSRecords.getContentStorage().acquireNewRecord();
            }
            try (AbstractStorage.StorageDataOutput output = FSRecords.getContentStorage().writeStream(recordId, true);){
                output.write(bytes);
            }
            return recordId;
        });
    }

    @NotNull
    public static DataOutputStream writeAttribute(int fileId, @NotNull FileAttribute att) {
        if (att == null) {
            FSRecords.$$$reportNull$$$0(22);
        }
        AttributeOutputStream stream = new AttributeOutputStream(fileId, att);
        if (att.isVersioned()) {
            try {
                DataInputOutputUtil.writeINT(stream, att.getVersion());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        AttributeOutputStream attributeOutputStream = stream;
        if (attributeOutputStream == null) {
            FSRecords.$$$reportNull$$$0(23);
        }
        return attributeOutputStream;
    }

    private static int findOrCreateContentRecord(byte[] bytes, int offset, int length) throws IOException {
        assert (WE_HAVE_CONTENT_HASHES);
        long started = DUMP_STATISTICS ? System.nanoTime() : 0L;
        byte[] contentHash = DigestUtil.calculateContentHash((MessageDigest)CONTENT_HASH_DIGEST, (byte[])bytes, (int)offset, (int)length);
        long done = DUMP_STATISTICS ? System.nanoTime() - started : 0L;
        time += done;
        totalContents += (long)length;
        if (DUMP_STATISTICS && (++contents & 0x3FFF) == 0) {
            LOG.info("Contents:" + contents + " of " + totalContents + ", reuses:" + reuses + " of " + totalReuses + " for " + time / 1000000L);
        }
        ContentHashEnumerator hashesEnumerator = FSRecords.getContentHashesEnumerator();
        int largestId = hashesEnumerator.getLargestId();
        int page = hashesEnumerator.enumerate(contentHash);
        if (page <= largestId) {
            ++reuses;
            FSRecords.getContentStorage().acquireRecord(page);
            totalReuses += (long)length;
            return page;
        }
        int newRecord = FSRecords.getContentStorage().acquireNewRecord();
        assert (page == newRecord) : "Unexpected content storage modification: page=" + page + "; newRecord=" + newRecord;
        return -page;
    }

    static void dispose() {
        FSRecords.writeAndHandleErrors(() -> {
            try {
                DbConnection.doForce();
                DbConnection.closeFiles();
            }
            finally {
                ourIsDisposed = true;
            }
        });
    }

    public static void invalidateCaches() {
        DbConnection.createBrokenMarkerFile(null);
    }

    static void checkSanity() {
        long t = System.currentTimeMillis();
        int recordCount = FSRecords.readAndHandleErrors(() -> {
            int fileLength = FSRecords.length();
            assert (fileLength % 40 == 0);
            return fileLength / 40;
        });
        IntArrayList usedAttributeRecordIds = new IntArrayList();
        IntArrayList validAttributeIds = new IntArrayList();
        for (int id2 = 2; id2 < recordCount; ++id2) {
            int flags = FSRecords.getFlags(id2);
            LOG.assertTrue((flags & 0xFFFFFE80) == 0, "Invalid flags: 0x" + Integer.toHexString(flags) + ", id: " + id2);
            int currentId = id2;
            boolean isFreeRecord = FSRecords.readAndHandleErrors(() -> DbConnection.myFreeRecords.contains(currentId));
            if (BitUtil.isSet(flags, 256)) {
                LOG.assertTrue(isFreeRecord, "Record, marked free, not in free list: " + id2);
                continue;
            }
            LOG.assertTrue(!isFreeRecord, "Record, not marked free, in free list: " + id2);
            FSRecords.checkRecordSanity(id2, recordCount, usedAttributeRecordIds, validAttributeIds);
        }
        t = System.currentTimeMillis() - t;
        LOG.info("Sanity check took " + t + " ms");
    }

    private static void checkRecordSanity(int id2, int recordCount, IntArrayList usedAttributeRecordIds, IntArrayList validAttributeIds) {
        int parentId = FSRecords.getParent(id2);
        assert (parentId >= 0 && parentId < recordCount);
        if (parentId > 0 && FSRecords.getParent(parentId) > 0) {
            int parentFlags = FSRecords.getFlags(parentId);
            assert (!BitUtil.isSet(parentFlags, 256)) : parentId + ": " + Integer.toHexString(parentFlags);
            assert (BitUtil.isSet(parentFlags, 2)) : parentId + ": " + Integer.toHexString(parentFlags);
        }
        CharSequence name = FSRecords.getNameSequence(id2);
        LOG.assertTrue(parentId == 0 || name.length() != 0, "File with empty name found under " + FSRecords.getNameSequence(parentId) + ", id=" + id2);
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.checkContentsStorageSanity(id2);
            FSRecords.checkAttributesStorageSanity(id2, usedAttributeRecordIds, validAttributeIds);
        });
        long length = FSRecords.getLength(id2);
        assert (length >= -1L) : "Invalid file length found for " + name + ": " + length;
    }

    private static void checkContentsStorageSanity(int id2) {
        int recordId = FSRecords.getContentRecordId(id2);
        assert (recordId >= 0);
        if (recordId > 0) {
            FSRecords.getContentStorage().checkSanity(recordId);
        }
    }

    private static void checkAttributesStorageSanity(int id2, IntArrayList usedAttributeRecordIds, IntArrayList validAttributeIds) {
        int attributeRecordId = FSRecords.getAttributeRecordId(id2);
        assert (attributeRecordId >= 0);
        if (attributeRecordId > 0) {
            try {
                FSRecords.checkAttributesSanity(attributeRecordId, usedAttributeRecordIds, validAttributeIds);
            }
            catch (IOException ex) {
                DbConnection.handleError(ex);
            }
        }
    }

    private static void checkAttributesSanity(int attributeRecordId, IntArrayList usedAttributeRecordIds, IntArrayList validAttributeIds) throws IOException {
        assert (!usedAttributeRecordIds.contains(attributeRecordId));
        usedAttributeRecordIds.add(attributeRecordId);
        try (DataInputStream dataInputStream = FSRecords.getAttributesStorage().readStream(attributeRecordId);){
            if (bulkAttrReadSupport) {
                FSRecords.skipRecordHeader(dataInputStream, 0, 0);
            }
            while (dataInputStream.available() > 0) {
                int attId = DataInputOutputUtil.readINT(dataInputStream);
                if (!validAttributeIds.contains(attId)) {
                    validAttributeIds.add(attId);
                }
                int attDataRecordIdOrSize = DataInputOutputUtil.readINT(dataInputStream);
                if (inlineAttributes) {
                    if (attDataRecordIdOrSize < 64) {
                        dataInputStream.skipBytes(attDataRecordIdOrSize);
                        continue;
                    }
                    attDataRecordIdOrSize -= 64;
                }
                assert (!usedAttributeRecordIds.contains(attDataRecordIdOrSize));
                usedAttributeRecordIds.add(attDataRecordIdOrSize);
                FSRecords.getAttributesStorage().checkSanity(attDataRecordIdOrSize);
            }
        }
    }

    @Contract(value="_->fail")
    public static void handleError(Throwable e) throws RuntimeException, Error {
        DbConnection.handleError(e);
    }

    static {
        DUMP_STATISTICS = WE_HAVE_CONTENT_HASHES;
        CONTENT_HASH_DIGEST = DigestUtil.sha1();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childIds";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDirCache";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "att";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "listRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "listAll";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSequence";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetNameSequence";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentById";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadContentById";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributesToRecord";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "requestVfsRebuild";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRootRecord";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readAndHandleErrors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeAndHandleErrors";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFileById";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNameId";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readAttributeWithLock";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAttributePage";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writeRecordHeader";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AttributeOutputStream
    extends DataOutputStream {
        @NotNull
        private final FileAttribute myAttribute;
        private final int myFileId;

        private AttributeOutputStream(int fileId, @NotNull FileAttribute attribute) {
            if (attribute == null) {
                AttributeOutputStream.$$$reportNull$$$0(0);
            }
            super(new BufferExposingByteArrayOutputStream());
            this.myFileId = fileId;
            this.myAttribute = attribute;
        }

        @Override
        public void close() throws IOException {
            super.close();
            FSRecords.writeAndHandleErrors(() -> {
                BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
                if (inlineAttributes && _out.size() < 64) {
                    this.rewriteDirectoryRecordWithAttrContent(_out);
                    FSRecords.incLocalModCount();
                } else {
                    FSRecords.incLocalModCount();
                    int page = FSRecords.findAttributePage(this.myFileId, this.myAttribute, true);
                    if (inlineAttributes && page < 0) {
                        this.rewriteDirectoryRecordWithAttrContent(new BufferExposingByteArrayOutputStream());
                        page = FSRecords.findAttributePage(this.myFileId, this.myAttribute, true);
                    }
                    if (bulkAttrReadSupport) {
                        BufferExposingByteArrayOutputStream stream = new BufferExposingByteArrayOutputStream();
                        this.out = stream;
                        FSRecords.writeRecordHeader(DbConnection.getAttributeId(this.myAttribute.getId()), this.myFileId, this);
                        this.write(_out.getInternalBuffer(), 0, _out.size());
                        FSRecords.getAttributesStorage().writeBytes(page, stream.toByteArraySequence(), this.myAttribute.isFixedSize());
                    } else {
                        FSRecords.getAttributesStorage().writeBytes(page, _out.toByteArraySequence(), this.myAttribute.isFixedSize());
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rewriteDirectoryRecordWithAttrContent(@NotNull BufferExposingByteArrayOutputStream _out) throws IOException {
            Throwable throwable;
            if (_out == null) {
                AttributeOutputStream.$$$reportNull$$$0(1);
            }
            int recordId = FSRecords.getAttributeRecordId(this.myFileId);
            assert (inlineAttributes);
            int encodedAttrId = DbConnection.getAttributeId(this.myAttribute.getId());
            Storage storage = FSRecords.getAttributesStorage();
            BufferExposingByteArrayOutputStream unchangedPreviousDirectoryStream = null;
            boolean directoryRecord = false;
            if (recordId == 0) {
                recordId = storage.createNewRecord();
                FSRecords.setAttributeRecordId(this.myFileId, recordId);
                directoryRecord = true;
            } else {
                throwable = null;
                try (DataInputStream attrRefs = storage.readStream(recordId);
                     FilterOutputStream dataStream = null;){
                    int remainingAtStart = attrRefs.available();
                    if (bulkAttrReadSupport) {
                        unchangedPreviousDirectoryStream = new BufferExposingByteArrayOutputStream();
                        dataStream = new DataOutputStream(unchangedPreviousDirectoryStream);
                        int attId = DataInputOutputUtil.readINT(attrRefs);
                        assert (attId == DbConnection.RESERVED_ATTR_ID);
                        int fileId = DataInputOutputUtil.readINT(attrRefs);
                        assert (this.myFileId == fileId);
                        FSRecords.writeRecordHeader(attId, fileId, (DataOutputStream)dataStream);
                    }
                    while (attrRefs.available() > 0) {
                        int attIdOnPage = DataInputOutputUtil.readINT(attrRefs);
                        int attrAddressOrSize = DataInputOutputUtil.readINT(attrRefs);
                        if (attIdOnPage != encodedAttrId) {
                            if (dataStream == null) {
                                unchangedPreviousDirectoryStream = new BufferExposingByteArrayOutputStream();
                                dataStream = new DataOutputStream(unchangedPreviousDirectoryStream);
                            }
                            DataInputOutputUtil.writeINT((DataOutput)((Object)dataStream), attIdOnPage);
                            DataInputOutputUtil.writeINT((DataOutput)((Object)dataStream), attrAddressOrSize);
                            if (attrAddressOrSize >= 64) continue;
                            byte[] b = new byte[attrAddressOrSize];
                            attrRefs.readFully(b);
                            dataStream.write(b);
                            continue;
                        }
                        if (attrAddressOrSize >= 64) continue;
                        if (_out.size() == attrAddressOrSize) {
                            int remaining = attrRefs.available();
                            storage.replaceBytes(recordId, remainingAtStart - remaining, _out.toByteArraySequence());
                            return;
                        }
                        attrRefs.skipBytes(attrAddressOrSize);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            throwable = null;
            try (AbstractStorage.StorageDataOutput directoryStream = storage.writeStream(recordId);){
                if (directoryRecord && bulkAttrReadSupport) {
                    FSRecords.writeRecordHeader(DbConnection.RESERVED_ATTR_ID, this.myFileId, directoryStream);
                }
                if (unchangedPreviousDirectoryStream != null) {
                    directoryStream.write(unchangedPreviousDirectoryStream.getInternalBuffer(), 0, unchangedPreviousDirectoryStream.size());
                }
                if (_out.size() > 0) {
                    DataInputOutputUtil.writeINT(directoryStream, encodedAttrId);
                    DataInputOutputUtil.writeINT(directoryStream, _out.size());
                    directoryStream.write(_out.getInternalBuffer(), 0, _out.size());
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_out";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords$AttributeOutputStream";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rewriteDirectoryRecordWithAttrContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ContentOutputStream
    extends DataOutputStream {
        final int myFileId;
        final boolean myFixedSize;

        private ContentOutputStream(int fileId, boolean readOnly) {
            super(new BufferExposingByteArrayOutputStream());
            this.myFileId = fileId;
            this.myFixedSize = readOnly;
        }

        @Override
        public void close() throws IOException {
            super.close();
            BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
            this.writeBytes(_out.toByteArraySequence());
        }

        private void writeBytes(ByteArraySequence bytes) {
            FSRecords.writeAndHandleErrors(() -> {
                ByteArraySequence newBytes;
                boolean fixedSize;
                int page;
                RefCountingStorage contentStorage = FSRecords.getContentStorage();
                FSRecords.checkFileIsValid(this.myFileId);
                if (WE_HAVE_CONTENT_HASHES) {
                    page = FSRecords.findOrCreateContentRecord(bytes.getBytes(), bytes.getOffset(), bytes.getLength());
                    if (page < 0 || FSRecords.getContentId(this.myFileId) != page) {
                        FSRecords.incModCount(this.myFileId);
                        FSRecords.setContentRecordId(this.myFileId, page > 0 ? page : -page);
                    }
                    FSRecords.setContentRecordId(this.myFileId, page > 0 ? page : -page);
                    if (page > 0) {
                        return;
                    }
                    page = -page;
                    fixedSize = true;
                } else {
                    FSRecords.incModCount(this.myFileId);
                    page = FSRecords.getContentRecordId(this.myFileId);
                    if (page == 0 || contentStorage.getRefCount(page) > 1) {
                        page = contentStorage.acquireNewRecord();
                        FSRecords.setContentRecordId(this.myFileId, page);
                    }
                    fixedSize = this.myFixedSize;
                }
                if (useCompressionUtil) {
                    BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                    try (DataOutputStream outputStream = new DataOutputStream(out);){
                        CompressionUtil.writeCompressed(outputStream, bytes.getBytes(), bytes.getOffset(), bytes.getLength());
                    }
                    newBytes = out.toByteArraySequence();
                } else {
                    newBytes = bytes;
                }
                contentStorage.writeBytes(page, newBytes, fixedSize);
            });
        }
    }

    public static class NameId {
        public static final NameId[] EMPTY_ARRAY = new NameId[0];
        public final int id;
        public final CharSequence name;
        public final int nameId;

        public NameId(int id2, int nameId, @NotNull CharSequence name) {
            if (name == null) {
                NameId.$$$reportNull$$$0(0);
            }
            this.id = id2;
            this.nameId = nameId;
            this.name = name;
            if (id2 <= 0 || nameId <= 0) {
                throw new IllegalArgumentException("invalid arguments id: " + id2 + "; nameId: " + nameId);
            }
        }

        public String toString() {
            return this.name + " (" + this.id + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/persistent/FSRecords$NameId", "<init>"));
        }
    }

    private static class DbConnection {
        private static boolean ourInitialized;
        private static PersistentStringEnumerator myNames;
        private static Storage myAttributes;
        private static RefCountingStorage myContents;
        private static ResizeableMappedFile myRecords;
        private static ContentHashEnumerator myContentHashesEnumerator;
        private static File myRootsFile;
        private static final VfsDependentEnum<String> myAttributesList;
        private static final TIntArrayList myFreeRecords;
        private static volatile boolean myDirty;
        private static ScheduledFuture<?> myFlushingFuture;
        private static boolean myCorrupted;
        private static final AttrPageAwareCapacityAllocationPolicy REASONABLY_SMALL;
        private static final int RESERVED_ATTR_ID;
        private static final int FIRST_ATTR_ID_OFFSET;

        private DbConnection() {
        }

        public static void connect() {
            FSRecords.writeAndHandleErrors(() -> {
                if (!DbConnection.ourInitialized) {
                    DbConnection.init();
                    DbConnection.setupFlushing();
                    DbConnection.ourInitialized = true;
                }
            });
        }

        private static void scanFreeRecords() {
            int fileLength = (int)myRecords.length();
            LOG.assertTrue(fileLength % 40 == 0, "invalid file size: " + fileLength);
            int count = fileLength / 40;
            for (int n = 2; n < count; ++n) {
                if (!BitUtil.isSet(FSRecords.getFlags(n), 256)) continue;
                myFreeRecords.add(n);
            }
        }

        static int getFreeRecord() {
            return myFreeRecords.isEmpty() ? 0 : myFreeRecords.remove(myFreeRecords.size() - 1);
        }

        private static void createBrokenMarkerFile(@Nullable Throwable reason) {
            File brokenMarker = DbConnection.getCorruptionMarkerFile();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (PrintStream stream = new PrintStream(out);){
                new Exception().printStackTrace(stream);
                if (reason != null) {
                    stream.print("\nReason:\n");
                    reason.printStackTrace(stream);
                }
            }
            LOG.info("Creating VFS corruption marker; Trace=\n" + out);
            try {
                var4_5 = null;
                try (FileWriter writer = new FileWriter(brokenMarker);){
                    writer.write("These files are corrupted and must be rebuilt from the scratch on next startup");
                }
                catch (Throwable throwable) {
                    var4_5 = throwable;
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static File getCorruptionMarkerFile() {
            return new File(FSRecords.basePath(), "corruption.marker");
        }

        private static void init() {
            Exception exception = null;
            for (int i = 0; i < 10; ++i) {
                exception = DbConnection.tryInit();
                if (exception != null) continue;
                return;
            }
            throw new RuntimeException("Can't initialize filesystem storage", exception);
        }

        @Nullable
        private static Exception tryInit() {
            File basePath = FSRecords.basePath().getAbsoluteFile();
            if (!basePath.isDirectory() && !basePath.mkdirs()) {
                return new RuntimeException("Cannot create storage directory: " + basePath);
            }
            File namesFile = new File(basePath, "names" + VFS_FILES_EXTENSION);
            File attributesFile = new File(basePath, "attrib" + VFS_FILES_EXTENSION);
            File contentsFile = new File(basePath, "content" + VFS_FILES_EXTENSION);
            File contentsHashesFile = new File(basePath, "contentHashes" + VFS_FILES_EXTENSION);
            File recordsFile = new File(basePath, "records" + VFS_FILES_EXTENSION);
            myRootsFile = ourStoreRootsSeparately ? new File(basePath, "roots" + VFS_FILES_EXTENSION) : null;
            File vfsDependentEnumBaseFile = VfsDependentEnum.getBaseFile();
            if (!namesFile.exists()) {
                DbConnection.invalidateIndex("'" + namesFile.getPath() + "' does not exist");
            }
            try {
                int version2;
                boolean initial;
                boolean aligned;
                if (DbConnection.getCorruptionMarkerFile().exists()) {
                    DbConnection.invalidateIndex("corruption marker found");
                    throw new IOException("Corruption marker file found");
                }
                PagedFileStorage.StorageLockContext storageLockContext = new PagedFileStorage.StorageLockContext(false);
                myNames = new PersistentStringEnumerator(namesFile.toPath(), storageLockContext);
                myAttributes = new Storage(attributesFile.getPath(), REASONABLY_SMALL){

                    @Override
                    protected AbstractRecordsTable createRecordsTable(PagePool pool, File recordsFile) throws IOException {
                        return inlineAttributes && useSmallAttrTable ? new CompactRecordsTable(recordsFile, pool, false) : super.createRecordsTable(pool, recordsFile);
                    }
                };
                myContents = new RefCountingStorage(contentsFile.getPath(), CapacityAllocationPolicy.FIVE_PERCENT_FOR_GROWTH, useCompressionUtil){

                    @Override
                    @NotNull
                    protected ExecutorService createExecutor() {
                        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor("FSRecords Pool");
                        if (executorService == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return executorService;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/FSRecords$DbConnection$2", "createExecutor"));
                    }
                };
                myContentHashesEnumerator = WE_HAVE_CONTENT_HASHES ? new ContentHashEnumerator(contentsHashesFile.toPath(), storageLockContext) : null;
                boolean bl = aligned = PagedFileStorage.BUFFER_SIZE % 40 == 0;
                if (!aligned) {
                    LOG.error("Buffer size " + PagedFileStorage.BUFFER_SIZE + " is not aligned for record size " + 40);
                }
                boolean bl2 = initial = (myRecords = new ResizeableMappedFile(recordsFile.toPath(), 20480, storageLockContext, PagedFileStorage.BUFFER_SIZE, aligned, IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER)).length() == 0L;
                if (initial) {
                    DbConnection.cleanRecord(0);
                    DbConnection.cleanRecord(1);
                    DbConnection.setCurrentVersion();
                }
                if ((version2 = DbConnection.getVersion()) != VERSION) {
                    throw new IOException("FS repository version mismatch: actual=" + version2 + " expected=" + VERSION);
                }
                if (myRecords.getInt(12L) != 523190095) {
                    throw new IOException("FS repository wasn't safely shut down");
                }
                if (initial) {
                    DbConnection.markDirty();
                }
                DbConnection.scanFreeRecords();
                DbConnection.getAttributeId(ourChildrenAttr.getId());
                return null;
            }
            catch (Exception e) {
                LOG.info("Filesystem storage is corrupted or does not exist. [Re]Building. Reason: " + e.getMessage());
                try {
                    DbConnection.closeFiles();
                    boolean deleted = FileUtil.delete(DbConnection.getCorruptionMarkerFile());
                    deleted &= IOUtil.deleteAllFilesStartingWith(namesFile);
                    deleted &= AbstractStorage.deleteFiles(attributesFile.getPath());
                    deleted &= AbstractStorage.deleteFiles(contentsFile.getPath());
                    deleted &= IOUtil.deleteAllFilesStartingWith(contentsHashesFile);
                    deleted &= IOUtil.deleteAllFilesStartingWith(recordsFile);
                    deleted &= IOUtil.deleteAllFilesStartingWith(vfsDependentEnumBaseFile);
                    if (!(deleted &= myRootsFile == null || IOUtil.deleteAllFilesStartingWith(myRootsFile))) {
                        throw new IOException("Cannot delete filesystem storage files");
                    }
                }
                catch (IOException e1) {
                    Runnable warnAndShutdown = () -> {
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            e1.printStackTrace();
                        } else {
                            String message = "Files in " + basePath.getPath() + " are locked.\n" + ApplicationNamesInfo.getInstance().getProductName() + " will not be able to start up.";
                            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), message, IdeBundle.message("dialog.title.fatal.error", new Object[0]), 0);
                            } else {
                                System.err.println(message);
                            }
                        }
                        Runtime.getRuntime().halt(1);
                    };
                    if (EventQueue.isDispatchThread()) {
                        warnAndShutdown.run();
                    } else {
                        SwingUtilities.invokeLater(warnAndShutdown);
                    }
                    throw new RuntimeException("Can't rebuild filesystem storage ", e1);
                }
                return e;
            }
        }

        private static void invalidateIndex(@NotNull String reason) {
            String[] children2;
            if (reason == null) {
                DbConnection.$$$reportNull$$$0(0);
            }
            LOG.info("Marking VFS as corrupted: " + reason);
            File indexRoot = PathManager.getIndexRoot();
            if (indexRoot.exists() && (children2 = indexRoot.list()) != null && children2.length > 0) {
                FileUtil.createIfDoesntExist(new File(PathManager.getIndexRoot(), "corruption.marker"));
            }
        }

        @NotNull
        private static String getCachesDir() {
            String dir = System.getProperty("caches_dir");
            String string = dir == null ? PathManager.getSystemPath() + "/caches/" : dir;
            if (string == null) {
                DbConnection.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static void markDirty() {
            assert (lock.isWriteLocked());
            if (!myDirty) {
                myDirty = true;
                myRecords.putInt(12L, 313341156);
            }
        }

        private static void setupFlushing() {
            if (!backgroundVfsFlush) {
                return;
            }
            myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){
                private int lastModCount;

                @Override
                public void run() {
                    if (this.lastModCount == ourLocalModificationCount) {
                        DbConnection.flush();
                    }
                    this.lastModCount = ourLocalModificationCount;
                }
            });
        }

        private static void doForce() {
            if (myNames != null && myFlushingFuture != null) {
                myNames.force();
                myAttributes.force();
                myContents.force();
                if (myContentHashesEnumerator != null) {
                    myContentHashesEnumerator.force();
                }
                DbConnection.markClean();
                myRecords.force();
            }
        }

        private static void flush() {
            if (DbConnection.isDirty() && !HeavyProcessLatch.INSTANCE.isRunning()) {
                FSRecords.readAndHandleErrors(() -> {
                    DbConnection.doForce();
                    return null;
                });
            }
        }

        public static boolean isDirty() {
            return myDirty || myNames.isDirty() || myAttributes.isDirty() || myContents.isDirty() || myRecords.isDirty() || myContentHashesEnumerator != null && myContentHashesEnumerator.isDirty();
        }

        private static int getVersion() {
            int recordsVersion = myRecords.getInt(0L);
            if (myAttributes.getVersion() != recordsVersion || myContents.getVersion() != recordsVersion) {
                return -1;
            }
            return recordsVersion;
        }

        private static long getTimestamp() {
            return myRecords.getLong(16L);
        }

        private static void setCurrentVersion() {
            myRecords.putInt(0L, VERSION);
            myRecords.putLong(16L, System.currentTimeMillis());
            myAttributes.setVersion(VERSION);
            myContents.setVersion(VERSION);
            myRecords.putInt(12L, 523190095);
        }

        static void cleanRecord(int id2) {
            myRecords.put((long)id2 * 40L, ZEROES, 0, 40);
        }

        private static PersistentStringEnumerator getNames() {
            return myNames;
        }

        private static void closeFiles() throws IOException {
            if (myFlushingFuture != null) {
                myFlushingFuture.cancel(false);
                myFlushingFuture = null;
            }
            if (myNames != null) {
                myNames.close();
                myNames = null;
            }
            if (myAttributes != null) {
                Disposer.dispose(myAttributes);
                myAttributes = null;
            }
            if (myContents != null) {
                Disposer.dispose(myContents);
                myContents = null;
            }
            if (myContentHashesEnumerator != null) {
                myContentHashesEnumerator.close();
                myContentHashesEnumerator = null;
            }
            if (myRecords != null) {
                DbConnection.markClean();
                myRecords.close();
                myRecords = null;
            }
            ourInitialized = false;
        }

        private static void markClean() {
            assert (lock.isWriteLocked() || lock.getReadHoldCount() != 0);
            if (myDirty) {
                myDirty = false;
                myRecords.putInt(12L, myCorrupted ? -1412464769 : 523190095);
            }
        }

        private static int getAttributeId(@NotNull String attId) throws IOException {
            if (attId == null) {
                DbConnection.$$$reportNull$$$0(2);
            }
            return myAttributesList.getIdRaw(attId, false) + FIRST_ATTR_ID_OFFSET;
        }

        @Contract(value="_->fail")
        private static void handleError(@NotNull Throwable e) throws RuntimeException, Error {
            if (e == null) {
                DbConnection.$$$reportNull$$$0(3);
            }
            assert (lock.getReadHoldCount() == 0);
            if (!ourIsDisposed) {
                w.lock();
                try {
                    if (!myCorrupted) {
                        DbConnection.createBrokenMarkerFile(e);
                        myCorrupted = true;
                        DbConnection.doForce();
                    }
                }
                finally {
                    w.unlock();
                }
            }
            ExceptionUtil.rethrow(e);
        }

        static {
            myAttributesList = new VfsDependentEnum<String>("attrib", EnumeratorStringDescriptor.INSTANCE, 1);
            myFreeRecords = new TIntArrayList();
            REASONABLY_SMALL = new AttrPageAwareCapacityAllocationPolicy();
            RESERVED_ATTR_ID = bulkAttrReadSupport ? 1 : 0;
            FIRST_ATTR_ID_OFFSET = bulkAttrReadSupport ? RESERVED_ATTR_ID : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords$DbConnection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/FSRecords$DbConnection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCachesDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invalidateIndex";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributeId";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleError";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class AttrPageAwareCapacityAllocationPolicy
        extends CapacityAllocationPolicy {
            boolean myAttrPageRequested;

            private AttrPageAwareCapacityAllocationPolicy() {
            }

            @Override
            public int calculateCapacity(int requiredLength) {
                return Math.max(this.myAttrPageRequested ? 8 : 32, Math.min((int)((double)requiredLength * 1.2), (requiredLength / 1024 + 1) * 1024));
            }
        }
    }
}

