/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker;
import com.intellij.openapi.vfs.newvfs.persistent.VfsEventGenerationHelper;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Queue;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LocalFileSystemRefreshWorker {
    private final boolean myIsRecursive;
    private final NewVirtualFile myRefreshRoot;
    private final VfsEventGenerationHelper myHelper;
    private volatile boolean myCancelled;
    private static Consumer<? super VirtualFile> ourTestListener;
    private static final BasicFileAttributes BROKEN_SYMLINK_ATTRIBUTES;

    LocalFileSystemRefreshWorker(@NotNull NewVirtualFile refreshRoot, boolean isRecursive) {
        if (refreshRoot == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(0);
        }
        this.myHelper = new VfsEventGenerationHelper();
        this.myIsRecursive = isRecursive;
        this.myRefreshRoot = refreshRoot;
    }

    @NotNull
    List<VFileEvent> getEvents() {
        List<VFileEvent> list2 = this.myHelper.getEvents();
        if (list2 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(1);
        }
        return list2;
    }

    void cancel() {
        this.myCancelled = true;
    }

    void scan() {
        NewVirtualFile root = this.myRefreshRoot;
        boolean rootDirty = root.isDirty();
        if (VfsEventGenerationHelper.LOG.isDebugEnabled()) {
            VfsEventGenerationHelper.LOG.debug("root=" + root + " dirty=" + rootDirty);
        }
        if (!rootDirty) {
            return;
        }
        NewVirtualFileSystem fs = root.getFileSystem();
        FileAttributes rootAttributes = fs.getAttributes(root);
        if (rootAttributes == null) {
            this.myHelper.scheduleDeletion(root);
            root.markClean();
            return;
        }
        if (rootAttributes.isDirectory()) {
            fs = PersistentFS.replaceWithNativeFS(fs);
        }
        RefreshContext context = this.createRefreshContext(fs, PersistentFS.getInstance(), FilePathHashingStrategy.create(fs.isCaseSensitive()));
        context.submitRefreshRequest(() -> this.processFile(root, context));
        context.waitForRefreshToFinish();
    }

    @NotNull
    private RefreshContext createRefreshContext(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistentFS, @NotNull TObjectHashingStrategy<String> strategy) {
        if (fs == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(2);
        }
        if (persistentFS == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(3);
        }
        if (strategy == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(4);
        }
        int parallelism = Registry.intValue("vfs.use.nio-based.local.refresh.worker.parallelism", Runtime.getRuntime().availableProcessors() - 1);
        if (this.myIsRecursive && parallelism > 0 && !ApplicationManager.getApplication().isDispatchThread()) {
            return new ConcurrentRefreshContext(fs, persistentFS, strategy, parallelism);
        }
        return new SequentialRefreshContext(fs, persistentFS, strategy);
    }

    private void processFile(@NotNull NewVirtualFile file2, @NotNull RefreshContext refreshContext) {
        if (file2 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(5);
        }
        if (refreshContext == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(6);
        }
        if (!VfsEventGenerationHelper.checkDirty(file2) || this.isCancelled(file2, refreshContext)) {
            return;
        }
        if (file2.isDirectory()) {
            boolean fullSync = ((VirtualDirectoryImpl)file2).allChildrenLoaded();
            if (fullSync) {
                this.fullDirRefresh((VirtualDirectoryImpl)file2, refreshContext);
            } else {
                this.partialDirRefresh((VirtualDirectoryImpl)file2, refreshContext);
            }
        } else {
            this.refreshFile(file2, refreshContext);
        }
        if (this.isCancelled(file2, refreshContext)) {
            return;
        }
        if (this.myIsRecursive || !file2.isDirectory()) {
            file2.markClean();
        }
    }

    private void refreshFile(@NotNull NewVirtualFile file2, @NotNull RefreshContext refreshContext) {
        if (file2 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(7);
        }
        if (refreshContext == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(8);
        }
        RefreshingFileVisitor refreshingFileVisitor = new RefreshingFileVisitor(file2, refreshContext, null, Collections.singletonList(file2));
        refreshingFileVisitor.visit(file2);
        this.addAllEventsFrom(refreshingFileVisitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllEventsFrom(@NotNull RefreshingFileVisitor refreshingFileVisitor) {
        if (refreshingFileVisitor == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(9);
        }
        VfsEventGenerationHelper vfsEventGenerationHelper = this.myHelper;
        synchronized (vfsEventGenerationHelper) {
            this.myHelper.addAllEventsFrom(refreshingFileVisitor.getHelper());
        }
    }

    private void fullDirRefresh(@NotNull VirtualDirectoryImpl dir, @NotNull RefreshContext refreshContext) {
        RefreshingFileVisitor refreshingFileVisitor;
        Pair<List<String>, List<VirtualFile>> result2;
        boolean hasEvents;
        if (dir == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(10);
        }
        if (refreshContext == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(11);
        }
        do {
            if ((result2 = LocalFileSystemRefreshWorker.getDirectorySnapshot(dir)) == null) {
                return;
            }
            refreshingFileVisitor = new RefreshingFileVisitor(dir, refreshContext, null, (Collection)result2.second);
            refreshingFileVisitor.visit(dir);
            if (!this.myCancelled) continue;
            this.addAllEventsFrom(refreshingFileVisitor);
            break;
        } while (!(hasEvents = ReadAction.compute(() -> {
            if (ApplicationManager.getApplication().isDisposed()) {
                return true;
            }
            if (LocalFileSystemRefreshWorker.areChildrenOrNamesChanged(dir, (List)result2.first, (List)result2.second)) {
                if (VfsEventGenerationHelper.LOG.isDebugEnabled()) {
                    VfsEventGenerationHelper.LOG.debug("retry: " + dir);
                }
                return false;
            }
            this.addAllEventsFrom(refreshingFileVisitor);
            return true;
        }).booleanValue()));
    }

    @Nullable
    static Pair<List<String>, List<VirtualFile>> getDirectorySnapshot(@NotNull VirtualDirectoryImpl dir) {
        if (dir == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(12);
        }
        return ReadAction.compute(() -> {
            if (ApplicationManager.getApplication().isDisposed()) {
                return null;
            }
            VirtualFile[] children2 = dir.getChildren();
            return Pair.pair(LocalFileSystemRefreshWorker.getNames(children2), Arrays.asList(children2));
        });
    }

    static boolean areChildrenOrNamesChanged(@NotNull VirtualDirectoryImpl dir, @NotNull List<String> names2, @NotNull List<VirtualFile> children2) {
        VirtualFile[] currentChildren;
        if (dir == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(13);
        }
        if (names2 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(14);
        }
        if (children2 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(15);
        }
        return !children2.equals(Arrays.asList(currentChildren = dir.getChildren())) || !names2.equals(LocalFileSystemRefreshWorker.getNames(currentChildren));
    }

    private static List<String> getNames(VirtualFile[] children2) {
        return ContainerUtil.map(children2, VirtualFile::getName);
    }

    private void partialDirRefresh(@NotNull VirtualDirectoryImpl dir, @NotNull RefreshContext refreshContext) {
        RefreshingFileVisitor refreshingFileVisitor;
        List wanted;
        List cached;
        boolean hasEvents;
        if (dir == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(16);
        }
        if (refreshContext == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(17);
        }
        do {
            Pair result2 = ReadAction.compute(() -> Pair.pair(dir.getCachedChildren(), dir.getSuspiciousNames()));
            cached = (List)result2.getFirst();
            wanted = (List)result2.getSecond();
            if (cached.isEmpty() && wanted.isEmpty()) {
                return;
            }
            refreshingFileVisitor = new RefreshingFileVisitor(dir, refreshContext, wanted, cached);
            refreshingFileVisitor.visit(dir);
            if (!this.myCancelled) continue;
            this.addAllEventsFrom(refreshingFileVisitor);
            break;
        } while (!(hasEvents = ReadAction.compute(() -> {
            if (!cached.equals(dir.getCachedChildren()) || !wanted.equals(dir.getSuspiciousNames())) {
                if (VfsEventGenerationHelper.LOG.isDebugEnabled()) {
                    VfsEventGenerationHelper.LOG.debug("retry: " + dir);
                }
                return false;
            }
            this.addAllEventsFrom(refreshingFileVisitor);
            return true;
        }).booleanValue()));
    }

    private boolean isCancelled(@NotNull NewVirtualFile stopAt, @NotNull RefreshContext refreshContext) {
        if (stopAt == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(18);
        }
        if (refreshContext == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(19);
        }
        if (ourTestListener != null) {
            ourTestListener.accept(stopAt);
        }
        if (this.myCancelled) {
            refreshContext.filesToBecomeDirty.offer(stopAt);
            return true;
        }
        return false;
    }

    private void checkCancelled(@NotNull NewVirtualFile stopAt, @NotNull RefreshContext refreshContext) throws RefreshWorker.RefreshCancelledException {
        if (stopAt == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(20);
        }
        if (refreshContext == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(21);
        }
        if (this.isCancelled(stopAt, refreshContext)) {
            throw new RefreshWorker.RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(@NotNull NewVirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(22);
        }
        file2.markClean();
        file2.markDirty();
    }

    static void setTestListener(@Nullable Consumer<? super VirtualFile> testListener) {
        ourTestListener = testListener;
    }

    @NotNull
    private static Path fixCaseIfNeeded(@NotNull Path path2, @NotNull VirtualFile file2) throws IOException {
        if (path2 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(23);
        }
        if (file2 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(24);
        }
        if (SystemInfo.isFileSystemCaseSensitive) {
            Path path3 = path2;
            if (path3 == null) {
                LocalFileSystemRefreshWorker.$$$reportNull$$$0(25);
            }
            return path3;
        }
        Path path4 = file2.is(VFileProperty.SYMLINK) ? path2.toRealPath(LinkOption.NOFOLLOW_LINKS) : path2.toRealPath(new LinkOption[0]);
        if (path4 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(26);
        }
        return path4;
    }

    private static boolean isWritable(@NotNull Path file2, @NotNull BasicFileAttributes a, boolean directory) {
        boolean isWritable;
        if (file2 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(27);
        }
        if (a == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(28);
        }
        if (a instanceof DosFileAttributes) {
            DosFileAttributes dosFileAttributes = (DosFileAttributes)a;
            isWritable = directory || !dosFileAttributes.isReadOnly();
        } else {
            isWritable = a instanceof PosixFileAttributes ? ((PosixFileAttributes)a).permissions().contains((Object)PosixFilePermission.OWNER_WRITE) : file2.toFile().canWrite();
        }
        return isWritable;
    }

    @NotNull
    static FileAttributes toFileAttributes(@NotNull Path path2, @NotNull BasicFileAttributes a, boolean isSymlink) {
        if (path2 == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(29);
        }
        if (a == null) {
            LocalFileSystemRefreshWorker.$$$reportNull$$$0(30);
        }
        if (isSymlink && a == BROKEN_SYMLINK_ATTRIBUTES) {
            FileAttributes fileAttributes = FileAttributes.BROKEN_SYMLINK;
            if (fileAttributes == null) {
                LocalFileSystemRefreshWorker.$$$reportNull$$$0(31);
            }
            return fileAttributes;
        }
        long lastModified = a.lastModifiedTime().toMillis();
        boolean writable = LocalFileSystemRefreshWorker.isWritable(path2, a, a.isDirectory());
        if (SystemInfo.isWindows) {
            boolean hidden = path2.getParent() != null && ((DosFileAttributes)a).isHidden();
            return new FileAttributes(a.isDirectory(), a.isOther(), isSymlink, hidden, a.size(), lastModified, writable);
        }
        return new FileAttributes(a.isDirectory(), a.isOther(), isSymlink, false, a.size(), lastModified, writable);
    }

    static {
        BROKEN_SYMLINK_ATTRIBUTES = new BasicFileAttributes(){
            private final FileTime myFileTime = FileTime.fromMillis(0L);

            @Override
            public FileTime lastModifiedTime() {
                return this.myFileTime;
            }

            @Override
            public FileTime lastAccessTime() {
                return this.myFileTime;
            }

            @Override
            public FileTime creationTime() {
                return this.myFileTime;
            }

            @Override
            public boolean isRegularFile() {
                return false;
            }

            @Override
            public boolean isDirectory() {
                return false;
            }

            @Override
            public boolean isSymbolicLink() {
                return true;
            }

            @Override
            public boolean isOther() {
                return false;
            }

            @Override
            public long size() {
                return 0L;
            }

            @Override
            public Object fileKey() {
                return this;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 25: 
            case 26: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 25: 
            case 26: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshRoot";
                break;
            }
            case 1: 
            case 25: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentFS";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 5: 
            case 7: 
            case 22: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshingFileVisitor";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCaseIfNeeded";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "toFileAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 25: 
            case 26: 
            case 31: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRefreshContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "refreshFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAllEventsFrom";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fullDirRefresh";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDirectorySnapshot";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "areChildrenOrNamesChanged";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "partialDirRefresh";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isCancelled";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkCancelled";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "forceMarkDirty";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fixCaseIfNeeded";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "toFileAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 25: 
            case 26: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RefreshingFileVisitor
    extends SimpleFileVisitor<Path> {
        private final VfsEventGenerationHelper myHelper;
        private final Map<String, VirtualFile> myPersistentChildren;
        private final Set<String> myChildrenWeAreInterested;
        private final NewVirtualFile myFileOrDir;
        private final RefreshContext myRefreshContext;

        RefreshingFileVisitor(@NotNull NewVirtualFile fileOrDir, @Nullable(value="null means all") @Nullable(value="null means all") RefreshContext refreshContext, @NotNull Collection<String> childrenToRefresh, Collection<? extends VirtualFile> existingPersistentChildren) {
            if (fileOrDir == null) {
                RefreshingFileVisitor.$$$reportNull$$$0(0);
            }
            if (refreshContext == null) {
                RefreshingFileVisitor.$$$reportNull$$$0(1);
            }
            if (existingPersistentChildren == null) {
                RefreshingFileVisitor.$$$reportNull$$$0(2);
            }
            this.myHelper = new VfsEventGenerationHelper();
            this.myFileOrDir = fileOrDir;
            this.myRefreshContext = refreshContext;
            this.myPersistentChildren = new THashMap<String, VirtualFile>(existingPersistentChildren.size(), refreshContext.strategy);
            this.myChildrenWeAreInterested = childrenToRefresh == null ? null : new THashSet<String>(childrenToRefresh, refreshContext.strategy);
            for (VirtualFile virtualFile2 : existingPersistentChildren) {
                String name = virtualFile2.getName();
                this.myPersistentChildren.put(name, virtualFile2);
                if (this.myChildrenWeAreInterested == null) continue;
                this.myChildrenWeAreInterested.add(name);
            }
        }

        @Override
        public FileVisitResult visitFile(Path file2, BasicFileAttributes attributes) throws IOException {
            String name = file2.getName(file2.getNameCount() - 1).toString();
            if (!this.acceptsFileName(name)) {
                return FileVisitResult.CONTINUE;
            }
            NewVirtualFile child2 = (NewVirtualFile)this.myPersistentChildren.remove(name);
            boolean isDirectory = attributes.isDirectory();
            boolean isSpecial = attributes.isOther();
            boolean isLink = attributes.isSymbolicLink();
            if (isSpecial && isDirectory && SystemInfo.isWindows) {
                isSpecial = false;
                isLink = true;
            }
            if (isLink) {
                try {
                    attributes = Files.readAttributes(file2, BasicFileAttributes.class, new LinkOption[0]);
                }
                catch (FileSystemException ignore) {
                    attributes = BROKEN_SYMLINK_ATTRIBUTES;
                }
                isDirectory = attributes.isDirectory();
            } else if (this.myFileOrDir.is(VFileProperty.SYMLINK)) {
                try {
                    attributes = Files.readAttributes(file2, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                }
                catch (AccessDeniedException | NoSuchFileException ignore) {
                    attributes = BROKEN_SYMLINK_ATTRIBUTES;
                }
                isLink = attributes.isSymbolicLink();
            }
            if (child2 == null) {
                NewVirtualFile parent = this.myFileOrDir.isDirectory() ? this.myFileOrDir : this.myFileOrDir.getParent();
                String symLinkTarget = isLink ? FileUtil.toSystemIndependentName(file2.toRealPath(new LinkOption[0]).toString()) : null;
                try {
                    FileAttributes fa = LocalFileSystemRefreshWorker.toFileAttributes(file2, attributes, isLink);
                    this.myHelper.scheduleCreation(parent, name, fa, symLinkTarget, () -> LocalFileSystemRefreshWorker.this.checkCancelled(this.myFileOrDir, this.myRefreshContext));
                }
                catch (RefreshWorker.RefreshCancelledException e) {
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
            if (LocalFileSystemRefreshWorker.this.isCancelled(child2, this.myRefreshContext)) {
                return FileVisitResult.TERMINATE;
            }
            if (!child2.isDirty()) {
                return FileVisitResult.CONTINUE;
            }
            boolean oldIsDirectory = child2.isDirectory();
            boolean oldIsSymlink = child2.is(VFileProperty.SYMLINK);
            boolean oldIsSpecial = child2.is(VFileProperty.SPECIAL);
            if (oldIsDirectory != isDirectory || oldIsSymlink != isLink || oldIsSpecial != isSpecial) {
                this.myHelper.scheduleDeletion(child2);
                NewVirtualFile parent = this.myFileOrDir.isDirectory() ? this.myFileOrDir : this.myFileOrDir.getParent();
                String symLinkTarget = isLink ? FileUtil.toSystemIndependentName(file2.toRealPath(new LinkOption[0]).toString()) : null;
                try {
                    FileAttributes fa = LocalFileSystemRefreshWorker.toFileAttributes(file2, attributes, isLink);
                    this.myHelper.scheduleCreation(parent, child2.getName(), fa, symLinkTarget, () -> LocalFileSystemRefreshWorker.this.checkCancelled(this.myFileOrDir, this.myRefreshContext));
                }
                catch (RefreshWorker.RefreshCancelledException e) {
                    return FileVisitResult.TERMINATE;
                }
                child2.markClean();
                return FileVisitResult.CONTINUE;
            }
            String currentName = child2.getName();
            if (!currentName.equals(name)) {
                this.myHelper.scheduleAttributeChange(child2, "name", currentName, name);
            }
            if (!isDirectory) {
                this.myHelper.checkContentChanged(child2, this.myRefreshContext.persistence.getTimeStamp(child2), attributes.lastModifiedTime().toMillis(), this.myRefreshContext.persistence.getLastRecordedLength(child2), attributes.size());
            }
            this.myHelper.checkWritableAttributeChange(child2, this.myRefreshContext.persistence.isWritable(child2), LocalFileSystemRefreshWorker.isWritable(file2, attributes, isDirectory));
            if (attributes instanceof DosFileAttributes) {
                this.myHelper.checkHiddenAttributeChange(child2, child2.is(VFileProperty.HIDDEN), ((DosFileAttributes)attributes).isHidden());
            }
            if (isLink) {
                this.myHelper.checkSymbolicLinkChange(child2, child2.getCanonicalPath(), this.myRefreshContext.fs.resolveSymLink(child2));
            }
            if (!child2.isDirectory()) {
                child2.markClean();
            } else if (LocalFileSystemRefreshWorker.this.myIsRecursive) {
                this.myRefreshContext.submitRefreshRequest(() -> LocalFileSystemRefreshWorker.this.processFile(child2, this.myRefreshContext));
            }
            return FileVisitResult.CONTINUE;
        }

        boolean acceptsFileName(@NotNull String name) {
            if (name == null) {
                RefreshingFileVisitor.$$$reportNull$$$0(3);
            }
            return !VfsUtil.isBadName(name);
        }

        void visit(@NotNull VirtualFile fileOrDir) {
            block9: {
                if (fileOrDir == null) {
                    RefreshingFileVisitor.$$$reportNull$$$0(4);
                }
                try {
                    Path path2 = Paths.get(fileOrDir.getPath(), new String[0]);
                    if (fileOrDir.isDirectory()) {
                        if (this.myChildrenWeAreInterested == null) {
                            EnumSet<FileVisitOption> options = fileOrDir.is(VFileProperty.SYMLINK) ? EnumSet.of(FileVisitOption.FOLLOW_LINKS) : EnumSet.noneOf(FileVisitOption.class);
                            Files.walkFileTree(path2, options, 1, this);
                            break block9;
                        }
                        for (String child2 : this.myChildrenWeAreInterested) {
                            try {
                                BasicFileAttributes attrs;
                                Path subPath = LocalFileSystemRefreshWorker.fixCaseIfNeeded(path2.resolve(child2), fileOrDir);
                                FileVisitResult result2 = this.visitFile(subPath, attrs = Files.readAttributes(subPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS));
                                if (result2 != FileVisitResult.TERMINATE) continue;
                                break block9;
                            }
                            catch (IOException iOException) {
                            }
                        }
                        break block9;
                    }
                    Path file2 = LocalFileSystemRefreshWorker.fixCaseIfNeeded(path2, fileOrDir);
                    BasicFileAttributes attrs = Files.readAttributes(file2, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    this.visitFile(file2, attrs);
                }
                catch (AccessDeniedException | NoSuchFileException path2) {
                }
                catch (IOException ex) {
                    VfsEventGenerationHelper.LOG.error(ex);
                }
            }
        }

        @NotNull
        VfsEventGenerationHelper getHelper() {
            if (!this.myPersistentChildren.isEmpty()) {
                if (!LocalFileSystemRefreshWorker.this.myCancelled) {
                    for (VirtualFile child2 : this.myPersistentChildren.values()) {
                        this.myHelper.scheduleDeletion(child2);
                    }
                }
                this.myPersistentChildren.clear();
            }
            VfsEventGenerationHelper vfsEventGenerationHelper = this.myHelper;
            if (vfsEventGenerationHelper == null) {
                RefreshingFileVisitor.$$$reportNull$$$0(5);
            }
            return vfsEventGenerationHelper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOrDir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refreshContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingPersistentChildren";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker$RefreshingFileVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker$RefreshingFileVisitor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptsFileName";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ConcurrentRefreshContext
    extends RefreshContext {
        private final ExecutorService service;
        private final AtomicInteger tasksScheduled;
        private final CountDownLatch refreshFinishedLatch;

        ConcurrentRefreshContext(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistentFS, @NotNull TObjectHashingStrategy<String> strategy, int parallelism) {
            if (fs == null) {
                ConcurrentRefreshContext.$$$reportNull$$$0(0);
            }
            if (persistentFS == null) {
                ConcurrentRefreshContext.$$$reportNull$$$0(1);
            }
            if (strategy == null) {
                ConcurrentRefreshContext.$$$reportNull$$$0(2);
            }
            super(fs, persistentFS, strategy);
            this.tasksScheduled = new AtomicInteger();
            this.refreshFinishedLatch = new CountDownLatch(1);
            this.service = AppExecutorUtil.createBoundedApplicationPoolExecutor("Refresh Worker", parallelism);
        }

        @Override
        void submitRefreshRequest(@NotNull Runnable action2) {
            if (action2 == null) {
                ConcurrentRefreshContext.$$$reportNull$$$0(3);
            }
            this.tasksScheduled.incrementAndGet();
            this.service.execute(() -> {
                try {
                    action2.run();
                }
                finally {
                    if (this.tasksScheduled.decrementAndGet() == 0) {
                        this.refreshFinishedLatch.countDown();
                    }
                }
            });
        }

        @Override
        void doWaitForRefreshToFinish() {
            try {
                this.refreshFinishedLatch.await(1L, TimeUnit.DAYS);
                this.service.shutdown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "persistentFS";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker$ConcurrentRefreshContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "submitRefreshRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SequentialRefreshContext
    extends RefreshContext {
        private final Queue<Runnable> myRefreshRequests;

        SequentialRefreshContext(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistentFS, @NotNull TObjectHashingStrategy<String> strategy) {
            if (fs == null) {
                SequentialRefreshContext.$$$reportNull$$$0(0);
            }
            if (persistentFS == null) {
                SequentialRefreshContext.$$$reportNull$$$0(1);
            }
            if (strategy == null) {
                SequentialRefreshContext.$$$reportNull$$$0(2);
            }
            super(fs, persistentFS, strategy);
            this.myRefreshRequests = new Queue(100);
        }

        @Override
        void submitRefreshRequest(@NotNull Runnable request2) {
            if (request2 == null) {
                SequentialRefreshContext.$$$reportNull$$$0(3);
            }
            this.myRefreshRequests.addLast(request2);
        }

        @Override
        void doWaitForRefreshToFinish() {
            while (!this.myRefreshRequests.isEmpty()) {
                this.myRefreshRequests.pullFirst().run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "persistentFS";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker$SequentialRefreshContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "submitRefreshRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class RefreshContext {
        final NewVirtualFileSystem fs;
        final PersistentFS persistence;
        final TObjectHashingStrategy<String> strategy;
        final BlockingQueue<NewVirtualFile> filesToBecomeDirty;

        RefreshContext(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull TObjectHashingStrategy<String> strategy) {
            if (fs == null) {
                RefreshContext.$$$reportNull$$$0(0);
            }
            if (persistence == null) {
                RefreshContext.$$$reportNull$$$0(1);
            }
            if (strategy == null) {
                RefreshContext.$$$reportNull$$$0(2);
            }
            this.filesToBecomeDirty = new LinkedBlockingQueue<NewVirtualFile>();
            this.fs = fs;
            this.persistence = persistence;
            this.strategy = strategy;
        }

        abstract void submitRefreshRequest(@NotNull Runnable var1);

        abstract void doWaitForRefreshToFinish();

        final void waitForRefreshToFinish() {
            this.doWaitForRefreshToFinish();
            for (NewVirtualFile file2 : this.filesToBecomeDirty) {
                LocalFileSystemRefreshWorker.forceMarkDirty(file2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "persistence";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "strategy";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/newvfs/persistent/LocalFileSystemRefreshWorker$RefreshContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

