/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.impl.win32.Win32LocalFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.FsRoot;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.ReplicatorInputStream;
import com.intellij.util.text.CharSequenceHashingStrategy;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentFSImpl
extends PersistentFS
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PersistentFS.class);
    private final Map<String, VirtualFileSystemEntry> myRoots = ConcurrentCollectionFactory.createMap(10, 0.4f, JobSchedulerImpl.getCPUCoresCount(), FileUtil.PATH_HASHING_STRATEGY);
    private final ConcurrentIntObjectMap<VirtualFileSystemEntry> myIdToDirCache = ContainerUtil.createConcurrentIntObjectSoftValueMap();
    private final Object myInputLock = new Object();
    private final AtomicBoolean myShutDown = new AtomicBoolean(false);
    private final AtomicInteger myStructureModificationCount = new AtomicInteger();
    private BulkFileListener myPublisher;
    private final VfsData myVfsData = new VfsData();
    private static final int INNER_ARRAYS_THRESHOLD = 1024;

    public PersistentFSImpl() {
        ShutDownTracker.getInstance().registerShutdownTask(this::performShutdown);
        LowMemoryWatcher.register(this::clearIdCache, this);
        AsyncEventSupport.startListening();
        Activity activity = StartUpMeasurer.startActivity("connect FSRecords");
        FSRecords.connect();
        activity.end();
    }

    @NotNull
    private BulkFileListener getPublisher() {
        BulkFileListener publisher = this.myPublisher;
        if (publisher == null) {
            this.myPublisher = publisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
        }
        BulkFileListener bulkFileListener = publisher;
        if (bulkFileListener == null) {
            PersistentFSImpl.$$$reportNull$$$0(0);
        }
        return bulkFileListener;
    }

    @Override
    public void dispose() {
        this.performShutdown();
    }

    private void performShutdown() {
        if (this.myShutDown.compareAndSet(false, true)) {
            LOG.info("VFS dispose started");
            FSRecords.dispose();
            LOG.info("VFS dispose completed");
        }
    }

    @Override
    public boolean areChildrenLoaded(@NotNull VirtualFile dir) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(1);
        }
        return PersistentFSImpl.areChildrenLoaded(PersistentFSImpl.getFileId(dir));
    }

    @Override
    public long getCreationTimestamp() {
        return FSRecords.getCreationTimestamp();
    }

    @NotNull
    public VirtualFileSystemEntry getOrCacheDir(int id2, @NotNull VirtualDirectoryImpl newDir) {
        VirtualFileSystemEntry dir;
        if (newDir == null) {
            PersistentFSImpl.$$$reportNull$$$0(2);
        }
        if ((dir = (VirtualFileSystemEntry)this.myIdToDirCache.get(id2)) != null) {
            VirtualFileSystemEntry virtualFileSystemEntry = dir;
            if (virtualFileSystemEntry == null) {
                PersistentFSImpl.$$$reportNull$$$0(3);
            }
            return virtualFileSystemEntry;
        }
        VirtualFileSystemEntry virtualFileSystemEntry = this.myIdToDirCache.cacheOrGet(id2, newDir);
        if (virtualFileSystemEntry == null) {
            PersistentFSImpl.$$$reportNull$$$0(4);
        }
        return virtualFileSystemEntry;
    }

    public VirtualFileSystemEntry getCachedDir(int id2) {
        return (VirtualFileSystemEntry)this.myIdToDirCache.get(id2);
    }

    @NotNull
    private static NewVirtualFileSystem getDelegate(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(5);
        }
        NewVirtualFileSystem newVirtualFileSystem = (NewVirtualFileSystem)file2.getFileSystem();
        if (newVirtualFileSystem == null) {
            PersistentFSImpl.$$$reportNull$$$0(6);
        }
        return newVirtualFileSystem;
    }

    @Override
    public boolean wereChildrenAccessed(@NotNull VirtualFile dir) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(7);
        }
        return FSRecords.wereChildrenAccessed(PersistentFSImpl.getFileId(dir));
    }

    @Override
    public String @NotNull [] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(8);
        }
        FSRecords.NameId[] nameIds = this.listAll(file2);
        String[] stringArray = ContainerUtil.map2Array(nameIds, String.class, id2 -> id2.name.toString());
        if (stringArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @Override
    public String @NotNull [] listPersisted(@NotNull VirtualFile parent) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(10);
        }
        return PersistentFSImpl.listPersisted(FSRecords.list(PersistentFSImpl.getFileId(parent)));
    }

    private static String @NotNull [] listPersisted(int @NotNull [] childrenIds) {
        if (childrenIds == null) {
            PersistentFSImpl.$$$reportNull$$$0(11);
        }
        String[] names2 = ArrayUtil.newStringArray(childrenIds.length);
        for (int i = 0; i < childrenIds.length; ++i) {
            names2[i] = FSRecords.getName(childrenIds[i]);
        }
        if (names2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(12);
        }
        return names2;
    }

    private static FSRecords.NameId @NotNull [] persistAllChildren(@NotNull VirtualFile file2, int id2, FSRecords.NameId @NotNull [] current2) {
        NewVirtualFileSystem fs;
        String[] delegateNames;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(13);
        }
        if (current2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(14);
        }
        if ((delegateNames = VfsUtil.filterNames((fs = PersistentFSImpl.replaceWithNativeFS(PersistentFSImpl.getDelegate(file2))).list(file2))).length == 0 && current2.length > 0) {
            if (current2 == null) {
                PersistentFSImpl.$$$reportNull$$$0(15);
            }
            return current2;
        }
        THashSet<String> toAdd = new THashSet<String>(Arrays.asList(delegateNames), FilePathHashingStrategy.create(fs.isCaseSensitive()));
        for (FSRecords.NameId nameId : current2) {
            toAdd.remove(nameId.name.toString());
        }
        TIntArrayList childrenIds = new TIntArrayList(current2.length + toAdd.size());
        ArrayList<FSRecords.NameId> nameIds = new ArrayList<FSRecords.NameId>(current2.length + toAdd.size());
        for (FSRecords.NameId nameId : current2) {
            childrenIds.add(nameId.id);
            nameIds.add(nameId);
        }
        for (String newName : toAdd) {
            Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, file2, newName, null, null);
            if (childData == null) continue;
            int childId = PersistentFSImpl.makeChildRecord(id2, newName, childData, fs);
            childrenIds.add(childId);
            nameIds.add(new FSRecords.NameId(childId, FileNameCache.storeName(newName), newName));
        }
        nameIds.sort(Comparator.comparingInt(o -> o.id));
        FSRecords.updateList(id2, childrenIds.toNativeArray());
        PersistentFSImpl.setChildrenCached(id2);
        FSRecords.NameId[] nameIdArray = nameIds.toArray(FSRecords.NameId.EMPTY_ARRAY);
        if (nameIdArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(16);
        }
        return nameIdArray;
    }

    private static void setChildrenCached(int id2) {
        int flags = FSRecords.getFlags(id2);
        FSRecords.setFlags(id2, flags | 1, true);
    }

    @Override
    public FSRecords.NameId @NotNull [] listAll(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(17);
        }
        int id2 = PersistentFSImpl.getFileId(file2);
        FSRecords.NameId[] nameIds = FSRecords.listAll(id2);
        if (!PersistentFSImpl.areChildrenLoaded(id2)) {
            nameIds = PersistentFSImpl.persistAllChildren(file2, id2, nameIds);
        }
        if (nameIds == null) {
            PersistentFSImpl.$$$reportNull$$$0(18);
        }
        return nameIds;
    }

    private static boolean areChildrenLoaded(int parentId) {
        return BitUtil.isSet(FSRecords.getFlags(parentId), 1);
    }

    @Override
    @Nullable
    public DataInputStream readAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(19);
        }
        if (att == null) {
            PersistentFSImpl.$$$reportNull$$$0(20);
        }
        return FSRecords.readAttributeWithLock(PersistentFSImpl.getFileId(file2), att);
    }

    @Override
    @NotNull
    public DataOutputStream writeAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(21);
        }
        if (att == null) {
            PersistentFSImpl.$$$reportNull$$$0(22);
        }
        com.intellij.util.io.DataOutputStream dataOutputStream = FSRecords.writeAttribute(PersistentFSImpl.getFileId(file2), att);
        if (dataOutputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(23);
        }
        return dataOutputStream;
    }

    @Nullable
    private static DataInputStream readContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(24);
        }
        return FSRecords.readContent(PersistentFSImpl.getFileId(file2));
    }

    @NotNull
    private static DataInputStream readContentById(int contentId) {
        DataInputStream dataInputStream = FSRecords.readContentById(contentId);
        if (dataInputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(25);
        }
        return dataInputStream;
    }

    @NotNull
    private static DataOutputStream writeContent(@NotNull VirtualFile file2, boolean readOnly) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(26);
        }
        com.intellij.util.io.DataOutputStream dataOutputStream = FSRecords.writeContent(PersistentFSImpl.getFileId(file2), readOnly);
        if (dataOutputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(27);
        }
        return dataOutputStream;
    }

    private static void writeContent(@NotNull VirtualFile file2, ByteArraySequence content2, boolean readOnly) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(28);
        }
        FSRecords.writeContent(PersistentFSImpl.getFileId(file2), content2, readOnly);
    }

    @Override
    public int storeUnlinkedContent(byte @NotNull [] bytes) {
        if (bytes == null) {
            PersistentFSImpl.$$$reportNull$$$0(29);
        }
        return FSRecords.storeUnlinkedContent(bytes);
    }

    @Override
    public int getModificationCount(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(30);
        }
        return FSRecords.getModCount(PersistentFSImpl.getFileId(file2));
    }

    @Override
    public int getModificationCount() {
        return FSRecords.getLocalModCount();
    }

    @Override
    public int getStructureModificationCount() {
        return this.myStructureModificationCount.get();
    }

    public void incStructuralModificationCount() {
        this.myStructureModificationCount.incrementAndGet();
    }

    @Override
    public int getFilesystemModificationCount() {
        return FSRecords.getModCount();
    }

    private static boolean writeAttributesToRecord(int id2, int parentId, @NotNull CharSequence name, @NotNull NewVirtualFileSystem fs, @NotNull FileAttributes attributes, @Nullable String symlinkTarget) {
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(31);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(32);
        }
        if (attributes == null) {
            PersistentFSImpl.$$$reportNull$$$0(33);
        }
        assert (id2 > 0) : id2;
        assert (parentId >= 0) : parentId;
        if (name.length() != 0 ? PersistentFSImpl.namesEqual(fs, name, FSRecords.getNameSequence(id2)) : PersistentFSImpl.areChildrenLoaded(id2)) {
            return false;
        }
        FSRecords.writeAttributesToRecord(id2, parentId, attributes, name.toString());
        if (attributes.isSymLink()) {
            FSRecords.storeSymlinkTarget(id2, symlinkTarget);
            if (fs instanceof Win32LocalFileSystem) {
                fs = LocalFileSystem.getInstance();
            }
            if (fs instanceof LocalFileSystemImpl) {
                VirtualFile parent = PersistentFSImpl.getInstance().findFileById(parentId);
                assert (parent != null) : parentId + 47 + id2 + ": " + name.toString() + " -> " + symlinkTarget;
                String linkPath = parent.getPath() + '/' + name.toString();
                ((LocalFileSystemImpl)fs).symlinkUpdated(id2, parent, linkPath, symlinkTarget);
            }
        }
        return true;
    }

    @Override
    public int getFileAttributes(int id2) {
        assert (id2 > 0);
        return FSRecords.getFlags(id2);
    }

    @Override
    public boolean isDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(34);
        }
        return PersistentFSImpl.isDirectory(this.getFileAttributes(PersistentFSImpl.getFileId(file2)));
    }

    private static boolean namesEqual(@NotNull VirtualFileSystem fs, @NotNull CharSequence n1, @NotNull CharSequence n2) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(35);
        }
        if (n1 == null) {
            PersistentFSImpl.$$$reportNull$$$0(36);
        }
        if (n2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(37);
        }
        return Comparing.equal(n1, n2, fs.isCaseSensitive());
    }

    @Override
    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            PersistentFSImpl.$$$reportNull$$$0(38);
        }
        return fileOrDirectory.exists();
    }

    @Override
    public long getTimeStamp(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(39);
        }
        return FSRecords.getTimestamp(PersistentFSImpl.getFileId(file2));
    }

    @Override
    public void setTimeStamp(@NotNull VirtualFile file2, long modStamp) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(40);
        }
        int id2 = PersistentFSImpl.getFileId(file2);
        FSRecords.setTimestamp(id2, modStamp);
        PersistentFSImpl.getDelegate(file2).setTimeStamp(file2, modStamp);
    }

    private static int getFileId(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(41);
        }
        return ((VirtualFileWithId)((Object)file2)).getId();
    }

    @Override
    public boolean isSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(42);
        }
        return PersistentFSImpl.isSymLink(this.getFileAttributes(PersistentFSImpl.getFileId(file2)));
    }

    @Override
    public String resolveSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(43);
        }
        return FSRecords.readSymlinkTarget(PersistentFSImpl.getFileId(file2));
    }

    @Override
    public boolean isWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(44);
        }
        return !BitUtil.isSet(this.getFileAttributes(PersistentFSImpl.getFileId(file2)), 4);
    }

    @Override
    public boolean isHidden(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(45);
        }
        return BitUtil.isSet(this.getFileAttributes(PersistentFSImpl.getFileId(file2)), 64);
    }

    @Override
    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(46);
        }
        PersistentFSImpl.getDelegate(file2).setWritable(file2, writableFlag);
        boolean oldWritable = this.isWritable(file2);
        if (oldWritable != writableFlag) {
            this.processEvent(new VFilePropertyChangeEvent(this, file2, "writable", oldWritable, writableFlag, false));
        }
    }

    @Override
    public int getId(@NotNull VirtualFile parent, @NotNull String childName, @NotNull NewVirtualFileSystem fs) {
        int parentId;
        int[] children2;
        int childId;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(47);
        }
        if (childName == null) {
            PersistentFSImpl.$$$reportNull$$$0(48);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(49);
        }
        if ((childId = PersistentFSImpl.findExistingId(childName, children2 = FSRecords.list(parentId = PersistentFSImpl.getFileId(parent)), fs)) > 0) {
            return childId;
        }
        Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, parent, childName, null, null);
        if (childData != null) {
            String oldChildName = childName;
            if (StringUtil.isEmptyOrSpaces(childName = fs.getCanonicallyCasedName(new FakeVirtualFile(parent, oldChildName)))) {
                return 0;
            }
            if (!childName.equals(oldChildName) && (childId = PersistentFSImpl.findExistingId(childName, children2, fs)) > 0) {
                return childId;
            }
            childId = PersistentFSImpl.makeChildRecord(parentId, childName, childData, fs);
            FSRecords.updateList(parentId, ArrayUtil.append(children2, childId));
            return childId;
        }
        return 0;
    }

    private static int findExistingId(@NotNull String childName, int @NotNull [] childIds, @NotNull NewVirtualFileSystem fs) {
        if (childName == null) {
            PersistentFSImpl.$$$reportNull$$$0(50);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(51);
        }
        if (childIds == null) {
            PersistentFSImpl.$$$reportNull$$$0(52);
        }
        if (childIds.length > 0) {
            int nameId = FSRecords.getNameId(childName);
            int[] nArray = childIds;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int childId = nArray[i];
                if (nameId != FSRecords.getNameId(childId)) continue;
                return childId;
            }
        }
        for (int childId : childIds) {
            if (!PersistentFSImpl.namesEqual(fs, childName, FSRecords.getNameSequence(childId))) continue;
            return childId;
        }
        return 0;
    }

    @Override
    public long getLength(@NotNull VirtualFile file2) {
        long length;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(53);
        }
        return (length = PersistentFSImpl.getLengthIfUpToDate(file2)) == -1L ? PersistentFSImpl.reloadLengthFromDelegate(file2, PersistentFSImpl.getDelegate(file2)) : length;
    }

    @Override
    public long getLastRecordedLength(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(54);
        }
        int id2 = PersistentFSImpl.getFileId(file2);
        return FSRecords.getLength(id2);
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile parent, @NotNull String name) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(55);
        }
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(56);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(57);
        }
        PersistentFSImpl.getDelegate(file2).copyFile(requestor, file2, parent, name);
        this.processEvent(new VFileCopyEvent(requestor, file2, parent, name));
        VirtualFile child2 = parent.findChild(name);
        if (child2 == null) {
            throw new IOException("Cannot create child");
        }
        VirtualFile virtualFile2 = child2;
        if (virtualFile2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(58);
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(59);
        }
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(60);
        }
        PersistentFSImpl.getDelegate(parent).createChildDirectory(requestor, parent, dir);
        this.processEvent(new VFileCreateEvent(requestor, parent, dir, true, null, null, false, ChildInfo.EMPTY_ARRAY));
        VirtualFile child2 = parent.findChild(dir);
        if (child2 == null) {
            throw new IOException("Cannot create child directory '" + dir + "' at " + parent.getPath());
        }
        VirtualFile virtualFile2 = child2;
        if (virtualFile2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(61);
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(62);
        }
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(63);
        }
        PersistentFSImpl.getDelegate(parent).createChildFile(requestor, parent, file2);
        this.processEvent(new VFileCreateEvent(requestor, parent, file2, false, null, null, false, null));
        VirtualFile child2 = parent.findChild(file2);
        if (child2 == null) {
            throw new IOException("Cannot create child file '" + file2 + "' at " + parent.getPath());
        }
        if (child2.getCharset().equals(StandardCharsets.UTF_8) && !(child2.getFileType() instanceof InternalFileType)) {
            EncodingManager encodingManager;
            Project project2 = ProjectLocator.getInstance().guessProjectForFile(child2);
            EncodingManager encodingManager2 = encodingManager = project2 == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance(project2);
            if (encodingManager.shouldAddBOMForNewUtf8File()) {
                child2.setBOM(CharsetToolkit.UTF8_BOM);
            }
        }
        VirtualFile virtualFile2 = child2;
        if (virtualFile2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(64);
        }
        return virtualFile2;
    }

    @Override
    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(65);
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
        delegate.deleteFile(requestor, file2);
        if (!delegate.exists(file2)) {
            this.processEvent(new VFileDeleteEvent(requestor, file2, false));
        }
    }

    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(66);
        }
        if (newName == null) {
            PersistentFSImpl.$$$reportNull$$$0(67);
        }
        PersistentFSImpl.getDelegate(file2).renameFile(requestor, file2, newName);
        String oldName = file2.getName();
        if (!newName.equals(oldName)) {
            this.processEvent(new VFilePropertyChangeEvent(requestor, file2, "name", oldName, newName, false));
        }
    }

    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(68);
        }
        byte[] byArray = this.contentsToByteArray(file2, true);
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(69);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2, boolean cacheContent) throws IOException {
        byte[] byArray;
        boolean reloadFromDelegate;
        boolean outdated;
        long length;
        int fileId;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(70);
        }
        DataInputStream contentStream = null;
        Object object = this.myInputLock;
        synchronized (object) {
            fileId = PersistentFSImpl.getFileId(file2);
            length = PersistentFSImpl.getLengthIfUpToDate(file2);
            outdated = length == -1L;
            reloadFromDelegate = outdated || (contentStream = PersistentFSImpl.readContent(file2)) == null;
        }
        if (reloadFromDelegate) {
            byte[] content2;
            NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
            if (outdated) {
                FSRecords.setLength(fileId, delegate.getLength(file2));
                content2 = delegate.contentsToByteArray(file2);
            } else {
                content2 = delegate.contentsToByteArray(file2);
                FSRecords.setLength(fileId, content2.length);
            }
            Application application = ApplicationManager.getApplication();
            if ((!delegate.isReadOnly() || cacheContent && !application.isInternal() && !application.isUnitTestMode()) && (long)content2.length <= PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD) {
                Object object2 = this.myInputLock;
                synchronized (object2) {
                    PersistentFSImpl.writeContent(file2, new ByteArraySequence(content2), delegate.isReadOnly());
                    PersistentFSImpl.setFlag(file2, 8, false);
                }
            }
            if (content2 == null) {
                PersistentFSImpl.$$$reportNull$$$0(71);
            }
            return content2;
        }
        try {
            assert (length >= 0L) : file2;
            byArray = FileUtil.loadBytes(contentStream, (int)length);
        }
        catch (IOException e) {
            FSRecords.handleError(e);
            if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                PersistentFSImpl.$$$reportNull$$$0(73);
            }
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(72);
        }
        return byArray;
    }

    @Override
    public byte @NotNull [] contentsToByteArray(int contentId) throws IOException {
        DataInputStream stream = PersistentFSImpl.readContentById(contentId);
        byte[] byArray = FileUtil.loadBytes(stream);
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(74);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        DataInputStream contentStream;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(75);
        }
        Object object = this.myInputLock;
        // MONITORENTER : object
        if (PersistentFSImpl.getLengthIfUpToDate(file2) != -1L && !FileUtilRt.isTooLarge(file2.getLength()) && (contentStream = PersistentFSImpl.readContent(file2)) != null) {
            DataInputStream dataInputStream = contentStream;
            // MONITOREXIT : object
            if (dataInputStream != null) return dataInputStream;
            PersistentFSImpl.$$$reportNull$$$0(78);
            return dataInputStream;
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
        long len = PersistentFSImpl.reloadLengthFromDelegate(file2, delegate);
        InputStream nativeStream = delegate.getInputStream(file2);
        if (len > PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD) {
            InputStream inputStream = nativeStream;
            // MONITOREXIT : object
            if (inputStream != null) return inputStream;
            PersistentFSImpl.$$$reportNull$$$0(76);
            return inputStream;
        }
        InputStream inputStream = this.createReplicator(file2, nativeStream, len, delegate.isReadOnly());
        // MONITOREXIT : object
        if (inputStream != null) return inputStream;
        PersistentFSImpl.$$$reportNull$$$0(77);
        return inputStream;
    }

    private static long reloadLengthFromDelegate(@NotNull VirtualFile file2, @NotNull NewVirtualFileSystem delegate) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(79);
        }
        if (delegate == null) {
            PersistentFSImpl.$$$reportNull$$$0(80);
        }
        long len = delegate.getLength(file2);
        FSRecords.setLength(PersistentFSImpl.getFileId(file2), len);
        return len;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private InputStream createReplicator(final @NotNull VirtualFile file2, @NotNull InputStream nativeStream, final long fileLength, boolean bl) {
        void readOnly;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(81);
        }
        if (nativeStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(82);
        }
        if (nativeStream instanceof BufferExposingByteArrayInputStream) {
            BufferExposingByteArrayInputStream byteStream = (BufferExposingByteArrayInputStream)nativeStream;
            byte[] bytes = byteStream.getInternalBuffer();
            this.storeContentToStorage(fileLength, file2, (boolean)readOnly, bytes, bytes.length);
            InputStream inputStream = nativeStream;
            if (inputStream == null) {
                PersistentFSImpl.$$$reportNull$$$0(83);
            }
            return inputStream;
        }
        BufferExposingByteArrayOutputStream cache = new BufferExposingByteArrayOutputStream((int)fileLength);
        return new ReplicatorInputStream(nativeStream, cache, (boolean)readOnly, cache){
            final /* synthetic */ boolean val$readOnly;
            final /* synthetic */ BufferExposingByteArrayOutputStream val$cache;
            {
                this.val$readOnly = bl;
                this.val$cache = bufferExposingByteArrayOutputStream;
                super(arg0, arg1);
            }

            @Override
            public void close() throws IOException {
                super.close();
                PersistentFSImpl.this.storeContentToStorage(fileLength, file2, this.val$readOnly, this.val$cache.getInternalBuffer(), this.val$cache.size());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void storeContentToStorage(long fileLength, @NotNull VirtualFile file2, boolean readOnly, byte @NotNull [] bytes, int n) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(84);
        }
        if (bytes == null) {
            PersistentFSImpl.$$$reportNull$$$0(85);
        }
        Object object = this.myInputLock;
        synchronized (object) {
            void bytesLength;
            if ((long)bytesLength == fileLength) {
                PersistentFSImpl.writeContent(file2, new ByteArraySequence(bytes, 0, (int)bytesLength), readOnly);
                PersistentFSImpl.setFlag(file2, 8, false);
            } else {
                PersistentFSImpl.setFlag(file2, 8, true);
            }
        }
    }

    public byte @Nullable [] getContentHashIfStored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(86);
        }
        return FSRecords.getContentHash(PersistentFSImpl.getFileId(file2));
    }

    private static long getLengthIfUpToDate(@NotNull VirtualFile file2) {
        int fileId;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(87);
        }
        return BitUtil.isSet(FSRecords.getFlags(fileId = PersistentFSImpl.getFileId(file2)), 8) ? -1L : FSRecords.getLength(fileId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file2, final Object requestor, final long modStamp, long l) {
        void timeStamp;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(88);
        }
        return new ByteArrayOutputStream((long)timeStamp){
            private boolean closed;
            final /* synthetic */ long val$timeStamp;
            {
                this.val$timeStamp = l2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                Throwable throwable;
                if (this.closed) {
                    return;
                }
                super.close();
                ApplicationManager.getApplication().assertWriteAccessAllowed();
                VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, file2, file2.getModificationStamp(), modStamp, false);
                List<VFileContentChangeEvent> events = Collections.singletonList(event);
                PersistentFSImpl.this.getPublisher().before(events);
                NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
                try {
                    throwable = null;
                    try (DataOutputStream persistenceStream = PersistentFSImpl.writeContent(file2, delegate.isReadOnly());){
                        ((OutputStream)persistenceStream).write(this.buf, 0, this.count);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        try (OutputStream ioFileStream = delegate.getOutputStream(file2, requestor, modStamp, this.val$timeStamp);){
                            ioFileStream.write(this.buf, 0, this.count);
                        }
                        this.closed = true;
                        FileAttributes attributes = delegate.getAttributes(file2);
                        PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), attributes != null ? attributes.length : 0L, attributes != null ? attributes.lastModified : 0L);
                    }
                    catch (Throwable throwable4) {
                        this.closed = true;
                        FileAttributes attributes = delegate.getAttributes(file2);
                        PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), attributes != null ? attributes.length : 0L, attributes != null ? attributes.lastModified : 0L);
                        PersistentFSImpl.this.getPublisher().after(events);
                        throw throwable4;
                    }
                    PersistentFSImpl.this.getPublisher().after(events);
                    throw throwable3;
                }
                try {
                    throwable = null;
                    try (OutputStream ioFileStream = delegate.getOutputStream(file2, requestor, modStamp, this.val$timeStamp);){
                        ioFileStream.write(this.buf, 0, this.count);
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    this.closed = true;
                    FileAttributes attributes = delegate.getAttributes(file2);
                    PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), attributes != null ? attributes.length : 0L, attributes != null ? attributes.lastModified : 0L);
                }
                catch (Throwable throwable6) {
                    this.closed = true;
                    FileAttributes attributes = delegate.getAttributes(file2);
                    PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), attributes != null ? attributes.length : 0L, attributes != null ? attributes.lastModified : 0L);
                    PersistentFSImpl.this.getPublisher().after(events);
                    throw throwable6;
                }
                PersistentFSImpl.this.getPublisher().after(events);
            }
        };
    }

    @Override
    public int acquireContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(89);
        }
        return FSRecords.acquireFileContent(PersistentFSImpl.getFileId(file2));
    }

    @Override
    public void releaseContent(int contentId) {
        FSRecords.releaseContent(contentId);
    }

    @Override
    public int getCurrentContentId(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(90);
        }
        return FSRecords.getContentId(PersistentFSImpl.getFileId(file2));
    }

    @Override
    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(91);
        }
        if (newParent == null) {
            PersistentFSImpl.$$$reportNull$$$0(92);
        }
        PersistentFSImpl.getDelegate(file2).moveFile(requestor, file2, newParent);
        this.processEvent(new VFileMoveEvent(requestor, file2, newParent));
    }

    private void processEvent(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(93);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (event.isValid()) {
            List<VFileEvent> events = Collections.singletonList(event);
            this.getPublisher().before(events);
            this.applyEvent(event);
            this.getPublisher().after(events);
        }
    }

    private static int groupByPath(@NotNull List<? extends VFileEvent> events, int startIndex, @NotNull MostlySingularMultiMap<String, VFileEvent> filesInvolved, @NotNull Set<? super String> middleDirsInvolved, @NotNull Set<? super String> deletedPaths, @NotNull Set<? super String> createdPaths, @NotNull Set<? super VFileEvent> eventsToRemove) {
        int i;
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(94);
        }
        if (filesInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(95);
        }
        if (middleDirsInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(96);
        }
        if (deletedPaths == null) {
            PersistentFSImpl.$$$reportNull$$$0(97);
        }
        if (createdPaths == null) {
            PersistentFSImpl.$$$reportNull$$$0(98);
        }
        if (eventsToRemove == null) {
            PersistentFSImpl.$$$reportNull$$$0(99);
        }
        for (i = startIndex; i < events.size(); ++i) {
            String path2;
            VFileEvent event = events.get(i);
            String path3 = event.getPath();
            if (event instanceof VFileDeleteEvent && PersistentFSImpl.removeNestedDelete(path3, deletedPaths)) {
                eventsToRemove.add(event);
                continue;
            }
            if (event instanceof VFileCreateEvent && !createdPaths.add(path3)) {
                eventsToRemove.add(event);
                continue;
            }
            if (PersistentFSImpl.checkIfConflictingPaths(event, path3, filesInvolved, middleDirsInvolved) || (path2 = PersistentFSImpl.getAlternativePath(event)) != null && !FileUtil.PATH_HASHING_STRATEGY.equals(path2, path3) && PersistentFSImpl.checkIfConflictingPaths(event, path2, filesInvolved, middleDirsInvolved)) break;
        }
        return i;
    }

    @Nullable
    private static String getAlternativePath(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(100);
        }
        String path2 = null;
        if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name")) {
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
            VirtualFile parent = pce.getFile().getParent();
            String newName = (String)pce.getNewValue();
            path2 = parent == null ? newName : parent.getPath() + "/" + newName;
        } else if (event instanceof VFileCopyEvent) {
            path2 = ((VFileCopyEvent)event).getFile().getPath();
        } else if (event instanceof VFileMoveEvent) {
            VFileMoveEvent vme = (VFileMoveEvent)event;
            String newName = vme.getFile().getName();
            path2 = vme.getNewParent().getPath() + "/" + newName;
        }
        return path2;
    }

    private static boolean removeNestedDelete(@NotNull String path2, @NotNull Set<? super String> deletedPaths) {
        int liPrev;
        if (path2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(101);
        }
        if (deletedPaths == null) {
            PersistentFSImpl.$$$reportNull$$$0(102);
        }
        if (!deletedPaths.add(path2)) {
            return true;
        }
        int li = path2.length();
        while ((liPrev = path2.lastIndexOf(47, li - 1)) != -1) {
            path2 = path2.substring(0, liPrev);
            li = liPrev;
            if (!deletedPaths.contains(path2)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkIfConflictingPaths(@NotNull VFileEvent event, @NotNull String path2, @NotNull MostlySingularMultiMap<String, VFileEvent> files2, @NotNull Set<? super String> middleDirs) {
        int liPrev;
        Iterable<VFileEvent> stored;
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(103);
        }
        if (path2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(104);
        }
        if (files2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(105);
        }
        if (middleDirs == null) {
            PersistentFSImpl.$$$reportNull$$$0(106);
        }
        if (!PersistentFSImpl.canReconcileEvents(event, stored = files2.get(path2))) {
            return true;
        }
        if (middleDirs.contains(path2)) {
            return true;
        }
        files2.add(path2, event);
        int li = path2.length();
        while ((liPrev = path2.lastIndexOf(47, li - 1)) != -1) {
            String parentDir = path2.substring(0, liPrev);
            if (files2.containsKey(parentDir)) {
                return true;
            }
            if (!middleDirs.add(parentDir)) break;
            li = liPrev;
        }
        return false;
    }

    private static boolean canReconcileEvents(@NotNull VFileEvent event, @NotNull Iterable<? extends VFileEvent> stored) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(107);
        }
        if (stored == null) {
            PersistentFSImpl.$$$reportNull$$$0(108);
        }
        return ContainerUtil.and(stored, e -> PersistentFSImpl.canReconcile(event, e));
    }

    private static boolean canReconcile(@NotNull VFileEvent event1, @NotNull VFileEvent event2) {
        if (event1 == null) {
            PersistentFSImpl.$$$reportNull$$$0(109);
        }
        if (event2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(110);
        }
        return PersistentFSImpl.isContentChangeLikeHarmlessEvent(event1) && PersistentFSImpl.isContentChangeLikeHarmlessEvent(event2);
    }

    private static boolean isContentChangeLikeHarmlessEvent(@NotNull VFileEvent event1) {
        if (event1 == null) {
            PersistentFSImpl.$$$reportNull$$$0(111);
        }
        return event1 instanceof VFileContentChangeEvent || event1 instanceof VFilePropertyChangeEvent && (((VFilePropertyChangeEvent)event1).getPropertyName().equals("writable") || ((VFilePropertyChangeEvent)event1).getPropertyName().equals("encoding"));
    }

    private int groupAndValidate(@NotNull List<? extends VFileEvent> events, int startIndex, @NotNull List<? super Runnable> outApplyEvents, @NotNull List<? super VFileEvent> outValidatedEvents, @NotNull MostlySingularMultiMap<String, VFileEvent> filesInvolved, @NotNull Set<? super String> middleDirsInvolved) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(112);
        }
        if (outApplyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(113);
        }
        if (outValidatedEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(114);
        }
        if (filesInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(115);
        }
        if (middleDirsInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(116);
        }
        THashSet toIgnore = new THashSet(ContainerUtil.identityStrategy());
        int endIndex = PersistentFSImpl.groupByPath(events, startIndex, filesInvolved, middleDirsInvolved, new THashSet<String>(FileUtil.PATH_HASHING_STRATEGY), new THashSet<String>(FileUtil.PATH_HASHING_STRATEGY), toIgnore);
        assert (endIndex > startIndex) : events.get(startIndex) + "; files: " + filesInvolved + "; middleDirs: " + middleDirsInvolved;
        this.groupCreations(events, startIndex, endIndex, outValidatedEvents, outApplyEvents, toIgnore);
        this.groupDeletions(events, startIndex, endIndex, outValidatedEvents, outApplyEvents, toIgnore);
        this.groupOthers(events, startIndex, endIndex, outValidatedEvents, outApplyEvents);
        return endIndex;
    }

    private void groupCreations(@NotNull List<? extends VFileEvent> events, final int start2, final int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyEvents, @NotNull Set<? extends VFileEvent> toIgnore) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(117);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(118);
        }
        if (outApplyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(119);
        }
        if (toIgnore == null) {
            PersistentFSImpl.$$$reportNull$$$0(120);
        }
        MultiMap grouped = null;
        for (int i = start2; i < end; ++i) {
            VFileEvent e = events.get(i);
            if (!(e instanceof VFileCreateEvent) || toIgnore.contains(e)) continue;
            VFileCreateEvent vFileCreateEvent = (VFileCreateEvent)e;
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)vFileCreateEvent.getParent();
            if (grouped == null) {
                grouped = new MultiMap<VirtualDirectoryImpl, VFileCreateEvent>(){

                    @Override
                    @NotNull
                    protected Map<VirtualDirectoryImpl, Collection<VFileCreateEvent>> createMap() {
                        return new THashMap<VirtualDirectoryImpl, Collection<VFileCreateEvent>>(end - start2);
                    }
                };
            }
            grouped.putValue(parent, vFileCreateEvent);
        }
        if (grouped != null) {
            boolean hasValidEvents = false;
            for (Map.Entry entry : grouped.entrySet()) {
                VirtualDirectoryImpl directory = (VirtualDirectoryImpl)entry.getKey();
                List createEvents = (List)entry.getValue();
                directory.validateChildrenToCreate(createEvents);
                hasValidEvents |= !createEvents.isEmpty();
                outValidated.addAll(createEvents);
            }
            if (hasValidEvents) {
                MultiMap finalGrouped = grouped;
                outApplyEvents.add(() -> {
                    this.applyCreations(finalGrouped);
                    this.incStructuralModificationCount();
                });
            }
        }
    }

    private void groupDeletions(@NotNull List<? extends VFileEvent> events, final int start2, final int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyEvents, @NotNull Set<? extends VFileEvent> toIgnore) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(121);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(122);
        }
        if (outApplyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(123);
        }
        if (toIgnore == null) {
            PersistentFSImpl.$$$reportNull$$$0(124);
        }
        MultiMap grouped = null;
        boolean hasValidEvents = false;
        for (int i = start2; i < end; ++i) {
            VFileEvent event = events.get(i);
            if (!(event instanceof VFileDeleteEvent) || toIgnore.contains(event) || !event.isValid()) continue;
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            @Nullable VirtualDirectoryImpl parent = (VirtualDirectoryImpl)de.getFile().getParent();
            if (grouped == null) {
                grouped = new MultiMap<VirtualDirectoryImpl, VFileDeleteEvent>(){

                    @Override
                    @NotNull
                    protected Map<VirtualDirectoryImpl, Collection<VFileDeleteEvent>> createMap() {
                        return new HashMap<VirtualDirectoryImpl, Collection<VFileDeleteEvent>>(end - start2);
                    }
                };
            }
            grouped.putValue(parent, de);
            outValidated.add(event);
            hasValidEvents = true;
        }
        if (hasValidEvents) {
            MultiMap finalGrouped = grouped;
            outApplyEvents.add(() -> {
                this.clearIdCache();
                this.applyDeletions(finalGrouped);
                this.incStructuralModificationCount();
            });
        }
    }

    private void groupOthers(@NotNull List<? extends VFileEvent> events, int start2, int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyEvents) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(125);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(126);
        }
        if (outApplyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(127);
        }
        for (int i = start2; i < end; ++i) {
            VFileEvent event = events.get(i);
            if (event instanceof VFileCreateEvent || event instanceof VFileDeleteEvent || !event.isValid()) continue;
            outValidated.add(event);
            outApplyEvents.add(() -> this.applyEvent(event));
        }
    }

    @Override
    public void processEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(128);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        int startIndex = 0;
        final int cappedInitialSize = Math.min(events.size(), 1024);
        ArrayList applyEvents = new ArrayList(cappedInitialSize);
        MostlySingularMultiMap<String, VFileEvent> files2 = new MostlySingularMultiMap<String, VFileEvent>(){

            @Override
            @NotNull
            protected Map<String, Object> createMap() {
                return new THashMap<String, Object>(cappedInitialSize, FileUtil.PATH_HASHING_STRATEGY);
            }
        };
        THashSet<String> middleDirs = new THashSet<String>(cappedInitialSize, FileUtil.PATH_HASHING_STRATEGY);
        ArrayList validated = new ArrayList(cappedInitialSize);
        BulkFileListener publisher = this.getPublisher();
        while (startIndex != events.size()) {
            applyEvents.clear();
            files2.clear();
            middleDirs.clear();
            validated.clear();
            startIndex = this.groupAndValidate(events, startIndex, applyEvents, validated, files2, middleDirs);
            if (validated.isEmpty()) continue;
            ImmutableList<VFileEvent> toSend = ContainerUtil.immutableList(validated.toArray(new VFileEvent[0]));
            publisher.before(toSend);
            applyEvents.forEach(Runnable::run);
            publisher.after(toSend);
        }
    }

    private void applyDeletions(@NotNull MultiMap<VirtualDirectoryImpl, VFileDeleteEvent> deletions) {
        if (deletions == null) {
            PersistentFSImpl.$$$reportNull$$$0(129);
        }
        for (Map.Entry<VirtualDirectoryImpl, Collection<VFileDeleteEvent>> entry : deletions.entrySet()) {
            VirtualDirectoryImpl parent = entry.getKey();
            Collection<VFileDeleteEvent> deleteEvents = entry.getValue();
            if (parent == null || !parent.isValid()) {
                deleteEvents.forEach(this::applyEvent);
                return;
            }
            int parentId = PersistentFSImpl.getFileId(parent);
            int[] oldIds = FSRecords.list(parentId);
            TIntHashSet parentChildrenIds = new TIntHashSet(oldIds);
            ArrayList<CharSequence> childrenNamesDeleted = new ArrayList<CharSequence>(deleteEvents.size());
            TIntHashSet childrenIdsDeleted = new TIntHashSet(deleteEvents.size());
            for (VFileDeleteEvent event : deleteEvents) {
                VirtualFile file2 = event.getFile();
                int id2 = PersistentFSImpl.getFileId(file2);
                childrenNamesDeleted.add(file2.getNameSequence());
                childrenIdsDeleted.add(id2);
                FSRecords.deleteRecordRecursively(id2);
                PersistentFSImpl.invalidateSubtree(file2);
                parentChildrenIds.remove(id2);
            }
            FSRecords.updateList(parentId, parentChildrenIds.toArray());
            parent.removeChildren(childrenIdsDeleted, childrenNamesDeleted);
        }
    }

    private void applyCreations(@NotNull MultiMap<VirtualDirectoryImpl, VFileCreateEvent> creations) {
        if (creations == null) {
            PersistentFSImpl.$$$reportNull$$$0(130);
        }
        for (Map.Entry<VirtualDirectoryImpl, Collection<VFileCreateEvent>> entry : creations.entrySet()) {
            VirtualDirectoryImpl parent = entry.getKey();
            Collection<VFileCreateEvent> createEvents = entry.getValue();
            this.applyCreateEventsInDirectory(parent, createEvents);
        }
    }

    private void applyCreateEventsInDirectory(@NotNull VirtualDirectoryImpl parent, @NotNull Collection<? extends VFileCreateEvent> createEvents) {
        int parentId;
        NewVirtualFile vf;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(131);
        }
        if (createEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(132);
        }
        if (!((vf = this.findFileById(parentId = PersistentFSImpl.getFileId(parent))) instanceof VirtualDirectoryImpl)) {
            return;
        }
        parent = (VirtualDirectoryImpl)vf;
        NewVirtualFileSystem delegate = PersistentFSImpl.replaceWithNativeFS(PersistentFSImpl.getDelegate(parent));
        TIntHashSet parentChildrenIds = new TIntHashSet(createEvents.size());
        List<ChildInfo> childrenAdded = PersistentFSImpl.getOrCreateChildInfos(parent, createEvents, VFileCreateEvent::getChildName, parentChildrenIds, delegate, (createEvent, childId) -> {
            createEvent.resetCache();
            String name = createEvent.getChildName();
            Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(delegate, createEvent.getParent(), name, createEvent.getAttributes(), createEvent.getSymlinkTarget());
            if (childData == null) {
                return null;
            }
            childId = PersistentFSImpl.makeChildRecord(parentId, name, childData, delegate);
            return new ChildInfoImpl((int)childId, name, (FileAttributes)childData.first, createEvent.getChildren(), createEvent.getSymlinkTarget());
        });
        FSRecords.updateList(parentId, parentChildrenIds.toArray());
        parent.createAndAddChildren(childrenAdded, false, (__, ___) -> {});
        PersistentFSImpl.saveScannedChildrenRecursively(createEvents, delegate);
    }

    private static void saveScannedChildrenRecursively(@NotNull Collection<? extends VFileCreateEvent> createEvents, @NotNull NewVirtualFileSystem delegate) {
        if (createEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(133);
        }
        if (delegate == null) {
            PersistentFSImpl.$$$reportNull$$$0(134);
        }
        for (VFileCreateEvent vFileCreateEvent : createEvents) {
            VirtualFile createdDir;
            ChildInfo[] children2 = vFileCreateEvent.getChildren();
            if (children2 == null || !vFileCreateEvent.isDirectory() || !((createdDir = vFileCreateEvent.getFile()) instanceof VirtualDirectoryImpl)) continue;
            ArrayDeque<Pair<VirtualDirectoryImpl, ChildInfo[]>> queue = new ArrayDeque<Pair<VirtualDirectoryImpl, ChildInfo[]>>();
            queue.add(Pair.pair((VirtualDirectoryImpl)createdDir, children2));
            while (!queue.isEmpty()) {
                Pair queued = (Pair)queue.remove();
                VirtualDirectoryImpl directory = (VirtualDirectoryImpl)queued.first;
                TIntHashSet childIds = new TIntHashSet();
                List<Object> scannedChildren = Arrays.asList((Object[])queued.second);
                List<ChildInfo> added = PersistentFSImpl.getOrCreateChildInfos(directory, scannedChildren, ChildInfo::getName, childIds, delegate, (childInfo, childId) -> {
                    if (childId < 0) {
                        String childName = childInfo.getName().toString();
                        Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(delegate, directory, childName, childInfo.getFileAttributes(), childInfo.getSymLinkTarget());
                        if (childData == null) {
                            return null;
                        }
                        childId = PersistentFSImpl.makeChildRecord(directory.getId(), childName, childData, delegate);
                    }
                    return new ChildInfoImpl((int)childId, childInfo.getNameId(), childInfo.getFileAttributes(), childInfo.getChildren(), childInfo.getSymLinkTarget());
                });
                FSRecords.updateList(directory.getId(), childIds.toArray());
                PersistentFSImpl.setChildrenCached(directory.getId());
                directory.createAndAddChildren(added, true, (childCreated, childInfo) -> {
                    if (childCreated instanceof VirtualDirectoryImpl && childInfo.getChildren() != null) {
                        queue.add(Pair.pair((VirtualDirectoryImpl)childCreated, childInfo.getChildren()));
                    }
                });
            }
        }
    }

    @NotNull
    private static <T> List<ChildInfo> getOrCreateChildInfos(@NotNull VirtualDirectoryImpl parent, @NotNull Collection<? extends T> createEvents, @NotNull Function<? super T, ? extends CharSequence> nameExtractor, @NotNull TIntHashSet parentChildrenIds, @NotNull NewVirtualFileSystem delegate, @NotNull PairFunction<? super T, ? super Integer, ? extends ChildInfo> convertor) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(135);
        }
        if (createEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(136);
        }
        if (nameExtractor == null) {
            PersistentFSImpl.$$$reportNull$$$0(137);
        }
        if (parentChildrenIds == null) {
            PersistentFSImpl.$$$reportNull$$$0(138);
        }
        if (delegate == null) {
            PersistentFSImpl.$$$reportNull$$$0(139);
        }
        if (convertor == null) {
            PersistentFSImpl.$$$reportNull$$$0(140);
        }
        int parentId = parent.getId();
        FSRecords.NameId[] oldNameIds = FSRecords.listAll(parentId);
        int[] oldIds = new int[oldNameIds.length];
        CharSequenceHashingStrategy strategy = delegate.isCaseSensitive() ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE;
        THashSet<CharSequence> persistedNames = new THashSet<CharSequence>(oldNameIds.length, (TObjectHashingStrategy<CharSequence>)strategy);
        for (int i = 0; i < oldNameIds.length; ++i) {
            FSRecords.NameId nameId = oldNameIds[i];
            parentChildrenIds.add(nameId.id);
            persistedNames.add(nameId.name);
            oldIds[i] = nameId.id;
        }
        ArrayList<ChildInfo> childrenAdded = new ArrayList<ChildInfo>(createEvents.size());
        for (T createEvent : createEvents) {
            ChildInfo childInfo;
            CharSequence name = nameExtractor.apply(createEvent);
            int childId = -1;
            if (persistedNames.contains(name)) {
                childId = PersistentFSImpl.findExistingId(name.toString(), oldIds, delegate);
            }
            if ((childInfo = convertor.fun(createEvent, childId)) == null) continue;
            childrenAdded.add(childInfo);
            parentChildrenIds.add(childInfo.getId());
        }
        ArrayList<ChildInfo> arrayList = childrenAdded;
        if (arrayList == null) {
            PersistentFSImpl.$$$reportNull$$$0(141);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public VirtualFileSystemEntry findRoot(@NotNull String path2, @NotNull NewVirtualFileSystem fs) {
        boolean mark;
        FsRoot newRoot;
        FileAttributes parentAttributes;
        String parentPath;
        String rootPath;
        CharSequence rootName;
        if (path2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(142);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(143);
        }
        if (path2.isEmpty()) {
            LOG.error("Invalid root, fs=" + fs);
            return null;
        }
        String rootUrl = UriUtil.trimTrailingSlashes(VirtualFileManager.constructUrl(fs.getProtocol(), path2));
        VirtualFileSystemEntry root = this.myRoots.get(rootUrl);
        if (root != null) {
            return root;
        }
        if (fs instanceof ArchiveFileSystem) {
            ArchiveFileSystem afs = (ArchiveFileSystem)fs;
            VirtualFile localFile = afs.findLocalByRootPath(path2);
            if (localFile == null) {
                return null;
            }
            rootName = localFile.getNameSequence();
            rootPath = afs.getRootPathByLocal(localFile);
            rootUrl = UriUtil.trimTrailingSlashes(VirtualFileManager.constructUrl(fs.getProtocol(), rootPath));
        } else {
            rootPath = path2;
            rootName = rootPath;
        }
        FileAttributes attributes = fs.getAttributes(new StubVirtualFile(){

            @Override
            @NotNull
            public String getPath() {
                String string = rootPath;
                if (string == null) {
                    6.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @Nullable
            public VirtualFile getParent() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$6", "getPath"));
            }
        });
        if (attributes == null || !attributes.isDirectory()) {
            return null;
        }
        String string = parentPath = fs instanceof LocalFileSystem ? PathUtil.getParentPath(rootPath) : "";
        if (!parentPath.isEmpty() && (parentAttributes = fs.getAttributes(new StubVirtualFile(){

            @Override
            @NotNull
            public String getPath() {
                String string = parentPath;
                if (string == null) {
                    7.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @Nullable
            public VirtualFile getParent() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$7", "getPath"));
            }
        })) != null) {
            throw new IllegalArgumentException("Must pass FS root path, but got: '" + path2 + "', which has a parent '" + parentPath + "'). Use NewVirtualFileSystem.extractRootPath() for obtaining root path");
        }
        int rootId = FSRecords.findRootRecord(rootUrl);
        int rootNameId = FileNameCache.storeName(rootName.toString());
        Map<String, VirtualFileSystemEntry> map2 = this.myRoots;
        synchronized (map2) {
            root = this.myRoots.get(rootUrl);
            if (root != null) {
                return root;
            }
            try {
                newRoot = new FsRoot(rootId, rootNameId, this.myVfsData, fs, StringUtil.trimTrailing(rootPath, '/'));
            }
            catch (VfsData.FileAlreadyCreatedException e) {
                for (Map.Entry<String, VirtualFileSystemEntry> entry : this.myRoots.entrySet()) {
                    VirtualFileSystemEntry existingRoot = entry.getValue();
                    if (existingRoot.getId() != rootId) continue;
                    String message = "Duplicate FS roots: " + rootUrl + " / " + entry.getKey() + " id=" + rootId + " valid=" + existingRoot.isValid();
                    throw new RuntimeException(message, e);
                }
                throw new RuntimeException("No root duplication, rootName='" + rootName + "'; rootNameId=" + rootNameId + "; rootId=" + rootId + "; path='" + path2 + "'; fs=" + fs + "; rootUrl='" + rootUrl + "'", e);
            }
            this.incStructuralModificationCount();
            mark = PersistentFSImpl.writeAttributesToRecord(rootId, 0, rootName, fs, attributes, null);
            this.myRoots.put(rootUrl, newRoot);
            this.myIdToDirCache.put(rootId, newRoot);
        }
        if (!mark && attributes.lastModified != FSRecords.getTimestamp(rootId)) {
            ((VirtualFileSystemEntry)newRoot).markDirtyRecursively();
        }
        LOG.assertTrue(rootId == newRoot.getId(), "root=" + newRoot + " expected=" + rootId + " actual=" + newRoot.getId());
        return newRoot;
    }

    @Override
    public void clearIdCache() {
        this.myIdToDirCache.entrySet().removeIf(e -> ((VirtualFileSystemEntry)e.getValue()).getParent() != null);
    }

    @Override
    @Nullable
    public NewVirtualFile findFileById(int id2) {
        VirtualFileSystemEntry cached = (VirtualFileSystemEntry)this.myIdToDirCache.get(id2);
        return cached != null ? cached : FSRecords.findFileById(id2, this.myIdToDirCache);
    }

    @Override
    public NewVirtualFile findFileByIdIfCached(int id2) {
        return this.myVfsData.hasLoadedFile(id2) ? this.findFileById(id2) : null;
    }

    @Override
    public VirtualFile @NotNull [] getRoots() {
        Collection<VirtualFileSystemEntry> roots = this.myRoots.values();
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(144);
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getRoots(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(145);
        }
        ArrayList<NewVirtualFile> roots = new ArrayList<NewVirtualFile>();
        for (NewVirtualFile newVirtualFile : this.myRoots.values()) {
            if (newVirtualFile.getFileSystem() != fs) continue;
            roots.add(newVirtualFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(146);
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getLocalRoots() {
        SmartList<NewVirtualFile> roots = new SmartList<NewVirtualFile>();
        for (NewVirtualFile newVirtualFile : this.myRoots.values()) {
            if (!newVirtualFile.isInLocalFileSystem() || newVirtualFile.getFileSystem() instanceof TempFileSystem) continue;
            roots.add(newVirtualFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(147);
        }
        return virtualFileArray;
    }

    private void applyEvent(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(148);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Applying " + event);
        }
        try {
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent ce = (VFileCreateEvent)event;
                this.executeCreateChild(ce.getParent(), ce.getChildName(), ce.getAttributes(), ce.getSymlinkTarget(), ce.isEmptyDirectory());
            } else if (event instanceof VFileDeleteEvent) {
                VFileDeleteEvent deleteEvent = (VFileDeleteEvent)event;
                this.executeDelete(deleteEvent.getFile());
            } else if (event instanceof VFileContentChangeEvent) {
                VFileContentChangeEvent contentUpdateEvent = (VFileContentChangeEvent)event;
                VirtualFile file2 = contentUpdateEvent.getFile();
                long length = contentUpdateEvent.getNewLength();
                long timestamp = contentUpdateEvent.getNewTimestamp();
                if (!contentUpdateEvent.isLengthAndTimestampDiffProvided()) {
                    NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
                    FileAttributes attributes = delegate.getAttributes(file2);
                    length = attributes != null ? attributes.length : 0L;
                    timestamp = attributes != null ? attributes.lastModified : 0L;
                }
                PersistentFSImpl.executeTouch(file2, contentUpdateEvent.isFromRefresh(), contentUpdateEvent.getModificationStamp(), length, timestamp);
            } else if (event instanceof VFileCopyEvent) {
                VFileCopyEvent ce = (VFileCopyEvent)event;
                this.executeCreateChild(ce.getNewParent(), ce.getNewChildName(), null, null, ce.getFile().getChildren().length == 0);
            } else if (event instanceof VFileMoveEvent) {
                VFileMoveEvent moveEvent = (VFileMoveEvent)event;
                this.executeMove(moveEvent.getFile(), moveEvent.getNewParent());
            } else if (event instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)event;
                VirtualFile file3 = propertyChangeEvent.getFile();
                Object newValue = propertyChangeEvent.getNewValue();
                switch (propertyChangeEvent.getPropertyName()) {
                    case "name": {
                        PersistentFSImpl.executeRename(file3, (String)newValue);
                        break;
                    }
                    case "writable": {
                        PersistentFSImpl.executeSetWritable(file3, (Boolean)newValue);
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("File " + file3 + " writable=" + file3.isWritable() + " id=" + PersistentFSImpl.getFileId(file3));
                        break;
                    }
                    case "HIDDEN": {
                        PersistentFSImpl.executeSetHidden(file3, (Boolean)newValue);
                        break;
                    }
                    case "symlink": {
                        PersistentFSImpl.executeSetTarget(file3, (String)newValue);
                        this.markForContentReloadRecursively(PersistentFSImpl.getFileId(file3));
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    public String toString() {
        return "PersistentFS";
    }

    private void executeCreateChild(@NotNull VirtualFile parent, @NotNull String name, @Nullable FileAttributes attributes, @Nullable String symlinkTarget, boolean isEmptyDirectory) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(149);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(150);
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(parent);
        int parentId = PersistentFSImpl.getFileId(parent);
        Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(delegate, parent, name, attributes, symlinkTarget);
        if (childData != null) {
            int childId = PersistentFSImpl.makeChildRecord(parentId, name, childData, delegate);
            PersistentFSImpl.appendIdToParentList(parentId, childId);
            assert (parent instanceof VirtualDirectoryImpl) : parent;
            VirtualDirectoryImpl dir = (VirtualDirectoryImpl)parent;
            VirtualFileSystemEntry child2 = dir.createChild(name, childId, dir.getFileSystem(), (FileAttributes)childData.first, isEmptyDirectory);
            if (isEmptyDirectory) {
                PersistentFSImpl.setChildrenCached(childId);
            }
            dir.addChild(child2);
            this.incStructuralModificationCount();
        }
    }

    private static int makeChildRecord(int parentId, @NotNull CharSequence name, @NotNull Pair<FileAttributes, String> childData, @NotNull NewVirtualFileSystem fs) {
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(151);
        }
        if (childData == null) {
            PersistentFSImpl.$$$reportNull$$$0(152);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(153);
        }
        int childId = FSRecords.createRecord();
        PersistentFSImpl.writeAttributesToRecord(childId, parentId, name, fs, (FileAttributes)childData.first, (String)childData.second);
        assert (childId > 0) : childId;
        return childId;
    }

    @Nullable
    private static Pair<FileAttributes, String> getChildData(@NotNull NewVirtualFileSystem fs, @NotNull VirtualFile parent, @NotNull String name, @Nullable FileAttributes attributes, @Nullable String symlinkTarget) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(154);
        }
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(155);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(156);
        }
        if (attributes == null) {
            FakeVirtualFile virtualFile2 = new FakeVirtualFile(parent, name);
            attributes = fs.getAttributes(virtualFile2);
            symlinkTarget = attributes != null && attributes.isSymLink() ? fs.resolveSymLink(virtualFile2) : null;
        }
        return attributes == null ? null : Pair.pair(attributes, symlinkTarget);
    }

    private static void appendIdToParentList(int parentId, int childId) {
        int[] childrenList = FSRecords.list(parentId);
        childrenList = ArrayUtil.append(childrenList, childId);
        FSRecords.updateList(parentId, childrenList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDelete(@NotNull VirtualFile file2) {
        int parentId;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(157);
        }
        if (!file2.exists()) {
            LOG.error("Deleting a file which does not exist: " + ((VirtualFileWithId)((Object)file2)).getId() + " " + file2.getPath());
            return;
        }
        this.clearIdCache();
        int id2 = PersistentFSImpl.getFileId(file2);
        VirtualFile parent = file2.getParent();
        int n = parentId = parent == null ? 0 : PersistentFSImpl.getFileId(parent);
        if (parentId == 0) {
            String rootUrl = UriUtil.trimTrailingSlashes(file2.getUrl());
            Map<String, VirtualFileSystemEntry> map2 = this.myRoots;
            synchronized (map2) {
                this.myRoots.remove(rootUrl);
                this.myIdToDirCache.remove(id2);
                FSRecords.deleteRootRecord(id2);
            }
        } else {
            PersistentFSImpl.removeIdFromParentList(parentId, id2, parent, file2);
            VirtualDirectoryImpl directory = (VirtualDirectoryImpl)file2.getParent();
            assert (directory != null) : file2;
            directory.removeChild(file2);
        }
        FSRecords.deleteRecordRecursively(id2);
        PersistentFSImpl.invalidateSubtree(file2);
        this.incStructuralModificationCount();
    }

    private static void invalidateSubtree(@NotNull VirtualFile file2) {
        VirtualFileSystem fs;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(158);
        }
        VirtualFileSystemEntry impl = (VirtualFileSystemEntry)file2;
        if (file2.is(VFileProperty.SYMLINK) && (fs = file2.getFileSystem()) instanceof LocalFileSystemImpl) {
            ((LocalFileSystemImpl)fs).symlinkRemoved(impl.getId());
        }
        impl.invalidate();
        for (VirtualFile child2 : impl.getCachedChildren()) {
            PersistentFSImpl.invalidateSubtree(child2);
        }
    }

    private static void removeIdFromParentList(int parentId, int id2, @NotNull VirtualFile parent, VirtualFile file2) {
        int[] childList;
        int index;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(159);
        }
        if ((index = ArrayUtil.indexOf(childList = FSRecords.list(parentId), id2)) == -1) {
            throw new RuntimeException("Cannot find child (" + id2 + ")" + file2 + "\n\tin (" + parentId + ")" + parent + "\n\tactual children:" + Arrays.toString(childList));
        }
        childList = ArrayUtil.remove(childList, index);
        FSRecords.updateList(parentId, childList);
    }

    private static void executeRename(@NotNull VirtualFile file2, @NotNull String newName) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(160);
        }
        if (newName == null) {
            PersistentFSImpl.$$$reportNull$$$0(161);
        }
        int id2 = PersistentFSImpl.getFileId(file2);
        FSRecords.setName(id2, newName);
        ((VirtualFileSystemEntry)file2).setNewName(newName);
    }

    private static void executeSetWritable(@NotNull VirtualFile file2, boolean writableFlag) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(162);
        }
        PersistentFSImpl.setFlag(file2, 4, !writableFlag);
        ((VirtualFileSystemEntry)file2).updateProperty("writable", writableFlag);
    }

    private static void executeSetHidden(@NotNull VirtualFile file2, boolean hiddenFlag) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(163);
        }
        PersistentFSImpl.setFlag(file2, 64, hiddenFlag);
        ((VirtualFileSystemEntry)file2).updateProperty("HIDDEN", hiddenFlag);
    }

    private static void executeSetTarget(@NotNull VirtualFile file2, @Nullable String target2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(164);
        }
        int id2 = PersistentFSImpl.getFileId(file2);
        FSRecords.storeSymlinkTarget(id2, target2);
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof LocalFileSystemImpl) {
            ((LocalFileSystemImpl)fs).symlinkUpdated(id2, file2.getParent(), file2.getPath(), target2);
        }
    }

    private static void setFlag(@NotNull VirtualFile file2, int mask, boolean value2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(165);
        }
        PersistentFSImpl.setFlag(PersistentFSImpl.getFileId(file2), mask, value2);
    }

    private static void setFlag(int id2, int mask, boolean value2) {
        int flags;
        int oldFlags = FSRecords.getFlags(id2);
        int n = flags = value2 ? oldFlags | mask : oldFlags & ~mask;
        if (oldFlags != flags) {
            FSRecords.setFlags(id2, flags, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void executeTouch(@NotNull VirtualFile file2, boolean reloadContentFromDelegate, long newModificationStamp, long newLength, long l) {
        void newTimestamp;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(166);
        }
        if (reloadContentFromDelegate) {
            PersistentFSImpl.setFlag(file2, 8, true);
        }
        int fileId = PersistentFSImpl.getFileId(file2);
        FSRecords.setLength(fileId, newLength);
        FSRecords.setTimestamp(fileId, (long)newTimestamp);
        ((VirtualFileSystemEntry)file2).setModificationStamp(newModificationStamp);
    }

    private void executeMove(@NotNull VirtualFile file2, @NotNull VirtualFile newParent) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(167);
        }
        if (newParent == null) {
            PersistentFSImpl.$$$reportNull$$$0(168);
        }
        this.clearIdCache();
        int fileId = PersistentFSImpl.getFileId(file2);
        int newParentId = PersistentFSImpl.getFileId(newParent);
        int oldParentId = PersistentFSImpl.getFileId(file2.getParent());
        PersistentFSImpl.removeIdFromParentList(oldParentId, fileId, file2.getParent(), file2);
        FSRecords.setParent(fileId, newParentId);
        PersistentFSImpl.appendIdToParentList(newParentId, fileId);
        ((VirtualFileSystemEntry)file2).setParent(newParent);
    }

    @Override
    public String getName(int id2) {
        assert (id2 > 0);
        return FSRecords.getName(id2);
    }

    public void cleanPersistedContent(int id2) {
        PersistentFSImpl.doCleanPersistedContent(id2);
    }

    public void cleanPersistedContents() {
        int[] roots;
        for (int root : roots = FSRecords.listRoots()) {
            this.markForContentReloadRecursively(root);
        }
    }

    private void markForContentReloadRecursively(int id2) {
        if (PersistentFSImpl.isDirectory(this.getFileAttributes(id2))) {
            for (int child2 : FSRecords.list(id2)) {
                this.markForContentReloadRecursively(child2);
            }
        } else {
            PersistentFSImpl.doCleanPersistedContent(id2);
        }
    }

    private static void doCleanPersistedContent(int id2) {
        PersistentFSImpl.setFlag(id2, 8, true);
    }

    @Override
    public boolean mayHaveChildren(int id2) {
        return FSRecords.mayHaveChildren(id2);
    }

    ConcurrentIntObjectMap<VirtualFileSystemEntry> getIdToDirCache() {
        return this.myIdToDirCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl";
                break;
            }
            case 1: 
            case 7: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDir";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 53: 
            case 54: 
            case 55: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 75: 
            case 79: 
            case 81: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 157: 
            case 158: 
            case 160: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 47: 
            case 56: 
            case 59: 
            case 62: 
            case 131: 
            case 135: 
            case 149: 
            case 155: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenIds";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "att";
                break;
            }
            case 29: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 31: 
            case 57: 
            case 150: 
            case 151: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: 
            case 35: 
            case 49: 
            case 51: 
            case 143: 
            case 145: 
            case 153: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n1";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n2";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childIds";
                break;
            }
            case 67: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 80: 
            case 134: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeStream";
                break;
            }
            case 92: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 93: 
            case 100: 
            case 103: 
            case 107: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 94: 
            case 112: 
            case 117: 
            case 121: 
            case 125: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 95: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesInvolved";
                break;
            }
            case 96: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middleDirsInvolved";
                break;
            }
            case 97: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedPaths";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdPaths";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventsToRemove";
                break;
            }
            case 101: 
            case 104: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middleDirs";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stored";
                break;
            }
            case 109: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event1";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event2";
                break;
            }
            case 113: 
            case 119: 
            case 123: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outApplyEvents";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outValidatedEvents";
                break;
            }
            case 118: 
            case 122: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outValidated";
                break;
            }
            case 120: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletions";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creations";
                break;
            }
            case 132: 
            case 133: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createEvents";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExtractor";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentChildrenIds";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCacheDir";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "listPersisted";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "persistAllChildren";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "listAll";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentById";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "writeContent";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildFile";
                break;
            }
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplicator";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateChildInfos";
                break;
            }
            case 144: 
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "areChildrenLoaded";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCacheDir";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDelegate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wereChildrenAccessed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "listPersisted";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "persistAllChildren";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "listAll";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readContent";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "writeContent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "storeUnlinkedContent";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getModificationCount";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributesToRecord";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "namesEqual";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getFileId";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findExistingId";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getLastRecordedLength";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 68: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "reloadLengthFromDelegate";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createReplicator";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "storeContentToStorage";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getContentHashIfStored";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getLengthIfUpToDate";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "acquireContent";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentContentId";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "processEvent";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "groupByPath";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativePath";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "removeNestedDelete";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "checkIfConflictingPaths";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "canReconcileEvents";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "canReconcile";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "isContentChangeLikeHarmlessEvent";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "groupAndValidate";
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "groupCreations";
                break;
            }
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "groupDeletions";
                break;
            }
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "groupOthers";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "processEvents";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "applyDeletions";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "applyCreations";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "applyCreateEventsInDirectory";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "saveScannedChildrenRecursively";
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateChildInfos";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "applyEvent";
                break;
            }
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "executeCreateChild";
                break;
            }
            case 151: 
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "makeChildRecord";
                break;
            }
            case 154: 
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getChildData";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "executeDelete";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "invalidateSubtree";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "removeIdFromParentList";
                break;
            }
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "executeRename";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "executeSetWritable";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "executeSetHidden";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "executeSetTarget";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "setFlag";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "executeTouch";
                break;
            }
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "executeMove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

