/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.local.DirectoryAccessChecker;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.LocalFileSystemRefreshWorker;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.VfsEventGenerationHelper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.containers.Queue;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshWorker {
    private final boolean myIsRecursive;
    private final Queue<NewVirtualFile> myRefreshQueue;
    private final VfsEventGenerationHelper myHelper;
    private volatile boolean myCancelled;
    private final LocalFileSystemRefreshWorker myLocalFileSystemRefreshWorker;
    private static Consumer<? super VirtualFile> ourTestListener;

    public RefreshWorker(@NotNull NewVirtualFile refreshRoot, boolean isRecursive) {
        if (refreshRoot == null) {
            RefreshWorker.$$$reportNull$$$0(0);
        }
        this.myRefreshQueue = new Queue(100);
        this.myHelper = new VfsEventGenerationHelper();
        boolean canUseNioRefresher = refreshRoot.isInLocalFileSystem() && !(refreshRoot.getFileSystem() instanceof TempFileSystem) && Registry.is("vfs.use.nio-based.local.refresh.worker");
        this.myLocalFileSystemRefreshWorker = canUseNioRefresher ? new LocalFileSystemRefreshWorker(refreshRoot, isRecursive) : null;
        this.myIsRecursive = isRecursive;
        this.myRefreshQueue.addLast(refreshRoot);
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            List<VFileEvent> list2 = this.myLocalFileSystemRefreshWorker.getEvents();
            if (list2 == null) {
                RefreshWorker.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<VFileEvent> list3 = this.myHelper.getEvents();
        if (list3 == null) {
            RefreshWorker.$$$reportNull$$$0(2);
        }
        return list3;
    }

    public void cancel() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            this.myLocalFileSystemRefreshWorker.cancel();
        }
        this.myCancelled = true;
    }

    public void scan() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            this.myLocalFileSystemRefreshWorker.scan();
            return;
        }
        NewVirtualFile root = this.myRefreshQueue.pullFirst();
        NewVirtualFileSystem fs = root.getFileSystem();
        if (root.isDirectory()) {
            fs = PersistentFS.replaceWithNativeFS(fs);
        }
        PersistentFS persistence = PersistentFS.getInstance();
        FileAttributes attributes = fs.getAttributes(root);
        if (attributes == null) {
            this.myHelper.scheduleDeletion(root);
            root.markClean();
            return;
        }
        if (fs instanceof LocalFileSystemBase) {
            DirectoryAccessChecker.refresh();
        }
        this.checkAndScheduleChildRefresh(fs, persistence, root.getParent(), root, attributes);
        if (root.isDirty()) {
            if (this.myRefreshQueue.isEmpty()) {
                this.queueDirectory(root);
            }
            try {
                this.processQueue(fs, persistence);
            }
            catch (RefreshCancelledException e) {
                VfsEventGenerationHelper.LOG.trace("refresh cancelled");
            }
        }
    }

    private void queueDirectory(NewVirtualFile root) {
        if (root instanceof VirtualDirectoryImpl) {
            this.myRefreshQueue.addLast(root);
        } else {
            VfsEventGenerationHelper.LOG.error("not a directory: " + root + " (" + root.getClass());
        }
    }

    private void processQueue(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence) throws RefreshCancelledException {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(3);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(4);
        }
        TObjectHashingStrategy<String> strategy = FilePathHashingStrategy.create(fs.isCaseSensitive());
        block2: while (!this.myRefreshQueue.isEmpty()) {
            boolean succeeded;
            VirtualDirectoryImpl dir = (VirtualDirectoryImpl)this.myRefreshQueue.pullFirst();
            boolean fullSync = dir.allChildrenLoaded();
            do {
                this.myHelper.beginTransaction();
                try {
                    succeeded = fullSync ? this.fullDirRefresh(fs, persistence, strategy, dir) : this.partialDirRefresh(fs, persistence, strategy, dir);
                }
                catch (InvalidVirtualFileAccessException e) {
                    this.myHelper.endTransaction(false);
                    continue block2;
                }
                this.myHelper.endTransaction(succeeded);
                if (succeeded || !VfsEventGenerationHelper.LOG.isTraceEnabled()) continue;
                VfsEventGenerationHelper.LOG.trace("retry: " + dir);
            } while (!succeeded);
            if (!this.myIsRecursive) continue;
            dir.markClean();
        }
    }

    private boolean fullDirRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull TObjectHashingStrategy<String> strategy, @NotNull VirtualDirectoryImpl dir) {
        OpenTHashSet<String> actualNames;
        Pair<List<String>, List<VirtualFile>> snapshot;
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(5);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(6);
        }
        if (strategy == null) {
            RefreshWorker.$$$reportNull$$$0(7);
        }
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(8);
        }
        if ((snapshot = LocalFileSystemRefreshWorker.getDirectorySnapshot(dir)) == null) {
            return false;
        }
        List<String> persistedNames = snapshot.getFirst();
        List<VirtualFile> children2 = snapshot.getSecond();
        String[] upToDateNames = VfsUtil.filterNames(fs.list(dir));
        THashSet<String> newNames = ContainerUtil.newTroveSet(strategy, upToDateNames);
        if (dir.allChildrenLoaded() && children2.size() < upToDateNames.length) {
            for (VirtualFile child3 : children2) {
                newNames.remove(child3.getName());
            }
        } else {
            newNames.removeAll(persistedNames);
        }
        THashSet<String> deletedNames = ContainerUtil.newTroveSet(strategy, persistedNames);
        ContainerUtil.removeAll(deletedNames, upToDateNames);
        OpenTHashSet<String> openTHashSet = actualNames = fs.isCaseSensitive() ? null : new OpenTHashSet<String>(strategy, upToDateNames);
        if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
            VfsEventGenerationHelper.LOG.trace("current=" + persistedNames + " +" + newNames + " -" + deletedNames);
        }
        ArrayList<ChildInfo> newKids = new ArrayList<ChildInfo>(newNames.size());
        for (String newName : newNames) {
            this.checkCancelled(dir);
            ChildInfo childInfo = RefreshWorker.childRecord(fs, dir, newName);
            if (childInfo != null) {
                newKids.add(childInfo);
                continue;
            }
            if (!VfsEventGenerationHelper.LOG.isTraceEnabled()) continue;
            VfsEventGenerationHelper.LOG.trace("[+] fs=" + fs + " dir=" + dir + " name=" + newName);
        }
        ArrayList<Pair<VirtualFile, FileAttributes>> updatedMap = new ArrayList<Pair<VirtualFile, FileAttributes>>(children2.size());
        for (VirtualFile virtualFile2 : children2) {
            this.checkCancelled(dir);
            if (deletedNames.contains(virtualFile2.getName())) continue;
            updatedMap.add(Pair.pair(virtualFile2, fs.getAttributes(virtualFile2)));
        }
        if (this.isFullScanDirectoryChanged(dir, persistedNames, children2)) {
            return false;
        }
        for (String string : deletedNames) {
            VirtualFileSystemEntry child2 = dir.findChild(string);
            if (child2 == null) continue;
            this.myHelper.scheduleDeletion(child2);
        }
        for (ChildInfo childInfo : newKids) {
            this.myHelper.scheduleCreation(dir, childInfo.getName().toString(), childInfo.getFileAttributes(), childInfo.getSymLinkTarget(), () -> this.checkCancelled(dir));
        }
        for (Pair pair : updatedMap) {
            NewVirtualFile child2 = (NewVirtualFile)pair.first;
            this.checkCancelled(child2);
            FileAttributes childAttributes = (FileAttributes)pair.second;
            if (childAttributes != null) {
                this.checkAndScheduleChildRefresh(fs, persistence, dir, child2, childAttributes);
                this.checkAndScheduleFileNameChange(actualNames, child2);
                continue;
            }
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.warn("[x] fs=" + fs + " dir=" + dir + " name=" + child2.getName());
            }
            this.myHelper.scheduleDeletion(child2);
        }
        return !this.isFullScanDirectoryChanged(dir, persistedNames, children2);
    }

    private boolean isFullScanDirectoryChanged(VirtualDirectoryImpl dir, List<String> names2, List<VirtualFile> children2) {
        return ReadAction.compute(() -> {
            this.checkCancelled(dir);
            return LocalFileSystemRefreshWorker.areChildrenOrNamesChanged(dir, names2, children2);
        });
    }

    private boolean partialDirRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull TObjectHashingStrategy<String> strategy, @NotNull VirtualDirectoryImpl dir) {
        OpenTHashSet<String> actualNames;
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(9);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(10);
        }
        if (strategy == null) {
            RefreshWorker.$$$reportNull$$$0(11);
        }
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(12);
        }
        Pair snapshot = ReadAction.compute(() -> {
            this.checkCancelled(dir);
            return Pair.pair(dir.getCachedChildren(), dir.getSuspiciousNames());
        });
        List cached = (List)snapshot.getFirst();
        List wanted = (List)snapshot.getSecond();
        OpenTHashSet<String> openTHashSet = actualNames = fs.isCaseSensitive() || cached.isEmpty() ? null : new OpenTHashSet<String>(strategy, VfsUtil.filterNames(fs.list(dir)));
        if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
            VfsEventGenerationHelper.LOG.trace("cached=" + cached + " actual=" + actualNames + " suspicious=" + wanted);
        }
        ArrayList<Pair<VirtualFile, FileAttributes>> existingMap = new ArrayList<Pair<VirtualFile, FileAttributes>>(cached.size());
        for (VirtualFile child2 : cached) {
            this.checkCancelled(dir);
            existingMap.add(Pair.pair(child2, fs.getAttributes(child2)));
        }
        ArrayList<ChildInfo> newKids = new ArrayList<ChildInfo>(wanted.size());
        for (String string : wanted) {
            if (string.isEmpty()) continue;
            this.checkCancelled(dir);
            ChildInfo record = RefreshWorker.childRecord(fs, dir, string);
            if (record == null) continue;
            newKids.add(record);
        }
        if (this.isDirectoryChanged(dir, cached, wanted)) {
            return false;
        }
        for (Pair pair : existingMap) {
            NewVirtualFile child3 = (NewVirtualFile)pair.first;
            this.checkCancelled(child3);
            FileAttributes childAttributes = (FileAttributes)pair.second;
            if (childAttributes != null) {
                this.checkAndScheduleChildRefresh(fs, persistence, dir, child3, childAttributes);
                this.checkAndScheduleFileNameChange(actualNames, child3);
                continue;
            }
            this.myHelper.scheduleDeletion(child3);
        }
        for (ChildInfo childInfo : newKids) {
            this.myHelper.scheduleCreation(dir, childInfo.getName().toString(), childInfo.getFileAttributes(), childInfo.getSymLinkTarget(), () -> this.checkCancelled(dir));
        }
        return !this.isDirectoryChanged(dir, cached, wanted);
    }

    private boolean isDirectoryChanged(@NotNull VirtualDirectoryImpl dir, @NotNull List<VirtualFile> cached, @NotNull List<String> wanted) {
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(13);
        }
        if (cached == null) {
            RefreshWorker.$$$reportNull$$$0(14);
        }
        if (wanted == null) {
            RefreshWorker.$$$reportNull$$$0(15);
        }
        return ReadAction.compute(() -> {
            this.checkCancelled(dir);
            return !cached.equals(dir.getCachedChildren()) || !wanted.equals(dir.getSuspiciousNames());
        });
    }

    @Nullable
    private static ChildInfo childRecord(@NotNull NewVirtualFileSystem fs, @NotNull VirtualFile dir, @NotNull String name) {
        FakeVirtualFile file2;
        FileAttributes attributes;
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(16);
        }
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(17);
        }
        if (name == null) {
            RefreshWorker.$$$reportNull$$$0(18);
        }
        if ((attributes = fs.getAttributes(file2 = new FakeVirtualFile(dir, name))) == null) {
            return null;
        }
        boolean isEmptyDir = attributes.isDirectory() && !fs.hasChildren(file2);
        String symlinkTarget = attributes.isSymLink() ? fs.resolveSymLink(file2) : null;
        return new ChildInfoImpl(-1, name, attributes, (ChildInfo[])(isEmptyDir ? ChildInfo.EMPTY_ARRAY : null), symlinkTarget);
    }

    private void checkCancelled(@NotNull NewVirtualFile stopAt) throws RefreshCancelledException {
        if (stopAt == null) {
            RefreshWorker.$$$reportNull$$$0(19);
        }
        if (ourTestListener != null) {
            ourTestListener.accept(stopAt);
        }
        if (this.myCancelled) {
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.trace("cancelled at: " + stopAt);
            }
            RefreshWorker.forceMarkDirty(stopAt);
            while (!this.myRefreshQueue.isEmpty()) {
                RefreshWorker.forceMarkDirty(this.myRefreshQueue.pullFirst());
            }
            throw new RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(@NotNull NewVirtualFile file2) {
        if (file2 == null) {
            RefreshWorker.$$$reportNull$$$0(20);
        }
        file2.markClean();
        file2.markDirty();
    }

    private void checkAndScheduleChildRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @Nullable NewVirtualFile parent, @NotNull NewVirtualFile child2, @NotNull FileAttributes childAttributes) {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(21);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(22);
        }
        if (child2 == null) {
            RefreshWorker.$$$reportNull$$$0(23);
        }
        if (childAttributes == null) {
            RefreshWorker.$$$reportNull$$$0(24);
        }
        if (!VfsEventGenerationHelper.checkDirty(child2)) {
            return;
        }
        if (this.checkAndScheduleFileTypeChange(fs, parent, child2, childAttributes)) {
            child2.markClean();
            return;
        }
        this.myHelper.checkWritableAttributeChange(child2, persistence.isWritable(child2), childAttributes.isWritable());
        if (SystemInfo.isWindows) {
            this.myHelper.checkHiddenAttributeChange(child2, child2.is(VFileProperty.HIDDEN), childAttributes.isHidden());
        }
        if (childAttributes.isSymLink()) {
            this.myHelper.checkSymbolicLinkChange(child2, child2.getCanonicalPath(), fs.resolveSymLink(child2));
        }
        if (!childAttributes.isDirectory()) {
            long oltTS = persistence.getTimeStamp(child2);
            long newTS = childAttributes.lastModified;
            long oldLength = persistence.getLastRecordedLength(child2);
            long newLength = childAttributes.length;
            this.myHelper.checkContentChanged(child2, oltTS, newTS, oldLength, newLength);
            child2.markClean();
        } else if (this.myIsRecursive) {
            this.queueDirectory(child2);
        }
    }

    private boolean checkAndScheduleFileTypeChange(@NotNull NewVirtualFileSystem fs, @Nullable NewVirtualFile parent, @NotNull NewVirtualFile child2, @NotNull FileAttributes childAttributes) {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(25);
        }
        if (child2 == null) {
            RefreshWorker.$$$reportNull$$$0(26);
        }
        if (childAttributes == null) {
            RefreshWorker.$$$reportNull$$$0(27);
        }
        boolean currentIsDirectory = child2.isDirectory();
        boolean upToDateIsDirectory = childAttributes.isDirectory();
        boolean currentIsSymlink = child2.is(VFileProperty.SYMLINK);
        boolean upToDateIsSymlink = childAttributes.isSymLink();
        boolean currentIsSpecial = child2.is(VFileProperty.SPECIAL);
        boolean upToDateIsSpecial = childAttributes.isSpecial();
        if (currentIsDirectory != upToDateIsDirectory || currentIsSymlink != upToDateIsSymlink || currentIsSpecial != upToDateIsSpecial) {
            this.myHelper.scheduleDeletion(child2);
            if (parent != null) {
                String symlinkTarget = upToDateIsSymlink ? fs.resolveSymLink(child2) : null;
                this.myHelper.scheduleCreation(parent, child2.getName(), childAttributes, symlinkTarget, () -> this.checkCancelled(parent));
            } else {
                VfsEventGenerationHelper.LOG.error("transgender orphan: " + child2 + ' ' + childAttributes);
            }
            return true;
        }
        return false;
    }

    private void checkAndScheduleFileNameChange(@Nullable OpenTHashSet<String> actualNames, @NotNull VirtualFile child2) {
        String currentName;
        String actualName;
        if (child2 == null) {
            RefreshWorker.$$$reportNull$$$0(28);
        }
        if (actualNames != null && (actualName = actualNames.get(currentName = child2.getName())) != null && !currentName.equals(actualName)) {
            this.myHelper.scheduleAttributeChange(child2, "name", currentName, actualName);
        }
    }

    public static void setTestListener(@Nullable Consumer<? super VirtualFile> testListener) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourTestListener = testListener;
        LocalFileSystemRefreshWorker.setTestListener(testListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshRoot";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 16: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistence";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cached";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wanted";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/RefreshWorker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processQueue";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fullDirRefresh";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "partialDirRefresh";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryChanged";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "childRecord";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkCancelled";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "forceMarkDirty";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkAndScheduleChildRefresh";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkAndScheduleFileTypeChange";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkAndScheduleFileNameChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RefreshCancelledException
    extends RuntimeException {
        RefreshCancelledException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

