/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VfsDependentEnum<T> {
    private static final String DEPENDENT_PERSISTENT_LIST_START_PREFIX = "vfs_enum_";
    private final File myFile;
    private final DataExternalizer<T> myKeyDescriptor;
    private final int myVersion;
    private boolean myMarkedForInvalidation;
    private final List<T> myInstances;
    private final Map<T, Integer> myInstanceToId;
    private final Object myLock;
    private boolean myTriedToLoadFile;

    public VfsDependentEnum(@NotNull String fileName, @NotNull KeyDescriptor<T> descriptor2, int version2) {
        if (fileName == null) {
            VfsDependentEnum.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            VfsDependentEnum.$$$reportNull$$$0(1);
        }
        this.myInstances = ContainerUtil.createConcurrentList();
        this.myInstanceToId = ContainerUtil.newConcurrentMap();
        this.myLock = new Object();
        this.myFile = new File(FSRecords.basePath(), DEPENDENT_PERSISTENT_LIST_START_PREFIX + fileName + FSRecords.VFS_FILES_EXTENSION);
        this.myKeyDescriptor = descriptor2;
        this.myVersion = version2;
    }

    @NotNull
    static File getBaseFile() {
        return new File(FSRecords.basePath(), DEPENDENT_PERSISTENT_LIST_START_PREFIX);
    }

    public int getId(@NotNull T s) throws IOException {
        if (s == null) {
            VfsDependentEnum.$$$reportNull$$$0(2);
        }
        return this.getIdRaw(s, true);
    }

    int getIdRaw(@NotNull T s, boolean vfsRebuildOnException) throws IOException {
        Integer integer;
        if (s == null) {
            VfsDependentEnum.$$$reportNull$$$0(3);
        }
        if ((integer = this.myInstanceToId.get(s)) != null) {
            return integer;
        }
        Object object = this.myLock;
        synchronized (object) {
            integer = this.myInstanceToId.get(s);
            if (integer != null) {
                return integer;
            }
            try {
                boolean loaded = this.loadFromFile();
                if (loaded && (integer = this.myInstanceToId.get(s)) != null) {
                    return integer;
                }
                int enumerated = this.myInstances.size() + 1;
                this.register(s, enumerated);
                this.saveToFile(s);
                return enumerated;
            }
            catch (IOException e) {
                this.invalidate(e, vfsRebuildOnException);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(@NotNull T instance2) throws IOException {
        if (instance2 == null) {
            VfsDependentEnum.$$$reportNull$$$0(4);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.myFile, true);
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(fileOutputStream));){
            if (this.myFile.length() == 0L) {
                DataInputOutputUtil.writeTIME(output, FSRecords.getCreationTimestamp());
                DataInputOutputUtil.writeINT(output, this.myVersion);
            }
            this.myKeyDescriptor.save(output, instance2);
        }
        finally {
            try {
                fileOutputStream.getFD().sync();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadFromFile() throws IOException {
        THashMap<T, Integer> elementToIdMap;
        ArrayList<T> elements2;
        DataInputStream input;
        block27: {
            if (this.myTriedToLoadFile) return false;
            if (!this.myInstances.isEmpty()) return false;
            if (!this.myFile.exists()) return false;
            this.myTriedToLoadFile = true;
            boolean deleteFile2 = false;
            input = new DataInputStream(new BufferedInputStream(new FileInputStream(this.myFile)));
            Throwable throwable = null;
            try {
                long vfsVersion = DataInputOutputUtil.readTIME(input);
                if (vfsVersion != FSRecords.getCreationTimestamp()) {
                    deleteFile2 = true;
                    boolean bl = false;
                    return bl;
                }
                int savedVersion = DataInputOutputUtil.readINT(input);
                if (savedVersion == this.myVersion) {
                    elements2 = new ArrayList<T>();
                    elementToIdMap = new THashMap<T, Integer>();
                    break block27;
                }
                throw new IOException("Version mismatch: current " + this.myVersion + ", previous:" + savedVersion + ", file:" + this.myFile);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (deleteFile2) {
                    FileUtil.deleteWithRenaming(this.myFile);
                }
            }
        }
        while (true) {
            if (input.available() <= 0) {
                this.myInstances.addAll(elements2);
                this.myInstanceToId.putAll(elementToIdMap);
                boolean bl = true;
                return bl;
            }
            T instance2 = this.myKeyDescriptor.read(input);
            assert (instance2 != null);
            elements2.add(instance2);
            elementToIdMap.put(instance2, elements2.size());
        }
    }

    private void invalidate(@NotNull Throwable e, boolean vfsRebuildOnException) {
        if (e == null) {
            VfsDependentEnum.$$$reportNull$$$0(5);
        }
        if (!this.myMarkedForInvalidation) {
            this.myMarkedForInvalidation = true;
            FileUtil.deleteWithRenaming(this.myFile);
            if (vfsRebuildOnException) {
                FSRecords.requestVfsRebuild(e);
            }
        }
    }

    private void register(@NotNull T instance2, int id2) {
        if (instance2 == null) {
            VfsDependentEnum.$$$reportNull$$$0(6);
        }
        this.myInstanceToId.put(instance2, id2);
        assert (id2 == this.myInstances.size() + 1);
        this.myInstances.add(instance2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public T getById(int id2) throws IOException {
        boolean loaded;
        block10: {
            T instance2;
            assert (id2 > 0);
            if (--id2 < this.myInstances.size() && (instance2 = this.myInstances.get(id2)) != null) {
                T t = instance2;
                if (t != null) return t;
                VfsDependentEnum.$$$reportNull$$$0(7);
                return t;
            }
            Object object = this.myLock;
            // MONITORENTER : object
            if (id2 < this.myInstances.size() && (instance2 = this.myInstances.get(id2)) != null) {
                T t = instance2;
                // MONITOREXIT : object
                if (t != null) return t;
                VfsDependentEnum.$$$reportNull$$$0(8);
                return t;
            }
            loaded = this.loadFromFile();
            if (!loaded || (instance2 = this.myInstances.get(id2)) == null) break block10;
            T t = instance2;
            // MONITOREXIT : object
            if (t != null) return t;
            VfsDependentEnum.$$$reportNull$$$0(9);
            return t;
        }
        try {
            assert (false) : "Reading nonexistent value:" + id2 + "," + this.myFile + ", loaded:" + loaded;
        }
        catch (IOException | AssertionError e) {
            this.invalidate((Throwable)e, true);
            throw e;
        }
        VfsDependentEnum.$$$reportNull$$$0(10);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/VfsDependentEnum";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/VfsDependentEnum";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getById";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIdRaw";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

