/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.ex;

import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.FocusUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.lang.reflect.Field;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        if (!(focusCycleRoot instanceof JComponent)) {
            return super.getDefaultComponent(focusCycleRoot);
        }
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)focusCycleRoot, this);
    }

    public static JComponent getPreferredFocusedComponent(@NotNull JComponent component2) {
        if (component2 == null) {
            IdeFocusTraversalPolicy.$$$reportNull$$$0(0);
        }
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(component2, null);
    }

    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        Component after2 = super.getComponentAfter(aContainer, aComponent);
        return this.doFind(aContainer, aComponent, after2);
    }

    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        Component before = super.getComponentBefore(aContainer, aComponent);
        return this.doFind(aContainer, aComponent, before);
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    @Nullable
    private Component doFind(Container aContainer, Component aComponent, @Nullable Component siblingComponent) {
        JComponent defaultFocusableComponent;
        if (siblingComponent == null) {
            return FocusUtil.findFocusableComponentIn(aContainer, aComponent);
        }
        if (siblingComponent instanceof EditorsSplitters && (defaultFocusableComponent = EditorsSplitters.findDefaultComponentInSplitters(this.getProject())) != null) {
            return defaultFocusableComponent;
        }
        return siblingComponent.isFocusable() ? siblingComponent : FocusUtil.findFocusableComponentIn((JComponent)siblingComponent, null);
    }

    @Nullable
    public static JComponent getPreferredFocusedComponent(@NotNull JComponent component2, @Nullable FocusTraversalPolicy policyToIgnore) {
        if (component2 == null) {
            IdeFocusTraversalPolicy.$$$reportNull$$$0(1);
        }
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(component2, policyToIgnore, null);
    }

    @Nullable
    private static JComponent getPreferredFocusedComponent(@NotNull JComponent component2, @Nullable FocusTraversalPolicy policyToIgnore, @Nullable Field focusTraversalPolicyField) {
        if (component2 == null) {
            IdeFocusTraversalPolicy.$$$reportNull$$$0(2);
        }
        if (!component2.isVisible()) {
            return null;
        }
        Object focusTraversalPolicy = null;
        if (component2.isFocusTraversalPolicySet()) {
            try {
                focusTraversalPolicyField = Container.class.getDeclaredField("focusTraversalPolicy");
                focusTraversalPolicyField.setAccessible(true);
            }
            catch (ReflectiveOperationException e) {
                focusTraversalPolicyField = null;
            }
            try {
                focusTraversalPolicy = focusTraversalPolicyField != null && component2.isFocusTraversalPolicySet() ? (FocusTraversalPolicy)focusTraversalPolicyField.get(component2) : null;
            }
            catch (IllegalAccessException e) {
                focusTraversalPolicy = null;
            }
        }
        if (focusTraversalPolicy != null && focusTraversalPolicy != policyToIgnore) {
            if (focusTraversalPolicy.getClass().getName().contains("LegacyGlueFocusTraversalPolicy")) {
                return component2;
            }
            Component defaultComponent = ((FocusTraversalPolicy)focusTraversalPolicy).getDefaultComponent(component2);
            if (defaultComponent instanceof JComponent) {
                return (JComponent)defaultComponent;
            }
        }
        if (component2 instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)component2;
            Component selectedComponent = tabbedPane.getSelectedComponent();
            if (selectedComponent instanceof JComponent) {
                return IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)selectedComponent);
            }
            return null;
        }
        if (IdeFocusTraversalPolicy._accept(component2)) {
            return component2;
        }
        for (Component ca : component2.getComponents()) {
            JComponent c;
            if (!(ca instanceof JComponent) || (c = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)ca, null, focusTraversalPolicyField)) == null) continue;
            return c;
        }
        return null;
    }

    @Override
    protected final boolean accept(Component aComponent) {
        if (aComponent instanceof JComponent) {
            return IdeFocusTraversalPolicy._accept((JComponent)aComponent);
        }
        return super.accept(aComponent);
    }

    private static boolean _accept(@NotNull JComponent component2) {
        if (component2 == null) {
            IdeFocusTraversalPolicy.$$$reportNull$$$0(3);
        }
        if (!(component2.isEnabled() && component2.isVisible() && component2.isFocusable())) {
            return false;
        }
        if (component2 instanceof EditorComponentImpl || component2 instanceof EditorWindowHolder) {
            return true;
        }
        if (component2 instanceof JTextComponent) {
            return ((JTextComponent)component2).isEditable();
        }
        return component2 instanceof AbstractButton || component2 instanceof JList || component2 instanceof JTree || component2 instanceof JTable || component2 instanceof JComboBox;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "component";
        objectArray2[1] = "com/intellij/openapi/wm/ex/IdeFocusTraversalPolicy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreferredFocusedComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "_accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

