/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.SystemProperties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\tH\u0014J\u0012\u0010\u000f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005R\u0014\u0010\u0007\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/wm/impl/CloseProjectWindowHelper;", "", "()V", "isMacSystemMenu", "", "()Z", "isShowWelcomeScreen", "isShowWelcomeScreenFromSettings", "closeProjectAndShowWelcomeFrameIfNoProjectOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "getNumberOfOpenedProjects", "", "quitApp", "windowClosing", "intellij.platform.ide.impl"})
public class CloseProjectWindowHelper {
    protected boolean isMacSystemMenu() {
        return SystemProperties.getBooleanProperty("idea.test.isMacSystemMenu", SystemInfo.isMacSystemMenu);
    }

    private final boolean isShowWelcomeScreen() {
        return this.isMacSystemMenu() && this.isShowWelcomeScreenFromSettings();
    }

    protected boolean isShowWelcomeScreenFromSettings() {
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalSettings, (String)"GeneralSettings.getInstance()");
        return generalSettings.isShowWelcomeScreen();
    }

    public void windowClosing(@Nullable Project project2) {
        int numberOfOpenedProjects = this.getNumberOfOpenedProjects();
        if (numberOfOpenedProjects > 1 || numberOfOpenedProjects == 1 && this.isShowWelcomeScreen()) {
            this.closeProjectAndShowWelcomeFrameIfNoProjectOpened(project2);
        } else {
            this.quitApp();
        }
    }

    protected int getNumberOfOpenedProjects() {
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
        return projectManager.getOpenProjects().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeProjectAndShowWelcomeFrameIfNoProjectOpened(@Nullable Project project2) {
        boolean $i$f$runInAutoSaveDisabledMode = false;
        AutoCloseable autoCloseable = SaveAndSyncHandler.Companion.getInstance().disableAutoSave();
        boolean bl = false;
        Throwable throwable = null;
        try {
            Application app;
            AccessToken it$iv = (AccessToken)autoCloseable;
            boolean bl2 = false;
            boolean bl3 = false;
            if (project2 != null && project2.isOpen()) {
                ProjectManagerEx.getInstanceEx().closeAndDispose(project2);
            }
            Application application = app = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
            application.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC).projectFrameClosed();
            SaveAndSyncHandler.Companion.getInstance().saveSettingsUnderModalProgress(app);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        WelcomeFrame.showIfNoProjectOpened();
    }

    protected void quitApp() {
        ApplicationManager.getApplication().exit();
    }
}

