/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.JBUIScale;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FrameBoundsConverter {
    @NotNull
    public static Rectangle convertFromDeviceSpaceAndFitToScreen(@NotNull Rectangle bounds2) {
        if (bounds2 == null) {
            FrameBoundsConverter.$$$reportNull$$$0(0);
        }
        Rectangle b = bounds2.getBounds();
        int centerX = b.x + b.width / 2;
        int centerY = b.y + b.height / 2;
        boolean scaleNeeded = FrameBoundsConverter.shouldConvert();
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle devBounds = gc.getBounds();
            if (scaleNeeded) {
                FrameBoundsConverter.scaleUp(devBounds, gc);
            }
            if (!devBounds.contains(centerX, centerY)) continue;
            if (scaleNeeded) {
                FrameBoundsConverter.scaleDown(b, gc);
            }
            Rectangle screen = ScreenUtil.getScreenRectangle(gc);
            if (b.x < screen.x) {
                b.x = screen.x;
            }
            if (b.y < screen.y) {
                b.y = screen.y;
            }
            if (b.width > screen.width) {
                b.width = screen.width;
            }
            if (b.height > screen.height) {
                b.height = screen.height;
            }
            Rectangle rectangle = b;
            if (rectangle == null) {
                FrameBoundsConverter.$$$reportNull$$$0(1);
            }
            return rectangle;
        }
        ScreenUtil.fitToScreen(b);
        Rectangle rectangle = b;
        if (rectangle == null) {
            FrameBoundsConverter.$$$reportNull$$$0(2);
        }
        return rectangle;
    }

    public static Rectangle convertToDeviceSpace(GraphicsConfiguration gc, @NotNull Rectangle bounds2) {
        if (bounds2 == null) {
            FrameBoundsConverter.$$$reportNull$$$0(3);
        }
        Rectangle b = bounds2.getBounds();
        if (!FrameBoundsConverter.shouldConvert()) {
            return b;
        }
        try {
            FrameBoundsConverter.scaleUp(b, gc);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return b;
    }

    private static boolean shouldConvert() {
        if (SystemInfoRt.isLinux || SystemInfoRt.isMac) {
            return false;
        }
        return JreHiDpiUtil.isJreHiDPIEnabled();
    }

    private static void scaleUp(@NotNull Rectangle bounds2, @NotNull GraphicsConfiguration gc) {
        if (bounds2 == null) {
            FrameBoundsConverter.$$$reportNull$$$0(4);
        }
        if (gc == null) {
            FrameBoundsConverter.$$$reportNull$$$0(5);
        }
        FrameBoundsConverter.scale(bounds2, gc.getBounds(), JBUIScale.sysScale(gc));
    }

    private static void scaleDown(@NotNull Rectangle bounds2, @NotNull GraphicsConfiguration gc) {
        if (bounds2 == null) {
            FrameBoundsConverter.$$$reportNull$$$0(6);
        }
        if (gc == null) {
            FrameBoundsConverter.$$$reportNull$$$0(7);
        }
        float scale = JBUIScale.sysScale(gc);
        assert (scale != 0.0f);
        FrameBoundsConverter.scale(bounds2, gc.getBounds(), 1.0f / scale);
    }

    private static void scale(@NotNull Rectangle bounds2, @NotNull Rectangle deviceBounds, float scale) {
        if (bounds2 == null) {
            FrameBoundsConverter.$$$reportNull$$$0(8);
        }
        if (deviceBounds == null) {
            FrameBoundsConverter.$$$reportNull$$$0(9);
        }
        int x = (int)Math.floor((float)deviceBounds.x + (float)(bounds2.x - deviceBounds.x) * scale);
        int y = (int)Math.floor((float)deviceBounds.y + (float)(bounds2.y - deviceBounds.y) * scale);
        bounds2.setBounds(x, y, (int)Math.ceil((float)bounds2.width * scale), (int)Math.ceil((float)bounds2.height * scale));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/FrameBoundsConverter";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/FrameBoundsConverter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFromDeviceSpaceAndFitToScreen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertFromDeviceSpaceAndFitToScreen";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertToDeviceSpace";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "scaleUp";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scaleDown";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "scale";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

