/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.FrameBoundsConverter;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.ui.ScreenUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.peer.FramePeer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import sun.awt.AWTAccessor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\f"}, d2={"updateDefaultFrameInfoInDeviceSpace", "", "windowManager", "Lcom/intellij/openapi/wm/impl/WindowManagerImpl;", "newInfo", "Lcom/intellij/openapi/wm/impl/FrameInfo;", "updateFrameInfo", "frameHelper", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "lastNormalFrameBounds", "Ljava/awt/Rectangle;", "oldFrameInfo", "intellij.platform.ide.impl"})
public final class FrameInfoHelperKt {
    private static final FrameInfo updateFrameInfo(ProjectFrameHelper frameHelper, Rectangle lastNormalFrameBounds, FrameInfo oldFrameInfo) {
        FrameInfo frameInfo;
        FrameInfo frameInfo2;
        boolean usePreviousBounds;
        Object peer;
        IdeFrameImpl ideFrameImpl = frameHelper.getFrame();
        Intrinsics.checkExpressionValueIsNotNull((Object)ideFrameImpl, (String)"frameHelper.frame");
        IdeFrameImpl frame = ideFrameImpl;
        int extendedState = frame.getExtendedState();
        if (SystemInfo.isMacOSLion && (peer = AWTAccessor.getComponentAccessor().getPeer(frame)) instanceof FramePeer) {
            extendedState = ((FramePeer)peer).getState();
        }
        boolean isInFullScreen = FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs() && frameHelper.isInFullScreen();
        boolean isMaximized = FrameInfoHelper.Companion.isMaximized(extendedState) || isInFullScreen;
        FrameInfo frameInfo3 = oldFrameInfo;
        Rectangle oldBounds = frameInfo3 != null ? frameInfo3.getBounds() : null;
        Rectangle newBounds = FrameBoundsConverter.convertToDeviceSpace(frame.getGraphicsConfiguration(), isMaximized && lastNormalFrameBounds != null ? lastNormalFrameBounds : frame.getBounds());
        boolean bl = usePreviousBounds = lastNormalFrameBounds == null && isMaximized && oldBounds != null && newBounds.contains(new Point((int)oldBounds.getCenterX(), (int)oldBounds.getCenterY()));
        if (!usePreviousBounds && Intrinsics.areEqual((Object)oldBounds, (Object)newBounds) ^ true && !ScreenUtil.intersectsVisibleScreen(frame)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(WindowInfoImpl.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("Frame bounds are invalid: " + newBounds);
        }
        if ((frameInfo2 = oldFrameInfo) == null) {
            frameInfo2 = frameInfo = new FrameInfo();
        }
        if (!usePreviousBounds) {
            frameInfo.setBounds(newBounds);
        }
        frameInfo.setExtendedState(extendedState);
        if (FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs()) {
            frameInfo.setFullScreen(isInFullScreen);
        }
        return frameInfo;
    }

    public static final void updateDefaultFrameInfoInDeviceSpace(@NotNull WindowManagerImpl windowManager, @NotNull FrameInfo newInfo) {
        Intrinsics.checkParameterIsNotNull((Object)windowManager, (String)"windowManager");
        Intrinsics.checkParameterIsNotNull((Object)newInfo, (String)"newInfo");
        windowManager.defaultFrameInfoHelper.copyFrom(newInfo);
    }

    public static final /* synthetic */ FrameInfo access$updateFrameInfo(ProjectFrameHelper frameHelper, Rectangle lastNormalFrameBounds, FrameInfo oldFrameInfo) {
        return FrameInfoHelperKt.updateFrameInfo(frameHelper, lastNormalFrameBounds, oldFrameInfo);
    }
}

