/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.mac.MacMainFrameDecorator;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class IdeFrameDecorator
implements IdeFrameImpl.FrameDecorator {
    static final String FULL_SCREEN = "ide.frame.full.screen";
    protected final JFrame myFrame;
    private static final Logger LOG = Logger.getInstance(IdeFrameDecorator.class);

    protected IdeFrameDecorator(@NotNull JFrame frame) {
        if (frame == null) {
            IdeFrameDecorator.$$$reportNull$$$0(0);
        }
        this.myFrame = frame;
    }

    @Override
    public abstract boolean isInFullScreen();

    @NotNull
    public abstract Promise<Boolean> toggleFullScreen(boolean var1);

    @Nullable
    public static IdeFrameDecorator decorate(@NotNull JFrame frame, @NotNull Disposable parentDisposable) {
        if (frame == null) {
            IdeFrameDecorator.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            IdeFrameDecorator.$$$reportNull$$$0(2);
        }
        try {
            if (SystemInfo.isMac) {
                return new MacMainFrameDecorator(frame, parentDisposable);
            }
            if (SystemInfo.isWindows) {
                return new WinMainFrameDecorator(frame);
            }
            if (SystemInfo.isXWindow && X11UiUtil.isFullScreenSupported()) {
                return new EWMHFrameDecorator(frame, parentDisposable);
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed to initialize IdeFrameDecorator. " + t.getMessage(), t);
        }
        return null;
    }

    protected void notifyFrameComponents(boolean state) {
        this.myFrame.getRootPane().putClientProperty(FULL_SCREEN, state);
        JMenuBar menuBar = this.myFrame.getJMenuBar();
        if (menuBar != null) {
            menuBar.putClientProperty(FULL_SCREEN, state);
        }
    }

    public static boolean isCustomDecorationActive() {
        return SystemInfo.isWindows && SystemProperties.getBooleanProperty("ide.win.frame.decoration", true) && JdkEx.isCustomDecorationSupported();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/IdeFrameDecorator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "decorate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EWMHFrameDecorator
    extends IdeFrameDecorator {
        private Boolean myRequestedState;

        private EWMHFrameDecorator(final @NotNull JFrame frame, @NotNull Disposable parentDisposable) {
            if (frame == null) {
                EWMHFrameDecorator.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                EWMHFrameDecorator.$$$reportNull$$$0(1);
            }
            super(frame);
            this.myRequestedState = null;
            frame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (myRequestedState != null) {
                        this.notifyFrameComponents(myRequestedState);
                        myRequestedState = null;
                    }
                }
            });
            if (SystemInfo.isKDE && ComponentUtil.isDisableAutoRequestFocus()) {
                final WindowAdapter deiconifyListener = new WindowAdapter(){

                    @Override
                    public void windowDeiconified(WindowEvent event) {
                        frame.toFront();
                    }
                };
                frame.addWindowListener(deiconifyListener);
                Disposer.register(parentDisposable, new Disposable(){

                    @Override
                    public void dispose() {
                        frame.removeWindowListener(deiconifyListener);
                    }
                });
            }
        }

        @Override
        public boolean isInFullScreen() {
            return this.myFrame != null && X11UiUtil.isInFullScreenMode(this.myFrame);
        }

        @Override
        @NotNull
        public Promise<Boolean> toggleFullScreen(boolean state) {
            if (this.myFrame != null) {
                this.myRequestedState = state;
                X11UiUtil.toggleFullScreenMode(this.myFrame);
                if (this.myFrame.getJMenuBar() instanceof IdeMenuBar) {
                    IdeMenuBar frameMenuBar = (IdeMenuBar)this.myFrame.getJMenuBar();
                    frameMenuBar.onToggleFullScreen(state);
                }
            }
            Promise promise2 = Promises.resolvedPromise((Object)state);
            if (promise2 == null) {
                EWMHFrameDecorator.$$$reportNull$$$0(2);
            }
            return promise2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/IdeFrameDecorator$EWMHFrameDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/IdeFrameDecorator$EWMHFrameDecorator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toggleFullScreen";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class WinMainFrameDecorator
    extends IdeFrameDecorator {
        private WinMainFrameDecorator(@NotNull JFrame frame) {
            if (frame == null) {
                WinMainFrameDecorator.$$$reportNull$$$0(0);
            }
            super(frame);
        }

        @Override
        public boolean isInFullScreen() {
            return UIUtil.isWindowClientPropertyTrue(this.myFrame, IdeFrameDecorator.FULL_SCREEN);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Promise<Boolean> toggleFullScreen(boolean state) {
            GraphicsDevice device;
            Rectangle bounds2 = this.myFrame.getBounds();
            int extendedState = this.myFrame.getExtendedState();
            if (state && extendedState == 0) {
                this.myFrame.getRootPane().putClientProperty("normalBounds", bounds2);
            }
            if ((device = ScreenUtil.getScreenDevice(bounds2)) == null) {
                Promise promise2 = Promises.rejectedPromise();
                if (promise2 == null) {
                    WinMainFrameDecorator.$$$reportNull$$$0(1);
                }
                return promise2;
            }
            Rectangle defaultBounds = device.getDefaultConfiguration().getBounds();
            try {
                this.myFrame.getRootPane().putClientProperty("togglingFullScreenInProgress", Boolean.TRUE);
                this.myFrame.getRootPane().putClientProperty("dispose.temporary", Boolean.TRUE);
                this.myFrame.dispose();
                this.myFrame.setUndecorated(state);
            }
            finally {
                if (state) {
                    this.myFrame.setBounds(defaultBounds);
                } else {
                    Object o = this.myFrame.getRootPane().getClientProperty("normalBounds");
                    if (o instanceof Rectangle) {
                        this.myFrame.setBounds((Rectangle)o);
                    }
                }
                this.myFrame.setVisible(true);
                this.myFrame.getRootPane().putClientProperty("dispose.temporary", null);
                if (!state && (extendedState & 6) != 0) {
                    this.myFrame.setExtendedState(extendedState);
                }
                this.notifyFrameComponents(state);
            }
            EventQueue.invokeLater(() -> this.myFrame.getRootPane().putClientProperty("togglingFullScreenInProgress", null));
            Promise promise3 = Promises.resolvedPromise((Object)state);
            if (promise3 == null) {
                WinMainFrameDecorator.$$$reportNull$$$0(2);
            }
            return promise3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/IdeFrameDecorator$WinMainFrameDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/IdeFrameDecorator$WinMainFrameDecorator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toggleFullScreen";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

