/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.ui.BalloonLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IdeFrameImpl
extends JFrame
implements IdeFrame,
DataProvider {
    @Deprecated
    public static final Key<Boolean> SHOULD_OPEN_IN_FULL_SCREEN = Key.create("should.open.in.full.screen");
    public static final String NORMAL_STATE_BOUNDS = "normalBounds";
    public static final String TOGGLING_FULL_SCREEN_IN_PROGRESS = "togglingFullScreenInProgress";
    @Nullable
    private FrameHelper myFrameHelper;
    @Nullable
    private FrameDecorator myFrameDecorator;

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            IdeFrameImpl.$$$reportNull$$$0(0);
        }
        return this.myFrameHelper == null ? null : this.myFrameHelper.getData(dataId);
    }

    @Nullable
    FrameHelper getFrameHelper() {
        return this.myFrameHelper;
    }

    @Override
    public void setRootPane(JRootPane root) {
        super.setRootPane(root);
    }

    void setFrameHelper(@Nullable FrameHelper frameHelper, @Nullable FrameDecorator frameDecorator) {
        this.myFrameHelper = frameHelper;
        this.myFrameDecorator = frameDecorator;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIdeFrameImpl();
        }
        return this.accessibleContext;
    }

    @Override
    public void setTitle(String title) {
        if (this.myFrameHelper == null) {
            super.setTitle(title);
        } else {
            this.myFrameHelper.setTitle(title);
        }
    }

    void doSetTitle(String value2) {
        super.setTitle(value2);
    }

    @Override
    public void setExtendedState(int state) {
        if (LoadingState.COMPONENTS_REGISTERED.isOccurred() && this.getExtendedState() == 0 && FrameInfoHelper.isMaximized(state)) {
            this.getRootPane().putClientProperty(NORMAL_STATE_BOUNDS, this.getBounds());
        }
        super.setExtendedState(state);
    }

    @Override
    public void paint(@NotNull Graphics g) {
        if (g == null) {
            IdeFrameImpl.$$$reportNull$$$0(1);
        }
        if (LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            UISettings.setupAntialiasing(g);
        }
        super.paint(g);
    }

    @Override
    public void show() {
        super.show();
        SwingUtilities.invokeLater(() -> this.setFocusableWindowState(true));
    }

    @Override
    @NotNull
    public Insets getInsets() {
        Insets insets = SystemInfo.isMac && this.isInFullScreen() ? JBUI.emptyInsets() : super.getInsets();
        if (insets == null) {
            IdeFrameImpl.$$$reportNull$$$0(2);
        }
        return insets;
    }

    @Override
    public boolean isInFullScreen() {
        return this.myFrameDecorator != null && this.myFrameDecorator.isInFullScreen();
    }

    @Override
    public void dispose() {
        if (this.myFrameHelper == null) {
            this.doDispose();
        } else {
            this.myFrameHelper.dispose();
        }
    }

    void doDispose() {
        UIUtil.invokeLaterIfNeeded(() -> super.dispose());
    }

    @Nullable
    public static Window getActiveFrame() {
        for (Frame frame : Frame.getFrames()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return null;
    }

    @Deprecated
    public void updateView() {
        if (this.myFrameHelper != null) {
            this.myFrameHelper.updateView();
        }
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public Project getProject() {
        return this.myFrameHelper == null ? null : this.myFrameHelper.getProject();
    }

    @Override
    @Nullable
    public StatusBar getStatusBar() {
        return this.myFrameHelper == null ? null : this.myFrameHelper.getHelper().getStatusBar();
    }

    @Override
    @NotNull
    public Rectangle suggestChildFrameBounds() {
        Rectangle rectangle = Objects.requireNonNull(this.myFrameHelper).getHelper().suggestChildFrameBounds();
        if (rectangle == null) {
            IdeFrameImpl.$$$reportNull$$$0(3);
        }
        return rectangle;
    }

    @Override
    public void setFrameTitle(String title) {
        if (this.myFrameHelper != null) {
            this.myFrameHelper.getHelper().setFrameTitle(title);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.getRootPane();
    }

    @Override
    @Nullable
    public BalloonLayout getBalloonLayout() {
        return this.myFrameHelper == null ? null : this.myFrameHelper.getHelper().getBalloonLayout();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/IdeFrameImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/IdeFrameImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestChildFrameBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected final class AccessibleIdeFrameImpl
    extends JFrame.AccessibleJFrame {
        protected AccessibleIdeFrameImpl() {
            super(IdeFrameImpl.this);
        }

        @Override
        public String getAccessibleName() {
            return IdeFrameImpl.this.myFrameHelper == null ? super.getAccessibleName() : IdeFrameImpl.this.myFrameHelper.getAccessibleName();
        }
    }

    static interface FrameDecorator {
        public boolean isInFullScreen();
    }

    static interface FrameHelper
    extends DataProvider {
        public String getAccessibleName();

        public void dispose();

        public void setTitle(String var1);

        public void updateView();

        @Nullable
        public Project getProject();

        @NotNull
        public IdeFrame getHelper();
    }
}

