/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.WeakTimerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.LinuxIdeMenuBar;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.status.ClockPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeMenuBar
extends JMenuBar
implements IdeEventQueue.EventDispatcher,
UISettingsListener {
    private static final Logger LOG = Logger.getInstance(IdeMenuBar.class);
    private static final int COLLAPSED_HEIGHT = 2;
    private List<AnAction> myVisibleActions = new ArrayList<AnAction>();
    private List<AnAction> myNewVisibleActions = new ArrayList<AnAction>();
    private final MenuItemPresentationFactory myPresentationFactory = new MenuItemPresentationFactory();
    protected final Disposable myDisposable = Disposer.newDisposable();
    @Nullable
    private final ClockPanel myClockPanel;
    @Nullable
    private final MyExitFullScreenButton myButton;
    @Nullable
    private final Animator myAnimator;
    @Nullable
    private final Timer myActivationWatcher;
    @NotNull
    private State myState = State.EXPANDED;
    private double myProgress;
    private boolean myActivated;

    @NotNull
    public static IdeMenuBar createMenuBar() {
        return SystemInfo.isLinux ? new LinuxIdeMenuBar() : new IdeMenuBar();
    }

    protected IdeMenuBar() {
        if (WindowManagerImpl.isFloatingMenuBarSupported()) {
            this.myAnimator = new MyAnimator();
            this.myActivationWatcher = TimerUtil.createNamedTimer("IdeMenuBar", 100, new MyActionListener());
            this.myClockPanel = new ClockPanel();
            this.myButton = new MyExitFullScreenButton();
            this.add(this.myClockPanel);
            this.add(this.myButton);
            this.addPropertyChangeListener("ide.frame.full.screen", event -> this.updateState());
            this.addMouseListener(new MyMouseListener());
        } else {
            this.myAnimator = null;
            this.myActivationWatcher = null;
            this.myClockPanel = null;
            this.myButton = null;
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform(this, super.getComponentGraphics(graphics));
    }

    @NotNull
    public State getState() {
        State state = this.myState == null ? State.EXPANDING : this.myState;
        if (state == null) {
            IdeMenuBar.$$$reportNull$$$0(0);
        }
        return state;
    }

    @Override
    public JMenu add(JMenu menu) {
        menu.setFocusable(false);
        return super.add(menu);
    }

    @Override
    public Border getBorder() {
        State state = this.getState();
        if (state == State.EXPANDING || state == State.COLLAPSING) {
            return JBUI.Borders.empty();
        }
        if (state == State.TEMPORARY_EXPANDED && StartupUiUtil.isUnderDarcula()) {
            return JBUI.Borders.customLine(Gray._75, 0, 0, 1, 0);
        }
        if (state == State.COLLAPSED) {
            return JBUI.Borders.emptyBottom(1);
        }
        return UISettings.getInstance().getShowMainToolbar() || UISettings.getInstance().getShowNavigationBar() ? super.getBorder() : null;
    }

    @Override
    public void paint(Graphics g) {
        if (this.getState() == State.COLLAPSED) {
            return;
        }
        super.paint(g);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.myClockPanel == null || this.myButton == null) {
            return;
        }
        if (this.getState() == State.EXPANDED) {
            this.myClockPanel.setVisible(false);
            this.myButton.setVisible(false);
        } else {
            this.myClockPanel.setVisible(true);
            this.myButton.setVisible(true);
            Dimension preferredSize = this.myButton.getPreferredSize();
            this.myButton.setBounds(this.getBounds().width - preferredSize.width, 0, preferredSize.width, preferredSize.height);
            preferredSize = this.myClockPanel.getPreferredSize();
            this.myClockPanel.setBounds(this.getBounds().width - preferredSize.width - this.myButton.getWidth(), 0, preferredSize.width, preferredSize.height);
        }
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        if (!isIncluded && this.getState() == State.TEMPORARY_EXPANDED) {
            this.myActivated = false;
            this.setState(State.COLLAPSING);
            this.restartAnimator();
            return;
        }
        if (isIncluded && this.getState() == State.COLLAPSED) {
            this.myActivated = true;
            this.setState(State.TEMPORARY_EXPANDED);
            this.revalidate();
            this.repaint();
            SwingUtilities.invokeLater(() -> {
                JMenu menu = this.getMenu(this.getSelectionModel().getSelectedIndex());
                if (menu.isPopupMenuVisible()) {
                    menu.setPopupMenuVisible(false);
                    menu.setPopupMenuVisible(true);
                }
            });
        }
        super.menuSelectionChanged(isIncluded);
    }

    private boolean isActivated() {
        int index = this.getSelectionModel().getSelectedIndex();
        return index != -1 && this.getMenu(index).isPopupMenuVisible();
    }

    private void updateState() {
        if (this.myAnimator == null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        if (!(window instanceof IdeFrame)) {
            return;
        }
        boolean fullScreen = ((IdeFrame)((Object)window)).isInFullScreen();
        if (fullScreen) {
            this.setState(State.COLLAPSING);
            this.restartAnimator();
        } else {
            this.myAnimator.suspend();
            this.setState(State.EXPANDED);
            if (this.myClockPanel != null) {
                this.myClockPanel.setVisible(false);
                if (this.myButton != null) {
                    this.myButton.setVisible(false);
                }
            }
        }
    }

    private void setState(@NotNull State state) {
        if (state == null) {
            IdeMenuBar.$$$reportNull$$$0(1);
        }
        this.myState = state;
        if (this.myState == State.EXPANDING && this.myActivationWatcher != null && !this.myActivationWatcher.isRunning()) {
            this.myActivationWatcher.start();
        } else if (this.myActivationWatcher != null && this.myActivationWatcher.isRunning() && (state == State.EXPANDED || state == State.COLLAPSED)) {
            this.myActivationWatcher.stop();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getState().isInProgress()) {
            dimension.height = 2 + (int)((this.getState() == State.COLLAPSING ? 1.0 - this.myProgress : this.myProgress) * (double)(dimension.height - 2));
        } else if (this.getState() == State.COLLAPSED) {
            dimension.height = 2;
        }
        return dimension;
    }

    private void restartAnimator() {
        if (this.myAnimator != null) {
            this.myAnimator.reset();
            this.myAnimator.resume();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        IdeMenuBar.doWithLazyActionManager(actionManager -> {
            this.doUpdateMenuActions(false, (ActionManager)actionManager);
            actionManager.addTimerListener(1000, new WeakTimerListener(new MyTimerListener()));
        });
        Disposer.register(ApplicationManager.getApplication(), this.myDisposable);
        IdeEventQueue.getInstance().addDispatcher(this, this.myDisposable);
    }

    private static void doWithLazyActionManager(@NotNull Consumer<ActionManager> whatToDo) {
        ActionManager created;
        if (whatToDo == null) {
            IdeMenuBar.$$$reportNull$$$0(2);
        }
        if ((created = ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class)) == null) {
            NonUrgentExecutor.getInstance().execute(() -> {
                ActionManager actionManager = ActionManager.getInstance();
                ApplicationManager.getApplication().invokeLater(() -> whatToDo.accept(actionManager), ModalityState.any());
            });
        } else {
            whatToDo.accept(created);
        }
    }

    @Override
    public void removeNotify() {
        if (ScreenUtil.isStandardAddRemoveNotify(this)) {
            if (this.myAnimator != null) {
                this.myAnimator.suspend();
            }
            Disposer.dispose(this.myDisposable);
        }
        super.removeNotify();
    }

    @Override
    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            IdeMenuBar.$$$reportNull$$$0(3);
        }
        this.updateMnemonicsVisibility();
        this.myPresentationFactory.reset();
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        if (e == null) {
            IdeMenuBar.$$$reportNull$$$0(4);
        }
        if (e instanceof MouseEvent && this.getState() != State.EXPANDED) {
            this.considerRestartingAnimator((MouseEvent)e);
        }
        return false;
    }

    private void considerRestartingAnimator(MouseEvent mouseEvent) {
        boolean mouseInside;
        boolean bl = mouseInside = this.myActivated || UIUtil.isDescendingFrom(this.findActualComponent(mouseEvent), this);
        if (mouseEvent.getID() == 505 && mouseEvent.getSource() == SwingUtilities.windowForComponent(this) && !this.myActivated) {
            mouseInside = false;
        }
        if (mouseInside && this.getState() == State.COLLAPSED) {
            this.setState(State.EXPANDING);
            this.restartAnimator();
        } else if (!mouseInside && this.getState() != State.COLLAPSING && this.getState() != State.COLLAPSED) {
            this.setState(State.COLLAPSING);
            this.restartAnimator();
        }
    }

    @Nullable
    private Component findActualComponent(MouseEvent mouseEvent) {
        Component component2 = mouseEvent.getComponent();
        if (component2 == null) {
            return null;
        }
        Component deepestComponent = this.getState() != State.EXPANDED && !this.getState().isInProgress() && this.contains(SwingUtilities.convertPoint(component2, mouseEvent.getPoint(), this)) ? this : SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        if (deepestComponent != null) {
            component2 = deepestComponent;
        }
        return component2;
    }

    void updateMenuActions() {
        this.updateMenuActions(false);
    }

    void updateMenuActions(boolean forceRebuild) {
        this.doUpdateMenuActions(forceRebuild, ActionManager.getInstance());
    }

    private void doUpdateMenuActions(boolean forceRebuild, @NotNull ActionManager manager) {
        if (manager == null) {
            IdeMenuBar.$$$reportNull$$$0(5);
        }
        this.myNewVisibleActions.clear();
        DataContext dataContext = ((DataManagerImpl)DataManager.getInstance()).getDataContextTest(this);
        this.expandActionGroup(dataContext, this.myNewVisibleActions, manager);
        if (!forceRebuild && this.myNewVisibleActions.equals(this.myVisibleActions)) {
            return;
        }
        boolean changeBarVisibility = this.myNewVisibleActions.isEmpty() || this.myVisibleActions.isEmpty();
        List<AnAction> temp = this.myVisibleActions;
        this.myVisibleActions = this.myNewVisibleActions;
        this.myNewVisibleActions = temp;
        this.removeAll();
        boolean enableMnemonics = !UISettings.getInstance().getDisableMnemonics();
        boolean isDarkMenu = this.isDarkMenu();
        for (AnAction action2 : this.myVisibleActions) {
            this.add(this.createActionMenu(enableMnemonics, isDarkMenu, (ActionGroup)action2));
        }
        this.updateGlobalMenuRoots();
        this.updateMnemonicsVisibility();
        if (this.myClockPanel != null) {
            this.add(this.myClockPanel);
            this.add(this.myButton);
        }
        this.validate();
        if (changeBarVisibility) {
            this.invalidate();
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
            if (frame != null) {
                frame.validate();
            }
        }
    }

    protected boolean isDarkMenu() {
        return SystemInfo.isMacSystemMenu && NSDefaults.isDarkMenuBar();
    }

    @NotNull
    protected ActionMenu createActionMenu(boolean enableMnemonics, boolean isDarkMenu, ActionGroup action2) {
        return new ActionMenu(null, "MainMenu", action2, this.myPresentationFactory, enableMnemonics, isDarkMenu);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBackground(g);
    }

    protected void paintBackground(Graphics g) {
        if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            g.setColor(UIManager.getColor("MenuItem.background"));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (this.getState().isInProgress()) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform oldTransform = g2.getTransform();
            AffineTransform newTransform = oldTransform != null ? new AffineTransform(oldTransform) : new AffineTransform();
            newTransform.concatenate(AffineTransform.getTranslateInstance(0.0, this.getHeight() - super.getPreferredSize().height));
            g2.setTransform(newTransform);
            super.paintChildren(g2);
            g2.setTransform(oldTransform);
        } else if (this.getState() != State.COLLAPSED) {
            super.paintChildren(g);
        }
    }

    private void expandActionGroup(DataContext context, List<? super AnAction> newVisibleActions, ActionManager actionManager) {
        AnAction[] children2;
        ActionGroup mainActionGroup = this.getMainMenuActionGroup();
        if (mainActionGroup == null) {
            return;
        }
        for (AnAction action2 : children2 = mainActionGroup.getChildren(null)) {
            if (!(action2 instanceof ActionGroup)) continue;
            Presentation presentation = this.myPresentationFactory.getPresentation(action2);
            AnActionEvent e = new AnActionEvent(null, context, "MainMenu", presentation, actionManager, 0);
            e.setInjectedContext(action2.isInInjectedContext());
            action2.update(e);
            if (!presentation.isVisible()) continue;
            newVisibleActions.add(action2);
        }
    }

    @Nullable
    public ActionGroup getMainMenuActionGroup() {
        return (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("MainMenu");
    }

    @Override
    public int getMenuCount() {
        int menuCount = super.getMenuCount();
        return this.myClockPanel != null ? menuCount - 2 : menuCount;
    }

    private void updateMnemonicsVisibility() {
        boolean enabled = !UISettings.getInstance().getDisableMnemonics();
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu menu = this.getMenu(i);
            if (!(menu instanceof ActionMenu)) continue;
            ((ActionMenu)menu).setMnemonicEnabled(enabled);
        }
    }

    protected void updateGlobalMenuRoots() {
    }

    public static void installAppMenuIfNeeded(@NotNull JFrame frame) {
        JMenuBar menuBar;
        if (frame == null) {
            IdeMenuBar.$$$reportNull$$$0(6);
        }
        if ((menuBar = frame.getJMenuBar()) instanceof IdeMenuBar) {
            try {
                ((IdeMenuBar)menuBar).doInstallAppMenuIfNeeded(frame);
            }
            catch (Throwable e) {
                LOG.warn("cannot install app menu", e);
            }
        } else if (menuBar != null) {
            LOG.info("The menu bar '" + menuBar + " of frame '" + frame + "' isn't instance of IdeMenuBar");
        }
    }

    protected void doInstallAppMenuIfNeeded(@NotNull JFrame frame) {
        if (frame == null) {
            IdeMenuBar.$$$reportNull$$$0(7);
        }
    }

    public void onToggleFullScreen(boolean isFullScreen) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/IdeMenuBar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whatToDo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/IdeMenuBar";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doWithLazyActionManager";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dispatch";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateMenuActions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installAppMenuIfNeeded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doInstallAppMenuIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyExitFullScreenButton
    extends JButton {
        private MyExitFullScreenButton() {
            this.setFocusable(false);
            this.addActionListener(e -> {
                ProjectFrameHelper frameHelper = ProjectFrameHelper.getFrameHelper(SwingUtilities.getWindowAncestor(this));
                if (frameHelper != null) {
                    frameHelper.toggleFullScreen(false);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    model.setRollover(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    model.setRollover(false);
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            Container parent = this.getParent();
            int height = this.isVisible() && parent != null ? parent.getSize().height - parent.getInsets().top - parent.getInsets().bottom : super.getPreferredSize().height;
            return new Dimension(height, height);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            try {
                g2d.setColor(UIManager.getColor("Label.background"));
                g2d.fillRect(0, 0, this.getWidth() + 1, this.getHeight() + 1);
                g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                double s = (double)this.getHeight() / 13.0;
                g2d.translate(s, s);
                RoundRectangle2D.Double plate = new RoundRectangle2D.Double(0.0, 0.0, s * 11.0, s * 11.0, s, s);
                Color color = UIManager.getColor("Label.foreground");
                boolean hover = this.model.isRollover() || this.model.isPressed();
                g2d.setColor(ColorUtil.withAlpha(color, hover ? 0.25 : 0.18));
                g2d.fill(plate);
                g2d.setColor(ColorUtil.withAlpha(color, hover ? 0.4 : 0.33));
                g2d.draw(plate);
                g2d.setColor(ColorUtil.withAlpha(color, hover ? 0.7 : 0.66));
                GeneralPath path2 = new GeneralPath();
                path2.moveTo(s * 2.0, s * 6.0);
                path2.lineTo(s * 5.0, s * 6.0);
                path2.lineTo(s * 5.0, s * 9.0);
                path2.lineTo(s * 4.0, s * 8.0);
                path2.lineTo(s * 2.0, s * 10.0);
                path2.quadTo(s * 2.0 - s / Math.sqrt(2.0), s * 9.0 + s / Math.sqrt(2.0), s, s * 9.0);
                path2.lineTo(s * 3.0, s * 7.0);
                path2.lineTo(s * 2.0, s * 6.0);
                path2.closePath();
                g2d.fill(path2);
                g2d.draw(path2);
                path2 = new GeneralPath();
                path2.moveTo(s * 6.0, s * 2.0);
                path2.lineTo(s * 6.0, s * 5.0);
                path2.lineTo(s * 9.0, s * 5.0);
                path2.lineTo(s * 8.0, s * 4.0);
                path2.lineTo(s * 10.0, s * 2.0);
                path2.quadTo(s * 9.0 + s / Math.sqrt(2.0), s * 2.0 - s / Math.sqrt(2.0), s * 9.0, s);
                path2.lineTo(s * 7.0, s * 3.0);
                path2.lineTo(s * 6.0, s * 2.0);
                path2.closePath();
                g2d.fill(path2);
                g2d.draw(path2);
            }
            finally {
                g2d.dispose();
            }
        }
    }

    private static final class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Component c = e.getComponent();
            if (c instanceof IdeMenuBar) {
                Component item;
                Dimension size = c.getSize();
                Insets insets = ((IdeMenuBar)c).getInsets();
                Point p = e.getPoint();
                if ((p.y < insets.top || p.y >= size.height - insets.bottom) && (item = ((IdeMenuBar)c).findComponentAt(p.x, size.height / 2)) instanceof JMenuItem) {
                    item.dispatchEvent(MouseEventAdapter.convert(e, item, 1, 1));
                    e.consume();
                }
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IdeMenuBar.this.getState() == State.EXPANDED || IdeMenuBar.this.getState() == State.EXPANDING) {
                return;
            }
            boolean activated = IdeMenuBar.this.isActivated();
            if (IdeMenuBar.this.myActivated && !activated && IdeMenuBar.this.getState() == State.TEMPORARY_EXPANDED) {
                IdeMenuBar.this.myActivated = false;
                IdeMenuBar.this.setState(State.COLLAPSING);
                IdeMenuBar.this.restartAnimator();
            }
            if (activated) {
                IdeMenuBar.this.myActivated = true;
            }
        }
    }

    private final class MyAnimator
    extends Animator {
        MyAnimator() {
            super("MenuBarAnimator", 16, 300, false);
        }

        @Override
        public void paintNow(int frame, int totalFrames, int cycle) {
            IdeMenuBar.this.myProgress = (1.0 - Math.cos(Math.PI * (double)((float)frame / (float)totalFrames))) / 2.0;
            IdeMenuBar.this.revalidate();
            IdeMenuBar.this.repaint();
        }

        @Override
        protected void paintCycleEnd() {
            IdeMenuBar.this.myProgress = 1.0;
            switch (IdeMenuBar.this.getState()) {
                case COLLAPSING: {
                    IdeMenuBar.this.setState(State.COLLAPSED);
                    break;
                }
                case EXPANDING: {
                    IdeMenuBar.this.setState(State.TEMPORARY_EXPANDED);
                    break;
                }
            }
            if (!IdeMenuBar.this.isShowing()) {
                return;
            }
            IdeMenuBar.this.revalidate();
            if (IdeMenuBar.this.getState() == State.COLLAPSED) {
                IdeMenuBar.this.getParent().repaint();
            } else {
                IdeMenuBar.this.repaint();
            }
        }
    }

    private final class MyTimerListener
    implements TimerListener {
        private MyTimerListener() {
        }

        @Override
        public ModalityState getModalityState() {
            return ModalityState.stateForComponent(IdeMenuBar.this);
        }

        @Override
        public void run() {
            if (!IdeMenuBar.this.isShowing()) {
                return;
            }
            Window myWindow = SwingUtilities.windowForComponent(IdeMenuBar.this);
            if (myWindow != null && !myWindow.isActive()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
            if (selectedPath.length > 0) {
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window instanceof Dialog && ((Dialog)window).isModal()) {
                return;
            }
            IdeMenuBar.this.updateMenuActions();
        }
    }

    private static enum State {
        EXPANDED,
        COLLAPSING,
        COLLAPSED,
        EXPANDING,
        TEMPORARY_EXPANDED;


        boolean isInProgress() {
            return this == COLLAPSING || this == EXPANDING;
        }
    }
}

