/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageFilter;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.VolatileImage;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PaintersHelper
implements Painter.Listener {
    private static final Logger LOG = Logger.getInstance(PaintersHelper.class);
    private final Set<Painter> myPainters;
    private final Map<Painter, Component> myPainter2Component;
    private final JComponent myRootComponent;

    PaintersHelper(@NotNull JComponent component2) {
        if (component2 == null) {
            PaintersHelper.$$$reportNull$$$0(0);
        }
        this.myPainters = new LinkedHashSet<Painter>();
        this.myPainter2Component = new LinkedHashMap<Painter, Component>();
        this.myRootComponent = component2;
    }

    boolean hasPainters() {
        return !this.myPainters.isEmpty();
    }

    public boolean needsRepaint() {
        for (Painter painter : this.myPainters) {
            if (!painter.needsRepaint()) continue;
            return true;
        }
        return false;
    }

    void addPainter(@NotNull Painter painter, @Nullable Component component2) {
        if (painter == null) {
            PaintersHelper.$$$reportNull$$$0(1);
        }
        this.myPainters.add(painter);
        this.myPainter2Component.put(painter, component2 == null ? this.myRootComponent : component2);
        painter.addListener(this);
    }

    void removePainter(@NotNull Painter painter) {
        if (painter == null) {
            PaintersHelper.$$$reportNull$$$0(2);
        }
        painter.removeListener(this);
        this.myPainters.remove(painter);
        this.myPainter2Component.remove(painter);
    }

    public void clear() {
        for (Painter painter : this.myPainters) {
            painter.removeListener(this);
        }
        this.myPainters.clear();
        this.myPainter2Component.clear();
    }

    public void paint(Graphics g) {
        this.runAllPainters(g, this.computeOffsets(g, this.myRootComponent));
    }

    void runAllPainters(Graphics gg, @Nullable Offsets offsets2) {
        if (this.myPainters.isEmpty() || offsets2 == null) {
            return;
        }
        Graphics2D g = (Graphics2D)gg;
        AffineTransform orig = g.getTransform();
        int i = 0;
        for (Painter painter : this.myPainters) {
            if (!painter.needsRepaint()) continue;
            Component cur = this.myPainter2Component.get(painter);
            g.setTransform(offsets2.transform);
            g.translate(offsets2.offsets[i++], offsets2.offsets[i++]);
            painter.paint(cur, g);
        }
        g.setTransform(orig);
    }

    @Nullable
    Offsets computeOffsets(Graphics gg, @NotNull JComponent component2) {
        if (component2 == null) {
            PaintersHelper.$$$reportNull$$$0(3);
        }
        if (this.myPainters.isEmpty()) {
            return null;
        }
        Offsets offsets2 = new Offsets();
        offsets2.offsets = new int[this.myPainters.size() * 2];
        Graphics2D g = (Graphics2D)gg;
        offsets2.transform = new AffineTransform(g.getTransform());
        Rectangle r = null;
        Component prev = null;
        int i = 0;
        for (Painter painter : this.myPainters) {
            if (!painter.needsRepaint()) continue;
            Component cur = this.myPainter2Component.get(painter);
            if (cur != prev || r == null) {
                Container curParent = cur.getParent();
                if (curParent == null) continue;
                r = SwingUtilities.convertRectangle(curParent, cur.getBounds(), component2);
                prev = cur;
            }
            offsets2.offsets[i++] = r.x;
            offsets2.offsets[i++] = r.y;
        }
        return offsets2;
    }

    @Override
    public void onNeedsRepaint(@NotNull Painter painter, JComponent dirtyComponent) {
        if (painter == null) {
            PaintersHelper.$$$reportNull$$$0(4);
        }
        if (dirtyComponent != null && dirtyComponent.isShowing()) {
            Rectangle rec = SwingUtilities.convertRectangle(dirtyComponent, dirtyComponent.getBounds(), this.myRootComponent);
            this.myRootComponent.repaint(rec);
        } else {
            this.myRootComponent.repaint();
        }
    }

    static void initWallpaperPainter(@NotNull String propertyName, @NotNull PaintersHelper painters) {
        if (propertyName == null) {
            PaintersHelper.$$$reportNull$$$0(5);
        }
        if (painters == null) {
            PaintersHelper.$$$reportNull$$$0(6);
        }
        ImagePainter painter = (ImagePainter)PaintersHelper.newWallpaperPainter(propertyName, painters.myRootComponent);
        painters.addPainter(painter, null);
    }

    private static AbstractPainter newWallpaperPainter(final @NotNull String propertyName, final @NotNull JComponent rootComponent) {
        if (propertyName == null) {
            PaintersHelper.$$$reportNull$$$0(7);
        }
        if (rootComponent == null) {
            PaintersHelper.$$$reportNull$$$0(8);
        }
        return new ImagePainter(){
            Image image;
            float alpha;
            Insets insets;
            IdeBackgroundUtil.Fill fillType;
            IdeBackgroundUtil.Anchor anchor;
            String current;

            @Override
            public boolean needsRepaint() {
                return this.ensureImageLoaded();
            }

            @Override
            public void executePaint(Component component2, Graphics2D g) {
                if (this.image == null) {
                    return;
                }
                this.executePaint(g, component2, this.image, this.fillType, this.anchor, this.alpha, this.insets);
            }

            boolean ensureImageLoaded() {
                IdeFrame frame = ComponentUtil.getParentOfType(IdeFrame.class, rootComponent);
                Project project2 = frame == null ? null : frame.getProject();
                String value2 = IdeBackgroundUtil.getBackgroundSpec(project2, propertyName);
                if (!Comparing.equal(value2, this.current)) {
                    this.current = value2;
                    this.loadImageAsync(value2);
                }
                return this.image != null;
            }

            private void resetImage(String value2, Image newImage, float newAlpha, IdeBackgroundUtil.Fill newFill, IdeBackgroundUtil.Anchor newAnchor) {
                boolean newOk;
                if (!Comparing.equal(this.current, value2)) {
                    return;
                }
                boolean prevOk = this.image != null;
                this.clearImages(-1L);
                this.image = newImage;
                this.insets = JBUI.emptyInsets();
                this.alpha = newAlpha;
                this.fillType = newFill;
                this.anchor = newAnchor;
                boolean bl = newOk = newImage != null;
                if (prevOk || newOk) {
                    ModalityState modalityState = ModalityState.stateForComponent(rootComponent);
                    if (modalityState.dominates(ModalityState.NON_MODAL)) {
                        ComponentUtil.getActiveWindow().repaint();
                    } else {
                        IdeBackgroundUtil.repaintAllWindows();
                    }
                }
            }

            private void loadImageAsync(@Nullable String propertyValue) {
                String[] parts = (propertyValue != null ? propertyValue : propertyName + ".png").split(",");
                float newAlpha = Math.abs(Math.min((float)StringUtil.parseInt(parts.length > 1 ? parts[1] : "", 10) / 100.0f, 1.0f));
                IdeBackgroundUtil.Fill newFillType = StringUtil.parseEnum(parts.length > 2 ? StringUtil.toUpperCase(parts[2]) : "", IdeBackgroundUtil.Fill.SCALE, IdeBackgroundUtil.Fill.class);
                IdeBackgroundUtil.Anchor newAnchor = StringUtil.parseEnum(parts.length > 3 ? StringUtil.toUpperCase(parts[3]) : "", IdeBackgroundUtil.Anchor.CENTER, IdeBackgroundUtil.Anchor.class);
                String flip = parts.length > 4 ? parts[4] : "none";
                String filePath2 = parts[0];
                if (StringUtil.isEmpty(filePath2)) {
                    this.resetImage(propertyValue, null, newAlpha, newFillType, newAnchor);
                    return;
                }
                try {
                    URL url = filePath2.contains("://") ? new URL(filePath2) : (FileUtil.isAbsolutePlatformIndependent(filePath2) ? new File(filePath2) : new File(PathManager.getConfigPath(), filePath2)).toURI().toURL();
                    ModalityState modalityState = ModalityState.stateForComponent(rootComponent);
                    boolean flipH = "flipHV".equals(flip) || "flipH".equals(flip);
                    boolean flipV = "flipHV".equals(flip) || "flipV".equals(flip);
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        BufferedImageFilter flipFilter = flipV || flipH ? 1.flipFilter(flipV, flipH) : null;
                        Image m = ImageLoader.loadFromUrl(url, true, true, new ImageFilter[]{flipFilter}, ScaleContext.create());
                        ApplicationManager.getApplication().invokeLater(() -> this.resetImage(propertyValue, m, newAlpha, newFillType, newAnchor), modalityState);
                    });
                }
                catch (Exception e) {
                    this.resetImage(propertyValue, null, newAlpha, newFillType, newAnchor);
                }
            }
        };
    }

    static AbstractPainter newImagePainter(final @NotNull Image image, final @NotNull IdeBackgroundUtil.Fill fillType, final @NotNull IdeBackgroundUtil.Anchor anchor2, final float alpha, final @NotNull Insets insets) {
        if (image == null) {
            PaintersHelper.$$$reportNull$$$0(9);
        }
        if (fillType == null) {
            PaintersHelper.$$$reportNull$$$0(10);
        }
        if (anchor2 == null) {
            PaintersHelper.$$$reportNull$$$0(11);
        }
        if (insets == null) {
            PaintersHelper.$$$reportNull$$$0(12);
        }
        return new ImagePainter(){

            @Override
            public boolean needsRepaint() {
                return true;
            }

            @Override
            public void executePaint(Component component2, Graphics2D g) {
                this.executePaint(g, component2, image, fillType, anchor2, alpha, insets);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/PaintersHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addPainter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removePainter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "computeOffsets";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onNeedsRepaint";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "initWallpaperPainter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "newWallpaperPainter";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "newImagePainter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class ImagePainter
    extends AbstractPainter {
        final Map<GraphicsConfiguration, Cached> cachedMap = new HashMap<GraphicsConfiguration, Cached>();

        private ImagePainter() {
        }

        void executePaint(@NotNull Graphics2D g, @NotNull Component component2, @NotNull Image image, @NotNull IdeBackgroundUtil.Fill fillType, @NotNull IdeBackgroundUtil.Anchor anchor2, float alpha, @NotNull Insets insets) {
            long currentTime;
            boolean repaint;
            if (g == null) {
                ImagePainter.$$$reportNull$$$0(0);
            }
            if (component2 == null) {
                ImagePainter.$$$reportNull$$$0(1);
            }
            if (image == null) {
                ImagePainter.$$$reportNull$$$0(2);
            }
            if (fillType == null) {
                ImagePainter.$$$reportNull$$$0(3);
            }
            if (anchor2 == null) {
                ImagePainter.$$$reportNull$$$0(4);
            }
            if (insets == null) {
                ImagePainter.$$$reportNull$$$0(5);
            }
            int cw0 = component2.getWidth();
            int ch0 = component2.getHeight();
            JBInsets i = JBUI.insets(insets.top * ch0 / 100, insets.left * cw0 / 100, insets.bottom * ch0 / 100, insets.right * cw0 / 100);
            int cw = cw0 - i.left - i.right;
            int ch = ch0 - i.top - i.bottom;
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            if (w <= 0 || h <= 0) {
                return;
            }
            @Nullable GraphicsConfiguration cfg = g.getDeviceConfiguration();
            Cached cached = this.cachedMap.get(cfg);
            VolatileImage scaled = cached == null ? null : cached.image;
            Rectangle src0 = new Rectangle();
            Rectangle dst0 = new Rectangle();
            ImagePainter.calcSrcDst(src0, dst0, w, h, cw, ch, fillType);
            ImagePainter.alignRect(src0, w, h, anchor2);
            if (fillType == IdeBackgroundUtil.Fill.TILE) {
                ImagePainter.alignRect(dst0, cw, ch, anchor2);
            }
            int sw0 = scaled == null ? -1 : scaled.getWidth(null);
            int sh0 = scaled == null ? -1 : scaled.getHeight(null);
            boolean bl = repaint = cached == null || !cached.src.equals(src0) || !cached.dst.equals(dst0);
            while ((scaled = ImagePainter.validateImage(cfg, scaled)) == null || repaint) {
                int sw = Math.min(cw, dst0.width);
                int sh = Math.min(ch, dst0.height);
                if (scaled == null || sw0 < sw || sh0 < sh) {
                    scaled = ImagePainter.createImage(cfg, sw, sh);
                    cached = new Cached(scaled, src0, dst0);
                    this.cachedMap.put(cfg, cached);
                } else {
                    cached.src.setBounds(src0);
                    cached.dst.setBounds(dst0);
                }
                Graphics2D gg = scaled.createGraphics();
                gg.setComposite(AlphaComposite.Src);
                if (fillType == IdeBackgroundUtil.Fill.SCALE) {
                    gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    StartupUiUtil.drawImage((Graphics)gg, image, dst0, src0, null);
                } else if (fillType == IdeBackgroundUtil.Fill.TILE) {
                    Rectangle r = new Rectangle(0, 0, 0, 0);
                    for (int x = 0; x < dst0.width; x += w) {
                        for (int y = 0; y < dst0.height; y += h) {
                            r.setBounds(dst0.x + x, dst0.y + y, src0.width, src0.height);
                            StartupUiUtil.drawImage((Graphics)gg, image, r, src0, null);
                        }
                    }
                } else {
                    StartupUiUtil.drawImage((Graphics)gg, image, dst0, src0, null);
                }
                gg.dispose();
                repaint = false;
            }
            cached.touched = currentTime = System.currentTimeMillis();
            if (this.cachedMap.size() > 2) {
                this.clearImages(currentTime);
            }
            Rectangle src = new Rectangle(0, 0, cw, ch);
            Rectangle dst = new Rectangle(i.left, i.top, cw, ch);
            if (fillType != IdeBackgroundUtil.Fill.TILE) {
                ImagePainter.alignRect(src, dst0.width, dst0.height, anchor2);
            }
            float adjustedAlpha = Boolean.TRUE.equals(g.getRenderingHint(IdeBackgroundUtil.ADJUST_ALPHA)) ? 0.65f * alpha : alpha;
            GraphicsConfig gc = new GraphicsConfig(g).setAlpha(adjustedAlpha);
            StartupUiUtil.drawImage(g, scaled, dst, src, null, null);
            gc.restore();
        }

        static void calcSrcDst(Rectangle src, Rectangle dst, int w, int h, int cw, int ch, IdeBackgroundUtil.Fill fillType) {
            if (fillType == IdeBackgroundUtil.Fill.SCALE) {
                boolean useWidth = cw * h > ch * w;
                int sw = useWidth ? w : cw * h / ch;
                int sh = useWidth ? ch * w / cw : h;
                src.setBounds(0, 0, sw, sh);
                dst.setBounds(0, 0, cw, ch);
            } else if (fillType == IdeBackgroundUtil.Fill.TILE) {
                int dw = cw < w ? w : ((cw / w + 1) / 2 * 2 + 1) * w;
                int dh = ch < h ? h : ((ch / h + 1) / 2 * 2 + 1) * h;
                src.setBounds(0, 0, w, h);
                dst.setBounds(0, 0, dw, dh);
            } else {
                src.setBounds(0, 0, Math.min(w, cw), Math.min(h, ch));
                dst.setBounds(src);
            }
        }

        static void alignRect(Rectangle r, int w, int h, IdeBackgroundUtil.Anchor anchor2) {
            if (anchor2 == IdeBackgroundUtil.Anchor.TOP_CENTER || anchor2 == IdeBackgroundUtil.Anchor.CENTER || anchor2 == IdeBackgroundUtil.Anchor.BOTTOM_CENTER) {
                r.x = (w - r.width) / 2;
                r.y = anchor2 == IdeBackgroundUtil.Anchor.TOP_CENTER ? 0 : (anchor2 == IdeBackgroundUtil.Anchor.BOTTOM_CENTER ? h - r.height : (h - r.height) / 2);
            } else {
                int n = r.x = anchor2 == IdeBackgroundUtil.Anchor.TOP_LEFT || anchor2 == IdeBackgroundUtil.Anchor.MIDDLE_LEFT || anchor2 == IdeBackgroundUtil.Anchor.BOTTOM_LEFT ? 0 : w - r.width;
                r.y = anchor2 == IdeBackgroundUtil.Anchor.TOP_LEFT || anchor2 == IdeBackgroundUtil.Anchor.TOP_RIGHT ? 0 : (anchor2 == IdeBackgroundUtil.Anchor.BOTTOM_LEFT || anchor2 == IdeBackgroundUtil.Anchor.BOTTOM_RIGHT ? h - r.height : (h - r.height) / 2);
            }
        }

        void clearImages(long currentTime) {
            boolean all = currentTime <= 0L;
            Iterator<GraphicsConfiguration> it = this.cachedMap.keySet().iterator();
            while (it.hasNext()) {
                GraphicsConfiguration cfg = it.next();
                Cached c = this.cachedMap.get(cfg);
                if (!all && currentTime - c.touched <= 120000L) continue;
                it.remove();
                LOG.info(ImagePainter.logPrefix(cfg, c.image) + "image flushed" + (all ? "" : "; untouched for " + StringUtil.formatDuration(currentTime - c.touched)));
                c.image.flush();
            }
        }

        @Nullable
        private static VolatileImage validateImage(@Nullable GraphicsConfiguration cfg, @Nullable VolatileImage image) {
            if (image == null) {
                return null;
            }
            boolean lost1 = image.contentsLost();
            int validated = image.validate(cfg);
            boolean lost2 = image.contentsLost();
            if (lost1 || lost2 || validated != 0) {
                LOG.info(ImagePainter.logPrefix(cfg, image) + "image flushed: contentsLost=" + lost1 + "||" + lost2 + "; validate=" + validated);
                image.flush();
                return null;
            }
            return image;
        }

        @NotNull
        private static VolatileImage createImage(@Nullable GraphicsConfiguration cfg, int w, int h) {
            VolatileImage image;
            GraphicsConfiguration safe = cfg != null ? cfg : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            try {
                image = safe.createCompatibleVolatileImage(w, h, new ImageCapabilities(true), 3);
            }
            catch (Exception e) {
                image = safe.createCompatibleVolatileImage(w, h, 3);
            }
            image.validate(cfg);
            image.setAccelerationPriority(1.0f);
            ImageCapabilities caps = image.getCapabilities();
            LOG.info(ImagePainter.logPrefix(cfg, image) + (caps.isAccelerated() ? "" : "non-") + "accelerated " + (caps.isTrueVolatile() ? "" : "non-") + "volatile image created");
            VolatileImage volatileImage = image;
            if (volatileImage == null) {
                ImagePainter.$$$reportNull$$$0(6);
            }
            return volatileImage;
        }

        @NotNull
        private static String logPrefix(@Nullable GraphicsConfiguration cfg, @NotNull VolatileImage image) {
            if (image == null) {
                ImagePainter.$$$reportNull$$$0(7);
            }
            String string = "(" + (cfg == null ? "null" : cfg.getClass().getSimpleName()) + ") " + image.getWidth() + "x" + image.getHeight() + " ";
            if (string == null) {
                ImagePainter.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        static BufferedImageFilter flipFilter(final boolean flipV, final boolean flipH) {
            return new BufferedImageFilter(new BufferedImageOp(){

                @Override
                public BufferedImage filter(BufferedImage src, BufferedImage dest) {
                    AffineTransform tx = AffineTransform.getScaleInstance(flipH ? -1.0 : 1.0, flipV ? -1.0 : 1.0);
                    tx.translate(flipH ? (double)(-src.getWidth(null)) : 0.0, flipV ? (double)(-src.getHeight(null)) : 0.0);
                    AffineTransformOp op = new AffineTransformOp(tx, 1);
                    return op.filter(src, dest);
                }

                @Override
                public Rectangle2D getBounds2D(BufferedImage src) {
                    return null;
                }

                @Override
                public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
                    return null;
                }

                @Override
                public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
                    return null;
                }

                @Override
                public RenderingHints getRenderingHints() {
                    return null;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fillType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insets";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/PaintersHelper$ImagePainter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/PaintersHelper$ImagePainter";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createImage";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "logPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "executePaint";
                    break;
                }
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "logPrefix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Cached {
        final VolatileImage image;
        final Rectangle src;
        final Rectangle dst;
        long touched;

        Cached(VolatileImage image, Rectangle src, Rectangle dst) {
            this.image = image;
            this.src = src;
            this.dst = dst;
        }
    }

    public static class Offsets {
        AffineTransform transform;
        int[] offsets;
    }
}

