/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class PlatformFrameTitleBuilder
extends FrameTitleBuilder {
    @Override
    public String getProjectTitle(@NotNull Project project2) {
        String basePath;
        if (project2 == null) {
            PlatformFrameTitleBuilder.$$$reportNull$$$0(0);
        }
        if ((basePath = project2.getBasePath()) == null) {
            return project2.getName();
        }
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        int sameNamedProjects = ContainerUtil.count(Arrays.asList(projects), it -> it.getName().equals(project2.getName()));
        if (sameNamedProjects == 1 && !UISettings.getInstance().getFullPathsInWindowHeader()) {
            return project2.getName();
        }
        if ((basePath = FileUtil.toSystemDependentName(basePath)).equals(project2.getName()) && !UISettings.getInstance().getFullPathsInWindowHeader()) {
            return "[" + FileUtil.getLocationRelativeToUserHome(basePath) + "]";
        }
        return project2.getName() + " [" + FileUtil.getLocationRelativeToUserHome(basePath) + "]";
    }

    @Override
    public String getFileTitle(@NotNull Project project2, @NotNull VirtualFile file2) {
        String fileTitle;
        if (project2 == null) {
            PlatformFrameTitleBuilder.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            PlatformFrameTitleBuilder.$$$reportNull$$$0(2);
        }
        if (!(fileTitle = VfsPresentationUtil.getPresentableNameForUI(project2, file2)).endsWith(file2.getPresentableName()) || file2.getParent() == null) {
            return fileTitle;
        }
        if (UISettings.getInstance().getFullPathsInWindowHeader()) {
            return ProjectUtilCore.displayUrlRelativeToProject(file2, file2.getPresentableUrl(), project2, true, false);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        if (!fileIndex.isInContent(file2)) {
            String pathWithLibrary = ProjectUtilCore.decorateWithLibraryName(file2, project2, file2.getPresentableName());
            if (pathWithLibrary != null) {
                return pathWithLibrary;
            }
            return FileUtil.getLocationRelativeToUserHome(file2.getPresentableUrl());
        }
        if (PlatformUtils.isCidr() || PlatformUtils.isRider()) {
            return fileTitle;
        }
        return ProjectUtilCore.appendModuleName(file2, project2, fileTitle, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/PlatformFrameTitleBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectTitle";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileTitle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

