/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.FrameInfoHelperKt;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectFrameBounds", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(deprecated=true, value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001eB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u001d\u001a\u00020\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/wm/impl/ProjectFrameBounds;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/wm/impl/FrameInfo;", "Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "frameInfoHelper", "Lcom/intellij/openapi/wm/impl/FrameInfoHelper;", "isInFullScreen", "", "()Z", "pendingBounds", "Ljava/awt/Rectangle;", "getActualFrameInfoInDeviceSpace", "frame", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "windowManager", "Lcom/intellij/openapi/wm/impl/WindowManagerImpl;", "getFrameInfoInDeviceSpace", "getModificationCount", "", "getState", "loadState", "", "state", "markDirty", "bounds", "updateAndGetModificationCount", "updateDefaultFrameInfoOnProjectClose", "Companion", "intellij.platform.ide.impl"})
public final class ProjectFrameBounds
implements PersistentStateComponent<FrameInfo>,
ModificationTracker {
    private final FrameInfoHelper frameInfoHelper;
    private Rectangle pendingBounds;
    private final Project project;
    public static final Companion Companion = new Companion(null);

    public final boolean isInFullScreen() {
        FrameInfo frameInfo = this.frameInfoHelper.getInfo();
        return frameInfo != null ? frameInfo.getFullScreen() : false;
    }

    @Override
    @Nullable
    public FrameInfo getState() {
        return this.frameInfoHelper.getInfo();
    }

    @Override
    public void loadState(@NotNull FrameInfo state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.frameInfoHelper.setInfoInDeviceSpace(state);
    }

    @Override
    public long getModificationCount() {
        long l;
        if (this.frameInfoHelper.isDirty()) {
            WindowManager windowManager = WindowManager.getInstance();
            if (windowManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
            }
            l = this.frameInfoHelper.updateAndGetModificationCount(this.project, this.pendingBounds, (WindowManagerImpl)windowManager);
        } else {
            l = this.frameInfoHelper.getModificationCount();
        }
        return l;
    }

    @Nullable
    public final FrameInfo getFrameInfoInDeviceSpace() {
        return this.frameInfoHelper.getInfo();
    }

    @Nullable
    public final FrameInfo getActualFrameInfoInDeviceSpace(@NotNull ProjectFrameHelper frame, @NotNull WindowManagerImpl windowManager) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)windowManager, (String)"windowManager");
        if (this.frameInfoHelper.isDirty()) {
            this.updateAndGetModificationCount(frame, windowManager);
        }
        return this.frameInfoHelper.getInfo();
    }

    private final void updateAndGetModificationCount(ProjectFrameHelper frame, WindowManagerImpl windowManager) {
        this.frameInfoHelper.updateAndGetModificationCount(frame, this.pendingBounds, windowManager);
    }

    public final void updateDefaultFrameInfoOnProjectClose() {
        WindowManager windowManager = WindowManager.getInstance();
        if (windowManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
        }
        WindowManagerImpl windowManager2 = (WindowManagerImpl)windowManager;
        if (this.frameInfoHelper.isDirty() || this.frameInfoHelper.getInfo() == null) {
            this.frameInfoHelper.updateAndGetModificationCount(this.project, this.pendingBounds, windowManager2);
        } else {
            FrameInfo frameInfo = this.frameInfoHelper.getInfo();
            if (frameInfo == null) {
                return;
            }
            FrameInfoHelperKt.updateDefaultFrameInfoInDeviceSpace(windowManager2, frameInfo);
        }
    }

    public final void markDirty(@Nullable Rectangle bounds2) {
        if (bounds2 != null) {
            this.pendingBounds = new Rectangle(bounds2);
        }
        this.frameInfoHelper.setDirty(true);
    }

    public ProjectFrameBounds(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        this.frameInfoHelper = new FrameInfoHelper();
    }

    @JvmStatic
    @NotNull
    public static final ProjectFrameBounds getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/wm/impl/ProjectFrameBounds$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/wm/impl/ProjectFrameBounds;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ProjectFrameBounds getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Project $this$service$iv = project2;
            boolean $i$f$service = false;
            ProjectFrameBounds projectFrameBounds = $this$service$iv.getService(ProjectFrameBounds.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)projectFrameBounds, (String)"getService(T::class.java)");
            return projectFrameBounds;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

