/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.impl.ProjectWindowAction;
import com.intellij.platform.ModuleAttachProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectWindowActionGroup
extends DefaultActionGroup {
    private ProjectWindowAction latest = null;

    public void addProject(@NotNull Project project2) {
        String projectLocation;
        if (project2 == null) {
            ProjectWindowActionGroup.$$$reportNull$$$0(0);
        }
        if ((projectLocation = project2.getPresentableUrl()) == null) {
            return;
        }
        String projectName = ProjectWindowActionGroup.getProjectDisplayName(project2);
        ProjectWindowAction windowAction = new ProjectWindowAction(projectName, projectLocation, this.latest);
        List<ProjectWindowAction> duplicateWindowActions = this.findWindowActionsWithProjectName(projectName);
        if (!duplicateWindowActions.isEmpty()) {
            for (ProjectWindowAction action2 : duplicateWindowActions) {
                action2.getTemplatePresentation().setText(FileUtil.getLocationRelativeToUserHome(action2.getProjectLocation()));
            }
            windowAction.getTemplatePresentation().setText(FileUtil.getLocationRelativeToUserHome(windowAction.getProjectLocation()));
        }
        this.add(windowAction);
        this.latest = windowAction;
    }

    @NotNull
    private static String getProjectDisplayName(@NotNull Project project2) {
        String name;
        if (project2 == null) {
            ProjectWindowActionGroup.$$$reportNull$$$0(1);
        }
        String string = (name = ModuleAttachProcessor.getMultiProjectDisplayName(project2)) != null ? name : project2.getName();
        if (string == null) {
            ProjectWindowActionGroup.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void removeProject(@NotNull Project project2) {
        ProjectWindowAction windowAction;
        if (project2 == null) {
            ProjectWindowActionGroup.$$$reportNull$$$0(3);
        }
        if ((windowAction = this.findWindowAction(project2.getPresentableUrl())) == null) {
            return;
        }
        if (this.latest == windowAction) {
            ProjectWindowAction previous = this.latest.getPrevious();
            this.latest = previous != this.latest ? previous : null;
        }
        this.remove(windowAction);
        String projectName = ProjectWindowActionGroup.getProjectDisplayName(project2);
        List<ProjectWindowAction> duplicateWindowActions = this.findWindowActionsWithProjectName(projectName);
        if (duplicateWindowActions.size() == 1) {
            duplicateWindowActions.get(0).getTemplatePresentation().setText(projectName);
        }
        windowAction.dispose();
    }

    public boolean isEnabled() {
        return this.latest != null && this.latest.getPrevious() != this.latest;
    }

    @Override
    public boolean isDumbAware() {
        return true;
    }

    public void activateNextWindow(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ProjectWindowActionGroup.$$$reportNull$$$0(4);
        }
        if ((project2 = e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        ProjectWindowAction windowAction = this.findWindowAction(project2.getPresentableUrl());
        if (windowAction == null) {
            return;
        }
        ProjectWindowAction next = windowAction.getNext();
        if (next != null) {
            next.setSelected(e, true);
        }
    }

    public void activatePreviousWindow(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ProjectWindowActionGroup.$$$reportNull$$$0(5);
        }
        if ((project2 = e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        ProjectWindowAction windowAction = this.findWindowAction(project2.getPresentableUrl());
        if (windowAction == null) {
            return;
        }
        ProjectWindowAction previous = windowAction.getPrevious();
        if (previous != null) {
            previous.setSelected(e, true);
        }
    }

    @Nullable
    private ProjectWindowAction findWindowAction(String projectLocation) {
        AnAction[] children2;
        if (projectLocation == null) {
            return null;
        }
        for (AnAction child2 : children2 = this.getChildren(null)) {
            ProjectWindowAction windowAction;
            if (!(child2 instanceof ProjectWindowAction) || !projectLocation.equals((windowAction = (ProjectWindowAction)child2).getProjectLocation())) continue;
            return windowAction;
        }
        return null;
    }

    private List<ProjectWindowAction> findWindowActionsWithProjectName(String projectName) {
        AnAction[] children2;
        ArrayList<ProjectWindowAction> result2 = null;
        for (AnAction child2 : children2 = this.getChildren(null)) {
            ProjectWindowAction windowAction;
            if (!(child2 instanceof ProjectWindowAction) || !projectName.equals((windowAction = (ProjectWindowAction)child2).getProjectName())) continue;
            if (result2 == null) {
                result2 = new ArrayList<ProjectWindowAction>();
            }
            result2.add(windowAction);
        }
        if (result2 == null) {
            return Collections.emptyList();
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/ProjectWindowActionGroup";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/ProjectWindowActionGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDisplayName";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeProject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "activateNextWindow";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "activatePreviousWindow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

