/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

final class Surface
extends JComponent {
    private final Image myTopImage;
    private final Image myBottomImage;
    private final Point2D myBottomImageOffset;
    private final int myDirection;
    private final int myDesiredTimeToComplete;
    private final ToolWindowAnchor myAnchor;
    private int myOffset = 0;

    Surface(Image topImage, Image bottomImage, Point2D bottomImageOffset, int direction, ToolWindowAnchor anchor2, int desiredTimeToComplete) {
        this.myTopImage = topImage;
        this.myBottomImage = bottomImage;
        this.myBottomImageOffset = (Point2D)bottomImageOffset.clone();
        this.myAnchor = anchor2;
        this.myDirection = direction;
        this.myDesiredTimeToComplete = desiredTimeToComplete;
        this.setOpaque(true);
    }

    public final void runMovement() {
        if (!this.isShowing()) {
            return;
        }
        Rectangle bounds2 = this.getBounds();
        int distance2 = this.myAnchor == ToolWindowAnchor.LEFT || this.myAnchor == ToolWindowAnchor.RIGHT ? bounds2.width : bounds2.height;
        int count = 0;
        this.myOffset = 0;
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        long startTime = System.currentTimeMillis();
        while (true) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            long timeSpent = System.currentTimeMillis() - startTime;
            ++count;
            if (timeSpent >= (long)this.myDesiredTimeToComplete) break;
            double onePaintTime = (double)timeSpent / (double)count;
            int iterations = (int)((double)((long)this.myDesiredTimeToComplete - timeSpent) / onePaintTime);
            iterations = Math.max(1, iterations);
            this.myOffset += (distance2 - this.myOffset) / iterations;
        }
    }

    @Override
    public final void paint(Graphics g) {
        Rectangle bounds2 = this.getBounds();
        ((Graphics2D)g).translate(this.myBottomImageOffset.getX(), this.myBottomImageOffset.getY());
        if (this.myAnchor == ToolWindowAnchor.LEFT) {
            if (this.myDirection == 1) {
                g.setClip(null);
                g.clipRect(this.myOffset, 0, bounds2.width - this.myOffset, bounds2.height);
                UIUtil.drawImage(g, this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(0, 0, this.myOffset, bounds2.height);
                UIUtil.drawImage(g, this.myTopImage, this.myOffset - bounds2.width, 0, null);
            } else {
                g.setClip(null);
                g.clipRect(bounds2.width - this.myOffset, 0, this.myOffset, bounds2.height);
                UIUtil.drawImage(g, this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(0, 0, bounds2.width - this.myOffset, bounds2.height);
                UIUtil.drawImage(g, this.myTopImage, -this.myOffset, 0, null);
            }
            this.myTopImage.flush();
        } else if (this.myAnchor == ToolWindowAnchor.RIGHT) {
            if (this.myDirection == 1) {
                g.setClip(null);
                g.clipRect(0, 0, bounds2.width - this.myOffset, bounds2.height);
                UIUtil.drawImage(g, this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(bounds2.width - this.myOffset, 0, this.myOffset, bounds2.height);
                UIUtil.drawImage(g, this.myTopImage, bounds2.width - this.myOffset, 0, null);
            } else {
                g.setClip(null);
                g.clipRect(0, 0, this.myOffset, bounds2.height);
                UIUtil.drawImage(g, this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(this.myOffset, 0, bounds2.width - this.myOffset, bounds2.height);
                UIUtil.drawImage(g, this.myTopImage, this.myOffset, 0, null);
            }
        } else if (this.myAnchor == ToolWindowAnchor.TOP) {
            if (this.myDirection == 1) {
                g.setClip(null);
                g.clipRect(0, this.myOffset, bounds2.width, bounds2.height - this.myOffset);
                UIUtil.drawImage(g, this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(0, 0, bounds2.width, this.myOffset);
                UIUtil.drawImage(g, this.myTopImage, 0, -bounds2.height + this.myOffset, null);
            } else {
                g.setClip(null);
                g.clipRect(0, bounds2.height - this.myOffset, bounds2.width, this.myOffset);
                UIUtil.drawImage(g, this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(0, 0, bounds2.width, bounds2.height - this.myOffset);
                UIUtil.drawImage(g, this.myTopImage, 0, -this.myOffset, null);
            }
        } else if (this.myAnchor == ToolWindowAnchor.BOTTOM) {
            if (this.myDirection == 1) {
                g.setClip(null);
                g.clipRect(0, 0, bounds2.width, bounds2.height - this.myOffset);
                UIUtil.drawImage(g, this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(0, bounds2.height - this.myOffset, bounds2.width, this.myOffset);
                UIUtil.drawImage(g, this.myTopImage, 0, bounds2.height - this.myOffset, null);
            } else {
                g.setClip(null);
                g.clipRect(0, 0, bounds2.width, this.myOffset);
                UIUtil.drawImage(g, this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(0, this.myOffset, bounds2.width, bounds2.height - this.myOffset);
                UIUtil.drawImage(g, this.myTopImage, 0, this.myOffset, null);
            }
        }
    }
}

