/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.JdkConstants;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u000e\u001a\u00020\f2\b\b\u0001\u0010\u000f\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\bH\u0002\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a \u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u001a\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0002\u001a\u0010\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0003\u001aC\u0010'\u001a\u00020(28\b\u0004\u0010)\u001a2\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020(0*H\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\u00020\b8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006-"}, d2={"ACTIVE_ATTR_VALUE", "", "EDITOR_ELEMENT", "LAYOUT_TO_RESTORE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "activateToolWindowVKsMask", "", "getActivateToolWindowVKsMask", "()I", "isStackEnabled", "", "()Z", "areAllModifiersPressed", "modifiers", "mask", "findIconFromBean", "Ljavax/swing/Icon;", "bean", "Lcom/intellij/openapi/wm/ToolWindowEP;", "factory", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "getRootBounds", "Ljava/awt/Rectangle;", "frame", "Ljavax/swing/JFrame;", "getStripeTitleSupplier", "Ljava/util/function/Supplier;", "id", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "isInActiveToolWindow", "component", "", "activeToolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "keyCodeToInputMask", "code", "processDescriptors", "", "handler", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "intellij.platform.ide.impl"})
public final class ToolWindowManagerImplKt {
    private static final Logger LOG;
    private static final String EDITOR_ELEMENT = "editor";
    private static final String ACTIVE_ATTR_VALUE = "active";
    private static final String LAYOUT_TO_RESTORE = "layout-to-restore";

    private static final boolean areAllModifiersPressed(@JdkConstants.InputEventMask int modifiers, @JdkConstants.InputEventMask int mask) {
        return (modifiers ^ mask) == 0;
    }

    @JdkConstants.InputEventMask
    private static final int keyCodeToInputMask(int code) {
        int mask = 0;
        if (code == 16) {
            mask = 1;
        }
        if (code == 17) {
            mask = 2;
        }
        if (code == 157) {
            mask = 4;
        }
        if (code == 18) {
            mask = 8;
        }
        return mask;
    }

    @JdkConstants.InputEventMask
    private static final int getActivateToolWindowVKsMask() {
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return 0;
        }
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)keymapManager2, (String)"KeymapManager.getInstance()");
        Keymap keymap2 = keymapManager2.getActiveKeymap();
        Intrinsics.checkExpressionValueIsNotNull((Object)keymap2, (String)"KeymapManager.getInstance().activeKeymap");
        Keymap keymap3 = keymap2;
        Shortcut[] baseShortcut = keymap3.getShortcuts("ActivateProjectToolWindow");
        int baseModifiers = SystemInfo.isMac ? 4 : 8;
        for (Shortcut each : baseShortcut) {
            KeyStroke keyStroke;
            if (!(each instanceof KeyboardShortcut)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)((KeyboardShortcut)each).getFirstKeyStroke(), (String)"each.firstKeyStroke");
            baseModifiers = keyStroke.getModifiers();
            if (baseModifiers > 0) break;
        }
        return baseModifiers & 0xF;
    }

    private static final boolean isStackEnabled() {
        return Registry.is("ide.enable.toolwindow.stack");
    }

    private static final Rectangle getRootBounds(JFrame frame) {
        JRootPane rootPane;
        JRootPane jRootPane = rootPane = frame.getRootPane();
        Intrinsics.checkExpressionValueIsNotNull((Object)jRootPane, (String)"rootPane");
        Rectangle bounds2 = jRootPane.getBounds();
        bounds2.setLocation(frame.getX() + rootPane.getX(), frame.getY() + rootPane.getY());
        Rectangle rectangle = bounds2;
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"bounds");
        return rectangle;
    }

    private static final boolean isInActiveToolWindow(Object component2, ToolWindowImpl activeToolWindow) {
        JComponent source = component2 instanceof JComponent ? (JComponent)component2 : null;
        JComponent activeToolWindowComponent = activeToolWindow.getComponentIfInitialized();
        if (activeToolWindowComponent != null) {
            while (source != null && source != activeToolWindowComponent) {
                JComponent jComponent;
                if (source.getParent() != null && source.getParent() instanceof JComponent) {
                    Container container2 = source.getParent();
                    if (container2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type javax.swing.JComponent");
                    }
                    jComponent = (JComponent)container2;
                } else {
                    jComponent = null;
                }
                source = jComponent;
            }
        }
        return source != null;
    }

    private static final Supplier<String> getStripeTitleSupplier(String id2, PluginDescriptor pluginDescriptor) {
        String string;
        ClassLoader classLoader = pluginDescriptor.getPluginClassLoader();
        PluginId pluginId = pluginDescriptor.getPluginId();
        if (Intrinsics.areEqual((Object)pluginId, (Object)PluginManagerCore.CORE_ID)) {
            string = "messages.IdeBundle";
        } else {
            string = pluginDescriptor.getResourceBundleBaseName();
            if (string == null) {
                return null;
            }
        }
        String bundleName = string;
        try {
            ResourceBundle resourceBundle = DynamicBundle.INSTANCE.getResourceBundle(bundleName, classLoader);
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceBundle, (String)"DynamicBundle.INSTANCE.g\u2026(bundleName, classLoader)");
            ResourceBundle bundle = resourceBundle;
            String key = StringsKt.replace$default((String)("toolwindow.stripe." + id2), (String)" ", (String)"_", (boolean)false, (int)4, null);
            String label2 = BundleBase.messageOrDefault(bundle, key, id2, new Object[0]);
            return new Supplier<String>(label2){
                final /* synthetic */ String $label;

                public final String get() {
                    return this.$label;
                }
                {
                    this.$label = string;
                }
            };
        }
        catch (MissingResourceException e) {
            LOG.warn("Missing bundle " + bundleName + " at " + classLoader, e);
            return null;
        }
    }

    private static final Icon findIconFromBean(ToolWindowEP bean, ToolWindowFactory factory) {
        if (bean.icon == null) {
            return null;
        }
        Icon icon2 = IconLoader.findIcon(bean.icon, factory.getClass());
        if (icon2 != null) {
            return icon2;
        }
        try {
            return IconLoader.getIcon(bean.icon);
        }
        catch (Exception ignored) {
            return EmptyIcon.ICON_13;
        }
    }

    private static final void processDescriptors(Function2<? super ToolWindowEP, ? super PluginDescriptor, Unit> handler2) {
        int $i$f$processDescriptors = 0;
        ToolWindowEP.EP_NAME.processWithPluginDescriptor(new BiConsumer<ToolWindowEP, PluginDescriptor>(handler2){
            final /* synthetic */ Function2 $handler;

            public final void accept(ToolWindowEP bean, PluginDescriptor pluginDescriptor) {
                try {
                    ToolWindowEP toolWindowEP = bean;
                    Intrinsics.checkExpressionValueIsNotNull((Object)toolWindowEP, (String)"bean");
                    PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pluginDescriptor2, (String)"pluginDescriptor");
                    this.$handler.invoke((Object)toolWindowEP, (Object)pluginDescriptor2);
                }
                catch (ProcessCanceledException e) {
                    throw (Throwable)e;
                }
                catch (Throwable e) {
                    ToolWindowManagerImplKt.access$getLOG$p().error("Cannot process toolwindow " + bean.id, e);
                }
            }
            {
                this.$handler = function2;
            }
        });
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ToolWindowManagerImpl.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$isInActiveToolWindow(Object component2, ToolWindowImpl activeToolWindow) {
        return ToolWindowManagerImplKt.isInActiveToolWindow(component2, activeToolWindow);
    }

    public static final /* synthetic */ int access$getActivateToolWindowVKsMask$p() {
        return ToolWindowManagerImplKt.getActivateToolWindowVKsMask();
    }

    public static final /* synthetic */ int access$keyCodeToInputMask(int code) {
        return ToolWindowManagerImplKt.keyCodeToInputMask(code);
    }

    public static final /* synthetic */ boolean access$areAllModifiersPressed(int modifiers, int mask) {
        return ToolWindowManagerImplKt.areAllModifiersPressed(modifiers, mask);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$processDescriptors(Function2 handler2) {
        ToolWindowManagerImplKt.processDescriptors((Function2<? super ToolWindowEP, ? super PluginDescriptor, Unit>)handler2);
    }

    public static final /* synthetic */ Icon access$findIconFromBean(ToolWindowEP bean, ToolWindowFactory factory) {
        return ToolWindowManagerImplKt.findIconFromBean(bean, factory);
    }

    public static final /* synthetic */ Supplier access$getStripeTitleSupplier(String id2, PluginDescriptor pluginDescriptor) {
        return ToolWindowManagerImplKt.getStripeTitleSupplier(id2, pluginDescriptor);
    }

    public static final /* synthetic */ boolean access$isStackEnabled$p() {
        return ToolWindowManagerImplKt.isStackEnabled();
    }

    public static final /* synthetic */ Rectangle access$getRootBounds(JFrame frame) {
        return ToolWindowManagerImplKt.getRootBounds(frame);
    }
}

