/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManagerListener;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.FrameBoundsConverter;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.platform.ProjectFrameAllocatorKt;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.platform.WindowUtils;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WindowManager", defaultStateAsResource=true, storages={@Storage(value="window.state.xml", roamingType=RoamingType.DISABLED), @Storage(value="window.manager.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public final class WindowManagerImpl
extends WindowManagerEx
implements PersistentStateComponentWithModificationTracker<Element> {
    private static final Logger LOG = Logger.getInstance(WindowManagerImpl.class);
    @NonNls
    private static final String FOCUSED_WINDOW_PROPERTY_NAME = "focusedWindow";
    @NonNls
    private static final String FRAME_ELEMENT = "frame";
    private Boolean myAlphaModeSupported;
    private final EventDispatcher<WindowManagerListener> myEventDispatcher = EventDispatcher.create(WindowManagerListener.class);
    private final WindowWatcher myWindowWatcher = new WindowWatcher();
    private DesktopLayout myLayout = new DesktopLayout();
    private final Map<Project, ProjectFrameHelper> myProjectToFrame = new HashMap<Project, ProjectFrameHelper>();
    private final Map<Project, Set<JDialog>> myDialogsToDispose = new THashMap<Project, Set<JDialog>>();
    final FrameInfoHelper defaultFrameInfoHelper = new FrameInfoHelper();
    private final WindowAdapter myActivationListener = new WindowAdapter(){

        @Override
        public void windowActivated(WindowEvent e) {
            Project project2;
            Window activeWindow = e.getWindow();
            ProjectFrameHelper frameHelper = ProjectFrameHelper.getFrameHelper(activeWindow);
            Project project3 = project2 = frameHelper == null ? null : frameHelper.getProject();
            if (project2 != null) {
                WindowManagerImpl.this.proceedDialogDisposalQueue(project2);
            }
        }
    };
    private final ComponentAdapter myFrameStateListener = new ComponentAdapter(){

        @Override
        public void componentMoved(@NotNull ComponentEvent e) {
            if (e == null) {
                2.$$$reportNull$$$0(0);
            }
            this.update(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.update(e);
        }

        private void update(@NotNull ComponentEvent e) {
            ProjectFrameHelper frameHelper;
            IdeFrameImpl frame;
            if (e == null) {
                2.$$$reportNull$$$0(1);
            }
            if (UIUtil.isClientPropertyTrue((frame = (IdeFrameImpl)e.getComponent()).getRootPane(), "dispose.temporary") || UIUtil.isClientPropertyTrue(frame.getRootPane(), "togglingFullScreenInProgress")) {
                return;
            }
            int extendedState = frame.getExtendedState();
            Rectangle bounds2 = frame.getBounds();
            JRootPane rootPane = frame.getRootPane();
            if (extendedState == 0 && rootPane != null) {
                rootPane.putClientProperty("normalBounds", bounds2);
            }
            if ((frameHelper = ProjectFrameHelper.getFrameHelper(frame)) == null) {
                return;
            }
            Project project2 = frameHelper.getProject();
            if (project2 == null) {
                WindowManagerImpl.this.defaultFrameInfoHelper.updateFrameInfo(frameHelper);
            } else if (!project2.isDisposed()) {
                ProjectFrameBounds projectFrameBounds = ProjectFrameBounds.getInstance(project2);
                projectFrameBounds.markDirty(FrameInfoHelper.isMaximized(extendedState) ? null : bounds2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/wm/impl/WindowManagerImpl$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "componentMoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public WindowManagerImpl() {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) {
            Disposer.register(application, this::disposeRootFrame);
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(FOCUSED_WINDOW_PROPERTY_NAME, this.myWindowWatcher);
    }

    public ProjectFrameHelper @NotNull [] getAllProjectFrames() {
        ProjectFrameHelper[] projectFrameHelperArray = this.myProjectToFrame.values().toArray(new ProjectFrameHelper[0]);
        if (projectFrameHelperArray == null) {
            WindowManagerImpl.$$$reportNull$$$0(0);
        }
        return projectFrameHelperArray;
    }

    @Override
    @NotNull
    public List<ProjectFrameHelper> getProjectFrameHelpers() {
        return new ArrayList<ProjectFrameHelper>(this.myProjectToFrame.values());
    }

    @Override
    public JFrame findVisibleFrame() {
        ProjectFrameHelper firstFrameHelper = ContainerUtil.getFirstItem(this.myProjectToFrame.values());
        return firstFrameHelper == null ? (JFrame)((Object)WelcomeFrame.getInstance()) : firstFrameHelper.getFrame();
    }

    @Override
    @Nullable
    public IdeFrameEx findFirstVisibleFrameHelper() {
        return ContainerUtil.getFirstItem(this.myProjectToFrame.values());
    }

    @Override
    public void addListener(@NotNull WindowManagerListener listener2) {
        if (listener2 == null) {
            WindowManagerImpl.$$$reportNull$$$0(1);
        }
        this.myEventDispatcher.addListener(listener2);
    }

    @Override
    public void removeListener(@NotNull WindowManagerListener listener2) {
        if (listener2 == null) {
            WindowManagerImpl.$$$reportNull$$$0(2);
        }
        this.myEventDispatcher.removeListener(listener2);
    }

    @Override
    public final Rectangle getScreenBounds() {
        return ScreenUtil.getAllScreensRectangle();
    }

    @Override
    public Rectangle getScreenBounds(@NotNull Project project2) {
        GraphicsDevice[] devices;
        if (project2 == null) {
            WindowManagerImpl.$$$reportNull$$$0(3);
        }
        GraphicsEnvironment environment2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point onScreen = this.getFrame(project2).getLocationOnScreen();
        for (GraphicsDevice device : devices = environment2.getScreenDevices()) {
            Rectangle bounds2 = device.getDefaultConfiguration().getBounds();
            if (!bounds2.contains(onScreen)) continue;
            return bounds2;
        }
        return null;
    }

    @Override
    public final boolean isInsideScreenBounds(int x, int y, int width) {
        return ScreenUtil.getAllScreensShape().contains(x, y, width, 1.0);
    }

    @Override
    public final boolean isAlphaModeSupported() {
        if (this.myAlphaModeSupported == null) {
            this.myAlphaModeSupported = WindowManagerImpl.calcAlphaModelSupported();
        }
        return this.myAlphaModeSupported;
    }

    private static boolean calcAlphaModelSupported() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (device.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
            return true;
        }
        try {
            return WindowUtils.isWindowAlphaSupported();
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public final void setAlphaModeRatio(Window window, float ratio) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
        if (ratio < 0.0f || ratio > 1.0f) {
            throw new IllegalArgumentException("ratio must be in [0..1] range. ratio=" + ratio);
        }
        if (!this.isAlphaModeSupported() || !this.isAlphaModeEnabled(window)) {
            return;
        }
        WindowManagerImpl.setAlphaMode(window, ratio);
    }

    private static void setAlphaMode(Window window, float ratio) {
        try {
            if (SystemInfo.isMacOSLeopard) {
                if (window instanceof JWindow) {
                    ((JWindow)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window instanceof JDialog) {
                    ((JDialog)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window instanceof JFrame) {
                    ((JFrame)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                }
            } else if (WindowManagerImpl.isTranslucencySupported()) {
                window.setOpacity(1.0f - ratio);
            } else {
                WindowUtils.setWindowAlpha((Window)window, (float)(1.0f - ratio));
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    @Override
    public void setWindowMask(Window window, @Nullable Shape mask) {
        try {
            if (WindowManagerImpl.isPerPixelTransparencySupported()) {
                window.setShape(mask);
            } else {
                WindowUtils.setWindowMask((Window)window, (Shape)mask);
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    @Override
    public void setWindowShadow(Window window, WindowManagerEx.WindowShadowMode mode) {
        if (window instanceof JWindow) {
            JRootPane root = ((JWindow)window).getRootPane();
            root.putClientProperty("Window.shadow", mode == WindowManagerEx.WindowShadowMode.DISABLED ? Boolean.FALSE : Boolean.TRUE);
            root.putClientProperty("Window.style", mode == WindowManagerEx.WindowShadowMode.SMALL ? "small" : null);
        }
    }

    @Override
    public void resetWindow(Window window) {
        try {
            if (!this.isAlphaModeSupported()) {
                return;
            }
            this.setWindowMask(window, null);
            WindowManagerImpl.setAlphaMode(window, 0.0f);
            this.setWindowShadow(window, WindowManagerEx.WindowShadowMode.NORMAL);
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    @Override
    public final boolean isAlphaModeEnabled(Window window) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
        return this.isAlphaModeSupported();
    }

    @Override
    public final void setAlphaModeEnabled(Window window, boolean state) {
        if (!window.isDisplayable() || !window.isShowing()) {
            throw new IllegalArgumentException("window must be displayable and showing. window=" + window);
        }
    }

    @Override
    public void hideDialog(JDialog dialog2, Project project2) {
        if (project2 == null) {
            dialog2.dispose();
        } else {
            IdeFrameImpl frame = this.getFrame(project2);
            if (frame.isActive()) {
                dialog2.dispose();
            } else {
                this.queueForDisposal(dialog2, project2);
                dialog2.setVisible(false);
            }
        }
    }

    @Override
    public void adjustContainerWindow(Component c, Dimension oldSize, Dimension newSize) {
        JBPopup popup2;
        if (c == null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(c);
        if (window instanceof JWindow && (popup2 = (JBPopup)((JWindow)window).getRootPane().getClientProperty("JBPopup")) != null && oldSize.height < newSize.height) {
            Dimension size = popup2.getSize();
            size.height += newSize.height - oldSize.height;
            popup2.setSize(size);
            popup2.moveToFitScreen();
        }
    }

    @Override
    public final void doNotSuggestAsParent(Window window) {
        this.myWindowWatcher.doNotSuggestAsParent(window);
    }

    @Override
    public final void dispatchComponentEvent(ComponentEvent e) {
        this.myWindowWatcher.dispatchComponentEvent(e);
    }

    @Override
    @Nullable
    public final Window suggestParentWindow(@Nullable Project project2) {
        return this.myWindowWatcher.suggestParentWindow(project2, this);
    }

    @Override
    public StatusBar getStatusBar(@NotNull Project project2) {
        ProjectFrameHelper frame;
        if (project2 == null) {
            WindowManagerImpl.$$$reportNull$$$0(4);
        }
        return (frame = this.getFrameHelper(project2)) == null ? null : frame.getStatusBar();
    }

    @Override
    public StatusBar getStatusBar(@NotNull Component c, @Nullable Project project2) {
        Component parent;
        if (c == null) {
            WindowManagerImpl.$$$reportNull$$$0(5);
        }
        if ((parent = UIUtil.findUltimateParent(c)) instanceof IdeFrame) {
            return ((IdeFrame)((Object)parent)).getStatusBar().findChild(c);
        }
        IdeFrame frame = this.findFrameFor(project2);
        if (frame != null) {
            return frame.getStatusBar().findChild(c);
        }
        assert (false) : "Cannot find status bar for " + c;
        return null;
    }

    @Override
    public IdeFrame findFrameFor(@Nullable Project project2) {
        IdeFrame frame;
        if (project2 != null) {
            IdeFrame ideFrame = frame = project2.isDefault() ? WelcomeFrame.getInstance() : this.getFrameHelper(project2);
            if (frame == null) {
                frame = this.getFrameHelper(null);
            }
        } else {
            frame = ProjectFrameHelper.getFrameHelper(this.getMostRecentFocusedWindow());
            if (frame == null) {
                frame = WindowManagerImpl.tryToFindTheOnlyFrame();
            }
        }
        return frame;
    }

    @Nullable
    private static IdeFrame tryToFindTheOnlyFrame() {
        IdeFrameImpl candidate = null;
        for (Frame each : Frame.getFrames()) {
            if (!(each instanceof IdeFrameImpl)) continue;
            if (candidate == null) {
                candidate = (IdeFrameImpl)each;
                continue;
            }
            candidate = null;
            break;
        }
        return candidate == null ? null : ProjectFrameHelper.getFrameHelper(candidate);
    }

    @Override
    public final IdeFrameImpl getFrame(@Nullable Project project2) {
        ProjectFrameHelper helper = this.getFrameHelper(project2);
        return helper == null ? null : helper.getFrame();
    }

    @Override
    @Nullable
    @ApiStatus.Internal
    public ProjectFrameHelper getFrameHelper(@Nullable Project project2) {
        return this.myProjectToFrame.get(project2);
    }

    @Override
    @Nullable
    public ProjectFrameHelper findFrameHelper(@Nullable Project project2) {
        if (project2 == null) {
            IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            if (frame == null) {
                return null;
            }
            project2 = frame.getProject();
            if (project2 == null) {
                return null;
            }
        }
        return this.getFrameHelper(project2);
    }

    @Nullable
    @ApiStatus.Internal
    public IdeRootPane getProjectFrameRootPane(@Nullable Project project2) {
        ProjectFrameHelper helper = this.myProjectToFrame.get(project2);
        return helper == null ? null : helper.getRootPane();
    }

    @Override
    @Nullable
    public IdeFrame getIdeFrame(@Nullable Project project2) {
        IdeFrame result2;
        if (project2 != null) {
            return this.getFrameHelper(project2);
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        IdeFrame ideFrame = result2 = window != null ? WindowManagerImpl.getIdeFrame(UIUtil.findUltimateParent(window)) : null;
        if (result2 != null) {
            return result2;
        }
        for (Frame each : Frame.getFrames()) {
            result2 = WindowManagerImpl.getIdeFrame(each);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    private static IdeFrame getIdeFrame(@NotNull Component component2) {
        if (component2 == null) {
            WindowManagerImpl.$$$reportNull$$$0(6);
        }
        if (component2 instanceof IdeFrameImpl) {
            return ProjectFrameHelper.getFrameHelper((IdeFrameImpl)component2);
        }
        if (component2 instanceof IdeFrame) {
            return (IdeFrame)((Object)component2);
        }
        return null;
    }

    @Nullable
    @ApiStatus.Internal
    public ProjectFrameHelper removeAndGetRootFrame() {
        return this.myProjectToFrame.remove(null);
    }

    public void assignFrame(@NotNull ProjectFrameHelper frameHelper, @NotNull Project project2) {
        if (frameHelper == null) {
            WindowManagerImpl.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            WindowManagerImpl.$$$reportNull$$$0(8);
        }
        LOG.assertTrue(!this.myProjectToFrame.containsKey(project2));
        this.myProjectToFrame.put(project2, frameHelper);
        frameHelper.setProject(project2);
        IdeFrameImpl frame = frameHelper.getFrame();
        frame.setTitle(FrameTitleBuilder.getInstance().getProjectTitle(project2));
        frame.addWindowListener(this.myActivationListener);
        frame.addComponentListener(this.myFrameStateListener);
    }

    @NotNull
    public final ProjectFrameHelper allocateFrame(@NotNull Project project2) {
        if (project2 == null) {
            WindowManagerImpl.$$$reportNull$$$0(9);
        }
        return this.allocateFrame(project2, () -> new ProjectFrameHelper(ProjectFrameAllocatorKt.createNewProjectFrame(false), null));
    }

    @NotNull
    public final ProjectFrameHelper allocateFrame(@NotNull Project project2, @NotNull @NotNull Supplier<@NotNull ? extends ProjectFrameHelper> projectFrameHelperFactory) {
        ProjectFrameHelper frame;
        if (project2 == null) {
            WindowManagerImpl.$$$reportNull$$$0(10);
        }
        if (projectFrameHelperFactory == null) {
            WindowManagerImpl.$$$reportNull$$$0(11);
        }
        if ((frame = this.getFrameHelper(project2)) != null) {
            this.myEventDispatcher.getMulticaster().frameCreated(frame);
            ProjectFrameHelper projectFrameHelper = frame;
            if (projectFrameHelper == null) {
                WindowManagerImpl.$$$reportNull$$$0(12);
            }
            return projectFrameHelper;
        }
        frame = this.removeAndGetRootFrame();
        boolean isNewFrame = frame == null;
        FrameInfo frameInfo = null;
        if (isNewFrame) {
            frame = projectFrameHelperFactory.get();
            frame.init();
            frameInfo = ProjectFrameBounds.getInstance(project2).getFrameInfoInDeviceSpace();
            if (frameInfo == null || frameInfo.getBounds() == null) {
                Project lastFocusedProject;
                IdeFrame lastFocusedFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
                Project project3 = lastFocusedProject = lastFocusedFrame == null ? null : lastFocusedFrame.getProject();
                if (lastFocusedProject != null) {
                    frameInfo = ProjectFrameBounds.getInstance(lastFocusedProject).getActualFrameInfoInDeviceSpace(frame, this);
                }
                if (frameInfo == null || frameInfo.getBounds() == null) {
                    frameInfo = this.defaultFrameInfoHelper.getInfo();
                }
            }
            if (frameInfo != null && frameInfo.getBounds() != null) {
                Rectangle bounds2;
                if (frameInfo != this.defaultFrameInfoHelper.getInfo()) {
                    this.defaultFrameInfoHelper.copyFrom(frameInfo);
                }
                if ((bounds2 = frameInfo.getBounds()) != null) {
                    frame.getFrame().setBounds(FrameBoundsConverter.convertFromDeviceSpaceAndFitToScreen(bounds2));
                }
            }
        }
        frame.setProject(project2);
        this.myProjectToFrame.put(project2, frame);
        if (isNewFrame) {
            if (frameInfo != null) {
                frame.getFrame().setExtendedState(frameInfo.getExtendedState());
            }
            frame.getFrame().setVisible(true);
            if (FrameInfoHelper.isFullScreenSupportedInCurrentOs() && frameInfo != null && frameInfo.getFullScreen()) {
                frame.toggleFullScreen(true);
            }
        }
        frame.getFrame().addWindowListener(this.myActivationListener);
        if (isNewFrame) {
            frame.getFrame().addComponentListener(this.myFrameStateListener);
            IdeMenuBar.installAppMenuIfNeeded(frame.getFrame());
        }
        this.myEventDispatcher.getMulticaster().frameCreated(frame);
        ProjectFrameHelper projectFrameHelper = frame;
        if (projectFrameHelper == null) {
            WindowManagerImpl.$$$reportNull$$$0(13);
        }
        return projectFrameHelper;
    }

    private void proceedDialogDisposalQueue(@NotNull Project project2) {
        Set<JDialog> dialogs;
        if (project2 == null) {
            WindowManagerImpl.$$$reportNull$$$0(14);
        }
        if ((dialogs = this.myDialogsToDispose.remove(project2)) != null) {
            dialogs.forEach(Window::dispose);
        }
    }

    private void queueForDisposal(@NotNull JDialog dialog2, @NotNull Project project2) {
        if (dialog2 == null) {
            WindowManagerImpl.$$$reportNull$$$0(15);
        }
        if (project2 == null) {
            WindowManagerImpl.$$$reportNull$$$0(16);
        }
        this.myDialogsToDispose.computeIfAbsent(project2, k -> new THashSet()).add(dialog2);
    }

    @Override
    public final void releaseFrame(@NotNull ProjectFrameHelper frameHelper) {
        if (frameHelper == null) {
            WindowManagerImpl.$$$reportNull$$$0(17);
        }
        this.myEventDispatcher.getMulticaster().beforeFrameReleased(frameHelper);
        IdeFrameImpl frame = frameHelper.getFrame();
        Project project2 = frameHelper.getProject();
        LOG.assertTrue(project2 != null);
        frame.removeWindowListener(this.myActivationListener);
        this.proceedDialogDisposalQueue(project2);
        frameHelper.setProject(null);
        ((Frame)frame).setTitle(null);
        frameHelper.setFileTitle(null, null);
        this.myProjectToFrame.remove(project2);
        if (this.myProjectToFrame.isEmpty() && !LightEdit.owns(project2)) {
            this.myProjectToFrame.put(null, frameHelper);
        } else {
            IdeStatusBarImpl statusBar = frameHelper.getStatusBar();
            if (statusBar != null) {
                Disposer.dispose(statusBar);
            }
            Disposer.dispose(frameHelper);
        }
    }

    public final void disposeRootFrame() {
        ProjectFrameHelper rootFrame;
        if (this.myProjectToFrame.size() == 1 && (rootFrame = this.removeAndGetRootFrame()) != null) {
            Disposer.dispose(rootFrame);
        }
    }

    @Override
    public final Window getMostRecentFocusedWindow() {
        return this.myWindowWatcher.getFocusedWindow();
    }

    @Override
    public final Component getFocusedComponent(@NotNull Window window) {
        if (window == null) {
            WindowManagerImpl.$$$reportNull$$$0(18);
        }
        return this.myWindowWatcher.getFocusedComponent(window);
    }

    @Override
    @Nullable
    public final Component getFocusedComponent(@Nullable Project project2) {
        return this.myWindowWatcher.getFocusedComponent(project2);
    }

    @Override
    public void noStateLoaded() {
        try {
            this.myLayout.readExternal(JDOMUtil.load("<layout>\n  <!-- left stripe -->\n  <window_info id=\"Project\" order=\"0\" weight=\"0.25\" content_ui=\"combo\" />\n  <window_info id=\"Structure\" order=\"1\" weight=\"0.25\" />\n  <!-- bottom stripe -->\n  <window_info id=\"Version Control\" anchor=\"bottom\" order=\"0\" />\n  <window_info id=\"Find\" anchor=\"bottom\" order=\"1\" />\n  <window_info id=\"Run\" anchor=\"bottom\" order=\"2\" />\n  <window_info id=\"Debug\" anchor=\"bottom\" order=\"3\" weight=\"0.4\" />\n  <window_info id=\"Inspection\" anchor=\"bottom\" order=\"4\" weight=\"0.4\" />\n</layout>"));
        }
        catch (IOException | JDOMException e) {
            LOG.error(e);
        }
    }

    @Override
    public void loadState(@NotNull Element state) {
        Element desktopElement;
        Element frameElement;
        if (state == null) {
            WindowManagerImpl.$$$reportNull$$$0(19);
        }
        if ((frameElement = state.getChild(FRAME_ELEMENT)) != null) {
            String extendedState;
            FrameInfo info = new FrameInfo();
            XmlSerializer.deserializeInto(frameElement, info);
            if (info.getExtendedState() == 0 && (extendedState = frameElement.getAttributeValue("extended-state")) != null) {
                info.setExtendedState(StringUtil.parseInt(extendedState, 0));
            }
            if ((info.getExtendedState() & 1) > 0) {
                info.setExtendedState(0);
            }
            this.defaultFrameInfoHelper.copyFrom(info);
        }
        if ((desktopElement = state.getChild("layout")) != null) {
            this.myLayout.readExternal(desktopElement);
        }
    }

    @Override
    public long getStateModificationCount() {
        return this.defaultFrameInfoHelper.getModificationCount() + this.myLayout.getStateModificationCount();
    }

    @Nullable
    @ApiStatus.Internal
    public FrameInfo getDefaultFrameInfo() {
        return this.defaultFrameInfoHelper.getInfo();
    }

    @Override
    public Element getState() {
        Element layoutElement;
        Element frameElement;
        Element state = new Element("state");
        FrameInfo frameInfo = this.defaultFrameInfoHelper.getInfo();
        Element element2 = frameElement = frameInfo == null ? null : XmlSerializer.serialize(frameInfo);
        if (frameElement != null) {
            state.addContent(frameElement);
        }
        if ((layoutElement = this.myLayout.writeExternal("layout")) != null) {
            state.addContent(layoutElement);
        }
        return state;
    }

    @Override
    @NotNull
    public final DesktopLayout getLayout() {
        DesktopLayout desktopLayout = this.myLayout;
        if (desktopLayout == null) {
            WindowManagerImpl.$$$reportNull$$$0(20);
        }
        return desktopLayout;
    }

    @Override
    public final void setLayout(@NotNull DesktopLayout layout) {
        if (layout == null) {
            WindowManagerImpl.$$$reportNull$$$0(21);
        }
        this.myLayout = layout.copy();
    }

    public WindowWatcher getWindowWatcher() {
        return this.myWindowWatcher;
    }

    @Override
    public boolean isFullScreenSupportedInCurrentOS() {
        return FrameInfoHelper.isFullScreenSupportedInCurrentOs();
    }

    static boolean isFloatingMenuBarSupported() {
        return !SystemInfo.isMac && FrameInfoHelper.isFullScreenSupportedInCurrentOs();
    }

    static boolean isTranslucencySupported() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return device.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
    }

    static boolean isPerPixelTransparencySupported() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return device.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/WindowManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameHelper";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFrameHelperFactory";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProjectFrames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/WindowManagerImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "allocateFrame";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayout";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getScreenBounds";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStatusBar";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIdeFrame";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "assignFrame";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "allocateFrame";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "proceedDialogDisposalQueue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "queueForDisposal";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "releaseFrame";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFocusedComponent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setLayout";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

