/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentComboLabel;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

final class ComboContentLayout
extends ContentLayout {
    ContentComboLabel myComboLabel;

    ComboContentLayout(ToolWindowContentUi ui) {
        super(ui);
    }

    @Override
    public void init(@NotNull ContentManager contentManager2) {
        if (contentManager2 == null) {
            ComboContentLayout.$$$reportNull$$$0(0);
        }
        this.reset();
        this.myIdLabel = new BaseLabel(this.myUi, false);
        this.myComboLabel = new ContentComboLabel(this);
    }

    @Override
    public void reset() {
        this.myIdLabel = null;
        this.myComboLabel = null;
    }

    @Override
    public void layout() {
        Rectangle bounds2 = this.myUi.getTabComponent().getBounds();
        JBDimension idSize = this.isIdVisible() ? this.myIdLabel.getPreferredSize() : JBUI.emptySize();
        int eachX = 0;
        int eachY = 0;
        this.myIdLabel.setBounds(eachX, eachY, idSize.width, bounds2.height);
        Dimension comboSize = this.myComboLabel.getPreferredSize();
        int spaceLeft = bounds2.width - (eachX += idSize.width) - (this.isToDrawCombo() && this.isIdVisible() ? 3 : 0);
        int width = comboSize.width;
        if (width > spaceLeft) {
            width = spaceLeft;
        }
        this.myComboLabel.setBounds(eachX, eachY, width, bounds2.height);
    }

    @Override
    public int getMinimumWidth() {
        return this.myIdLabel != null ? this.myIdLabel.getPreferredSize().width : 0;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isToDrawCombo() || !this.myIdLabel.isVisible()) {
            return;
        }
        Rectangle r = this.myIdLabel.getBounds();
        g.setColor(ColorUtil.toAlpha(UIUtil.getLabelForeground(), 20));
        g.drawLine(r.width, 0, r.width, r.height);
        g.setColor(UIUtil.CONTRAST_BORDER_COLOR);
        g.drawLine(r.width - 1, 0, r.width - 1, r.height);
    }

    @Override
    public void update() {
        this.updateIdLabel(this.myIdLabel);
        this.myComboLabel.update();
    }

    @Override
    public void rebuild() {
        this.myUi.getTabComponent().removeAll();
        this.myUi.getTabComponent().add(this.myIdLabel);
        ToolWindowContentUi.initMouseListeners(this.myIdLabel, this.myUi, true);
        this.myUi.getTabComponent().add(this.myComboLabel);
        ToolWindowContentUi.initMouseListeners(this.myComboLabel, this.myUi, false);
    }

    boolean isToDrawCombo() {
        ContentManager manager = this.myUi.getContentManager();
        return manager != null && manager.getContentCount() > 1;
    }

    @Override
    public void contentAdded(ContentManagerEvent event) {
    }

    @Override
    public void contentRemoved(ContentManagerEvent event) {
    }

    @Override
    public void showContentPopup(ListPopup listPopup) {
        int width = this.myComboLabel.getSize().width;
        listPopup.setMinimumSize(new Dimension(width, 0));
        listPopup.show(new RelativePoint(this.myComboLabel, new Point(0, this.myComboLabel.getHeight())));
    }

    @Override
    public String getCloseActionName() {
        return "Close View";
    }

    @Override
    public String getCloseAllButThisActionName() {
        return "Close Other Views";
    }

    @Override
    public String getPreviousContentActionName() {
        return "Select Previous View";
    }

    @Override
    public String getNextContentActionName() {
        return "Select Next View";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentManager", "com/intellij/openapi/wm/impl/content/ComboContentLayout", "init"));
    }
}

