/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.UIBundle;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ColumnSelectionModePanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget,
PropertyChangeListener {
    private final TextPanel myTextPanel;

    public ColumnSelectionModePanel(@NotNull Project project2) {
        if (project2 == null) {
            ColumnSelectionModePanel.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myTextPanel = new TextPanel();
        this.myTextPanel.setVisible(false);
    }

    @Override
    @NotNull
    public String ID() {
        return "InsertOverwrite";
    }

    @Override
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    @Override
    public StatusBarWidget copy() {
        return new ColumnSelectionModePanel(this.getProject());
    }

    @Override
    public JComponent getComponent() {
        return this.myTextPanel;
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            ColumnSelectionModePanel.$$$reportNull$$$0(1);
        }
        super.install(statusBar);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
        Disposer.register(this, () -> KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this));
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        if (multicaster instanceof EditorEventMulticasterEx) {
            ((EditorEventMulticasterEx)multicaster).addPropertyChangeListener(this, this);
        }
        this.updateStatus();
    }

    private void updateStatus() {
        if (this.myProject.isDisposed()) {
            return;
        }
        Editor editor = this.getFocusedEditor();
        if (editor != null && !this.isOurEditor(editor)) {
            return;
        }
        if (editor == null || !editor.isColumnMode()) {
            this.myTextPanel.setVisible(false);
        } else {
            this.myTextPanel.setVisible(true);
            this.myTextPanel.setText(UIBundle.message("status.bar.column.status.text", new Object[0]));
            this.myTextPanel.setToolTipText(UIBundle.message("status.bar.column.status.tooltip.text", new Object[0]));
        }
    }

    @Override
    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            ColumnSelectionModePanel.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ColumnSelectionModePanel.$$$reportNull$$$0(3);
        }
        this.updateStatus();
    }

    @Override
    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            ColumnSelectionModePanel.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            ColumnSelectionModePanel.$$$reportNull$$$0(5);
        }
        this.updateStatus();
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        String propertyName;
        if (evt == null) {
            ColumnSelectionModePanel.$$$reportNull$$$0(6);
        }
        if ("insertMode".equals(propertyName = evt.getPropertyName()) || "columnMode".equals(propertyName) || "focusOwner".equals(propertyName)) {
            this.updateStatus();
        }
    }

    @Override
    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            ColumnSelectionModePanel.$$$reportNull$$$0(7);
        }
        this.updateStatus();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evt";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/status/ColumnSelectionModePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpened";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fileClosed";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

