/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.LineSeparatorPanel;
import com.intellij.openapi.wm.impl.status.widget.StatusBarEditorBasedWidgetFactory;
import com.intellij.ui.UIBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class LineSeparatorWidgetFactory
extends StatusBarEditorBasedWidgetFactory {
    @Override
    @NotNull
    public String getId() {
        return "LineSeparator";
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = UIBundle.message("status.bar.line.separator.widget.name", new Object[0]);
        if (string == null) {
            LineSeparatorWidgetFactory.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project2) {
        if (project2 == null) {
            LineSeparatorWidgetFactory.$$$reportNull$$$0(1);
        }
        return new LineSeparatorPanel(project2);
    }

    @Override
    public void disposeWidget(@NotNull StatusBarWidget widget) {
        if (widget == null) {
            LineSeparatorWidgetFactory.$$$reportNull$$$0(2);
        }
        Disposer.dispose(widget);
    }

    @Override
    public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            LineSeparatorWidgetFactory.$$$reportNull$$$0(3);
        }
        if (!super.canBeEnabledOn(statusBar)) {
            return false;
        }
        FileEditor editor = this.getFileEditor(statusBar);
        if (editor != null) {
            VirtualFile file2 = editor.getFile();
            return file2 != null && LoadTextUtil.detectLineSeparator(file2, true) != null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/LineSeparatorWidgetFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/LineSeparatorWidgetFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "disposeWidget";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canBeEnabledOn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

