/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryUsagePanel
extends TextPanel
implements CustomStatusBarWidget,
Activatable {
    public static final String WIDGET_ID = "Memory";
    private static final Color USED_COLOR = JBColor.namedColor("MemoryIndicator.usedBackground", new JBColor(Gray._185, Gray._110));
    private static final Color UNUSED_COLOR = JBColor.namedColor("MemoryIndicator.allocatedBackground", new JBColor(Gray._215, Gray._90));
    private long myLastAllocated = -1L;
    private long myLastUsed = -1L;
    private ScheduledFuture<?> myFuture;
    private final long myMaxMemory = Math.min(Runtime.getRuntime().maxMemory() / 0x100000L, 9999L);
    private StatusBar myStatusBar;

    public MemoryUsagePanel() {
        this.setFocusable(false);
        this.setTextAlignment(0.5f);
        new ClickListener(){

            @Override
            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                System.gc();
                MemoryUsagePanel.this.updateState();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/MemoryUsagePanel$1", "onClick"));
            }
        }.installOn(this, true);
        this.setBorder(JBUI.Borders.empty(0, 2));
        this.updateUI();
        new UiNotifyConnector(this, this);
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public void showNotify() {
        this.myFuture = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(this::updateState, 1L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public void hideNotify() {
        if (this.myFuture != null) {
            this.myFuture.cancel(true);
            this.myFuture = null;
        }
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            MemoryUsagePanel.$$$reportNull$$$0(0);
        }
        if (statusBar instanceof IdeStatusBarImpl) {
            ((IdeStatusBarImpl)statusBar).setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 6));
        }
    }

    @Override
    public void dispose() {
        if (this.myStatusBar instanceof IdeStatusBarImpl) {
            ((IdeStatusBarImpl)this.myStatusBar).setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        }
        this.myStatusBar = null;
    }

    @Override
    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    @Override
    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    public void setShowing(boolean showing2) {
        if (showing2 != this.isVisible()) {
            this.setVisible(showing2);
            this.revalidate();
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        int barWidth = size.width;
        Runtime rt = Runtime.getRuntime();
        long maxMem = rt.maxMemory();
        long allocatedMem = rt.totalMemory();
        long unusedMem = rt.freeMemory();
        long usedMem = allocatedMem - unusedMem;
        int usedBarLength = (int)((long)barWidth * usedMem / maxMem);
        int unusedBarLength = (int)((long)size.height * unusedMem / maxMem);
        g.setColor(UIUtil.getPanelBackground());
        g.fillRect(0, 0, barWidth, size.height - 1);
        g.setColor(USED_COLOR);
        g.fillRect(0, 0, usedBarLength, size.height - 1);
        g.setColor(UNUSED_COLOR);
        g.fillRect(usedBarLength, 0, unusedBarLength, size.height - 1);
        super.paintComponent(g);
    }

    @Override
    protected String getTextForPreferredSize() {
        long sample = this.myMaxMemory < 1000L ? 999L : 9999L;
        return " " + UIBundle.message("memory.usage.panel.message.text", sample, sample);
    }

    private void updateState() {
        if (!this.isShowing()) {
            return;
        }
        Runtime rt = Runtime.getRuntime();
        long maxMem = rt.maxMemory() / 0x100000L;
        long allocatedMem = rt.totalMemory() / 0x100000L;
        long usedMem = allocatedMem - rt.freeMemory() / 0x100000L;
        String text2 = UIBundle.message("memory.usage.panel.message.text", usedMem, maxMem);
        if (allocatedMem != this.myLastAllocated || usedMem != this.myLastUsed || !StringUtil.equals(text2, this.getText())) {
            this.myLastAllocated = allocatedMem;
            this.myLastUsed = usedMem;
            this.setText(text2);
            this.setToolTipText(UIBundle.message("memory.usage.panel.statistics.message", maxMem, allocatedMem, usedMem));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/openapi/wm/impl/status/MemoryUsagePanel", "install"));
    }
}

