/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatusBarUtil {
    private static final Logger LOG = Logger.getInstance(StatusBar.class);

    private StatusBarUtil() {
    }

    @Nullable
    public static Editor getCurrentTextEditor(@Nullable StatusBar statusBar) {
        Editor editor;
        if (statusBar == null) {
            return null;
        }
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor(statusBar);
        if (fileEditor instanceof TextEditor && StatusBarUtil.ensureValidEditorFile(editor = ((TextEditor)fileEditor).getEditor())) {
            return editor;
        }
        Project project2 = statusBar.getProject();
        if (project2 == null || project2.isDisposed()) {
            return null;
        }
        FileEditorManager manager = FileEditorManager.getInstance(project2);
        Editor editor2 = manager.getSelectedTextEditor();
        if (editor2 != null && StatusBarUtil.ensureValidEditorFile(editor2) && WindowManager.getInstance().getStatusBar(editor2.getComponent(), project2) == statusBar) {
            return editor2;
        }
        return null;
    }

    @Nullable
    public static FileEditor getCurrentFileEditor(@Nullable StatusBar statusBar) {
        EditorWithProviderComposite editor;
        if (statusBar == null) {
            return null;
        }
        Project project2 = statusBar.getProject();
        if (project2 == null) {
            return null;
        }
        DockContainer c = DockManager.getInstance(project2).getContainerFor(statusBar.getComponent());
        EditorsSplitters splitters = null;
        if (c instanceof DockableEditorTabbedContainer) {
            splitters = ((DockableEditorTabbedContainer)c).getSplitters();
        }
        if (splitters != null && splitters.getCurrentWindow() != null && (editor = splitters.getCurrentWindow().getSelectedEditor()) != null) {
            return editor.getSelectedWithProvider().getFileEditor();
        }
        return null;
    }

    public static void setStatusBarInfo(@NotNull Project project2, @NotNull @Nls String message) {
        StatusBar statusBar;
        if (project2 == null) {
            StatusBarUtil.$$$reportNull$$$0(0);
        }
        if (message == null) {
            StatusBarUtil.$$$reportNull$$$0(1);
        }
        if ((statusBar = WindowManager.getInstance().getStatusBar(project2)) != null) {
            statusBar.setInfo(message);
        }
    }

    private static boolean ensureValidEditorFile(@NotNull Editor editor) {
        if (editor == null) {
            StatusBarUtil.$$$reportNull$$$0(2);
        }
        Document document = editor.getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && !file2.isValid()) {
            Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(file2);
            Project project2 = editor.getProject();
            Boolean fileIsOpen = project2 == null ? null : Boolean.valueOf(ArrayUtil.contains(file2, FileEditorManager.getInstance(project2).getOpenFiles()));
            LOG.error("Returned editor for invalid file: " + editor + "; disposed=" + editor.isDisposed() + "; file " + file2.getClass() + "; cached document exists: " + (cachedDocument != null) + "; same as document: " + (cachedDocument == document) + "; file is open: " + fileIsOpen);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/status/StatusBarUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setStatusBarInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureValidEditorFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

