/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HectorComponent;
import com.intellij.codeInsight.daemon.impl.HectorComponentFactory;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSettingListener;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TogglePopupHintsPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
StatusBarWidget.IconPresentation {
    public static final String ID = "InspectionProfile";
    private Icon myCurrentIcon;
    private String myToolTipText;

    public TogglePopupHintsPanel(@NotNull Project project2) {
        if (project2 == null) {
            TogglePopupHintsPanel.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myCurrentIcon = IconLoader.getDisabledIcon(AllIcons.Ide.HectorOff);
    }

    @Override
    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            TogglePopupHintsPanel.$$$reportNull$$$0(1);
        }
        this.updateStatus();
    }

    @Override
    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            TogglePopupHintsPanel.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            TogglePopupHintsPanel.$$$reportNull$$$0(3);
        }
        this.updateStatus();
    }

    @Override
    public StatusBarWidget copy() {
        return new TogglePopupHintsPanel(this.getProject());
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myCurrentIcon;
    }

    @Override
    public String getTooltipText() {
        return this.myToolTipText;
    }

    @Override
    public Consumer<MouseEvent> getClickConsumer() {
        return e -> {
            PsiFile file2 = this.getCurrentFile();
            if (file2 != null) {
                if (!DaemonCodeAnalyzer.getInstance(file2.getProject()).isHighlightingAvailable(file2)) {
                    return;
                }
                HectorComponent component2 = ServiceManager.getService(this.myProject, HectorComponentFactory.class).create(file2);
                component2.showComponent(e.getComponent(), (Function1<? super Dimension, ? extends Point>)((Function1)d -> new Point(-d.width, -d.height)));
            }
        };
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            TogglePopupHintsPanel.$$$reportNull$$$0(4);
        }
        super.install(statusBar);
        this.myConnection.subscribe(PowerSaveMode.TOPIC, this::updateStatus);
        this.myConnection.subscribe(ProfileChangeAdapter.TOPIC, new ProfileChangeAdapter(){

            @Override
            public void profilesInitialized() {
                TogglePopupHintsPanel.this.updateStatus();
            }

            @Override
            public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
                TogglePopupHintsPanel.this.updateStatus();
            }

            @Override
            public void profileChanged(InspectionProfile profile) {
                TogglePopupHintsPanel.this.updateStatus();
            }
        });
        this.myConnection.subscribe(FileHighlightingSettingListener.SETTING_CHANGE, (__, ___) -> this.updateStatus());
        this.updateStatus();
    }

    @Override
    @NotNull
    public String ID() {
        return ID;
    }

    @Override
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    public void clear() {
        this.myCurrentIcon = IconLoader.getDisabledIcon(AllIcons.Ide.HectorOff);
        this.myToolTipText = null;
        this.myStatusBar.updateWidget(this.ID());
    }

    public void updateStatus() {
        UIUtil.invokeLaterIfNeeded(() -> this.updateStatus(this.getCurrentFile()));
    }

    private void updateStatus(PsiFile file2) {
        if (this.isDisposed()) {
            return;
        }
        if (TogglePopupHintsPanel.isStateChangeable(file2)) {
            if (PowerSaveMode.isEnabled()) {
                this.myCurrentIcon = IconLoader.getDisabledIcon(AllIcons.Ide.HectorOff);
                this.myToolTipText = "Code analysis is disabled in power save mode.\n";
            } else if (HighlightingLevelManager.getInstance(this.getProject()).shouldInspect(file2)) {
                this.myCurrentIcon = AllIcons.Ide.HectorOn;
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(file2.getProject()).getCurrentProfile();
                if (profile.wasInitialized()) {
                    this.myToolTipText = "Current inspection profile: " + profile.getName() + ".\n";
                }
            } else if (HighlightingLevelManager.getInstance(this.getProject()).shouldHighlight(file2)) {
                this.myCurrentIcon = AllIcons.Ide.HectorSyntax;
                this.myToolTipText = "Highlighting level is: Syntax.\n";
            } else {
                this.myCurrentIcon = AllIcons.Ide.HectorOff;
                this.myToolTipText = "Inspections are off.\n";
            }
            this.myToolTipText = this.myToolTipText + UIBundle.message("popup.hints.panel.click.to.configure.highlighting.tooltip.text", new Object[0]);
        } else {
            this.myCurrentIcon = file2 != null ? IconLoader.getDisabledIcon(AllIcons.Ide.HectorOff) : null;
            this.myToolTipText = null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }

    private static boolean isStateChangeable(PsiFile file2) {
        return file2 != null && DaemonCodeAnalyzer.getInstance(file2.getProject()).isHighlightingAvailable(file2);
    }

    @Nullable
    private PsiFile getCurrentFile() {
        VirtualFile virtualFile2 = this.getSelectedFile();
        if (virtualFile2 != null && virtualFile2.isValid()) {
            return PsiManager.getInstance(this.getProject()).findFile(virtualFile2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpened";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

