/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToggleReadOnlyAttributePanel
implements StatusBarWidget.Multiframe,
StatusBarWidget.IconPresentation {
    private StatusBar myStatusBar;

    @Override
    @Nullable
    public Icon getIcon() {
        if (!this.isReadonlyApplicable()) {
            return null;
        }
        VirtualFile virtualFile2 = this.getCurrentFile();
        return virtualFile2 == null || virtualFile2.isWritable() ? AllIcons.Ide.Readwrite : AllIcons.Ide.Readonly;
    }

    @Override
    @NotNull
    public String ID() {
        return "ReadOnlyAttribute";
    }

    @Override
    public StatusBarWidget copy() {
        return new ToggleReadOnlyAttributePanel();
    }

    @Override
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    @Override
    public void dispose() {
        this.myStatusBar = null;
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            ToggleReadOnlyAttributePanel.$$$reportNull$$$0(0);
        }
        this.myStatusBar = statusBar;
        this.myStatusBar.updateWidget(this.ID());
        ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(VirtualFileManager.VFS_CHANGES, new BulkVirtualFileListenerAdapter(new VirtualFileListener(){

            @Override
            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("writable".equals(event.getPropertyName())) {
                    ToggleReadOnlyAttributePanel.this.myStatusBar.updateWidget(ToggleReadOnlyAttributePanel.this.ID());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel$1", "propertyChanged"));
            }
        }));
        Project project2 = statusBar.getProject();
        if (project2 == null) {
            return;
        }
        project2.getMessageBus().connect(this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, new FileEditorManagerListener(){

            @Override
            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (ToggleReadOnlyAttributePanel.this.myStatusBar != null) {
                    ToggleReadOnlyAttributePanel.this.myStatusBar.updateWidget(ToggleReadOnlyAttributePanel.this.ID());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel$2", "selectionChanged"));
            }
        });
    }

    @Override
    public String getTooltipText() {
        VirtualFile virtualFile2 = this.getCurrentFile();
        int writable = virtualFile2 == null || virtualFile2.isWritable() ? 1 : 0;
        int readonly = writable == 1 ? 0 : 1;
        return ActionsBundle.message("action.ToggleReadOnlyAttribute.files", readonly, writable, 1, 0);
    }

    @Override
    public Consumer<MouseEvent> getClickConsumer() {
        return mouseEvent -> {
            VirtualFile file2 = this.getCurrentFile();
            if (!ToggleReadOnlyAttributePanel.isReadOnlyApplicableForFile(file2)) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            try {
                WriteAction.run(() -> ReadOnlyAttributeUtil.setReadOnlyAttribute(file2, file2.isWritable()));
                this.myStatusBar.updateWidget(this.ID());
            }
            catch (IOException e) {
                Messages.showMessageDialog(this.getProject(), e.getMessage(), UIBundle.message("error.dialog.title", new Object[0]), Messages.getErrorIcon());
            }
        };
    }

    private boolean isReadonlyApplicable() {
        VirtualFile file2 = this.getCurrentFile();
        return ToggleReadOnlyAttributePanel.isReadOnlyApplicableForFile(file2);
    }

    private static boolean isReadOnlyApplicableForFile(@Nullable VirtualFile file2) {
        return file2 != null && !file2.getFileSystem().isReadOnly();
    }

    @Nullable
    private Project getProject() {
        return this.myStatusBar != null ? this.myStatusBar.getProject() : null;
    }

    @Nullable
    private VirtualFile getCurrentFile() {
        Project project2 = this.getProject();
        if (project2 == null) {
            return null;
        }
        EditorsSplitters splitters = FileEditorManagerEx.getInstanceEx(project2).getSplittersFor(this.myStatusBar.getComponent());
        return splitters.getCurrentFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel", "install"));
    }
}

