/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Deque;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicIntegerArray;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class WriteThreadIndicatorWidgetFactory
implements StatusBarWidgetFactory {
    private static final String ID = "WriteThread";

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = UIBundle.message("status.bar.write.thread.widget.name", new Object[0]);
        if (string == null) {
            WriteThreadIndicatorWidgetFactory.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2) {
        if (project2 == null) {
            WriteThreadIndicatorWidgetFactory.$$$reportNull$$$0(1);
        }
        return ApplicationManager.getApplication().isInternal();
    }

    @Override
    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project2) {
        if (project2 == null) {
            WriteThreadIndicatorWidgetFactory.$$$reportNull$$$0(2);
        }
        return new WriteThreadWidget();
    }

    @Override
    public void disposeWidget(@NotNull StatusBarWidget widget) {
        if (widget == null) {
            WriteThreadIndicatorWidgetFactory.$$$reportNull$$$0(3);
        }
        Disposer.dispose(widget);
    }

    @Override
    public boolean isConfigurable() {
        return ApplicationManager.getApplication().isInternal();
    }

    @Override
    public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            WriteThreadIndicatorWidgetFactory.$$$reportNull$$$0(4);
        }
        return ApplicationManager.getApplication().isInternal();
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/WriteThreadIndicatorWidgetFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/WriteThreadIndicatorWidgetFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "disposeWidget";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canBeEnabledOn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WriteThreadWidget
    implements CustomStatusBarWidget {
        private static final Dimension WIDGET_SIZE = new Dimension(100, 20);
        private final JPanel myComponent = new MyComponent();
        private final Deque<AtomicIntegerArray> myStatsDeque = new LinkedBlockingDeque<AtomicIntegerArray>();
        private volatile AtomicIntegerArray myCurrentStats = new AtomicIntegerArray(4);
        private final javax.swing.Timer myTimer = new javax.swing.Timer(500, e -> {
            this.myStatsDeque.add(this.myCurrentStats);
            while (this.myStatsDeque.size() > WriteThreadWidget.WIDGET_SIZE.width) {
                this.myStatsDeque.pop();
            }
            this.myCurrentStats = new AtomicIntegerArray(4);
            this.myComponent.repaint();
        });
        private final Timer ourTimer2 = new Timer("Write Thread Widget Timer");

        private WriteThreadWidget() {
        }

        @Override
        public JComponent getComponent() {
            return this.myComponent;
        }

        @Override
        @NotNull
        public String ID() {
            return WriteThreadIndicatorWidgetFactory.ID;
        }

        @Override
        public void install(@NotNull StatusBar statusBar) {
            ApplicationImpl application;
            if (statusBar == null) {
                WriteThreadWidget.$$$reportNull$$$0(0);
            }
            if ((application = ObjectUtils.tryCast(ApplicationManager.getApplication(), ApplicationImpl.class)) == null) {
                return;
            }
            this.ourTimer2.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    ThreeState currentValue = application.isCurrentWriteOnEdt();
                    AtomicIntegerArray currentStats = myCurrentStats;
                    currentStats.incrementAndGet(currentValue.ordinal());
                    currentStats.incrementAndGet(3);
                }
            }, 0L, 1L);
            this.myTimer.start();
        }

        @Override
        public void dispose() {
            this.ourTimer2.cancel();
            this.myTimer.stop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/openapi/wm/impl/status/WriteThreadIndicatorWidgetFactory$WriteThreadWidget", "install"));
        }

        private class MyComponent
        extends JPanel {
            private MyComponent() {
            }

            @Override
            public Dimension getPreferredSize() {
                return WIDGET_SIZE;
            }

            @Override
            public Dimension getMinimumSize() {
                return WIDGET_SIZE;
            }

            @Override
            public Dimension getMaximumSize() {
                return WIDGET_SIZE;
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (g instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g;
                    int offsetx = 0;
                    for (AtomicIntegerArray stats : WriteThreadWidget.this.myStatsDeque) {
                        g2d.setColor(JBColor.GRAY);
                        g2d.fillRect(offsetx, 0, 1, WIDGET_SIZE.height);
                        int sum = stats.get(3);
                        int offsety = 0;
                        if (sum > 0) {
                            g2d.setColor(JBColor.RED);
                            int height = (stats.get(0) * WIDGET_SIZE.height + sum - 1) / sum;
                            g2d.fillRect(offsetx, WIDGET_SIZE.height - offsety - height, 1, height);
                            offsety -= height;
                            g2d.setColor(JBColor.GREEN);
                            height = (stats.get(1) * WIDGET_SIZE.height + sum - 1) / sum;
                            g2d.fillRect(offsetx, WIDGET_SIZE.height - offsety - height, 1, height);
                        }
                        ++offsetx;
                    }
                }
            }
        }
    }
}

