/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.IdeMessagePanel;
import com.intellij.diagnostic.MessagePool;
import com.intellij.icons.AllIcons;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.PluginDropHandler;
import com.intellij.idea.SplashManager;
import com.intellij.jdkEx.JdkEx;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.widget.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomFrameDialogContent;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.NewRecentProjectPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrameUpdater;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomePopupAction;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.Gray;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBSlidingPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlatWelcomeFrame
extends JFrame
implements IdeFrame,
Disposable,
AccessibleContextAccessor,
WelcomeFrameUpdater {
    public static final String BOTTOM_PANEL = "BOTTOM_PANEL";
    private static final String ACTION_GROUP_KEY = "ACTION_GROUP_KEY";
    public static final int DEFAULT_HEIGHT = 460;
    public static final int MAX_DEFAULT_WIDTH = 777;
    private BalloonLayout myBalloonLayout;
    private final FlatWelcomeScreen myScreen;
    private boolean myDisposed;

    public FlatWelcomeFrame() {
        SplashManager.hideBeforeShow(this);
        JRootPane rootPane = this.getRootPane();
        this.myScreen = new FlatWelcomeScreen();
        IdeGlassPaneImpl glassPane = new IdeGlassPaneImpl(rootPane){

            @Override
            public void addNotify() {
                super.addNotify();
                ApplicationManager.getApplication().invokeLater(() -> JBProtocolCommand.handleCurrentCommand());
            }
        };
        this.setGlassPane(glassPane);
        glassPane.setVisible(false);
        int defaultHeight = 460;
        if (IdeFrameDecorator.isCustomDecorationActive()) {
            JComponent holder = CustomFrameDialogContent.getCustomContentHolder(this, this.myScreen.getWelcomePanel(), UIManager.getColor("WelcomeScreen.background"));
            this.setContentPane(holder);
            if (holder instanceof CustomFrameDialogContent) {
                defaultHeight += ((CustomFrameDialogContent)holder).getHeaderHeight();
            }
        } else {
            this.setContentPane(this.myScreen.getWelcomePanel());
        }
        this.setTitle(this.getWelcomeFrameTitle());
        AppUIUtil.updateWindowIcon(this);
        int width = RecentProjectListActionProvider.getInstance().getActions(false).size() == 0 ? 666 : 777;
        this.getRootPane().setPreferredSize(JBUI.size(width, defaultHeight));
        this.setResizable(false);
        Dimension size = this.getPreferredSize();
        Point location2 = WindowStateService.getInstance().getLocation("WELCOME_SCREEN");
        Rectangle screenBounds = ScreenUtil.getScreenRectangle(location2 != null ? location2 : new Point(0, 0));
        this.setBounds(screenBounds.x + (screenBounds.width - size.width) / 2, screenBounds.y + (screenBounds.height - size.height) / 3, size.width, size.height);
        this.setAutoRequestFocus(false);
        UiNotifyConnector.doWhenFirstShown((Component)this, this::pack);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(this);
        connection.subscribe(ProjectManager.TOPIC, new ProjectManagerListener(){

            @Override
            public void projectOpened(@NotNull Project project2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                Disposer.dispose(FlatWelcomeFrame.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$2", "projectOpened"));
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, new AppLifecycleListener(){

            @Override
            public void appClosing() {
                FlatWelcomeFrame.saveLocation(FlatWelcomeFrame.this.getBounds());
            }
        });
        this.myBalloonLayout = new WelcomeBalloonLayoutImpl(rootPane, JBUI.insets(8), this.myScreen.myEventListener, this.myScreen.myEventLocation);
        WelcomeFrame.setupCloseAction(this);
        MnemonicHelper.init(this);
        Disposer.register(ApplicationManager.getApplication(), this);
        UIUtil.decorateWindowHeader(this.getRootPane());
        UIUtil.setCustomTitleBar(this, this.getRootPane(), runnable2 -> Disposer.register(this, () -> runnable2.run()));
    }

    @Override
    public void addNotify() {
        if (IdeFrameDecorator.isCustomDecorationActive()) {
            JdkEx.setHasCustomDecoration(this);
        }
        super.addNotify();
    }

    @Override
    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        super.dispose();
        if (this.myBalloonLayout != null) {
            ((BalloonLayoutImpl)this.myBalloonLayout).dispose();
            this.myBalloonLayout = null;
        }
        Disposer.dispose(this.myScreen);
        WelcomeFrame.resetInstance();
    }

    private static void saveLocation(@NotNull Rectangle location2) {
        if (location2 == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(0);
        }
        Point middle2 = new Point(location2.x + location2.width / 2, location2.y + location2.height / 2);
        WindowStateService.getInstance().putLocation("WELCOME_SCREEN", middle2);
    }

    @Override
    @Nullable
    public StatusBar getStatusBar() {
        return null;
    }

    public static Color getMainBackground() {
        return JBColor.namedColor("WelcomeScreen.background", new JBColor(0xF7F7F7, 4540234));
    }

    public static Color getProjectsBackground() {
        return JBColor.namedColor("WelcomeScreen.Projects.background", new JBColor(Gray.xFF, Gray.x39));
    }

    public static Color getLinkNormalColor() {
        return new JBColor(Gray._0, Gray.xBB);
    }

    public static Color getListSelectionColor(boolean hasFocus) {
        return hasFocus ? JBColor.namedColor("WelcomeScreen.Projects.selectionBackground", new JBColor(3700182, 4943535)) : JBColor.namedColor("WelcomeScreen.Projects.selectionInactiveBackground", new JBColor(Gray.xDD, Gray.x45));
    }

    public static Color getActionLinkSelectionColor() {
        return new JBColor(14411253, 4741237);
    }

    public static JBColor getSeparatorColor() {
        return JBColor.namedColor("WelcomeScreen.separatorColor", new JBColor(Gray.xEC, new Color(72, 75, 78)));
    }

    @Override
    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }

    protected String getWelcomeFrameTitle() {
        String suffix;
        String title = IdeBundle.message("label.welcome.to.0", ApplicationNamesInfo.getInstance().getFullProductName());
        if (Boolean.getBoolean("ide.ui.version.in.title")) {
            title = title + ' ' + ApplicationInfo.getInstance().getFullVersion();
        }
        if ((suffix = ProjectFrameHelper.getSuperUserSuffix()) != null) {
            title = title + " (" + suffix + ")";
        }
        return title;
    }

    @NotNull
    public static JComponent getPreferredFocusedComponent(@NotNull Pair<JPanel, JBList<AnAction>> pair) {
        JBTextField textField2;
        if (pair == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(1);
        }
        if (((JBList)pair.second).getModel().getSize() == 1 && (textField2 = UIUtil.uiTraverser((Component)pair.first).filter(JBTextField.class).first()) != null) {
            JBTextField jBTextField = textField2;
            if (jBTextField == null) {
                FlatWelcomeFrame.$$$reportNull$$$0(2);
            }
            return jBTextField;
        }
        JComponent jComponent = (JComponent)pair.second;
        if (jComponent == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @Override
    public void showPluginUpdates(@NotNull Runnable callback2) {
        if (callback2 == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(4);
        }
        this.myScreen.showPluginUpdates(callback2);
    }

    @Override
    public void hidePluginUpdates() {
        this.myScreen.hidePluginUpdates();
    }

    public static boolean isUseProjectGroups() {
        return Registry.is("welcome.screen.project.grouping.enabled");
    }

    private static JLabel createArrow(final ActionLink link) {
        JLabel arrow = new JLabel(AllIcons.General.ArrowDown);
        arrow.setCursor(Cursor.getPredefinedCursor(12));
        arrow.setVerticalAlignment(3);
        new ClickListener(){

            @Override
            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                MouseEvent newEvent = MouseEventAdapter.convert(e, link, e.getX(), e.getY());
                link.doClick(newEvent);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$4", "onClick"));
            }
        }.installOn(arrow);
        return arrow;
    }

    @Override
    @Nullable
    public BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    @Override
    @NotNull
    public Rectangle suggestChildFrameBounds() {
        Rectangle rectangle = this.getBounds();
        if (rectangle == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(5);
        }
        return rectangle;
    }

    @Override
    @Nullable
    public Project getProject() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return null;
        }
        return ProjectManager.getInstance().getDefaultProject();
    }

    @Override
    public void setFrameTitle(String title) {
        this.setTitle(title);
    }

    @Override
    public JComponent getComponent() {
        return this.getRootPane();
    }

    public static Pair<JPanel, JBList<AnAction>> createActionGroupPanel(ActionGroup action2, final Runnable backAction, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(6);
        }
        JPanel actionsListPanel = new JPanel(new BorderLayout());
        actionsListPanel.setBackground(FlatWelcomeFrame.getProjectsBackground());
        List<AnAction> groups = FlatWelcomeFrame.flattenActionGroups(action2);
        final DefaultListModel<AnAction> model = JBList.createDefaultListModel(groups);
        JBList<AnAction> list2 = new JBList<AnAction>((ListModel<AnAction>)model);
        for (AnAction group : groups) {
            if (!(group instanceof Disposable)) continue;
            Disposer.register(parentDisposable, (Disposable)((Object)group));
        }
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                model.clear();
            }
        });
        list2.setBackground(FlatWelcomeFrame.getProjectsBackground());
        list2.setCellRenderer((ListCellRenderer<AnAction>)new GroupedItemsListRenderer<AnAction>((ListItemDescriptor)new ListItemDescriptorAdapter<AnAction>(){

            @Nullable
            public String getTextFor(AnAction value2) {
                return FlatWelcomeFrame.getActionText(value2);
            }

            @Nullable
            public String getCaptionAboveOf(AnAction value2) {
                return FlatWelcomeFrame.getParentGroupName(value2);
            }

            public boolean hasSeparatorAboveOf(AnAction value2) {
                int index = model.indexOf(value2);
                String parentGroupName = FlatWelcomeFrame.getParentGroupName(value2);
                if (index < 1) {
                    return parentGroupName != null;
                }
                AnAction upper = (AnAction)model.get(index - 1);
                if (FlatWelcomeFrame.getParentGroupName(upper) == null && parentGroupName != null) {
                    return true;
                }
                return !Comparing.equal(FlatWelcomeFrame.getParentGroupName(upper), parentGroupName);
            }
        }){

            @Override
            protected JComponent createItemComponent() {
                this.myTextLabel = new ErrorLabel();
                this.myTextLabel.setOpaque(true);
                this.myTextLabel.setBorder(JBUI.Borders.empty(3, 7));
                return this.myTextLabel;
            }

            @Override
            protected Color getBackground() {
                return FlatWelcomeFrame.getProjectsBackground();
            }

            @Override
            protected void customizeComponent(JList<? extends AnAction> list2, AnAction value2, boolean isSelected) {
                if (this.myTextLabel != null) {
                    this.myTextLabel.setText(FlatWelcomeFrame.getActionText(value2));
                    this.myTextLabel.setIcon(value2.getTemplatePresentation().getIcon());
                }
            }
        });
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane(list2, true);
        pane2.setBackground(FlatWelcomeFrame.getProjectsBackground());
        actionsListPanel.add((Component)pane2, "Center");
        int width = (int)Math.max(Math.min(Math.round(list2.getPreferredSize().getWidth()), (long)JBUIScale.scale(200)), (long)JBUIScale.scale(100));
        pane2.setPreferredSize(JBUI.size(width + 14, -1));
        boolean singleProjectGenerator = list2.getModel().getSize() == 1;
        Ref selected2 = Ref.create();
        JPanel main2 = new JPanel(new BorderLayout());
        main2.add((Component)actionsListPanel, "West");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new JBColor(Gray._217, Gray._81)));
        main2.add((Component)bottomPanel, "South");
        HashMap panelsMap = new HashMap();
        ListSelectionListener selectionListener = e -> {
            Object value2;
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (!selected2.isNull()) {
                main2.remove((Component)selected2.get());
            }
            if ((value2 = list2.getSelectedValue()) instanceof AbstractActionWithPanel) {
                JPanel panel2 = panelsMap.computeIfAbsent(value2, o -> ((AbstractActionWithPanel)value2).createPanel());
                ((AbstractActionWithPanel)value2).onPanelSelected();
                panel2.setBorder(JBUI.Borders.empty(7, 10));
                selected2.set(panel2);
                main2.add((Component)selected2.get());
                FlatWelcomeFrame.updateBottomPanel(panel2, (AbstractActionWithPanel)value2, bottomPanel, backAction);
                main2.revalidate();
                main2.repaint();
            }
        };
        list2.addListSelectionListener(selectionListener);
        if (backAction != null) {
            new DumbAwareAction(){

                @Override
                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    e.getPresentation().setEnabled(!StackingPopupDispatcher.getInstance().isPopupFocused());
                }

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(1);
                    }
                    backAction.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$8";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, main2, parentDisposable);
        }
        FlatWelcomeFrame.installQuickSearch(list2);
        if (singleProjectGenerator) {
            actionsListPanel.setPreferredSize(new Dimension(0, 0));
        }
        return Pair.create(main2, list2);
    }

    private static void updateBottomPanel(@NotNull JPanel currentPanel, @NotNull AbstractActionWithPanel actionWithPanel, @NotNull JPanel bottomPanel, @Nullable Runnable backAction) {
        if (currentPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(7);
        }
        if (actionWithPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(8);
        }
        if (bottomPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(9);
        }
        bottomPanel.removeAll();
        if (SystemInfo.isMac) {
            FlatWelcomeFrame.addCancelButton(bottomPanel, backAction);
            FlatWelcomeFrame.addActionButton(bottomPanel, actionWithPanel, currentPanel);
        } else {
            FlatWelcomeFrame.addActionButton(bottomPanel, actionWithPanel, currentPanel);
            FlatWelcomeFrame.addCancelButton(bottomPanel, backAction);
        }
    }

    private static void addCancelButton(@NotNull JPanel bottomPanel, @Nullable Runnable backAction) {
        JComponent cancelButton;
        if (bottomPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(10);
        }
        if ((cancelButton = FlatWelcomeFrame.createCancelButton(backAction)) != null) {
            bottomPanel.add(cancelButton);
        }
    }

    private static void addActionButton(@NotNull JPanel bottomPanel, @NotNull AbstractActionWithPanel actionWithPanel, @NotNull JPanel currentPanel) {
        if (bottomPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(11);
        }
        if (actionWithPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(12);
        }
        if (currentPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(13);
        }
        JButton actionButton = actionWithPanel.getActionButton();
        bottomPanel.add(actionButton);
        currentPanel.getRootPane().setDefaultButton(actionButton);
    }

    @Nullable
    private static JComponent createCancelButton(@Nullable Runnable cancelAction) {
        if (cancelAction == null) {
            return null;
        }
        JButton cancelButton = new JButton(CommonBundle.getCancelButtonText());
        cancelButton.addActionListener(e -> cancelAction.run());
        return cancelButton;
    }

    public static void installQuickSearch(JBList<? extends AnAction> list2) {
        new ListSpeedSearch<AnAction>(list2, o -> {
            if (o instanceof AbstractActionWithPanel) {
                return o.getTemplatePresentation().getText();
            }
            return null;
        });
    }

    private static List<AnAction> flattenActionGroups(@NotNull ActionGroup action2) {
        if (action2 == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(14);
        }
        ArrayList<AnAction> groups = new ArrayList<AnAction>();
        for (AnAction anAction : action2.getChildren(null)) {
            if (anAction instanceof ActionGroup) {
                String groupName = FlatWelcomeFrame.getActionText(anAction);
                for (AnAction childAction : ((ActionGroup)anAction).getChildren(null)) {
                    if (groupName != null) {
                        FlatWelcomeFrame.setParentGroupName(groupName, childAction);
                    }
                    groups.add(childAction);
                }
                continue;
            }
            groups.add(anAction);
        }
        return groups;
    }

    private static String getActionText(@NotNull AnAction value2) {
        if (value2 == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(15);
        }
        return value2.getTemplatePresentation().getText();
    }

    private static String getParentGroupName(@NotNull AnAction value2) {
        if (value2 == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(16);
        }
        return (String)value2.getTemplatePresentation().getClientProperty(ACTION_GROUP_KEY);
    }

    private static void setParentGroupName(@NotNull String groupName, @NotNull AnAction childAction) {
        if (groupName == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(17);
        }
        if (childAction == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(18);
        }
        childAction.getTemplatePresentation().putClientProperty(ACTION_GROUP_KEY, groupName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPanel";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionWithPanel";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottomPanel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestChildFrameBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveLocation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredFocusedComponent";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showPluginUpdates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createActionGroupPanel";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateBottomPanel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addCancelButton";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addActionButton";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "flattenActionGroups";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getActionText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParentGroupName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setParentGroupName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class FlatWelcomeScreen
    extends JPanel
    implements WelcomeScreen,
    DataProvider {
        private final JBSlidingPanel mySlidingPanel;
        private final DefaultActionGroup myTouchbarActions;
        public Consumer<List<NotificationType>> myEventListener;
        public Computable<Point> myEventLocation;
        private LinkLabel<Object> myUpdatePluginsLink;
        private boolean inDnd;

        FlatWelcomeScreen() {
            super(new BorderLayout());
            this.mySlidingPanel = new JBSlidingPanel();
            this.myTouchbarActions = new DefaultActionGroup();
            this.mySlidingPanel.add("root", this);
            this.setBackground(FlatWelcomeFrame.getMainBackground());
            if (RecentProjectListActionProvider.getInstance().getActions(false, FlatWelcomeFrame.isUseProjectGroups()).size() > 0) {
                final JComponent recentProjects = this.createRecentProjects();
                this.add((Component)recentProjects, "West");
                final JList projectsList = UIUtil.findComponentOfType(recentProjects, JList.class);
                if (projectsList != null) {
                    projectsList.getModel().addListDataListener(new ListDataListener(){

                        @Override
                        public void intervalAdded(ListDataEvent e) {
                        }

                        @Override
                        public void intervalRemoved(ListDataEvent e) {
                            this.removeIfNeeded();
                        }

                        private void removeIfNeeded() {
                            if (RecentProjectListActionProvider.getInstance().getActions(false, FlatWelcomeFrame.isUseProjectGroups()).size() == 0) {
                                FlatWelcomeScreen.this.remove(recentProjects);
                                FlatWelcomeScreen.this.revalidate();
                                FlatWelcomeScreen.this.repaint();
                            }
                        }

                        @Override
                        public void contentsChanged(ListDataEvent e) {
                            this.removeIfNeeded();
                        }
                    });
                    projectsList.addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            projectsList.repaint();
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            projectsList.repaint();
                        }
                    });
                }
            }
            this.add((Component)this.createBody(), "Center");
            this.setDropTarget(new DropTarget(this, new DropTargetAdapter(){

                @Override
                public void dragEnter(DropTargetDragEvent e) {
                    this.setDnd(true);
                }

                @Override
                public void dragExit(DropTargetEvent e) {
                    this.setDnd(false);
                }

                @Override
                public void drop(DropTargetDropEvent e) {
                    this.setDnd(false);
                    e.acceptDrop(3);
                    Transferable transferable = e.getTransferable();
                    List<File> list2 = FileCopyPasteUtil.getFileList(transferable);
                    if (list2 != null && list2.size() > 0) {
                        PluginDropHandler pluginHandler = new PluginDropHandler();
                        if (!pluginHandler.canHandle(transferable, null) || !pluginHandler.handleDrop(transferable, null, null)) {
                            ProjectUtil.tryOpenFileList(null, list2, "WelcomeFrame");
                        }
                        e.dropComplete(true);
                        return;
                    }
                    e.dropComplete(false);
                }

                private void setDnd(boolean dnd) {
                    FlatWelcomeScreen.this.inDnd = dnd;
                    FlatWelcomeScreen.this.repaint();
                }
            }));
            TouchbarDataKeys.putActionDescriptor(this.myTouchbarActions).setShowText(true);
        }

        @Override
        public JComponent getWelcomePanel() {
            return this.mySlidingPanel;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.inDnd) {
                Rectangle bounds2 = this.getBounds();
                JBColor background = JBColor.namedColor("DragAndDrop.areaBackground", new Color(225, 235, 245));
                g.setColor(new Color(((Color)background).getRed(), ((Color)background).getGreen(), ((Color)background).getBlue(), 206));
                g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                JBColor backgroundBorder = JBColor.namedColor("DragAndDrop.areaBorderColor", new Color(137, 178, 222));
                g.setColor(backgroundBorder);
                g.drawRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                g.drawRect(bounds2.x + 1, bounds2.y + 1, bounds2.width - 2, bounds2.height - 2);
                JBColor foreground = JBColor.namedColor("DragAndDrop.areaForeground", Gray._120);
                g.setColor(foreground);
                Font labelFont = StartupUiUtil.getLabelFont();
                Font font = labelFont.deriveFont((float)labelFont.getSize() + 5.0f);
                String drop = "Drop files here to open";
                g.setFont(font);
                int dropWidth = g.getFontMetrics().stringWidth(drop);
                int dropHeight = g.getFontMetrics().getHeight();
                g.drawString(drop, bounds2.x + (bounds2.width - dropWidth) / 2, (int)((double)bounds2.y + (double)(bounds2.height - dropHeight) * 0.45));
            }
        }

        @NotNull
        private JComponent createBody() {
            NonOpaquePanel panel2 = new NonOpaquePanel(new BorderLayout());
            panel2.add((Component)this.createLogo(), "North");
            panel2.add((Component)this.createActionPanel(), "Center");
            panel2.add((Component)this.createUpdatesSettingsAndDocs(), "South");
            NonOpaquePanel nonOpaquePanel = panel2;
            if (nonOpaquePanel == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(0);
            }
            return nonOpaquePanel;
        }

        private JComponent createUpdatesSettingsAndDocs() {
            NonOpaquePanel panel2 = new NonOpaquePanel(new BorderLayout());
            panel2.add((Component)this.createUpdatePluginsLink(), "West");
            panel2.add((Component)this.createSettingsAndDocs(), "East");
            return panel2;
        }

        private JComponent createSettingsAndDocs() {
            NonOpaquePanel panel2 = new NonOpaquePanel(new BorderLayout());
            NonOpaquePanel toolbar = new NonOpaquePanel();
            AnAction register2 = ActionManager.getInstance().getAction("Register");
            boolean registeredVisible = false;
            if (register2 != null) {
                AnActionEvent e = AnActionEvent.createFromAnAction(register2, null, "WelcomeScreen", DataManager.getInstance().getDataContext(this));
                register2.update(e);
                Presentation presentation = e.getPresentation();
                if (presentation.isEnabled()) {
                    ActionLink registerLink = new ActionLink(IdeBundle.message("action.link.register", new Object[0]), register2);
                    registerLink.setFocusable(false);
                    registerLink.setNormalColor(FlatWelcomeFrame.getLinkNormalColor());
                    NonOpaquePanel button2 = new NonOpaquePanel(new BorderLayout());
                    button2.setBorder(JBUI.Borders.empty(4, 10));
                    button2.add(registerLink);
                    this.installFocusable(button2, register2, 38, 39, true);
                    NonOpaquePanel wrap = new NonOpaquePanel();
                    wrap.setBorder(JBUI.Borders.emptyLeft(10));
                    wrap.add(button2);
                    panel2.add((Component)wrap, "West");
                    registeredVisible = true;
                }
            }
            toolbar.setLayout(new BoxLayout(toolbar, 0));
            toolbar.add(this.createErrorsLink());
            toolbar.add(this.createEventsLink());
            toolbar.add(this.createActionLink(IdeBundle.message("action.Anonymous.text.configure", new Object[0]), "WelcomeScreen.Configure", AllIcons.General.GearPlain, !registeredVisible));
            toolbar.add(this.createActionLink(IdeBundle.message("action.GetHelp", new Object[0]), "WelcomeScreen.Documentation", null, false));
            panel2.add((Component)toolbar, "East");
            panel2.setBorder(JBUI.Borders.empty(0, 0, 8, 11));
            return panel2;
        }

        private JComponent createErrorsLink() {
            IdeMessagePanel panel2 = new IdeMessagePanel(null, MessagePool.getInstance());
            panel2.setBorder(JBUI.Borders.emptyRight(13));
            panel2.setOpaque(false);
            Disposer.register(this, panel2);
            return panel2;
        }

        private JComponent createEventsLink() {
            Ref actionLinkRef = new Ref();
            JComponent panel2 = this.createActionLink(IdeBundle.message("action.Events", new Object[0]), AllIcons.Ide.Notification.NoEvents, actionLinkRef, new AnAction(){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    ((WelcomeBalloonLayoutImpl)FlatWelcomeFrame.this.myBalloonLayout).showPopup();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$4", "actionPerformed"));
                }
            });
            panel2.setVisible(false);
            this.myEventListener = types -> {
                NotificationType type = null;
                for (NotificationType t : types) {
                    if (NotificationType.ERROR == t) {
                        type = NotificationType.ERROR;
                        break;
                    }
                    if (NotificationType.WARNING == t) {
                        type = NotificationType.WARNING;
                        continue;
                    }
                    if (type != null || NotificationType.INFORMATION != t) continue;
                    type = NotificationType.INFORMATION;
                }
                if (types.isEmpty()) {
                    panel2.setVisible(false);
                } else {
                    ((ActionLink)actionLinkRef.get()).setIcon((Icon)IdeNotificationArea.createIconWithNotificationCount((JComponent)actionLinkRef.get(), type, types.size(), false));
                    panel2.setVisible(true);
                }
            };
            this.myEventLocation = () -> {
                Point location2 = SwingUtilities.convertPoint(panel2, 0, 0, this.getRootPane().getLayeredPane());
                return new Point(location2.x, location2.y + 5);
            };
            return panel2;
        }

        private JComponent createActionLink(@Nls String text2, final String groupId2, Icon icon2, boolean focusListOnLeft) {
            final Ref<Object> ref = new Ref<Object>(null);
            AnAction action2 = new AnAction(){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    ActionGroup configureGroup = (ActionGroup)ActionManager.getInstance().getAction(groupId2);
                    PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, configureGroup, e.getDataContext(), false, false, false, false, null, -1, null, "WelcomeScreen", new MenuItemPresentationFactory(true), false);
                    popup2.showUnderneathOfLabel((JLabel)ref.get());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$5", "actionPerformed"));
                }
            };
            JComponent panel2 = this.createActionLink(text2, icon2, ref, action2);
            this.installFocusable(panel2, action2, 38, 40, focusListOnLeft);
            return panel2;
        }

        private JComponent createActionLink(@Nls String text2, Icon icon2, Ref<? super ActionLink> ref, AnAction action2) {
            ActionLink link = new ActionLink(text2, icon2, action2);
            ref.set(link);
            link.setFocusable(false);
            link.setPaintUnderline(false);
            link.setNormalColor(FlatWelcomeFrame.getLinkNormalColor());
            JActionLinkPanel panel2 = new JActionLinkPanel(link);
            panel2.setBorder(JBUI.Borders.empty(4, 6));
            panel2.add((Component)FlatWelcomeFrame.createArrow(link), "East");
            return panel2;
        }

        @NotNull
        private JComponent createActionPanel() {
            DefaultActionGroup group = new DefaultActionGroup();
            ActionGroup quickStart = (ActionGroup)ActionManager.getInstance().getAction("WelcomeScreen.QuickStart");
            this.collectAllActions(group, quickStart);
            GridBag gc = new GridBag();
            JPanel panel2 = new JPanel(new GridBagLayout());
            panel2.setOpaque(false);
            this.myTouchbarActions.removeAll();
            for (AnAction action2 : group.getChildren(null)) {
                Icon icon2;
                AnActionEvent e = AnActionEvent.createFromAnAction(action2, null, "WelcomeScreen", DataManager.getInstance().getDataContext(this));
                action2.update(e);
                Presentation presentation = e.getPresentation();
                if (!presentation.isVisible()) continue;
                String text2 = presentation.getText();
                if (text2 != null && text2.endsWith("...")) {
                    text2 = text2.substring(0, text2.length() - 3);
                }
                if ((icon2 = presentation.getIcon()) == null || icon2.getIconHeight() != JBUIScale.scale(16) || icon2.getIconWidth() != JBUIScale.scale(16)) {
                    icon2 = JBUI.scale(EmptyIcon.create(16));
                }
                action2 = this.wrapGroups(action2);
                ActionLink link = new ActionLink(text2, icon2, action2, null, "WelcomeScreen");
                link.setFocusable(false);
                link.setPaintUnderline(false);
                link.setNormalColor(FlatWelcomeFrame.getLinkNormalColor());
                JActionLinkPanel button2 = new JActionLinkPanel(link);
                button2.setBorder(JBUI.Borders.empty(8, 20));
                if (action2 instanceof WelcomePopupAction) {
                    button2.add((Component)FlatWelcomeFrame.createArrow(link), "East");
                    TouchbarDataKeys.putActionDescriptor(action2).setContextComponent(link);
                }
                this.installFocusable(button2, action2, 38, 40, true);
                panel2.add(Box.createHorizontalGlue(), gc.nextLine().next().fillCellHorizontally());
                panel2.add((Component)button2, gc.next().anchor(21));
                panel2.add(Box.createHorizontalGlue(), gc.next().fillCellHorizontally());
                this.myTouchbarActions.add(action2);
            }
            panel2.add(Box.createGlue(), gc.nextLine().next().fillCell().anchor(20).coverLine(3).weighty(1.0));
            JPanel jPanel = panel2;
            if (jPanel == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(1);
            }
            return jPanel;
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(2);
            }
            if (TouchbarDataKeys.ACTIONS_KEY.is(dataId)) {
                return this.myTouchbarActions;
            }
            return null;
        }

        private AnAction wrapGroups(AnAction action2) {
            if (action2 instanceof ActionGroup && ((ActionGroup)action2).isPopup()) {
                Pair<JPanel, JBList<AnAction>> panel2 = FlatWelcomeFrame.createActionGroupPanel((ActionGroup)action2, () -> this.goBack(), this);
                final Runnable onDone = () -> {
                    ListSelectionListener[] listeners;
                    FlatWelcomeFrame.this.setTitle(ProjectBundle.message("dialog.title.new.project", new Object[0]));
                    JBList list2 = (JBList)panel2.second;
                    ScrollingUtil.ensureSelectionExists(list2);
                    for (ListSelectionListener listener2 : listeners = (ListSelectionListener[])((DefaultListSelectionModel)list2.getSelectionModel()).getListeners(ListSelectionListener.class)) {
                        listener2.valueChanged(new ListSelectionEvent(list2, list2.getSelectedIndex(), list2.getSelectedIndex(), false));
                    }
                    JComponent toFocus = FlatWelcomeFrame.getPreferredFocusedComponent(panel2);
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(toFocus, true));
                };
                final String name = action2.getClass().getName();
                this.mySlidingPanel.add(name, (Component)panel2.first);
                Presentation p = action2.getTemplatePresentation();
                return new DumbAwareAction(p.getText(), p.getDescription(), p.getIcon()){

                    @Override
                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        FlatWelcomeScreen.this.mySlidingPanel.getLayout().swipe(FlatWelcomeScreen.this.mySlidingPanel, name, JBCardLayout.SwipeDirection.FORWARD, onDone);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$6", "actionPerformed"));
                    }
                };
            }
            return action2;
        }

        private void goBack() {
            this.mySlidingPanel.swipe("root", JBCardLayout.SwipeDirection.BACKWARD).doWhenDone(() -> {
                this.mySlidingPanel.getRootPane().setDefaultButton(null);
                FlatWelcomeFrame.this.setTitle(FlatWelcomeFrame.this.getWelcomeFrameTitle());
            });
        }

        private void collectAllActions(@NotNull DefaultActionGroup group, @NotNull ActionGroup actionGroup) {
            if (group == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(3);
            }
            if (actionGroup == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(4);
            }
            for (AnAction action2 : actionGroup.getChildren(null)) {
                if (action2 instanceof ActionGroup && !((ActionGroup)action2).isPopup()) {
                    this.collectAllActions(group, (ActionGroup)action2);
                    continue;
                }
                group.add(action2);
            }
        }

        @NotNull
        private JComponent createLogo() {
            ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
            NonOpaquePanel panel2 = new NonOpaquePanel(new BorderLayout());
            String welcomeScreenLogoUrl = appInfo.getWelcomeScreenLogoUrl();
            if (welcomeScreenLogoUrl != null) {
                JLabel logo = new JLabel(IconLoader.getIcon(welcomeScreenLogoUrl));
                logo.setBorder(JBUI.Borders.empty(30, 0, 10, 0));
                logo.setHorizontalAlignment(0);
                panel2.add((Component)logo, "North");
            }
            String applicationName = Boolean.getBoolean("ide.ui.name.with.edition") ? ApplicationNamesInfo.getInstance().getFullProductNameWithEdition() : ApplicationNamesInfo.getInstance().getFullProductName();
            JLabel appName = new JLabel(applicationName);
            appName.setForeground(JBColor.foreground());
            appName.setFont(this.getProductFont(36).deriveFont(0));
            appName.setHorizontalAlignment(0);
            String appVersion = "Version ";
            appVersion = appVersion + appInfo.getFullVersion();
            if (appInfo.isEAP() && !appInfo.getBuild().isSnapshot()) {
                appVersion = appVersion + " (" + appInfo.getBuild().asStringWithoutProductCode() + ")";
            }
            JLabel version2 = new JLabel(appVersion);
            version2.setFont(this.getProductFont(16));
            version2.setHorizontalAlignment(0);
            version2.setForeground(Gray._128);
            panel2.add(appName);
            panel2.add((Component)version2, "South");
            panel2.setBorder(JBUI.Borders.emptyBottom(20));
            NonOpaquePanel nonOpaquePanel = panel2;
            if (nonOpaquePanel == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(5);
            }
            return nonOpaquePanel;
        }

        @NotNull
        private Font getProductFont(int size) {
            Font font;
            try {
                font = this.loadFont().deriveFont((float)JBUIScale.scale(size));
            }
            catch (Throwable t) {
                Logger.getInstance(AppUIUtil.class).warn(t);
                Font font2 = StartupUiUtil.getLabelFont().deriveFont(JBUIScale.scale((float)size));
                if (font2 == null) {
                    FlatWelcomeScreen.$$$reportNull$$$0(7);
                }
                return font2;
            }
            if (font == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(6);
            }
            return font;
        }

        /*
         * Loose catch block
         */
        @NotNull
        private Font loadFont() {
            block19: {
                Font font;
                Throwable throwable;
                InputStream is;
                URL url;
                block16: {
                    block17: {
                        block18: {
                            String fontPath = "/fonts/Roboto-Light.ttf";
                            url = AppUIUtil.class.getResource(fontPath);
                            if (url != null) break block18;
                            Logger.getInstance(AppUIUtil.class).warn("Resource missing: " + fontPath);
                            break block19;
                        }
                        is = url.openStream();
                        throwable = null;
                        font = Font.createFont(0, is);
                        if (is == null) break block16;
                        if (throwable == null) break block17;
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block16;
                    }
                    is.close();
                }
                Font font2 = font;
                if (font2 == null) {
                    FlatWelcomeScreen.$$$reportNull$$$0(8);
                }
                return font2;
                {
                    catch (Throwable throwable3) {
                        try {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (is != null) {
                                    if (throwable != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        is.close();
                                    }
                                }
                                throw throwable4;
                            }
                        }
                        catch (Throwable t) {
                            Logger.getInstance(AppUIUtil.class).warn("Cannot load font: " + url, t);
                        }
                    }
                }
            }
            Font font = StartupUiUtil.getLabelFont();
            if (font == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(9);
            }
            return font;
        }

        private JComponent createRecentProjects() {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)new NewRecentProjectPanel(this), "Center");
            panel2.setBackground(FlatWelcomeFrame.getProjectsBackground());
            panel2.setBorder(new CustomLineBorder(FlatWelcomeFrame.getSeparatorColor(), JBUI.insetsRight(1)));
            return panel2;
        }

        private void installFocusable(final JComponent comp, final AnAction action2, final int prevKeyCode, final int nextKeyCode, final boolean focusListOnLeft) {
            comp.setFocusable(true);
            comp.setFocusTraversalKeysEnabled(true);
            comp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    JList list2 = UIUtil.findComponentOfType(FlatWelcomeFrame.this.getComponent(), JList.class);
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        ActionLink link;
                        InputEvent event = e;
                        if (e.getComponent() instanceof JComponent && (link = UIUtil.findComponentOfType((JComponent)e.getComponent(), ActionLink.class)) != null) {
                            event = new MouseEvent(link, 500, e.getWhen(), e.getModifiers(), 0, 0, 1, false, 1);
                        }
                        action2.actionPerformed(AnActionEvent.createFromAnAction(action2, event, "WelcomeScreen", DataManager.getInstance().getDataContext()));
                    } else if (e.getKeyCode() == prevKeyCode) {
                        FlatWelcomeScreen.this.focusPrev(comp);
                    } else if (e.getKeyCode() == nextKeyCode) {
                        FlatWelcomeScreen.this.focusNext(comp);
                    } else if (e.getKeyCode() == 37) {
                        if (focusListOnLeft) {
                            if (list2 != null) {
                                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(list2, true));
                            }
                        } else {
                            FlatWelcomeScreen.this.focusPrev(comp);
                        }
                    } else if (e.getKeyCode() == 39) {
                        FlatWelcomeScreen.this.focusNext(comp);
                    }
                }
            });
            comp.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    comp.setOpaque(true);
                    comp.setBackground(FlatWelcomeFrame.getActionLinkSelectionColor());
                }

                @Override
                public void focusLost(FocusEvent e) {
                    comp.setOpaque(false);
                    comp.setBackground(FlatWelcomeFrame.getMainBackground());
                }
            });
        }

        private void focusPrev(JComponent comp) {
            Component prev;
            FocusTraversalPolicy policy = FlatWelcomeFrame.this.getFocusTraversalPolicy();
            if (policy != null && (prev = policy.getComponentBefore(FlatWelcomeFrame.this, comp)) != null) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(prev, true));
            }
        }

        private void focusNext(JComponent comp) {
            Component next;
            FocusTraversalPolicy policy = FlatWelcomeFrame.this.getFocusTraversalPolicy();
            if (policy != null && (next = policy.getComponentAfter(FlatWelcomeFrame.this, comp)) != null) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(next, true));
            }
        }

        @Override
        public void setupFrame(JFrame frame) {
        }

        @Override
        public void dispose() {
        }

        private JComponent createUpdatePluginsLink() {
            this.myUpdatePluginsLink = new LinkLabel(IdeBundle.message("updates.plugins.welcome.screen.link.message", new Object[0]), null);
            this.myUpdatePluginsLink.setVisible(false);
            NonOpaquePanel wrap = new NonOpaquePanel(this.myUpdatePluginsLink);
            wrap.setBorder(JBUI.Borders.empty(0, 10, 8, 11));
            return wrap;
        }

        public void showPluginUpdates(@NotNull Runnable callback2) {
            if (callback2 == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(10);
            }
            this.myUpdatePluginsLink.setListener((__, ___) -> callback2.run(), null);
            this.myUpdatePluginsLink.setVisible(true);
        }

        public void hidePluginUpdates() {
            this.myUpdatePluginsLink.setListener(null, null);
            this.myUpdatePluginsLink.setVisible(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBody";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActionPanel";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLogo";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProductFont";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadFont";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "collectAllActions";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "showPluginUpdates";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        protected class JActionLinkPanel
        extends JPanel {
            @NotNull
            private final ActionLink myActionLink;

            public JActionLinkPanel(ActionLink actionLink) {
                if (actionLink == null) {
                    JActionLinkPanel.$$$reportNull$$$0(0);
                }
                super(new BorderLayout());
                this.myActionLink = actionLink;
                this.add(this.myActionLink);
                this.setOpaque(false);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleJActionLinkPanel(this.myActionLink.getAccessibleContext());
                }
                return this.accessibleContext;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionLink", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$JActionLinkPanel", "<init>"));
            }

            protected final class AccessibleJActionLinkPanel
            extends AccessibleContextDelegate {
                AccessibleJActionLinkPanel(AccessibleContext context) {
                    super(context);
                }

                @Override
                public Container getDelegateParent() {
                    return JActionLinkPanel.this.getParent();
                }

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PUSH_BUTTON;
                }
            }
        }
    }
}

