/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class BackwardDependenciesBuilder
extends DependenciesBuilder {
    private final AnalysisScope myForwardScope;
    private final AnalysisScope myScopeOfInterest;

    public BackwardDependenciesBuilder(Project project2, AnalysisScope scope) {
        this(project2, scope, null);
    }

    public BackwardDependenciesBuilder(Project project2, AnalysisScope scope, @Nullable AnalysisScope scopeOfInterest) {
        super(project2, scope);
        this.myScopeOfInterest = scopeOfInterest;
        this.myForwardScope = scopeOfInterest != null ? scopeOfInterest : ReadAction.compute(() -> this.getScope().getNarrowedComplementaryScope(this.getProject()));
        this.myFileCount = this.myForwardScope.getFileCount();
        this.myTotalFileCount = this.myFileCount + scope.getFileCount();
    }

    @Override
    public String getRootNodeNameInUsageView() {
        return AnalysisBundle.message("backward.dependencies.usage.view.root.node.text", new Object[0]);
    }

    @Override
    public String getInitialUsagesPosition() {
        return AnalysisBundle.message("backward.dependencies.usage.view.initial.text", new Object[0]);
    }

    @Override
    public AnalysisScope getScopeOfInterest() {
        return this.myScopeOfInterest;
    }

    @Override
    public boolean isBackward() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze() {
        ForwardDependenciesBuilder builder2 = new ForwardDependenciesBuilder(this.getProject(), this.myForwardScope);
        builder2.setTotalFileCount(this.myTotalFileCount);
        ((DependenciesBuilder)builder2).analyze();
        BackwardDependenciesBuilder.subtractScope(builder2, this.getScope());
        PsiManager psiManager = PsiManager.getInstance(this.getProject());
        psiManager.startBatchFilesProcessingMode();
        try {
            int fileCount = this.getScope().getFileCount();
            boolean includeTestSource = this.getScope().isIncludeTestSource();
            this.getScope().accept(virtualFile2 -> {
                if (!includeTestSource && TestSourcesFilter.isTestSources(virtualFile2, this.getProject())) {
                    return true;
                }
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                if (indicator != null) {
                    if (indicator.isCanceled()) {
                        throw new ProcessCanceledException();
                    }
                    indicator.setText(AnalysisBundle.message("package.dependencies.progress.text", new Object[0]));
                    indicator.setText2(this.getRelativeToProjectPath((VirtualFile)virtualFile2));
                    if (fileCount > 0) {
                        indicator.setFraction((double)(++this.myFileCount) / (double)this.myTotalFileCount);
                    }
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    PsiFile file2 = psiManager.findFile((VirtualFile)virtualFile2);
                    if (file2 != null) {
                        PsiElement navigationElement = file2.getNavigationElement();
                        if (navigationElement instanceof PsiFile) {
                            file2 = (PsiFile)navigationElement;
                        }
                        Map<PsiFile, Set<PsiFile>> dependencies = builder2.getDependencies();
                        for (PsiFile psiFile : dependencies.keySet()) {
                            if (!dependencies.get(psiFile).contains(file2)) continue;
                            Set<PsiFile> fileDeps = this.getDependencies().get(file2);
                            if (fileDeps == null) {
                                fileDeps = new HashSet<PsiFile>();
                                this.getDependencies().put(file2, fileDeps);
                            }
                            fileDeps.add(psiFile);
                        }
                        psiManager.dropResolveCaches();
                    }
                });
                return true;
            });
        }
        finally {
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    private static void subtractScope(DependenciesBuilder builders, AnalysisScope scope) {
        Map<PsiFile, Set<PsiFile>> dependencies = builders.getDependencies();
        HashSet<PsiFile> excluded = new HashSet<PsiFile>();
        for (PsiFile psiFile : dependencies.keySet()) {
            if (!scope.contains(psiFile)) continue;
            excluded.add(psiFile);
        }
        for (PsiFile psiFile : excluded) {
            dependencies.remove(psiFile);
        }
    }

    public AnalysisScope getForwardScope() {
        return this.myForwardScope;
    }
}

