/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.openapi.util.Comparing;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.ComplementPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyRule {
    private NamedScope myFromScope;
    private NamedScope myToScope;
    private final boolean myDenyRule;

    public DependencyRule(NamedScope fromPackageSet, NamedScope toPackageSet, boolean isDenyRule) {
        this.myFromScope = fromPackageSet;
        this.myToScope = toPackageSet;
        this.myDenyRule = isDenyRule;
    }

    public boolean isForbiddenToUse(@NotNull PsiFile from, @NotNull PsiFile to) {
        if (from == null) {
            DependencyRule.$$$reportNull$$$0(0);
        }
        if (to == null) {
            DependencyRule.$$$reportNull$$$0(1);
        }
        if (this.myFromScope == null || this.myToScope == null) {
            return false;
        }
        PackageSet fromSet = this.myFromScope.getValue();
        PackageSet toSet = this.myToScope.getValue();
        if (fromSet == null || toSet == null) {
            return false;
        }
        DependencyValidationManager holder = DependencyValidationManager.getInstance(from.getProject());
        return (this.myDenyRule ? fromSet.contains(from, holder) : new ComplementPackageSet(fromSet).contains(from, (NamedScopesHolder)holder)) && toSet.contains(to, holder);
    }

    public boolean isApplicable(@NotNull PsiFile file2) {
        if (file2 == null) {
            DependencyRule.$$$reportNull$$$0(2);
        }
        if (this.myFromScope == null || this.myToScope == null) {
            return false;
        }
        PackageSet fromSet = this.myFromScope.getValue();
        if (fromSet == null) {
            return false;
        }
        DependencyValidationManager holder = DependencyValidationManager.getInstance(file2.getProject());
        return this.myDenyRule ? fromSet.contains(file2, holder) : new ComplementPackageSet(fromSet).contains(file2, (NamedScopesHolder)holder);
    }

    public String getDisplayText() {
        String toScopeName = this.myToScope == null ? "" : this.myToScope.getName();
        String fromScopeName = this.myFromScope == null ? "" : this.myFromScope.getName();
        return this.myDenyRule ? AnalysisBundle.message("scope.display.name.deny.scope", toScopeName, fromScopeName) : AnalysisBundle.message("scope.display.name.allow.scope", toScopeName, fromScopeName);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DependencyRule)) {
            return false;
        }
        DependencyRule other = (DependencyRule)o;
        return this.getDisplayText().equals(other.getDisplayText()) && Comparing.strEqual(DependencyRule.getPackageSetPresentation(this.myFromScope), DependencyRule.getPackageSetPresentation(other.myFromScope)) && Comparing.strEqual(DependencyRule.getPackageSetPresentation(this.myToScope), DependencyRule.getPackageSetPresentation(other.myToScope));
    }

    @Nullable
    private static String getPackageSetPresentation(NamedScope scope) {
        PackageSet packageSet;
        if (scope != null && (packageSet = scope.getValue()) != null) {
            return packageSet.getText();
        }
        return null;
    }

    public int hashCode() {
        return this.getDisplayText().hashCode();
    }

    public DependencyRule createCopy() {
        return new DependencyRule(this.myFromScope == null ? null : this.myFromScope.createCopy(), this.myToScope == null ? null : this.myToScope.createCopy(), this.myDenyRule);
    }

    public boolean isDenyRule() {
        return this.myDenyRule;
    }

    public NamedScope getFromScope() {
        return this.myFromScope;
    }

    public void setFromScope(NamedScope fromScope) {
        this.myFromScope = fromScope;
    }

    public NamedScope getToScope() {
        return this.myToScope;
    }

    public void setToScope(NamedScope toScope) {
        this.myToScope = toScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packageDependencies/DependencyRule";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isForbiddenToUse";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

