/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.FindDependencyUtil;
import com.intellij.packageDependencies.ui.PanelProgressIndicator;
import com.intellij.packageDependencies.ui.UsagesPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;

public class DependenciesUsagesPanel
extends UsagesPanel {
    private final List<DependenciesBuilder> myBuilders;

    public DependenciesUsagesPanel(Project project2, List<DependenciesBuilder> builders) {
        super(project2);
        this.myBuilders = builders;
        this.setToInitialPosition();
    }

    @Override
    public String getInitialPositionText() {
        return this.myBuilders.get(0).getInitialUsagesPosition();
    }

    @Override
    public String getCodeUsagesString() {
        return this.myBuilders.get(0).getRootNodeNameInUsageView();
    }

    public void findUsages(Set<PsiFile> searchIn, Set<PsiFile> searchFor) {
        this.cancelCurrentFindRequest();
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            PanelProgressIndicator progress2 = new PanelProgressIndicator(component2 -> this.setToComponent((JComponent)component2));
            this.myCurrentProgress = progress2;
            ProgressManager.getInstance().runProcess(() -> {
                ApplicationManager.getApplication().runReadAction(() -> {
                    UsageInfo[] usages = UsageInfo.EMPTY_ARRAY;
                    Set elementsToSearch = null;
                    try {
                        if (this.myBuilders.get(0).isBackward()) {
                            elementsToSearch = searchIn;
                            usages = FindDependencyUtil.findBackwardDependencies(this.myBuilders, (Set<? extends PsiFile>)searchFor, (Set<? extends PsiFile>)searchIn);
                        } else {
                            elementsToSearch = searchFor;
                            usages = FindDependencyUtil.findDependencies(this.myBuilders, (Set<? extends PsiFile>)searchIn, (Set<? extends PsiFile>)searchFor);
                        }
                        assert (!new HashSet(elementsToSearch).contains(null));
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    catch (Exception e) {
                        LOG.error(e);
                    }
                    if (!progress2.isCanceled()) {
                        UsageInfo[] finalUsages = usages;
                        PsiElement[] _elementsToSearch = elementsToSearch != null ? PsiUtilCore.toPsiElementArray(elementsToSearch) : PsiElement.EMPTY_ARRAY;
                        ApplicationManager.getApplication().invokeLater(() -> this.showUsages(_elementsToSearch, finalUsages), ModalityState.stateForComponent(this));
                    }
                });
                this.myCurrentProgress = null;
            }, (ProgressIndicator)progress2);
        }), 300);
    }

    public void addBuilder(DependenciesBuilder builder2) {
        this.myBuilders.add(builder2);
    }
}

