/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiMethodCallPattern;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class PsiExpressionPattern<T extends PsiExpression, Self extends PsiExpressionPattern<T, Self>>
extends PsiJavaElementPattern<T, Self> {
    protected PsiExpressionPattern(Class<T> aClass) {
        super(aClass);
    }

    public Self ofType(final @NotNull ElementPattern pattern) {
        if (pattern == null) {
            PsiExpressionPattern.$$$reportNull$$$0(0);
        }
        return (Self)((PsiExpressionPattern)this.with(new PatternCondition<T>("ofType"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                return pattern.accepts(t.getType(), context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiExpressionPattern$1", "accepts"));
            }
        }));
    }

    public PsiMethodCallPattern methodCall(final ElementPattern<? extends PsiMethod> method2) {
        final PsiNamePatternCondition nameCondition = ContainerUtil.findInstance(method2.getCondition().getConditions(), PsiNamePatternCondition.class);
        return (PsiMethodCallPattern)((PsiMethodCallPattern)new PsiMethodCallPattern().and(this)).with(new PatternCondition<PsiMethodCallExpression>("methodCall"){

            @Override
            public boolean accepts(@NotNull PsiMethodCallExpression callExpression, ProcessingContext context) {
                if (callExpression == null) {
                    2.$$$reportNull$$$0(0);
                }
                PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
                if (nameCondition != null && !nameCondition.getNamePattern().accepts(methodExpression.getReferenceName())) {
                    return false;
                }
                for (JavaResolveResult result2 : methodExpression.multiResolve(true)) {
                    if (!method2.accepts(result2.getElement(), context)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/patterns/PsiExpressionPattern$2", "accepts"));
            }
        });
    }

    public Self skipParentheses(final ElementPattern<? extends PsiExpression> expressionPattern) {
        return (Self)((PsiExpressionPattern)this.with(new PatternCondition<T>("skipParentheses"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                Object expression = t;
                while (expression instanceof PsiParenthesizedExpression) {
                    expression = ((PsiParenthesizedExpression)expression).getExpression();
                }
                return expressionPattern.accepts(expression, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiExpressionPattern$3", "accepts"));
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiExpressionPattern", "ofType"));
    }

    public static class Capture<T extends PsiExpression>
    extends PsiExpressionPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }
    }
}

