/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeElementPattern<ParentType, T extends ParentType, Self extends TreeElementPattern<ParentType, T, Self>>
extends ObjectPattern<T, Self> {
    protected TreeElementPattern(@NotNull InitialPatternCondition<T> condition2) {
        if (condition2 == null) {
            TreeElementPattern.$$$reportNull$$$0(0);
        }
        super(condition2);
    }

    protected TreeElementPattern(Class<T> aClass) {
        super(aClass);
    }

    @Nullable
    protected abstract ParentType getParent(@NotNull ParentType var1);

    protected abstract ParentType[] getChildren(@NotNull ParentType var1);

    @SafeVarargs
    public final Self withParents(final Class<? extends ParentType> ... types) {
        if (types == null) {
            TreeElementPattern.$$$reportNull$$$0(1);
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("withParents"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                Object current2 = TreeElementPattern.this.getParent(t);
                for (Class type : types) {
                    if (current2 == null || !type.isInstance(current2)) {
                        return false;
                    }
                    current2 = TreeElementPattern.this.getParent(current2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$1", "accepts"));
            }
        }));
    }

    public Self withParent(@NotNull Class<? extends ParentType> type) {
        if (type == null) {
            TreeElementPattern.$$$reportNull$$$0(2);
        }
        return this.withParent(StandardPatterns.instanceOf(type));
    }

    @NotNull
    public Self withParent(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            TreeElementPattern.$$$reportNull$$$0(3);
        }
        Self Self = this.withSuperParent(1, pattern);
        if (Self == null) {
            TreeElementPattern.$$$reportNull$$$0(4);
        }
        return Self;
    }

    public Self withChild(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            TreeElementPattern.$$$reportNull$$$0(5);
        }
        return this.withChildren(StandardPatterns.collection().atLeastOne(pattern));
    }

    public Self withFirstChild(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            TreeElementPattern.$$$reportNull$$$0(6);
        }
        return this.withChildren(StandardPatterns.collection().first(pattern));
    }

    public Self withLastChild(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            TreeElementPattern.$$$reportNull$$$0(7);
        }
        return this.withChildren(StandardPatterns.collection().last(pattern));
    }

    public Self withChildren(@NotNull ElementPattern<Collection<ParentType>> pattern) {
        if (pattern == null) {
            TreeElementPattern.$$$reportNull$$$0(8);
        }
        return (Self)((TreeElementPattern)this.with(new PatternConditionPlus<T, Collection<ParentType>>("withChildren", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<Collection<ParentType>, ProcessingContext> processor2) {
                return processor2.process(Arrays.asList(TreeElementPattern.this.getChildren(t)), context);
            }
        }));
    }

    public Self isFirstAcceptedChild(final @NotNull ElementPattern<? super ParentType> pattern) {
        if (pattern == null) {
            TreeElementPattern.$$$reportNull$$$0(9);
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("isFirstAcceptedChild"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                Object parent;
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((parent = TreeElementPattern.this.getParent(t)) != null) {
                    T[] children2;
                    for (Object child2 : children2 = TreeElementPattern.this.getChildren(parent)) {
                        if (!pattern.accepts(child2, context)) continue;
                        return child2 == t;
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$3", "accepts"));
            }
        }));
    }

    public Self withSuperParent(int level, @NotNull Class<? extends ParentType> aClass) {
        if (aClass == null) {
            TreeElementPattern.$$$reportNull$$$0(10);
        }
        return this.withSuperParent(level, StandardPatterns.instanceOf(aClass));
    }

    public Self withSuperParent(final int level, @NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            TreeElementPattern.$$$reportNull$$$0(11);
        }
        return (Self)((TreeElementPattern)this.with(new PatternConditionPlus<T, ParentType>(level == 1 ? "withParent" : "withSuperParent", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<ParentType, ProcessingContext> processor2) {
                Object parent = t;
                for (int i = 0; i < level; ++i) {
                    if (parent == null) {
                        return true;
                    }
                    parent = TreeElementPattern.this.getParent(parent);
                }
                return processor2.process(parent, context);
            }
        }));
    }

    public Self inside(@NotNull Class<? extends ParentType> pattern) {
        if (pattern == null) {
            TreeElementPattern.$$$reportNull$$$0(12);
        }
        return this.inside(StandardPatterns.instanceOf(pattern));
    }

    public Self inside(@NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            TreeElementPattern.$$$reportNull$$$0(13);
        }
        return this.inside(false, pattern);
    }

    public Self inside(final boolean strict, @NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            TreeElementPattern.$$$reportNull$$$0(14);
        }
        return (Self)((TreeElementPattern)this.with(new PatternConditionPlus<T, ParentType>("inside", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<ParentType, ProcessingContext> processor2) {
                Object element2;
                Object t2 = element2 = strict ? TreeElementPattern.this.getParent(t) : t;
                while (element2 != null) {
                    if (!processor2.process(element2, context)) {
                        return false;
                    }
                    element2 = TreeElementPattern.this.getParent(element2);
                }
                return true;
            }
        }));
    }

    public Self withAncestor(final int levelsUp, final @NotNull ElementPattern<? extends ParentType> pattern) {
        if (pattern == null) {
            TreeElementPattern.$$$reportNull$$$0(15);
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("withAncestor"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    6.$$$reportNull$$$0(0);
                }
                Object element2 = t;
                for (int i = 0; i < levelsUp + 1; ++i) {
                    if (pattern.accepts(element2, context)) {
                        return true;
                    }
                    if ((element2 = TreeElementPattern.this.getParent(element2)) == null) break;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$6", "accepts"));
            }
        }));
    }

    public Self inside(final boolean strict, final @NotNull ElementPattern<? extends ParentType> pattern, final @NotNull ElementPattern<? extends ParentType> stopAt) {
        if (pattern == null) {
            TreeElementPattern.$$$reportNull$$$0(16);
        }
        if (stopAt == null) {
            TreeElementPattern.$$$reportNull$$$0(17);
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("inside"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                Object element2;
                if (t == null) {
                    7.$$$reportNull$$$0(0);
                }
                Object t2 = element2 = strict ? TreeElementPattern.this.getParent(t) : t;
                while (element2 != null) {
                    if (stopAt.accepts(element2, context)) {
                        return false;
                    }
                    if (pattern.accepts(element2, context)) {
                        return true;
                    }
                    element2 = TreeElementPattern.this.getParent(element2);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$7", "accepts"));
            }
        }));
    }

    @SafeVarargs
    public final Self insideSequence(final boolean strict, final ElementPattern<? extends ParentType> ... patterns) {
        if (patterns == null) {
            TreeElementPattern.$$$reportNull$$$0(18);
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("insideSequence"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                Object element2;
                if (t == null) {
                    8.$$$reportNull$$$0(0);
                }
                int i = 0;
                Object t2 = element2 = strict ? TreeElementPattern.this.getParent(t) : t;
                while (element2 != null && i < patterns.length) {
                    for (int j = i; j < patterns.length; ++j) {
                        if (!patterns[j].accepts(element2, context)) continue;
                        if (i != j) {
                            return false;
                        }
                        ++i;
                        break;
                    }
                    element2 = TreeElementPattern.this.getParent(element2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$8", "accepts"));
            }
        }));
    }

    public Self afterSibling(final ElementPattern<? extends ParentType> pattern) {
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("afterSibling"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                Object parent;
                if (t == null) {
                    9.$$$reportNull$$$0(0);
                }
                if ((parent = TreeElementPattern.this.getParent(t)) == null) {
                    return false;
                }
                T[] children2 = TreeElementPattern.this.getChildren(parent);
                int i = Arrays.asList(children2).indexOf(t);
                if (i <= 0) {
                    return false;
                }
                return pattern.accepts(children2[i - 1], context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$9", "accepts"));
            }
        }));
    }

    public Self afterSiblingSkipping(final @NotNull ElementPattern skip, final ElementPattern<? extends ParentType> pattern) {
        if (skip == null) {
            TreeElementPattern.$$$reportNull$$$0(19);
        }
        return (Self)((TreeElementPattern)this.with(new PatternCondition<T>("afterSiblingSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                Object parent;
                if (t == null) {
                    10.$$$reportNull$$$0(0);
                }
                if ((parent = TreeElementPattern.this.getParent(t)) == null) {
                    return false;
                }
                T[] children2 = TreeElementPattern.this.getChildren(parent);
                int i = Arrays.asList(children2).indexOf(t);
                while (--i >= 0) {
                    if (skip.accepts(children2[i], context)) continue;
                    return pattern.accepts(children2[i], context);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/TreeElementPattern$10", "accepts"));
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/patterns/TreeElementPattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/patterns/TreeElementPattern";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withParents";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withParent";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withChild";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withFirstChild";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withLastChild";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withChildren";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFirstAcceptedChild";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "withSuperParent";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "inside";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "withAncestor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insideSequence";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "afterSiblingSkipping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

